/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.print;

import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTIndexColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.print.IRetrieveDataListener;
import com.kingdee.cosmic.ctrl.kdf.table.print.TablePrintJob;
import com.kingdee.cosmic.ctrl.kdf.table.print.TablePrintJobImp;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.cosmic.ctrl.print.control.PaperInfo;
import com.kingdee.cosmic.ctrl.print.printjob.BufferPrintJob;
import com.kingdee.cosmic.ctrl.print.printjob.IPageProvider;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.print.resource.TableResources;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.DimensionFloat;
import com.kingdee.cosmic.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;
import com.kingdee.cosmic.ctrl.print.ui.component.Paper;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;

public class FrugalPrintJob
extends BufferPrintJob
implements IPageProvider {
    KDTable table;
    IRetrieveDataListener listener;
    protected PrintConfigModel printmode;
    protected String configName;
    TablePrintJob[] jobs;
    private IPrintJob currentJob = null;
    private int blockSpace = 0;
    private int tableSpace = 0;
    private HashMap frugalPageMap;
    private HashMap headerMap;
    private HashMap footerMap;
    boolean isFrugal = true;
    HeadFootModel orginHeader;
    HeadFootModel orginFooter;

    public FrugalPrintJob(IRetrieveDataListener listener, PrintConfigModel printmodel, String configName, KDPrinter printer) {
        this.setPrinter(printer);
        this.setPageProvider(this);
        this.table = listener.getTable();
        this.printmode = printmodel;
        this.configName = configName;
        this.listener = listener;
        String[] names = this.listener.getTableNames();
        this.jobs = new TablePrintJob[names.length];
        for (int i = 0; i < this.jobs.length; ++i) {
            this.jobs[i] = this.newPrintJob();
            this.jobs[i].setPrinter(printer);
            this.jobs[i].setConfig(this.getConfig());
            this.jobs[i].setPaperInfo(this.getPaperInfo());
        }
        if (this.jobs.length > 0) {
            this.currentJob = this.jobs[0];
        }
    }

    public void clear() {
        String[] names = this.listener.getTableNames();
        this.jobs = new TablePrintJob[names.length];
        for (int i = 0; i < this.jobs.length; ++i) {
            this.jobs[i] = this.newPrintJob();
            this.jobs[i].setID(names[i]);
            this.jobs[i].setPrinter(this.getPrinter());
            this.jobs[i].setConfig(this.getConfig());
            this.jobs[i].setPaperInfo(this.getPaperInfo());
        }
        this.currentJob = this.jobs.length > 0 ? this.jobs[0] : null;
        if (this.headerMap != null) {
            this.headerMap.clear();
        }
        if (this.footerMap != null) {
            this.footerMap.clear();
        }
        if (this.frugalPageMap != null) {
            this.frugalPageMap = null;
        }
        super.clear();
    }

    public TablePrintJob newPrintJob() {
        return new TablePrintJob(new TablePrintJobImp(this.table), this.printmode, this.configName);
    }

    public void setFrugal(boolean isFrugal) {
        this.isFrugal = isFrugal;
    }

    public void preparePagination() {
        super.preparePagination();
        this.getPaperInfo().setUseFrugalPaintable(this.isFrugal);
        this.getPaperInfo().setBlockSpace(this.blockSpace);
        this.getPaperInfo().setTableSpace(this.tableSpace);
        int count = -1;
        if (this.pageCount == -1) {
            int i = 0;
            Page page = this.createPaperByFrugal(i, this.getPaperInfo(), true);
            while (page != null) {
                page = this.createPaperByFrugal(++i, this.getPaperInfo(), true);
            }
            count = i;
        }
        this.setPageCount(count);
    }

    public Page get(int index, PaperInfo info) {
        if (this.currentJob == null) {
            return null;
        }
        return this.createPaperByFrugal(index, info, false);
    }

    private Page createPaperByFrugal(int index, PaperInfo info, boolean isCountNumberOfPages) {
        Page page = null;
        TablePrintJob job = null;
        int indexOfInJob = 0;
        if (index > 0) {
            Object[] jobAndIndex = (Object[])this.getFrugalPageMap().get(index - 1);
            if (jobAndIndex == null) {
                return null;
            }
            job = (BufferPrintJob)jobAndIndex[0];
            indexOfInJob = (Integer)jobAndIndex[1];
        } else if (index == 0) {
            if (this.jobs.length == 0) {
                return null;
            }
            job = this.jobs[0];
            indexOfInJob = -1;
            this.getPaperInfo().setLastPageHeight((float)this.tableSpace);
        }
        if (job == null) {
            return null;
        }
        int jobsize = this.jobs.length;
        for (int i = 0; i < jobsize; ++i) {
            TablePrintJob ajob = this.jobs[i];
            if (ajob.isBuffered()) continue;
            String id = ajob.getID();
            this.listener.fillTableData(id);
            this.bufferHeaderFooter(this.listener, id);
            ajob.bufferPrint();
            if (i != 0) continue;
            HeadFootModel header = HeadFootParser.parseHeadFootPage2Model((com.kingdee.cosmic.ctrl.kdf.form.Page)this.listener.getTable().getPrintManager().getHeader());
            this.setHeader(header);
            HeadFootModel footer = HeadFootParser.parseHeadFootPage2Model((com.kingdee.cosmic.ctrl.kdf.form.Page)this.listener.getTable().getPrintManager().getFooter());
            this.setFooter(footer);
        }
        int pageNumber = job.getPageCount();
        if (indexOfInJob >= pageNumber - 1) {
            TablePrintJob nextJob = this.getNextJob((IPrintJob)job);
            if (nextJob != null) {
                Object[] jobAndIndexAndPaper = this.createPaperByFrugal2((BufferPrintJob)nextJob, 0, info, isCountNumberOfPages);
                Object[] jobAndIndex2 = new Object[]{jobAndIndexAndPaper[0], jobAndIndexAndPaper[1]};
                page = (Page)jobAndIndexAndPaper[2];
                this.getFrugalPageMap().put(index, jobAndIndex2);
            } else {
                page = null;
            }
        } else {
            Object[] jobAndIndexAndPaper = this.createPaperByFrugal2((BufferPrintJob)job, indexOfInJob + 1, info, isCountNumberOfPages);
            Object[] jobAndIndex2 = new Object[]{jobAndIndexAndPaper[0], jobAndIndexAndPaper[1]};
            page = (Page)jobAndIndexAndPaper[2];
            this.getFrugalPageMap().put(index, jobAndIndex2);
        }
        return page;
    }

    private void bufferHeaderFooter(IRetrieveDataListener listener2, String id) {
        KDTable table = listener2.getTable();
        HeadFootModel header = null;
        com.kingdee.cosmic.ctrl.kdf.form.Page page = table.getPrintManager().getHeader();
        if (page != null) {
            this.orginHeader = HeadFootParser.parseHeadFootPage2Model((com.kingdee.cosmic.ctrl.kdf.form.Page)page);
            page = listener2.parserHeader(id, page);
            header = HeadFootParser.parseHeadFootPage2Model((com.kingdee.cosmic.ctrl.kdf.form.Page)page);
            this.orginHeader.updateOriginText();
            header.updateOriginText();
            if (this.orginHeader.getRowsCount() == header.getRowsCount()) {
                List list = header.getRowList();
                List list2 = this.orginHeader.getRowList();
                for (int i = 0; i < this.orginHeader.getRowsCount(); ++i) {
                    HeadFootRow row = (HeadFootRow)list.get(i);
                    HeadFootRow row2 = (HeadFootRow)list2.get(i);
                    if (row == null || row2 == null) continue;
                    row.setOriginText(row2.getOriginText());
                }
            }
        }
        this.getHeaderMap().put(id, header);
        page = table.getPrintManager().getFooter();
        if (page != null) {
            this.orginFooter = HeadFootParser.parseHeadFootPage2Model((com.kingdee.cosmic.ctrl.kdf.form.Page)page);
            page = listener2.parserHeader(id, page);
            header = HeadFootParser.parseHeadFootPage2Model((com.kingdee.cosmic.ctrl.kdf.form.Page)page);
        }
        this.getFooterMap().put(id, header);
    }

    public void setHeaderFooterToConfigUI() {
        this.setHeader(this.orginHeader);
        this.setFooter(this.orginFooter);
    }

    public void clearHeader() {
        this.setHeader(null);
    }

    private HashMap getHeaderMap() {
        if (this.headerMap == null) {
            this.headerMap = new HashMap();
        }
        return this.headerMap;
    }

    private HashMap getFooterMap() {
        if (this.footerMap == null) {
            this.footerMap = new HashMap();
        }
        return this.footerMap;
    }

    private Object[] createPaperByFrugal2(BufferPrintJob theJob, int index, PaperInfo info, boolean isCountNumberOfPages) {
        Object job = theJob;
        int addPageCount = 0;
        Page onePage = null;
        DimensionFloat rect = info.getPaintableSize2();
        float nextY = 0.0f;
        if (this.isFrugal) {
            onePage = new Page();
            onePage.setPainterBounds(0.0f, 0.0f, rect.width, rect.height);
            this.createPageHeader(onePage, (BufferPrintJob)job, 0.0f);
            nextY = this.tableSpace - 1;
        } else {
            HeadFootModel header = (HeadFootModel)this.getHeaderMap().get(job.getID());
            this.setHeader(header);
        }
        Page thPage = job.getPage(index);
        if (this.isFrugal) {
            thPage.setPainterLocation(0.0f, nextY);
            onePage.addPainter((IPainter)thPage);
            nextY += (float)thPage.getPainterSize().getHeight();
            while (true) {
                ++index;
                Page page = null;
                if (!isCountNumberOfPages) {
                    page = job.getPage(index);
                } else {
                    page = job.getBoundsPage(index);
                    if (page == null) {
                        page = job.getPage(index);
                    }
                }
                if (page == null) {
                    TablePrintJob nextjob = this.getNextJob((IPrintJob)job);
                    if (nextjob == null) break;
                    job = nextjob;
                    index = -1;
                    continue;
                }
                boolean isAdd = this.canAdd(onePage, page, index, nextY);
                if (!isAdd) break;
                if (index == 0) {
                    this.createPageHeader(onePage, (BufferPrintJob)job, nextY);
                    nextY += (float)this.tableSpace;
                } else {
                    nextY += (float)this.blockSpace;
                }
                onePage.addPainter((IPainter)page);
                page.setPainterLocation(0.0f, nextY);
                nextY += page.getPainterBounds().height;
                ++addPageCount;
            }
            onePage.setPainterSize(rect.width, nextY);
            --index;
        } else {
            onePage = thPage;
        }
        Object[] jobAndPageIndex = new Object[]{job, index, onePage};
        return jobAndPageIndex;
    }

    private boolean canAdd(Page onePage, Page page, int index, float useHeight) {
        double height;
        int space = this.blockSpace;
        if (index == 0) {
            space = this.tableSpace;
        }
        return !((height = (double)(useHeight + (float)space) + page.getPainterSize().getHeight()) > onePage.getPainterBounds().getHeight());
    }

    private int createPageHeader(Page onePage, BufferPrintJob job, float useHeight) {
        HeadFootModel model = (HeadFootModel)this.getHeaderMap().get(job.getID());
        if (model != null) {
            HeaderFooter headerUI = new HeaderFooter();
            headerUI.setModel(model);
            Rectangle2D.Float headRect = this.getPaperInfo().getPageHeadBounds();
            headerUI.setPainterLocation(0.0f, useHeight);
            headerUI.setPainterSize(headRect.width, (float)this.tableSpace);
            headerUI.setPainterInfo(job.getPrintPainterInfo());
            onePage.addPainter((IPainter)headerUI, headerUI.getLayer());
            return this.tableSpace - 1;
        }
        return 0;
    }

    private TablePrintJob getNextJob(IPrintJob job) {
        TablePrintJob nextJob = null;
        int jobsize = this.jobs.length;
        block0: for (int i = 0; i < jobsize; ++i) {
            TablePrintJob ajob = this.jobs[i];
            if (job != ajob) continue;
            for (int nextCount = i + 1; nextCount < jobsize; ++nextCount) {
                nextJob = this.jobs[nextCount];
                if (nextJob.getPageCount() != 0) break block0;
            }
            nextJob = null;
            break;
        }
        return nextJob;
    }

    protected HashMap getFrugalPageMap() {
        if (this.frugalPageMap == null) {
            this.frugalPageMap = new HashMap();
        }
        return this.frugalPageMap;
    }

    public void setBlockSpace(int space) {
        this.blockSpace = space;
    }

    public void setTableSpace(int space) {
        this.tableSpace = space;
    }

    protected void createHeader(Paper paper) {
        Canvas header = this.getHeader();
        if (!this.isFrugal) {
            paper.setHeader(header);
        }
    }

    protected double getScale(PrintRequestAttributeSet printRequestSet) {
        Class<ZoomScaleInfo> c = ZoomScaleInfo.class;
        ZoomScaleInfo factor = (ZoomScaleInfo)printRequestSet.get(c);
        if (factor == null) {
            return 1.0;
        }
        double scale = 1.0;
        if (!factor.isAutoFit()) {
            scale = factor.getScale();
            if (scale <= 0.0) {
                scale = 1.0;
            }
        } else {
            IConfigModel model;
            int w = factor.getAutoFitWidth();
            int h = factor.getAutoFitHeight();
            Rectangle pageRect = KDPrinterUtils.getPageBounds((PrintRequestAttributeSet)printRequestSet, (int)KDPrinterUtils.SCREEN_RESOLUTION);
            double scaleW = 1.0;
            double scaleH = 1.0;
            if (w > 0) {
                KDTIndexColumn column;
                int width = 0;
                PrintJobConfig config = this.getConfig();
                if (config != null && (model = config.getConfig(TableResources.getMsg((String)"tree.name"))) instanceof TablePageSetupModel && ((TablePageSetupModel)model).isRowIndex() && (column = this.table.getIndexColumn()) != null) {
                    width = column.getWidth();
                }
                if (width < 0) {
                    width = 0;
                }
                for (int i = 0; i < this.table.getColumnCount(); ++i) {
                    width += this.table.getColumn(i).getWidth();
                }
                if (width != 0) {
                    scaleW = (double)(pageRect.width * w) / (double)width;
                }
                if (scaleW > 1.0) {
                    scaleW = 1.0;
                }
            }
            if (h > 0) {
                int height = 0;
                PrintJobConfig config = this.getConfig();
                if (config != null && (model = config.getConfig(TableResources.getMsg((String)"tree.name"))) instanceof TablePageSetupModel && ((TablePageSetupModel)model).isColumnIndex()) {
                    for (int i = this.table.getHeadRowCount() - 1; i >= 0; --i) {
                        height += this.table.getHeadRow(i).getHeight();
                    }
                }
                if (height < 0) {
                    height = 0;
                }
                for (int i = 0; i < this.table.getRowCount(); ++i) {
                    height += this.table.getRow(i).getHeight();
                }
                if (height != 0) {
                    scaleH = (double)(pageRect.height * h) / (double)height;
                }
                if (scaleH > 1.0) {
                    scaleH = 1.0;
                }
            }
            scale = scaleH > scaleW ? scaleW : scaleH;
            printRequestSet.add((Attribute)new ZoomScaleInfo(w, h, scale));
        }
        return scale;
    }
}

