/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.print;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.print.TablePrintJob;
import com.kingdee.cosmic.ctrl.kdf.table.print.TablePrintJobImp;
import com.kingdee.cosmic.ctrl.print.IPrintActionListener;
import com.kingdee.cosmic.ctrl.print.KDPConstant;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupUI;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePrintSetupModel;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePrintSetupUI;
import com.kingdee.cosmic.ctrl.print.config.ui.PageSetupUI2;
import com.kingdee.cosmic.ctrl.print.config.ui.PageSetupUI3;
import com.kingdee.cosmic.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.cosmic.ctrl.print.printjob.IPrintJob;
import com.kingdee.cosmic.ctrl.print.resource.Resources;
import com.kingdee.cosmic.ctrl.print.resource.TableResources;
import java.awt.Component;

public class NewPrintManager
implements KDPConstant,
IPrintActionListener {
    protected KDTable table;
    protected KDPrinter printer;
    protected TablePrintSetupModel printmodel;
    protected TablePageSetupModel configmodel;
    protected String pageSetupModeName = TableResources.getMsg((String)"tree.name");
    protected String printSetupModeName = Resources.getMsg((String)"tree.print");
    protected IPrintJob printjob;
    protected boolean expandedOnly = false;
    protected Component parent;
    protected Class headfootUI;
    private boolean isAutoMemoryClear = false;

    public NewPrintManager(KDTable table) {
        this.setTable(table);
        this.initModel();
    }

    private void initModel() {
        this.printmodel = new TablePrintSetupModel();
        this.configmodel = new TablePageSetupModel();
        this.configmodel.setDefaultValue(true, true, false, true, false);
        this.configmodel.setDefault();
    }

    public void setDefault(boolean gridDefault, boolean singleColorDefault, boolean rowIndexDefault, boolean columnIndexDefault, boolean orderDefault) {
        this.configmodel.setDefaultValue(gridDefault, singleColorDefault, rowIndexDefault, columnIndexDefault, orderDefault);
        this.configmodel.setDefault();
    }

    public void setHeadFootUI(Class ui) {
        this.headfootUI = ui;
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    protected void resetKDPrinter() {
        if (this.printer == null) {
            this.printer = new KDPrinter();
            this.printer.addPrintActionListener((IPrintActionListener)this);
        }
        this.clear();
        this.printer.setParentWindow((Component)this.table);
        if (this.parent != null) {
            this.printer.setParentWindow(this.parent);
        }
        this.printer.getPrintPreview().setWindowType(0);
        if (this.table != null && this.table.getDataRequestManager().getDataRequestMode() == 0) {
            this.printer.unRegisterConfigUI(Resources.getMsg((String)"tree.page"));
            this.printer.registerConfigUI(Resources.getMsg((String)"tree.page"), PageSetupUI2.class, 0);
        } else {
            this.printer.unRegisterConfigUI(Resources.getMsg((String)"tree.page"));
            this.printer.registerConfigUI(Resources.getMsg((String)"tree.page"), PageSetupUI3.class, 0);
        }
        if (this.headfootUI != null) {
            this.printer.unRegisterConfigUI(Resources.getMsg((String)"tree.headerfooter"));
            this.printer.registerConfigUI(Resources.getMsg((String)"tree.headerfooter"), this.headfootUI, 2);
        }
        this.printer.registerConfigUI(this.pageSetupModeName, TablePageSetupUI.class, 2);
        this.printmodel.setSinglePrintJob(true);
        this.printer.setPrintPanel(TablePrintSetupUI.class, (PrintConfigModel)this.printmodel);
    }

    protected void clear() {
        this.printer.clear();
    }

    public KDPrinter getPrinter() {
        if (this.printer == null) {
            this.resetKDPrinter();
        }
        if (this.parent != null) {
            this.printer.setParentWindow(this.parent);
        }
        return this.printer;
    }

    public KDTable getTable() {
        return this.table;
    }

    public TablePageSetupModel getPrintJobConfig() {
        return this.configmodel;
    }

    public TablePrintSetupModel getPrinterConfig() {
        return this.printmodel;
    }

    public boolean pageDialog() {
        IPrintJob job = this.createPrintJobs();
        int status = job.pageDialog((Component)this.table, false);
        if (status == 3) {
            this.printPreview();
            return false;
        }
        return status == 1;
    }

    public void print() {
        boolean isCallBack = this.doBeforePrint();
        this.getPrinter().print();
        this.doAfterPrint(isCallBack);
    }

    public void printDirect() {
        boolean isCallBack = this.doBeforePrint();
        this.getPrinter().printDirect();
        this.doAfterPrint(isCallBack);
    }

    private boolean doBeforePrint() {
        boolean callback = this.table.getDataRequestManager().isMemoryCallback();
        if (this.isAutoMemoryClear()) {
            this.table.getDataRequestManager().setMemoryCallback(true);
        }
        return callback;
    }

    private void doAfterPrint(boolean isCallBack) {
        this.table.getDataRequestManager().setMemoryCallback(isCallBack);
    }

    public void printPreview() {
        boolean isCallBack = this.doBeforePrint();
        this.getPrinter().printPreview();
        this.doAfterPrint(isCallBack);
    }

    public void printPreview(Component parent) {
        this.parent = parent;
        this.printPreview();
    }

    public IPrintJob createPrintJobs() {
        this.resetKDPrinter();
        if (this.printjob == null) {
            this.printjob = this.newPrintJob();
            this.printjob.setPrinter(this.printer);
        }
        this.printjob.clear();
        this.printer.addPrintJob(this.printjob);
        this.printjob.getConfig().setConfig(this.pageSetupModeName, this.getConfigModel());
        this.printjob.getConfig().setConfig(this.printSetupModeName, (IConfigModel)this.printmodel);
        return this.printjob;
    }

    public IPrintJob getPrintJob() {
        return this.printjob;
    }

    public IPrintJob newPrintJob() {
        return new TablePrintJob(new TablePrintJobImp(this.table), (PrintConfigModel)this.printmodel, this.pageSetupModeName);
    }

    private IConfigModel getConfigModel() {
        return this.configmodel;
    }

    public IXmlElement toXmlElement() {
        this.createPrintJobs();
        if (this.printjob != null) {
            this.printjob.setID(this.table.getID());
        }
        IXmlElement e = this.getPrinter().getPrintConfig().toXmlElement();
        return e;
    }

    public void fromXmlElement(IXmlElement e) {
        this.createPrintJobs();
        this.getPrinter().getPrintConfig().fromXmlElement(e);
    }

    public void beforePrintOrPreview() {
        this.createPrintJobs();
    }

    public void beforePreview() {
    }

    public void setTable(KDTable table2) {
        this.table = table2;
    }

    public void setExpandedOnly(boolean expandedOnly) {
        this.expandedOnly = expandedOnly;
    }

    public boolean isExpandedOnly() {
        return this.expandedOnly;
    }

    public void closePreview() {
    }

    public boolean isAutoMemoryClear() {
        return this.isAutoMemoryClear;
    }

    public void setAutoMemoryClear(boolean isAutoMemoryClear) {
        this.isAutoMemoryClear = isAutoMemoryClear;
    }

    public void beforePrint() {
    }
}

