/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.editor;

import com.kingdee.cosmic.ctrl.kdf.table.KDTAbstractCellEditor;
import com.kingdee.cosmic.ctrl.kdf.util.Util;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTextField;

public class MultiTypeEditor
extends KDTAbstractCellEditor {
    JTextField comp = new JTextField();
    protected int clickCountToStart = 2;

    @Override
    public Object getValue() {
        Object value = null;
        String str = this.comp.getText();
        value = str == null || str.equals("") ? null : this.getObjectFrom(str);
        return value;
    }

    @Override
    public void setValue(Object value) {
        this.comp.setText(value != null ? value.toString() : "");
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public Component prepareComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
        char keyChar;
        this.setValue(value);
        this.comp.setBorder(null);
        this.comp.setBackground(style.getBackground());
        this.comp.setForeground(style.getFontColor());
        this.comp.setFont((Font)style.getKDFont());
        if (anEvent instanceof KeyEvent && (keyChar = ((KeyEvent)anEvent).getKeyChar()) >= ' ' && keyChar <= '~') {
            this.comp.setText(String.valueOf(keyChar));
        }
        return this.comp;
    }

    @Override
    public Component getComponent() {
        return this.comp;
    }

    private Object getObjectFrom(String str) {
        Object value = this.stringToNumber(str);
        if (value == null) {
            value = this.stringToBoolean(str);
        }
        if (value == null) {
            value = this.stringToDate(str);
        }
        if (value == null) {
            value = str;
        }
        return value;
    }

    private Object stringToNumber(String str) {
        return Util.stringToNumber((String)str);
    }

    private Object stringToBoolean(String str) {
        return Util.stringToBoolean((String)str);
    }

    private Object stringToDate(String str) {
        return Util.stringToDate((String)str);
    }

    @Override
    public Component getFocusComponent() {
        return this.comp;
    }

    @Override
    public String getText() {
        return this.comp.getText();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
    }

    @Override
    public void setText(String text) {
        this.comp.setText(text);
    }
}

