/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.kdfsax;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.SAXTableHandler;
import com.kingdee.cosmic.ctrl.kdf.util.kdfsax.BasicElementHandler;
import com.kingdee.cosmic.ctrl.kdf.util.kdfsax.IElementHandler;
import com.kingdee.cosmic.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.cosmic.ctrl.kdf.util.kdfsax.StylesHandler;
import com.kingdee.cosmic.ctrl.kdf.util.kdfsax.UserObjectsHandler;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KDFSAX
extends BasicElementHandler {
    private HashMap userObjects;
    private HashMap styles;
    private ArrayList tables;
    public static final int ALL = 15;
    public static final int STYLE = 1;
    public static final int VALUE = 2;
    public static final int USEROBJECT = 4;
    public static final int SHEET_USEROBJECT = 8;
    public static final int KDF_USEROBJECT = 16;
    private int mark = 15;

    public KDFSAX() {
        this(15);
    }

    public KDFSAX(int mark) {
        this.mark = mark;
        this.current = this;
        this.kdf = this;
        this.handlerMap = new HashMap();
        if (this.isStyle()) {
            this.handlerMap.put("Styles", new StylesHandler());
        }
        this.handlerMap.put("Table", new SAXTableHandler());
        if (this.isKDFUserObject()) {
            this.handlerMap.put("UserObjects", new UserObjectsHandler());
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        super.endElement(namespaceURI, sName, qName);
        if ("Styles".equals(qName)) {
            this.currentHandler = null;
        }
    }

    public void load(InputSource is) throws KDFSAXException {
        SAXParserFactory factory = null;
        try {
            factory = this.createSAXParser();
            if (null != factory) {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(is, (DefaultHandler)new MyHandler());
            }
        }
        catch (Exception e) {
            throw new KDFSAXException(e);
        }
    }

    public void load(InputStream is) throws KDFSAXException {
        SAXParserFactory factory = null;
        try {
            factory = this.createSAXParser();
            if (null != factory) {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(is, (DefaultHandler)new MyHandler());
            }
        }
        catch (Exception e) {
            throw new KDFSAXException(e);
        }
    }

    public void load(String file) throws KDFSAXException {
        SAXParserFactory factory = null;
        try {
            factory = this.createSAXParser();
            if (null != factory) {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(new File(FilenameUtils.normalize((String)file)), (DefaultHandler)new MyHandler());
            }
        }
        catch (Exception e) {
            throw new KDFSAXException(e);
        }
    }

    public IElementHandler getCurrentHandler() {
        return this.currentHandler;
    }

    public void setCurrentHandler(IElementHandler currentHandler) {
        this.currentHandler = currentHandler;
    }

    public HashMap getStyles() {
        return this.styles;
    }

    public void setStyles(HashMap styles) {
        this.styles = styles;
    }

    public ShareStyleAttributes getStyleAttributes(String id) {
        ShareStyleAttributes ssa = null;
        if (this.styles != null) {
            ssa = (ShareStyleAttributes)this.styles.get(id);
        }
        if (ssa == null) {
            ssa = Styles.getEmptySSA();
        }
        return ssa;
    }

    public ArrayList getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList();
        }
        return this.tables;
    }

    public void setTables(ArrayList tables) {
        this.tables = tables;
    }

    public Collection getAllTable() {
        return this.getTables();
    }

    public KDTable getTableByIndex(int idx) {
        if (idx < this.getTables().size()) {
            return (KDTable)this.getTables().get(idx);
        }
        return null;
    }

    public KDTable getTableByID(String id) {
        if (!StringUtil.isEmptyString((String)id)) {
            for (KDTable table : this.getTables()) {
                if (!id.equals(table.getID())) continue;
                return table;
            }
        }
        return null;
    }

    public KDTable removeTableByID(String id) {
        if (!StringUtil.isEmptyString((String)id)) {
            Iterator it = this.getTables().iterator();
            int i = 0;
            while (it.hasNext()) {
                KDTable table = (KDTable)it.next();
                if (id.equals(table.getID())) {
                    return (KDTable)this.tables.remove(i);
                }
                ++i;
            }
        }
        return null;
    }

    public KDTable removeTableByIndex(int idx) {
        return (KDTable)this.getTables().remove(idx);
    }

    private SAXParserFactory createSAXParser() throws Exception {
        SAXParserFactory factory = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(KDFSAX.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
        return factory;
    }

    public static void main(String[] args) {
    }

    public HashMap getUserObjects() {
        if (this.userObjects == null) {
            this.userObjects = new HashMap();
        }
        return this.userObjects;
    }

    public void setUserObjects(HashMap userObjects) {
        this.userObjects = userObjects;
    }

    public void addUserObject(String key, Object value) {
        this.getUserObjects().put(key, value);
    }

    public Object getUserObject(String key) {
        return this.getUserObjects().get(key);
    }

    public Object removeUserObject(String key) {
        return this.getUserObjects().remove(key);
    }

    public boolean isAll() {
        return this.mark == 15;
    }

    public boolean isStyle() {
        return (this.mark & 1) == 1;
    }

    public boolean isValue() {
        return (this.mark & 2) == 2;
    }

    public boolean isUserObject() {
        return (this.mark & 4) == 4;
    }

    public boolean isSheetUserObject() {
        return (this.mark & 8) == 8;
    }

    public boolean isKDFUserObject() {
        return (this.mark & 0x10) == 16;
    }

    class MyHandler
    extends DefaultHandler {
        MyHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            KDFSAX.this.startElement(namespaceURI, sName, qName, attrs);
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            KDFSAX.this.endElement(namespaceURI, sName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            KDFSAX.this.characters(ch, start, length);
        }
    }
}

