/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ButtonActionPropertyListenerEx
implements PropertyChangeListener {
    private static ReferenceQueue queue;
    private WeakReference target;
    private Action action;

    public ButtonActionPropertyListenerEx(JComponent b, Action a) {
        this.setTarget(b);
        this.action = a;
    }

    public void setTarget(JComponent c) {
        OwnedWeakReference r;
        if (queue == null) {
            queue = new ReferenceQueue();
        }
        while ((r = (OwnedWeakReference)queue.poll()) != null) {
            ButtonActionPropertyListenerEx oldPCL = (ButtonActionPropertyListenerEx)r.getOwner();
            Action oldAction = oldPCL.getAction();
            if (oldAction == null) continue;
            oldAction.removePropertyChangeListener(oldPCL);
        }
        this.target = new OwnedWeakReference(c, queue, this);
    }

    public JComponent getTarget() {
        return (JComponent)this.target.get();
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        AbstractButton button = (AbstractButton)this.getTarget();
        if (button == null) {
            Action action = (Action)e.getSource();
            action.removePropertyChangeListener(this);
        } else if (e.getPropertyName().equals("Name")) {
            String text;
            Boolean hide = (Boolean)button.getClientProperty("hideActionText");
            if (hide != null && !hide.booleanValue() && (text = (String)e.getNewValue()) != null && text.length() > 0) {
                button.setText(text);
                button.repaint();
            }
        } else if (e.getPropertyName().equals("ShortDescription")) {
            String text = (String)e.getNewValue();
            button.setToolTipText(text);
        } else if (propertyName.equals("visible")) {
            Boolean visibleState = (Boolean)e.getNewValue();
            if (visibleState != null) {
                button.setVisible(visibleState);
            }
        } else if (propertyName.equals("enabled")) {
            Boolean enabledState = (Boolean)e.getNewValue();
            button.setEnabled(enabledState);
            button.repaint();
        } else if (e.getPropertyName().equals("SmallIcon")) {
            Icon icon = (Icon)e.getNewValue();
            button.setIcon(icon);
            button.invalidate();
            button.repaint();
        } else if (e.getPropertyName().equals("MnemonicKey")) {
            Integer mn = (Integer)e.getNewValue();
            button.setMnemonic(mn);
            button.invalidate();
            button.repaint();
        } else if (e.getPropertyName().equals("ActionCommandKey")) {
            button.setActionCommand((String)e.getNewValue());
        }
    }

    private static class OwnedWeakReference
    extends WeakReference {
        private Object owner;

        OwnedWeakReference(Object target, ReferenceQueue queue, Object owner) {
            super(target, queue);
            this.owner = owner;
        }

        public Object getOwner() {
            return this.owner;
        }
    }
}

