/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorSelectedListener;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import com.kingdee.cosmic.ctrl.swing.model.ComboColorSelectionModel;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeComboColorDownListUI;
import java.awt.Color;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.colorchooser.ColorSelectionModel;

public class ComboColorDownList
extends JComponent
implements IKDComponent,
IKDEditor {
    private static final long serialVersionUID = -2248999230336665466L;
    protected Object userObject;
    private static final String uiClassID = "KingdeeComboColorDownListUI";
    private ColorSelectionModel selectionModel;
    private PropertyChangeListener propetyChangeListener = new PropertyChangeHandler();
    private boolean isUsedColorUI;
    private Color defaultColor = Color.BLACK;
    private String defaultColorPrompt = CtrlSwingMessages.getMLS("defaultColorPrompt", "\u81ea\u52a8");

    public ComboColorDownList(ColorSelectionModel model) {
        this.selectionModel = model == null ? new ComboColorSelectionModel() : model;
        this.updateUI();
        this.setFocusable(true);
        this.addPropertyChangeListener(this.propetyChangeListener);
        this.setOpaque(true);
        this.setBackground(new Color(245, 245, 245));
        this.setBorder(BorderFactory.createLineBorder(Color.BLUE));
    }

    public ComboColorDownList(ColorSelectionModel model, boolean isUsedColorUI) {
        this.isUsedColorUI = isUsedColorUI;
        this.selectionModel = model == null ? new ComboColorSelectionModel() : model;
        this.updateUI();
        this.setFocusable(true);
        this.addPropertyChangeListener(this.propetyChangeListener);
        this.setOpaque(true);
        this.setBackground(new Color(245, 245, 245));
        this.setBorder(BorderFactory.createLineBorder(Color.BLUE));
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public boolean isUsedColorUI() {
        return this.isUsedColorUI;
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        this.listenerList.add(DataChangeListener.class, listener);
    }

    protected void fireDataChanged(Object source, Object newValue, Object oldValue) {
        Object[] listeners = this.listenerList.getListenerList();
        DataChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class) continue;
            if (null == changeEvent) {
                changeEvent = new DataChangeEvent(source.getClass());
            }
            changeEvent.setNewValue(newValue);
            changeEvent.setOldValue(oldValue);
            ((DataChangeListener)listeners[i + 1]).dataChanged(changeEvent);
        }
    }

    @Override
    public Object getValue() {
        return this.getSelectionModel().getSelectedColor();
    }

    @Override
    public boolean isDisplay() {
        return this.isVisible();
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        this.listenerList.remove(DataChangeListener.class, listener);
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.setVisible(isDisplay);
    }

    @Override
    public void setValue(Object value) {
        if (value != null && !(value instanceof Color)) {
            throw new IllegalArgumentException("value is illegal.");
        }
        this.getSelectionModel().setSelectedColor((Color)value);
    }

    @Override
    public KingdeeComboColorDownListUI getUI() {
        return (KingdeeComboColorDownListUI)this.ui;
    }

    public void setUI(KingdeeComboColorDownListUI ui) {
        super.setUI(ui);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeComboColorDownListUI)UIManager.getUI(this));
    }

    public ColorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ColorSelectionModel model) {
        ColorSelectionModel oldModel = this.selectionModel;
        if (oldModel != model) {
            this.selectionModel = model;
            this.firePropertyChange("selectionModel", oldModel, model);
        }
    }

    public Color getColor() {
        return this.getSelectionModel().getSelectedColor();
    }

    public void setColor(Color c) {
        Color old = this.getSelectionModel().getSelectedColor();
        this.getSelectionModel().setSelectedColor(c);
        this.firePropertyChange("selectedColor", old, c);
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color color) {
        Color old = this.getDefaultColor();
        if (old != color) {
            this.defaultColor = color;
            this.firePropertyChange("defaultColor", old, this.getDefaultColor());
        }
    }

    public String getDefaultColorPrompt() {
        return this.defaultColorPrompt;
    }

    public void setDefaultColorPrompt(String string) {
        String old = this.getDefaultColorPrompt();
        if (!Objects.equals(old, string)) {
            this.defaultColorPrompt = string;
            this.firePropertyChange("defaultColorPrompt", old, this.getDefaultColorPrompt());
        }
    }

    public void addChooseKeyListener(KeyListener l) {
        this.getUI().addChooseKeyListener(l);
    }

    public void removeChooseKeyListener(KeyListener l) {
        this.getUI().removeChooseKeyListener(l);
    }

    public void addChooseMouseListener(MouseListener l) {
        this.getUI().addChooseMouseListener(l);
    }

    public void removeChooseMouseListener(MouseListener l) {
        this.getUI().removeChooseMouseListener(l);
    }

    public void addSelectedListener(ComboColorSelectedListener l) {
        this.listenerList.add(ComboColorSelectedListener.class, l);
    }

    public void removeSelectedListener(ComboColorSelectedListener l) {
        this.listenerList.remove(ComboColorSelectedListener.class, l);
    }

    public void addUsedColorPersistence(KDComboColor.IUsedColorPersistence i) {
        this.getUI().setSaveUsedColorListener(i);
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.cosmic.ctrl.swing.plaf.KingdeeComboColorDownListUI");
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectedColor")) {
                ComboColorDownList.this.fireDataChanged(ComboColorDownList.this.getSelectionModel(), evt.getNewValue(), evt.getOldValue());
            }
        }
    }
}

