/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class DecimalFormatEx
extends DecimalFormat {
    private static final long serialVersionUID = -6361251663295162889L;
    private static final String validateStr = "0123456789,.-";
    private KDFormattedTextField textField = null;

    public DecimalFormatEx() {
    }

    public DecimalFormatEx(String pattern) {
        super(pattern);
    }

    public DecimalFormatEx(String pattern, DecimalFormatSymbols symbols) {
        super(pattern, symbols);
    }

    public void setFormattedTextField(KDFormattedTextField ftf) {
        this.textField = ftf;
    }

    public static DecimalFormatEx getPercentInstanceEx() {
        Locale desiredLocale = Locale.getDefault();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(desiredLocale);
        DecimalFormatEx format = new DecimalFormatEx("#,##0%", symbols);
        return format;
    }

    public static DecimalFormatEx getPercentInstanceEx2() {
        DecimalFormatSymbols symbols = CtrlFormatUtilities.getDecimalFormatSymbols();
        if (symbols == null) {
            Locale desiredLocale = Locale.getDefault();
            symbols = new DecimalFormatSymbols(desiredLocale);
        }
        DecimalFormatEx format = new DecimalFormatEx("#,##0\u2030", symbols);
        return format;
    }

    public void setRemovingMinus(boolean b) {
        this.setNegativePrefix(b ? "" : "-");
    }

    public String formatBigDecimal(BigDecimal number) {
        if (this.textField == null) {
            return number.toString();
        }
        if (!this.textField.isGroupingUsed()) {
            return number.toString();
        }
        if (this.textField != null && !this.textField.hasFocus()) {
            DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
            StringBuffer sb = new StringBuffer();
            if (number != null) {
                String numberStr = CtrlSwingUtilities.bigDecimalToPlainString(number);
                if (numberStr.charAt(0) == '-') {
                    if (!this.textField.isRemovingMinusInDisplay()) {
                        sb.append('-');
                    }
                    numberStr = numberStr.substring(1);
                }
                int dotIndex = numberStr.indexOf(46);
                String prefix = "";
                String subfix = "";
                if (dotIndex != -1) {
                    prefix = numberStr.substring(0, dotIndex);
                    subfix = numberStr.substring(dotIndex).replace('.', symbols.getDecimalSeparator());
                } else {
                    prefix = numberStr;
                }
                char[] prefixDigits = prefix.toCharArray();
                int prefixDigitsLen = prefixDigits.length;
                int groupStartIndex = 0;
                int groups = prefixDigitsLen / 3;
                int mods = prefixDigitsLen % 3;
                if (mods == 0 && groups > 0) {
                    if (--groups > 0) {
                        groupStartIndex = 3;
                    }
                } else {
                    groupStartIndex = mods;
                }
                for (int i = 0; i < prefixDigitsLen; ++i) {
                    if (groups > 0 && i == groupStartIndex) {
                        sb.append(symbols.getGroupingSeparator());
                        groupStartIndex += 3;
                        --groups;
                    }
                    sb.append(prefixDigits[i]);
                }
                sb.append(subfix);
            }
            if (this.textField.isPercentDisplay()) {
                sb = this.toPercent(sb);
            }
            if (this.textField.isRemoveingZeroInDispaly()) {
                sb = this.removeTrailZero(sb);
            }
            return sb.toString();
        }
        String numberStr = CtrlSwingUtilities.bigDecimalToPlainString(number);
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        numberStr = numberStr.replace('.', symbols.getDecimalSeparator());
        if (this.textField.isRemoveingZeroInEdit() && this.textField.getDataVerifierType() != 12) {
            return this.removeTrailZero(numberStr).toString();
        }
        return numberStr;
    }

    public Object parseBigDecimal(String text) throws ParseException {
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        char decimalSeparator = symbols.getDecimalSeparator();
        char groupingSeparator = symbols.getGroupingSeparator();
        int lastDotIndex = text.lastIndexOf(decimalSeparator);
        if (lastDotIndex == -1) {
            lastDotIndex = text.length();
        } else if (lastDotIndex > 0 && decimalSeparator == text.charAt(lastDotIndex - 1)) {
            text = text.substring(0, lastDotIndex) + text.substring(lastDotIndex + 1, text.length());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i < lastDotIndex && (i - lastDotIndex) % 4 == 0 && groupingSeparator == c) continue;
            sb.append(c);
        }
        if (!this.isValidChar(text.toCharArray())) {
            throw new ParseException("Format.parseObject(String) failed", text.length());
        }
        try {
            NumberFormat f = DecimalFormat.getInstance();
            if (f instanceof DecimalFormat) {
                ((DecimalFormat)f).setDecimalFormatSymbols(this.getDecimalFormatSymbols());
            }
            return f.parse(sb.toString());
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("Format.parseObject(String) failed", 0);
            parseException.initCause(e);
            throw parseException;
        }
    }

    private boolean isValidChar(char[] c) {
        for (int i = 0; i < c.length; ++i) {
            if (validateStr.indexOf(c[i]) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean isNotZeroDigits(char c) {
        return c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
    }

    private int findNotZeroDigitLastIndex(StringBuffer sb, int dotIndex) {
        int lastIndex = -1;
        for (int i = dotIndex + 1; i < sb.length(); ++i) {
            if (!this.isNotZeroDigits(sb.charAt(i))) continue;
            lastIndex = i;
        }
        return lastIndex;
    }

    StringBuffer removeTrailZero(StringBuffer sb) {
        int dotIndex = sb.indexOf(String.valueOf(this.getDecimalFormatSymbols().getDecimalSeparator()));
        if (dotIndex != -1) {
            int index = this.findNotZeroDigitLastIndex(sb, dotIndex);
            sb = index != -1 ? sb.delete(index + 1, sb.length()) : sb.delete(dotIndex, sb.length());
        }
        return sb;
    }

    private StringBuffer toPercent(StringBuffer sb) {
        if (ArrayUtil.isEqual((Float)Float.valueOf(new BigDecimal(sb.toString()).floatValue()), (Float)Float.valueOf(0.0f))) {
            StringBuffer sb1 = new StringBuffer();
            sb1.append('0');
            int precision = this.textField.getPrecision();
            if (precision > 0) {
                sb1.append('.');
                for (int i = 0; i < precision; ++i) {
                    sb1.append('0');
                }
            }
            return sb1.append('%');
        }
        int dotIndex = sb.indexOf(".");
        if (dotIndex == -1) {
            sb = sb.append("00");
        } else {
            int len = sb.length();
            int b = len - dotIndex - 1;
            if (b == 1) {
                sb.replace(dotIndex, dotIndex + 1, "");
                sb.append('0');
            } else if (b == 2) {
                sb.replace(dotIndex, dotIndex + 1, "");
            } else if (b > 2) {
                sb.insert(dotIndex + 3, '.');
                sb.replace(dotIndex, dotIndex + 1, "");
            }
        }
        return sb.append('%');
    }

    private StringBuffer removeTrailZero(String s) {
        StringBuffer sb = new StringBuffer(s);
        return this.removeTrailZero(sb);
    }
}

