/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.KDSplitPane;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeSplitPaneUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class DefaultKingdeeSplitPaneDivider
extends BasicSplitPaneDivider {
    private static final long serialVersionUID = 1265440708968525121L;
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);

    public DefaultKingdeeSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setBorder(null);
        this.setBackground(Color.decode("#E4E4DF"));
        this.setLayout(new myDividerLayout());
    }

    private void setArrowType(int t) {
        ((KDSplitPane)this.splitPane).setArrowType(t);
    }

    private int getArrowType() {
        return ((KDSplitPane)this.splitPane).getArrowType();
    }

    @Override
    public void setEnabled(boolean b) {
        if (b == this.isEnabled()) {
            return;
        }
        super.setEnabled(b);
        if (b) {
            this.splitPane.addMouseListener(this.mouseHandler);
            this.splitPane.addMouseMotionListener(this.mouseHandler);
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
        } else {
            this.splitPane.removeMouseListener(this.mouseHandler);
            this.splitPane.removeMouseMotionListener(this.mouseHandler);
            this.removeMouseListener(this.mouseHandler);
            this.removeMouseMotionListener(this.mouseHandler);
        }
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public void paint(Graphics g) {
                if (DefaultKingdeeSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    if (DefaultKingdeeSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), 6);
                        xs[1] = 0;
                        xs[2] = blockSize << 1;
                        ys[0] = 0;
                        ys[1] = ys[2] = blockSize;
                        g.setColor(UIManager.getColor("SplitPane.arrowColor"));
                        g.fillPolygon(xs, ys, 3);
                        g.setColor(UIManager.getColor("SplitPane.arrow.borderColor"));
                        g.drawLine(1, 5, 1, 4);
                        g.drawLine(2, 3, 5, 0);
                        g.drawLine(6, 0, 9, 3);
                        g.drawLine(10, 4, 10, 5);
                        g.drawLine(2, 5, 9, 5);
                    } else {
                        int blockSize = Math.min(this.getWidth(), 6);
                        xs[0] = xs[2] = blockSize - 1;
                        xs[1] = 0;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                        g.setColor(UIManager.getColor("SplitPane.arrowColor"));
                        g.fillPolygon(xs, ys, 3);
                        g.setColor(UIManager.getColor("SplitPane.arrow.borderColor"));
                        g.drawLine(4, 1, 5, 1);
                        g.drawLine(0, 5, 3, 2);
                        g.drawLine(0, 6, 3, 9);
                        g.drawLine(4, 10, 5, 10);
                        g.drawLine(5, 2, 5, 9);
                    }
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setMinimumSize(new Dimension(6, 6));
        b.setCursor(defaultCursor);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    @Override
    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void setBorder(Border border) {
            }

            @Override
            public void paint(Graphics g) {
                if (DefaultKingdeeSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    if (DefaultKingdeeSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), 6);
                        xs[1] = blockSize << 1;
                        xs[2] = 0;
                        ys[0] = blockSize - 1;
                        ys[2] = 0;
                        ys[1] = 0;
                        g.setColor(UIManager.getColor("SplitPane.arrowColor"));
                        g.fillPolygon(xs, ys, 3);
                        g.setColor(UIManager.getColor("SplitPane.arrow.borderColor"));
                        g.drawLine(1, 0, 1, 1);
                        g.drawLine(2, 2, 5, 5);
                        g.drawLine(6, 5, 9, 2);
                        g.drawLine(10, 0, 10, 1);
                        g.drawLine(2, 0, 9, 0);
                    } else {
                        int blockSize = Math.min(this.getWidth(), 6);
                        xs[2] = 0;
                        xs[0] = 0;
                        xs[1] = blockSize - 1;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                        g.setColor(UIManager.getColor("SplitPane.arrowColor"));
                        g.fillPolygon(xs, ys, 3);
                        g.setColor(UIManager.getColor("SplitPane.arrow.borderColor"));
                        g.drawLine(0, 1, 1, 1);
                        g.drawLine(2, 2, 5, 5);
                        g.drawLine(2, 9, 5, 6);
                        g.drawLine(0, 10, 1, 10);
                        g.drawLine(0, 2, 0, 9);
                    }
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setMinimumSize(new Dimension(6, 6));
        b.setCursor(defaultCursor);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    @Override
    public void paint(Graphics g) {
        if (((KingdeeSplitPaneUI)this.splitPaneUI).hasDividerPointer()) {
            int length = 0;
            int adjust = 0;
            if (!this.splitPane.isOneTouchExpandable() || this.getArrowType() == 4 || this.getArrowType() == 1 || this.getArrowType() == 2 || this.getArrowType() == 3) {
                length = 12;
                adjust = 26;
            } else {
                length = 20;
                adjust = 40;
            }
            for (int i = 1; i <= length; ++i) {
                int x = this.getWidth() / 2 + 1;
                int y = this.getHeight() / 2 - 22 + i * 4;
                if (this.orientation == 1) {
                    x = this.getWidth() / 2 + 1;
                    y = this.getHeight() / 2 - adjust + i * 4;
                    g.setColor(UIManager.getColor("SplitPane.decoratePoint.shadow"));
                    g.drawLine(x, y, x, y);
                    if (i != length) {
                        g.drawLine(x - 3, y + 2, x - 3, y + 2);
                    }
                    g.setColor(UIManager.getColor("SplitPane.decoratePoint.highlight"));
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    if (i == length) continue;
                    g.drawLine(x - 2, y + 2, x - 2, y + 2);
                    continue;
                }
                y = this.getHeight() / 2 + 1;
                x = this.getWidth() / 2 - adjust + i * 4;
                g.setColor(UIManager.getColor("SplitPane.decoratePoint.shadow"));
                g.drawLine(x, y, x, y);
                if (i != length) {
                    g.drawLine(x + 2, y - 3, x + 2, y - 3);
                }
                g.setColor(UIManager.getColor("SplitPane.decoratePoint.highlight"));
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                if (i == length) continue;
                g.drawLine(x + 2, y - 2, x + 2, y - 2);
            }
        }
        super.paint(g);
    }

    @Override
    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
            this.leftButton = this.createLeftOneTouchButton();
            if (this.leftButton != null) {
                this.leftButton.addActionListener(new OneTouchActionHandler(true));
            }
            this.rightButton = this.createRightOneTouchButton();
            if (this.rightButton != null) {
                this.rightButton.addActionListener(new OneTouchActionHandler(false));
            }
            if (this.leftButton != null && this.rightButton != null) {
                this.add(this.leftButton);
                this.add(this.rightButton);
            }
        }
        this.invalidate();
        this.validate();
    }

    private void reValidateButtons() {
        switch (this.getArrowType()) {
            case 1: {
                this.leftButton.setVisible(true);
                this.rightButton.setVisible(false);
                break;
            }
            case 2: {
                this.leftButton.setVisible(false);
                this.rightButton.setVisible(true);
                break;
            }
            case 3: {
                this.leftButton.setVisible(true);
                this.rightButton.setVisible(false);
                break;
            }
            case 4: {
                this.leftButton.setVisible(false);
                this.rightButton.setVisible(true);
            }
            case 0: {
                this.leftButton.setVisible(true);
                this.rightButton.setVisible(true);
            }
        }
    }

    @Override
    public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = newUI;
        if (newUI != null) {
            this.splitPane = newUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new MyMouseHandler();
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    protected class MyMouseHandler
    extends BasicSplitPaneDivider.MouseHandler {
        protected MyMouseHandler() {
            super(DefaultKingdeeSplitPaneDivider.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (!DefaultKingdeeSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                return;
            }
            int lastLoc = DefaultKingdeeSplitPaneDivider.this.splitPane.getLastDividerLocation();
            Insets insets = DefaultKingdeeSplitPaneDivider.this.splitPane.getInsets();
            switch (DefaultKingdeeSplitPaneDivider.this.getArrowType()) {
                case 1: {
                    if (lastLoc < DefaultKingdeeSplitPaneDivider.this.splitPane.getWidth() - insets.right - DefaultKingdeeSplitPaneDivider.this.getWidth()) break;
                    DefaultKingdeeSplitPaneDivider.this.setArrowType(2);
                    break;
                }
                case 2: {
                    if (lastLoc > insets.left) break;
                    DefaultKingdeeSplitPaneDivider.this.setArrowType(1);
                    break;
                }
                case 3: {
                    if (lastLoc < DefaultKingdeeSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - DefaultKingdeeSplitPaneDivider.this.getHeight()) break;
                    DefaultKingdeeSplitPaneDivider.this.setArrowType(4);
                    break;
                }
                case 4: {
                    if (lastLoc > insets.top) break;
                    DefaultKingdeeSplitPaneDivider.this.setArrowType(3);
                }
            }
            DefaultKingdeeSplitPaneDivider.this.reValidateButtons();
        }
    }

    private class OneTouchActionHandler
    implements ActionListener {
        private boolean toMinimum;

        OneTouchActionHandler(boolean toMinimum) {
            this.toMinimum = toMinimum;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Insets insets = DefaultKingdeeSplitPaneDivider.this.splitPane.getInsets();
            int lastLoc = DefaultKingdeeSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int currentLoc = DefaultKingdeeSplitPaneDivider.this.splitPaneUI.getDividerLocation(DefaultKingdeeSplitPaneDivider.this.splitPane);
            int newLoc = this.toMinimum ? (DefaultKingdeeSplitPaneDivider.this.orientation == 0 ? (currentLoc >= DefaultKingdeeSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - DefaultKingdeeSplitPaneDivider.this.getHeight() ? lastLoc : insets.top) : (currentLoc >= DefaultKingdeeSplitPaneDivider.this.splitPane.getWidth() - insets.right - DefaultKingdeeSplitPaneDivider.this.getWidth() ? lastLoc : insets.left)) : (DefaultKingdeeSplitPaneDivider.this.orientation == 0 ? (currentLoc == insets.top ? lastLoc : DefaultKingdeeSplitPaneDivider.this.splitPane.getHeight() - DefaultKingdeeSplitPaneDivider.this.getHeight() - insets.top) : (currentLoc == insets.left ? lastLoc : DefaultKingdeeSplitPaneDivider.this.splitPane.getWidth() - DefaultKingdeeSplitPaneDivider.this.getWidth() - insets.left));
            if (currentLoc != newLoc) {
                DefaultKingdeeSplitPaneDivider.this.splitPane.setDividerLocation(newLoc);
                DefaultKingdeeSplitPaneDivider.this.splitPane.setLastDividerLocation(currentLoc);
            }
            switch (DefaultKingdeeSplitPaneDivider.this.getArrowType()) {
                case 1: {
                    DefaultKingdeeSplitPaneDivider.this.setArrowType(2);
                    break;
                }
                case 2: {
                    DefaultKingdeeSplitPaneDivider.this.setArrowType(1);
                    break;
                }
                case 3: {
                    DefaultKingdeeSplitPaneDivider.this.setArrowType(4);
                    break;
                }
                case 4: {
                    DefaultKingdeeSplitPaneDivider.this.setArrowType(3);
                }
            }
            JComponent left = (JComponent)DefaultKingdeeSplitPaneDivider.this.splitPane.getLeftComponent();
            JComponent right = (JComponent)DefaultKingdeeSplitPaneDivider.this.splitPane.getRightComponent();
            if (left != null && left.getMinimumSize().width < 2 && left.getMinimumSize().height < 2) {
                left.setMinimumSize(new Dimension(2, 2));
            }
            if (right != null && right.getMinimumSize().width < 2 && right.getMinimumSize().height < 2) {
                right.setMinimumSize(new Dimension(2, 2));
            }
            DefaultKingdeeSplitPaneDivider.this.reValidateButtons();
        }
    }

    protected class myDividerLayout
    extends BasicSplitPaneDivider.DividerLayout {
        protected myDividerLayout() {
            super(DefaultKingdeeSplitPaneDivider.this);
        }

        @Override
        public void layoutContainer(Container c) {
            if (DefaultKingdeeSplitPaneDivider.this.leftButton != null && DefaultKingdeeSplitPaneDivider.this.rightButton != null && c == DefaultKingdeeSplitPaneDivider.this) {
                if (DefaultKingdeeSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = DefaultKingdeeSplitPaneDivider.this.getInsets();
                    if (DefaultKingdeeSplitPaneDivider.this.orientation == 0) {
                        int extraX = insets != null ? insets.left : 0;
                        int blockSize = DefaultKingdeeSplitPaneDivider.this.getHeight();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, 6);
                        int y = (c.getSize().height - blockSize) / 2;
                        if (DefaultKingdeeSplitPaneDivider.this.getArrowType() == 0) {
                            DefaultKingdeeSplitPaneDivider.this.rightButton.setBounds(extraX + DefaultKingdeeSplitPaneDivider.this.getWidth() / 2 - blockSize * 3 - 1, y, blockSize * 2, blockSize);
                            DefaultKingdeeSplitPaneDivider.this.leftButton.setBounds(extraX + DefaultKingdeeSplitPaneDivider.this.getWidth() / 2 + blockSize * 2, y, blockSize * 2, blockSize);
                        } else if (DefaultKingdeeSplitPaneDivider.this.getArrowType() == 3) {
                            DefaultKingdeeSplitPaneDivider.this.rightButton.setVisible(false);
                            DefaultKingdeeSplitPaneDivider.this.leftButton.setBounds(extraX + DefaultKingdeeSplitPaneDivider.this.getWidth() / 2 - blockSize / 2 - 3, y, blockSize * 2, blockSize);
                        } else if (DefaultKingdeeSplitPaneDivider.this.getArrowType() == 4) {
                            DefaultKingdeeSplitPaneDivider.this.leftButton.setVisible(false);
                            DefaultKingdeeSplitPaneDivider.this.rightButton.setBounds(extraX + DefaultKingdeeSplitPaneDivider.this.getWidth() / 2 - blockSize / 2 - 3, y, blockSize * 2, blockSize);
                        }
                    } else {
                        int extraY = insets != null ? insets.top : 0;
                        int blockSize = DefaultKingdeeSplitPaneDivider.this.getWidth();
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, 6);
                        int x = (c.getSize().width - blockSize) / 2;
                        if (DefaultKingdeeSplitPaneDivider.this.getArrowType() == 0) {
                            DefaultKingdeeSplitPaneDivider.this.leftButton.setBounds(x, extraY + DefaultKingdeeSplitPaneDivider.this.getHeight() / 2 - blockSize * 3 - 2, blockSize, blockSize * 2);
                            DefaultKingdeeSplitPaneDivider.this.rightButton.setBounds(x, extraY + DefaultKingdeeSplitPaneDivider.this.getHeight() / 2 + blockSize * 2 + 2, blockSize, blockSize * 2);
                        } else if (DefaultKingdeeSplitPaneDivider.this.getArrowType() == 1) {
                            DefaultKingdeeSplitPaneDivider.this.rightButton.setVisible(false);
                            DefaultKingdeeSplitPaneDivider.this.leftButton.setBounds(x, extraY + DefaultKingdeeSplitPaneDivider.this.getHeight() / 2 - blockSize, blockSize, blockSize * 2);
                        } else if (DefaultKingdeeSplitPaneDivider.this.getArrowType() == 2) {
                            DefaultKingdeeSplitPaneDivider.this.leftButton.setVisible(false);
                            DefaultKingdeeSplitPaneDivider.this.rightButton.setBounds(x, extraY + DefaultKingdeeSplitPaneDivider.this.getHeight() / 2 - blockSize, blockSize, blockSize * 2);
                        }
                    }
                } else {
                    DefaultKingdeeSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    DefaultKingdeeSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }
    }
}

