/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.ButtonActionPropertyListenerEx;
import com.kingdee.cosmic.ctrl.swing.ButtonStates;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.model.CheckBoxModel;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeCheckBoxUI;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeIconFactory;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;

public class KDCheckBox
extends JCheckBox
implements IKDComponent,
ButtonStates,
IKDTextComponent {
    private static final long serialVersionUID = -6078729170730472359L;
    protected Object userObject = null;
    private Insets customInsets;
    private int accessAuthority = 0;
    private static final String[] staticTypes = new String[]{"MnemonicKey", "Name", "ShortDescription", "ActionCommandKey", "enabled", "visible"};

    public KDCheckBox() {
        this(null, null, false);
    }

    public KDCheckBox(Icon icon) {
        this(null, icon, false);
    }

    public KDCheckBox(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public KDCheckBox(String text) {
        this(text, null, false);
    }

    public KDCheckBox(Action a) {
        this();
        this.setAction(a);
    }

    public KDCheckBox(String text, boolean selected) {
        this(text, null, selected);
    }

    public KDCheckBox(String text, Icon icon) {
        this(text, icon, false);
    }

    public KDCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.setModel(new CheckBoxModel());
        this.getModel().setSelected(selected);
        this.enableInputMethods(false);
        if (!StringUtil.isEmptyString((String)text)) {
            this.setToolTipText(text);
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (!StringUtil.isEmptyString((String)text)) {
            this.setToolTipText(text);
        } else {
            this.setToolTipText(null);
        }
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setAccessAuthority(int authotiry) {
        if (this.accessAuthority == authotiry) {
            return;
        }
        this.accessAuthority = authotiry;
        if (this.accessAuthority == 0) {
            ((KingdeeCheckBoxUI)this.ui).setReadOnly(this, false);
        } else if (this.accessAuthority == 1) {
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
            ((KingdeeCheckBoxUI)this.ui).setReadOnly(this, true);
        } else if (this.accessAuthority == 2) {
            if (!this.isEnabled()) {
                this.setEnabled(true);
            }
            ((KingdeeCheckBoxUI)this.ui).setReadOnly(this, true);
        }
    }

    @Override
    public int getAccessAuthority() {
        return this.accessAuthority;
    }

    @Override
    public Icon getIcon() {
        return KingdeeIconFactory.getCheckBoxIcon();
    }

    public int getSelected() {
        ButtonModel m = this.getModel();
        if (!(m instanceof CheckBoxModel)) {
            return this.isSelected() ? 32 : 16;
        }
        CheckBoxModel thisModel = (CheckBoxModel)m;
        return thisModel.getSelected();
    }

    public void setSelected(int state) {
        ButtonModel m = this.getModel();
        if (!(m instanceof CheckBoxModel)) {
            super.setSelected(state > 0);
            return;
        }
        CheckBoxModel thisModel = (CheckBoxModel)m;
        thisModel.setSelected(state);
    }

    public void setSelected(int state, boolean fireListener) {
        if (fireListener) {
            this.setSelected(state);
        } else if (this.getModel() instanceof JToggleButton.ToggleButtonModel) {
            int i;
            ChangeListener[] savedChangeListeners = ((JToggleButton.ToggleButtonModel)this.getModel()).getChangeListeners();
            ItemListener[] savedItemListeners = ((JToggleButton.ToggleButtonModel)this.getModel()).getItemListeners();
            if (savedChangeListeners != null) {
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    this.getModel().removeChangeListener(savedChangeListeners[i]);
                }
            }
            if (savedItemListeners != null) {
                for (i = 0; i < savedItemListeners.length; ++i) {
                    this.getModel().removeItemListener(savedItemListeners[i]);
                }
            }
            this.setSelected(state);
            if (savedChangeListeners != null) {
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    this.getModel().addChangeListener(savedChangeListeners[i]);
                }
            }
            if (savedItemListeners != null) {
                for (i = 0; i < savedItemListeners.length; ++i) {
                    this.getModel().addItemListener(savedItemListeners[i]);
                }
            }
            this.repaint();
        } else {
            this.setSelected(state);
        }
    }

    @Override
    public void setSelected(boolean b) {
        ButtonModel m = this.getModel();
        if (!(m instanceof CheckBoxModel)) {
            super.setSelected(b);
            return;
        }
        ((CheckBoxModel)m).setSelected(b);
    }

    public void setSelected(boolean selected, boolean fireListener) {
        if (fireListener) {
            this.setSelected(selected);
        } else if (this.getModel() instanceof JToggleButton.ToggleButtonModel) {
            int i;
            ChangeListener[] savedChangeListeners = ((JToggleButton.ToggleButtonModel)this.getModel()).getChangeListeners();
            ItemListener[] savedItemListeners = ((JToggleButton.ToggleButtonModel)this.getModel()).getItemListeners();
            if (savedChangeListeners != null) {
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    this.getModel().removeChangeListener(savedChangeListeners[i]);
                }
            }
            if (savedItemListeners != null) {
                for (i = 0; i < savedItemListeners.length; ++i) {
                    this.getModel().removeItemListener(savedItemListeners[i]);
                }
            }
            this.setSelected(selected);
            if (savedChangeListeners != null) {
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    this.getModel().addChangeListener(savedChangeListeners[i]);
                }
            }
            if (savedItemListeners != null) {
                for (i = 0; i < savedItemListeners.length; ++i) {
                    this.getModel().addItemListener(savedItemListeners[i]);
                }
            }
            this.repaint();
        } else {
            this.setSelected(selected);
        }
    }

    public void setSwitch(boolean switchStyle) {
        ButtonModel m = this.getModel();
        if (!(m instanceof CheckBoxModel)) {
            m = new CheckBoxModel();
            this.setModel(m);
        }
        CheckBoxModel thisModel = (CheckBoxModel)m;
        thisModel.setSwitch(switchStyle);
    }

    public void setSwitch(boolean switchStyle, boolean fireListener) {
        if (fireListener) {
            this.setSwitch(switchStyle);
        } else if (this.getModel() instanceof JToggleButton.ToggleButtonModel) {
            int i;
            ChangeListener[] savedChangeListeners = ((JToggleButton.ToggleButtonModel)this.getModel()).getChangeListeners();
            ItemListener[] savedItemListeners = ((JToggleButton.ToggleButtonModel)this.getModel()).getItemListeners();
            if (savedChangeListeners != null) {
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    this.getModel().removeChangeListener(savedChangeListeners[i]);
                }
            }
            if (savedItemListeners != null) {
                for (i = 0; i < savedItemListeners.length; ++i) {
                    this.getModel().removeItemListener(savedItemListeners[i]);
                }
            }
            this.setSwitch(switchStyle);
            if (savedChangeListeners != null) {
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    this.getModel().addChangeListener(savedChangeListeners[i]);
                }
            }
            if (savedItemListeners != null) {
                for (i = 0; i < savedItemListeners.length; ++i) {
                    this.getModel().addItemListener(savedItemListeners[i]);
                }
            }
            this.repaint();
        } else {
            this.setSwitch(switchStyle);
        }
    }

    public boolean isSwitch() {
        ButtonModel m = this.getModel();
        if (!(m instanceof CheckBoxModel)) {
            return true;
        }
        CheckBoxModel thisModel = (CheckBoxModel)m;
        return thisModel.isSwitch();
    }

    public void setAlterType(int type) {
        ButtonModel m = this.getModel();
        if (!(m instanceof CheckBoxModel)) {
            m = new CheckBoxModel();
            this.setModel(m);
        }
        CheckBoxModel thisModel = (CheckBoxModel)m;
        thisModel.setAlterType(type);
    }

    public int getAlterType() {
        ButtonModel m = this.getModel();
        if (!(m instanceof CheckBoxModel)) {
            return 0;
        }
        CheckBoxModel thisModel = (CheckBoxModel)m;
        return thisModel.getAlterType();
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new ButtonActionPropertyListenerEx(this, a){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Boolean visibleState;
                String propertyName = e.getPropertyName();
                AbstractButton button = (AbstractButton)this.getTarget();
                if (button == null) {
                    Action action = (Action)e.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyName.equals("Name")) {
                    String text = (String)e.getNewValue();
                    button.setText(text);
                    button.repaint();
                } else if (propertyName.equals("ShortDescription")) {
                    String text = (String)e.getNewValue();
                    button.setToolTipText(text);
                } else if (propertyName.equals("enabled")) {
                    Boolean enabledState = (Boolean)e.getNewValue();
                    button.setEnabled(enabledState);
                    button.repaint();
                } else if (propertyName.equals("ActionCommandKey")) {
                    button.setActionCommand((String)e.getNewValue());
                } else if (propertyName.equals("visible") && (visibleState = (Boolean)e.getNewValue()) != null) {
                    button.setVisible(visibleState);
                }
            }
        };
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        String[] types = staticTypes;
        for (int i = 0; i < types.length; ++i) {
            Boolean objValue;
            String type = types[i];
            if (type == null) continue;
            if (type.equals("MnemonicKey")) {
                Integer n = a == null ? null : (Integer)a.getValue(type);
                this.setMnemonic(n == null ? 0 : n);
                continue;
            }
            if (type.equals("Name")) {
                this.setText(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("ShortDescription")) {
                this.setToolTipText(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("SmallIcon")) {
                this.setIcon(a != null ? (Icon)a.getValue(type) : null);
                continue;
            }
            if (type.equals("ActionCommandKey")) {
                this.setActionCommand(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("enabled")) {
                this.setEnabled(a != null ? a.isEnabled() : true);
                continue;
            }
            if (!type.equals("visible")) continue;
            boolean value = true;
            if (a != null && (objValue = (Boolean)a.getValue("visible")) != null) {
                value = objValue;
            }
            this.setVisible(value);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        if (this.isEnabled() && CtrlSwingUtilities.runCtrlInputVerifier(this)) {
            super.processMouseEvent(me);
        }
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public void setSelectState(int state) {
        this.setSelected(state);
    }

    public int getSelectState() {
        return this.getSelected();
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public void setRequired(boolean required) {
    }
}

