/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.HorizontalLayout;
import com.kingdee.cosmic.ctrl.swing.VerticalLayout;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class KDCollapsiblePane
extends JPanel {
    public static final String ANIMATION_STATE_KEY = "animationState";
    public static final String TOGGLE_ACTION = "toggle";
    public static final String COLLAPSE_ICON = "collapseIcon";
    public static final String EXPAND_ICON = "expandIcon";
    private boolean collapsed = false;
    private Orientation orientation = Orientation.VERTICAL;
    private Timer animateTimer;
    private AnimationListener animator;
    private int currentDimension = -1;
    private WrapperContainer wrapper;
    private boolean useAnimation = true;
    private AnimationParams animationParams;

    public KDCollapsiblePane() {
        this(Orientation.VERTICAL, new BorderLayout(0, 0));
    }

    public KDCollapsiblePane(Orientation orientation) {
        this(orientation, new BorderLayout(0, 0));
    }

    public KDCollapsiblePane(LayoutManager layout) {
        this(Orientation.VERTICAL, layout);
    }

    public KDCollapsiblePane(Orientation orientation, LayoutManager layout) {
        super.setLayout(layout);
        this.orientation = orientation;
        JPanel panel = new JPanel();
        if (orientation == Orientation.VERTICAL) {
            panel.setLayout(new VerticalLayout(2));
        } else {
            panel.setLayout(new HorizontalLayout(2));
        }
        this.setContentPane(panel);
        this.animator = new AnimationListener();
        this.setAnimationParams(new AnimationParams(30, 8, 0.01f, 1.0f));
        this.getActionMap().put(TOGGLE_ACTION, new ToggleAction());
    }

    public void setContentPane(Container contentPanel) {
        if (contentPanel == null) {
            throw new IllegalArgumentException("Content pane can't be null");
        }
        if (this.wrapper != null) {
            super.remove(0);
        }
        this.wrapper = new WrapperContainer(contentPanel);
        super.addImpl(this.wrapper, "Center", -1);
    }

    public Container getContentPane() {
        return this.wrapper.c;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.wrapper != null) {
            this.getContentPane().setLayout(mgr);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.getContentPane().add(comp, constraints, index);
    }

    @Override
    public void remove(Component comp) {
        this.getContentPane().remove(comp);
    }

    @Override
    public void remove(int index) {
        this.getContentPane().remove(index);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    public void setAnimated(boolean animated) {
        if (animated != this.useAnimation) {
            this.useAnimation = animated;
            this.firePropertyChange("animated", !this.useAnimation, this.useAnimation);
        }
    }

    public boolean isAnimated() {
        return this.useAnimation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation != this.orientation) {
            if (this.animateTimer.isRunning()) {
                throw new IllegalStateException("Orientation cannot be changed during collapsing.");
            }
            this.orientation = orientation;
            if (orientation == Orientation.VERTICAL) {
                this.getContentPane().setLayout(new VerticalLayout(2));
            } else {
                this.getContentPane().setLayout(new HorizontalLayout(2));
            }
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean val) {
        if (this.collapsed != val) {
            this.collapsed = val;
            if (this.isAnimated()) {
                if (this.collapsed) {
                    int dimension = this.orientation == Orientation.VERTICAL ? this.wrapper.getHeight() : this.wrapper.getWidth();
                    this.setAnimationParams(new AnimationParams(30, Math.max(8, dimension / 10), 1.0f, 0.01f));
                    this.animator.reinit(dimension, 0);
                    this.animateTimer.start();
                } else {
                    int dimension = this.orientation == Orientation.VERTICAL ? this.wrapper.getHeight() : this.wrapper.getWidth();
                    int preferredDimension = this.orientation == Orientation.VERTICAL ? this.getContentPane().getPreferredSize().height : this.getContentPane().getPreferredSize().width;
                    int delta = Math.max(8, preferredDimension / 10);
                    this.setAnimationParams(new AnimationParams(30, delta, 0.01f, 1.0f));
                    this.animator.reinit(dimension, preferredDimension);
                    this.animateTimer.start();
                }
            } else {
                this.wrapper.c.setVisible(!this.collapsed);
                this.invalidate();
                this.doLayout();
            }
            this.repaint();
            this.firePropertyChange("collapsed", !this.collapsed, this.collapsed);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim;
        if (!this.isAnimated()) {
            dim = this.getContentPane().isVisible() ? this.getContentPane().getPreferredSize() : super.getPreferredSize();
        } else {
            dim = new Dimension(this.getContentPane().getPreferredSize());
            if (!this.getContentPane().isVisible() && this.currentDimension != -1) {
                if (this.orientation == Orientation.VERTICAL) {
                    dim.height = this.currentDimension;
                } else {
                    dim.width = this.currentDimension;
                }
            }
        }
        return dim;
    }

    private void setAnimationParams(AnimationParams params) {
        if (params == null) {
            throw new IllegalArgumentException("params can't be null");
        }
        if (this.animateTimer != null) {
            this.animateTimer.stop();
        }
        this.animationParams = params;
        this.animateTimer = new Timer(this.animationParams.waitTime, this.animator);
        this.animateTimer.setInitialDelay(0);
    }

    private final class WrapperContainer
    extends JPanel {
        private BufferedImage img;
        private Container c;
        float alpha;

        public WrapperContainer(Container c) {
            super(new BorderLayout());
            this.alpha = 1.0f;
            this.c = c;
            this.add((Component)c, "Center");
            if (c instanceof JComponent && !c.isOpaque()) {
                ((JComponent)c).setOpaque(true);
            }
        }

        public void showImage() {
            this.makeImage();
            this.c.setVisible(false);
        }

        public void showContent() {
            KDCollapsiblePane.this.currentDimension = -1;
            this.c.setVisible(true);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
        }

        void makeImage() {
            if (this.getGraphicsConfiguration() != null && this.getWidth() > 0) {
                int dimension;
                int height;
                int width;
                Dimension dim = this.c.getPreferredSize();
                if (KDCollapsiblePane.this.orientation == Orientation.VERTICAL) {
                    width = this.getWidth();
                    dimension = height = dim.height;
                } else {
                    height = this.getHeight();
                    dimension = width = dim.width;
                }
                if (dimension > 0) {
                    this.img = this.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
                    this.c.setSize(width, height);
                    this.c.paint(this.img.getGraphics());
                } else {
                    this.img = null;
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!KDCollapsiblePane.this.useAnimation || this.c.isVisible()) {
                super.paintComponent(g);
            } else {
                if (this.img == null) {
                    this.makeImage();
                }
                if (g != null && this.img != null) {
                    if (KDCollapsiblePane.this.orientation == Orientation.VERTICAL) {
                        g.drawImage(this.img, 0, this.getHeight() - this.img.getHeight(), null);
                    } else {
                        g.drawImage(this.img, this.getWidth() - this.img.getWidth(), 0, null);
                    }
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComp = g2d.getComposite();
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, this.alpha);
            g2d.setComposite(alphaComp);
            super.paint(g2d);
            g2d.setComposite(oldComp);
        }
    }

    private final class AnimationListener
    implements ActionListener {
        private final Object ANIMATION_MUTEX = "Animation Synchronization Mutex";
        private int startDimension = 0;
        private int finalDimension = 0;

        private AnimationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                if (this.startDimension == this.finalDimension) {
                    KDCollapsiblePane.this.animateTimer.stop();
                    if (this.finalDimension > 0) {
                        KDCollapsiblePane.this.wrapper.showContent();
                        this.validate();
                        KDCollapsiblePane.this.firePropertyChange(KDCollapsiblePane.ANIMATION_STATE_KEY, null, "expanded");
                        return;
                    }
                    KDCollapsiblePane.this.firePropertyChange(KDCollapsiblePane.ANIMATION_STATE_KEY, null, "collapsed");
                }
                boolean contracting = this.startDimension > this.finalDimension;
                int delta = contracting ? -1 * ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.delta : ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.delta;
                int newDimension = KDCollapsiblePane.this.orientation == Orientation.VERTICAL ? KDCollapsiblePane.this.wrapper.getHeight() + delta : KDCollapsiblePane.this.wrapper.getWidth() + delta;
                if (contracting) {
                    if (newDimension < this.finalDimension) {
                        newDimension = this.finalDimension;
                    }
                } else if (newDimension > this.finalDimension) {
                    newDimension = this.finalDimension;
                }
                int dimension = KDCollapsiblePane.this.orientation == Orientation.VERTICAL ? ((WrapperContainer)((KDCollapsiblePane)KDCollapsiblePane.this).wrapper).c.getPreferredSize().height : ((WrapperContainer)((KDCollapsiblePane)KDCollapsiblePane.this).wrapper).c.getPreferredSize().width;
                float animateAlpha = (float)newDimension / (float)dimension;
                Rectangle bounds = KDCollapsiblePane.this.wrapper.getBounds();
                if (KDCollapsiblePane.this.orientation == Orientation.VERTICAL) {
                    int oldHeight = bounds.height;
                    bounds.height = newDimension;
                    KDCollapsiblePane.this.wrapper.setBounds(bounds);
                    bounds = KDCollapsiblePane.this.getBounds();
                    bounds.height = bounds.height - oldHeight + newDimension;
                    KDCollapsiblePane.this.currentDimension = bounds.height;
                } else {
                    int oldWidth = bounds.width;
                    bounds.width = newDimension;
                    KDCollapsiblePane.this.wrapper.setBounds(bounds);
                    bounds = KDCollapsiblePane.this.getBounds();
                    bounds.width = bounds.width - oldWidth + newDimension;
                    KDCollapsiblePane.this.currentDimension = bounds.width;
                }
                KDCollapsiblePane.this.setBounds(bounds);
                this.startDimension = newDimension;
                if (contracting) {
                    if (animateAlpha < ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.alphaEnd) {
                        animateAlpha = ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (animateAlpha > ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.alphaStart) {
                        animateAlpha = ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.alphaStart;
                    }
                } else {
                    if (animateAlpha > ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.alphaEnd) {
                        animateAlpha = ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (animateAlpha < ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.alphaStart) {
                        animateAlpha = ((KDCollapsiblePane)KDCollapsiblePane.this).animationParams.alphaStart;
                    }
                }
                ((KDCollapsiblePane)KDCollapsiblePane.this).wrapper.alpha = animateAlpha;
                this.validate();
            }
        }

        void validate() {
            Container parent = SwingUtilities.getAncestorOfClass(JCollapsiblePaneContainer.class, KDCollapsiblePane.this);
            parent = parent != null ? ((JCollapsiblePaneContainer)((Object)parent)).getValidatingContainer() : KDCollapsiblePane.this.getParent();
            if (parent != null) {
                if (parent instanceof JComponent) {
                    ((JComponent)parent).revalidate();
                } else {
                    parent.invalidate();
                }
                parent.doLayout();
                parent.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int startDimension, int stopDimension) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                KDCollapsiblePane.this.firePropertyChange(KDCollapsiblePane.ANIMATION_STATE_KEY, null, "reinit");
                this.startDimension = startDimension;
                this.finalDimension = stopDimension;
                KDCollapsiblePane.this.currentDimension = -1;
                KDCollapsiblePane.this.wrapper.showImage();
            }
        }
    }

    private static class AnimationParams {
        final int waitTime;
        final int delta;
        final float alphaStart;
        final float alphaEnd;

        public AnimationParams(int waitTime, int delta, float alphaStart, float alphaEnd) {
            this.waitTime = waitTime;
            this.delta = delta;
            this.alphaStart = alphaStart;
            this.alphaEnd = alphaEnd;
        }
    }

    public static interface JCollapsiblePaneContainer {
        public Container getValidatingContainer();
    }

    private class ToggleAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ToggleAction() {
            super(KDCollapsiblePane.TOGGLE_ACTION);
            KDCollapsiblePane.this.addPropertyChangeListener("collapsed", this);
        }

        @Override
        public void putValue(String key, Object newValue) {
            super.putValue(key, newValue);
            if (KDCollapsiblePane.EXPAND_ICON.equals(key) || KDCollapsiblePane.COLLAPSE_ICON.equals(key)) {
                this.updateIcon();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDCollapsiblePane.this.setCollapsed(!KDCollapsiblePane.this.isCollapsed());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateIcon();
        }

        void updateIcon() {
            if (KDCollapsiblePane.this.isCollapsed()) {
                this.putValue("SmallIcon", this.getValue(KDCollapsiblePane.EXPAND_ICON));
            } else {
                this.putValue("SmallIcon", this.getValue(KDCollapsiblePane.COLLAPSE_ICON));
            }
        }
    }

    public static class Orientation {
        public static Orientation HORIZONTAL = new Orientation();
        public static Orientation VERTICAL = new Orientation();
    }
}

