/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.dial.KpiDial;
import com.kingdee.cosmic.ctrl.swing.dial.KpiNeedle;
import com.kingdee.cosmic.ctrl.swing.dial.KpiPan;
import com.kingdee.cosmic.ctrl.swing.dial.KpiRange;
import com.kingdee.cosmic.ctrl.swing.dial.KpiScale;
import com.kingdee.cosmic.ctrl.swing.dial.KpiTitle;
import java.awt.Color;
import java.text.DecimalFormat;

public class KDDial
extends KpiDial
implements IKDComponent {
    private static final long serialVersionUID = 5089621353219529604L;
    private static final String DEFAULTKEY = "0";
    private static final Color NORMALCOLOR = new Color(36846);
    private static final Color WARNINGCOLOR = new Color(16700928);
    private static final Color CRITICALCOLOR = new Color(0xFF1313);
    protected Object userObject = null;

    @Override
    public void setUserObject(Object o) {
        this.userObject = o;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    public KDDial(KpiRange range, String title) {
        this.init(range, null, null, null, title);
    }

    public KDDial(KpiRange range, KpiRange normal, KpiRange warning, KpiRange critical, String title) {
        this.init(range, normal, warning, critical, title);
    }

    protected void init(KpiRange range, KpiRange normal, KpiRange warning, KpiRange critical, String title) {
        KpiPan bottomPan = new KpiPan();
        KpiNeedle ndl = new KpiNeedle();
        DecimalFormat ft = new DecimalFormat("###'%'");
        KpiScale scl = new KpiScale(null, 0, 0, 180);
        scl.setTicksPaint(Color.GRAY);
        scl.setTickLabelPaint(Color.WHITE);
        scl.setTickLabelFormat(ft);
        scl.setTotalRange(range);
        scl.setNormalRange(normal);
        scl.setWarningRange(warning);
        scl.setCriticalRange(critical);
        scl.setNormalPaint(NORMALCOLOR);
        scl.setWarningPaint(WARNINGCOLOR);
        scl.setCriticalPaint(CRITICALCOLOR);
        KpiTitle ttl = new KpiTitle(title);
        ndl.setScale(scl);
        this.addNeedle(ndl, DEFAULTKEY);
        this.addScale(scl, DEFAULTKEY);
        this.setPan(bottomPan);
        this.setTitle(ttl);
        this.setSize(this.getPreferredSize());
    }
}

