/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.IKDFontChooser;
import com.kingdee.cosmic.ctrl.swing.KDFont;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.model.FontSelectionModel;
import com.kingdee.cosmic.ctrl.swing.model.IFontSelectionModel;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeFontChooserUI;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class KDFontChooser
extends JComponent
implements IKDComponent,
IKDFontChooser {
    private static final long serialVersionUID = -3395786189771021616L;
    public static final int VIEW_COMBOBOX = 1;
    public static final int VIEW_LIST = 2;
    protected Object userObject = null;
    private static final String uiClassID = "KingdeeFontChooserUI";
    private IFontSelectionModel selectionModel;
    private int viewType;
    private boolean familyVisible = true;
    private boolean boldVisible = true;
    private boolean italicVisible = true;
    private boolean sizeVisible = true;
    private boolean familyEnabled = true;
    private boolean boldEnabled = true;
    private boolean italicEnabled = true;
    private boolean sizeEnabled = true;
    private Insets customInsets;

    public KDFontChooser() {
        this(new KDFont(CtrlCommonMessages.getMLS((String)"songti", (String)"\u5b8b\u4f53"), 0, 9), 1);
    }

    public KDFontChooser(Font initialFont) {
        this(initialFont, 1);
    }

    public KDFontChooser(int view) {
        this(new KDFont(CtrlCommonMessages.getMLS((String)"songti", (String)"\u5b8b\u4f53"), 0, 9), view);
    }

    public KDFontChooser(Font initialFont, int view) {
        this.setSelectionModel(new FontSelectionModel(initialFont));
        this.setViewType(view);
        this.updateUI();
    }

    public void setSelectionModel(IFontSelectionModel newModel) {
        IFontSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, newModel);
    }

    @Override
    public IFontSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setUI(KingdeeFontChooserUI ui) {
        super.setUI(ui);
    }

    @Override
    public KingdeeFontChooserUI getUI() {
        return (KingdeeFontChooserUI)this.ui;
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeFontChooserUI)UIManager.getUI(this));
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setSelectionFont(String name, int style, int size) {
        if (name != null && name.equals(CtrlSwingMessages.getMLS("otherfont", "\u5176\u4ed6\u5b57\u4f53"))) {
            name = "Dialog";
        }
        KDFont font = new KDFont(name, style, size);
        this.setSelectionFont(font);
    }

    public void setSelectionFontWithUnsure(String name, int style, int size) {
        if (name == null || size == -1 || style == -1) {
            boolean isNameSeted = false;
            boolean isSizeSeted = false;
            boolean isStyleSeted = false;
            if (name != null) {
                this.setFontFamily(name);
                isNameSeted = true;
            }
            if (size != -1) {
                this.setFontSize(size);
                isSizeSeted = true;
            }
            if (style != -1) {
                this.setFontStyle(style);
                isStyleSeted = true;
            }
            if (!isNameSeted) {
                this.setFontFamily(name);
            }
            if (!isSizeSeted) {
                this.setFontSize(size);
            }
            if (!isStyleSeted) {
                this.setFontStyle(style);
            }
        } else {
            this.setSelectionFont(name, style, size);
        }
    }

    @Override
    public void setSelectionFont(Font font) {
        Font old = this.getSelectionModel().getSelectedFont();
        this.getSelectionModel().setSelectedFont(font);
        this.firePropertyChange("selectionFont", old, this.getSelectionModel().getSelectedFont());
    }

    @Override
    public Font getSelectionFont() {
        return this.getSelectionModel().getSelectedFont();
    }

    @Override
    public void setViewType(int view) {
        if (view != this.viewType) {
            int old = this.viewType;
            this.viewType = view;
            this.syncVisibleEnabled();
            this.firePropertyChange("viewType", old, view);
        }
    }

    @Override
    public int getViewType() {
        return this.viewType;
    }

    private void syncVisibleEnabled() {
        if (2 == this.getViewType()) {
            this.setFamilyVisible(true);
            this.setSizeVisible(true);
            this.setBoldVisible(true);
            this.setItalicVisible(true);
            this.setFamilyEnabled(true);
            this.setSizeEnabled(true);
            this.setBoldEnabled(true);
            this.setItalicEnabled(true);
        }
    }

    @Override
    public void setFamilyVisible(boolean fv) {
        boolean old = this.familyVisible;
        this.familyVisible = 1 == this.getViewType() ? fv : true;
        this.firePropertyChange("familyVisible", old, this.familyVisible);
    }

    @Override
    public boolean isFamilyVisible() {
        return this.familyVisible;
    }

    @Override
    public void setSizeVisible(boolean sv) {
        boolean old = this.sizeVisible;
        this.sizeVisible = 1 == this.getViewType() ? sv : true;
        this.firePropertyChange("sizeVisible", old, this.sizeVisible);
    }

    @Override
    public boolean isSizeVisible() {
        return this.sizeVisible;
    }

    @Override
    public void setBoldVisible(boolean bv) {
        boolean old = this.boldVisible;
        this.boldVisible = 1 == this.getViewType() ? bv : true;
        this.firePropertyChange("boldVisible", old, this.boldVisible);
    }

    @Override
    public boolean isBoldVisible() {
        return this.boldVisible;
    }

    @Override
    public void setItalicVisible(boolean iv) {
        boolean old = this.italicVisible;
        this.italicVisible = 1 == this.getViewType() ? iv : true;
        this.firePropertyChange("italicVisible", old, this.italicVisible);
    }

    @Override
    public boolean isItalicVisible() {
        return this.italicVisible;
    }

    @Override
    public void setFamilyEnabled(boolean fe) {
        boolean old = this.familyEnabled;
        this.familyEnabled = 1 == this.getViewType() ? fe : true;
        this.firePropertyChange("familyEnabled", old, this.familyEnabled);
    }

    @Override
    public boolean isFamilyEnabled() {
        return this.familyEnabled;
    }

    @Override
    public void setSizeEnabled(boolean se) {
        boolean old = this.sizeEnabled;
        this.sizeEnabled = 1 == this.getViewType() ? se : true;
        this.firePropertyChange("sizeEnabled", old, this.sizeEnabled);
    }

    @Override
    public boolean isSizeEnabled() {
        return this.sizeEnabled;
    }

    @Override
    public void setBoldEnabled(boolean be) {
        boolean old = this.boldEnabled;
        this.boldEnabled = 1 == this.getViewType() ? be : true;
        this.firePropertyChange("boldEnabled", old, this.boldEnabled);
    }

    @Override
    public boolean isBoldEnabled() {
        return this.boldEnabled;
    }

    @Override
    public void setItalicEnabled(boolean ie) {
        boolean old = this.italicEnabled;
        this.italicEnabled = 1 == this.getViewType() ? ie : true;
        this.firePropertyChange("italicEnabled", old, this.italicEnabled);
    }

    @Override
    public boolean isItalicEnabled() {
        return this.italicEnabled;
    }

    public String getFontFamily() {
        return this.getSelectionFont().getFamily();
    }

    public int getFontSize() {
        return this.getSelectionFont().getSize();
    }

    public int getFontStyle() {
        return this.getSelectionFont().getStyle();
    }

    public boolean isFontBold() {
        return (this.getSelectionFont().getStyle() & 1) == 1;
    }

    public boolean isFontItalic() {
        return (this.getSelectionFont().getStyle() & 2) == 2;
    }

    public void setFontSize(int size) {
        if (size == -1) {
            this.getUI().unsuredSize();
        } else {
            this.setSelectionFont(this.getFontFamily(), this.getFontStyle(), size);
        }
    }

    public void setFontFamily(String family) {
        if (family == null) {
            this.getUI().unsuredFamily();
        } else {
            this.setSelectionFont(family, this.getFontStyle(), this.getFontSize());
        }
    }

    public void setFontStyle(int style) {
        if (style == -1) {
            this.getUI().unsuredStyle();
        } else {
            this.setSelectionFont(this.getFontFamily(), style, this.getFontSize());
        }
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.setFamilyEnabled(isEnabled);
        this.setSizeEnabled(isEnabled);
        this.setBoldEnabled(isEnabled);
        this.setItalicEnabled(isEnabled);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        this.setFamilyVisible(isVisible);
        this.setSizeVisible(isVisible);
        this.setBoldVisible(isVisible);
        this.setItalicVisible(isVisible);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.cosmic.ctrl.swing.plaf.KingdeeFontChooserUI");
    }
}

