/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.event.InfoTipModelChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.InfoTipModelChangeListener;
import com.kingdee.cosmic.ctrl.swing.model.IInfoTipModel;
import com.kingdee.cosmic.ctrl.swing.model.InfoTipModel;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeInfoTipUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class KDInfoTip
extends JToolTip
implements IKDComponent,
InfoTipModelChangeListener {
    private static final long serialVersionUID = 6873237427349542876L;
    public static final int NOT_ENOUGH_SPACE = 0;
    public static final int DOWN_THE_OWNER = 1;
    public static final int OVER_THE_OWNER = 2;
    public static final int NORMAL = 0;
    public static final int TEXT = 1;
    public static final int HTML = 2;
    protected Object userObject = null;
    private KingdeeInfoTipUI ui = new KingdeeInfoTipUI();
    private InfoTipModel model = null;
    private OwnerFocusHandler pfh = new OwnerFocusHandler();
    private OwnerMouseHandler pmh = new OwnerMouseHandler();
    private JComponent owner = null;
    private Popup popup;
    private int position = 0;
    private int type = 0;
    private boolean isShowing;
    private int blankSpace = 2;
    private Point popupPosition;
    private Rectangle rec;
    private boolean inTheOwner = false;

    public KDInfoTip(JComponent parent, String msg) {
        this.owner = parent;
        this.createModel();
        this.setText(msg);
        this.updateUI();
    }

    public KDInfoTip(JComponent parent, String msg, int type) {
        this.owner = parent;
        this.createModel();
        this.setType(type);
        this.setText(msg);
        this.updateUI();
    }

    public KDInfoTip(JComponent parent, Rectangle r, String msg, int type) {
        this.owner = parent;
        this.createModel();
        this.setType(type);
        this.setText(msg);
        this.rec = r;
        this.setPopupPosition(new Point(this.rec.x, this.rec.y));
        this.inTheOwner = true;
        this.updateUI();
    }

    public void setUI(KingdeeInfoTipUI ui) {
        super.setUI(ui);
    }

    public void createModel() {
        if (this.model != null) {
            return;
        }
        this.model = new InfoTipModel(this);
        this.model.addModelChangeListener(this);
    }

    public void setParent(JComponent parent) {
        this.owner = parent;
        if (this.isShowing) {
            this.setShowing(false);
            this.setShowing(true);
        }
    }

    public void setInnerRectangle(Rectangle r) {
        if (!this.inTheOwner) {
            return;
        }
        this.rec = r;
        this.setPopupPosition(new Point(this.rec.x, this.rec.y));
        if (this.isShowing) {
            this.setShowing(false);
            this.setShowing(true);
        }
    }

    public IInfoTipModel getModel() {
        return this.model;
    }

    public void setText(String tip) {
        this.model.setText(tip);
        if (this.isShowing) {
            this.setShowing(false);
            this.setShowing(true);
        }
    }

    public void setMaxRenderWidth(float maxWidth) {
        this.model.setMaxRenderWidth(maxWidth);
    }

    public void setBackgroundColor(Color c) {
        this.model.setBackgroundColor(c);
    }

    @Override
    public void updateUI() {
        if (this.ui == null) {
            this.ui = new KingdeeInfoTipUI();
        }
        this.setUI(this.ui);
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public int getPosition() {
        return this.position;
    }

    public int getType() {
        return this.type;
    }

    public void setArrowHeight(int height) {
        this.ui.setArrowHeight(height);
    }

    public void setRadian(int radian) {
        this.ui.setRadian(radian);
    }

    private void setType(int type) {
        this.type = type;
    }

    public void setShowing(boolean b) {
        if (this.isShowing == b) {
            return;
        }
        this.isShowing = b;
        if (b) {
            if (SwingUtilities.getWindowAncestor(this.owner) == null) {
                this.isShowing = false;
                return;
            }
            if (this.model.getText() == null) {
                return;
            }
            if (this.popup == null) {
                Point p = this.getPopupPointOnScreen();
                if (p == null) {
                    this.isShowing = false;
                    return;
                }
                this.popup = PopupFactory.getSharedInstance().getPopup(this.owner, this, p.x, p.y);
                JPanel parent = (JPanel)this.getParent();
                parent.setBorder(null);
                parent.setDoubleBuffered(false);
                parent.setOpaque(false);
                this.setOpaque(false);
            }
            this.owner.addFocusListener(this.pfh);
            this.owner.addMouseListener(this.pmh);
            this.popup.show();
        } else {
            if (this.popup == null) {
                return;
            }
            this.owner.removeFocusListener(this.pfh);
            this.owner.removeMouseListener(this.pmh);
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    private Point getPopupPointOnScreen() {
        JRootPane rp = this.owner.getRootPane();
        Point op = this.getPopupPosition();
        if (op == null) {
            op = this.popupPosition = new Point(0, 0);
        }
        op = SwingUtilities.convertPoint(this.owner, op, this.owner.getRootPane());
        Dimension d = this.ui.getPreferredSize(this);
        this.setPreferredSize(d);
        Dimension od = rp.getSize();
        if (op.x > od.width || op.y > od.height) {
            this.position = 0;
            return null;
        }
        if (od.width > d.width && od.height - op.y - (this.inTheOwner ? this.rec.height : this.owner.getHeight()) - this.blankSpace > d.height) {
            this.position = 1;
            if (od.width - op.x > d.width) {
                Point p = new Point(op.x, op.y + (this.inTheOwner ? this.rec.height : this.owner.getHeight()) + this.blankSpace);
                SwingUtilities.convertPointToScreen(p, this.owner.getRootPane());
                return p;
            }
            Point p = new Point(od.width - d.width, op.y + (this.inTheOwner ? this.rec.height : this.owner.getHeight()) + this.blankSpace);
            SwingUtilities.convertPointToScreen(p, this.owner.getRootPane());
            return p;
        }
        if (od.width > d.width && op.y - this.blankSpace > d.height) {
            this.position = 2;
            if (od.width - op.x > d.width) {
                Point p = new Point(op.x, op.y - this.blankSpace - d.height);
                SwingUtilities.convertPointToScreen(p, this.owner.getRootPane());
                return p;
            }
            Point p = new Point(od.width - d.width, op.y - this.blankSpace - d.height);
            SwingUtilities.convertPointToScreen(p, this.owner.getRootPane());
            return p;
        }
        if (od.width < d.width || od.height < d.height) {
            Point p;
            Dimension tipSize = this.caculateSize();
            this.setPreferredSize(tipSize);
            if (op.y < od.height / 2) {
                this.position = 1;
                int y = op.y + (this.inTheOwner ? this.rec.height : this.owner.getHeight()) + this.blankSpace;
                p = op.x + tipSize.width > od.width ? new Point(od.width - tipSize.width, y) : new Point(op.x, y);
                tipSize.height = tipSize.height > od.height - y ? od.height - y : tipSize.height;
            } else {
                this.position = 2;
                int y = op.y - this.blankSpace - tipSize.height;
                p = op.x + tipSize.width > od.width ? new Point(od.width - tipSize.width, y) : new Point(op.x, y);
                if (y < 0) {
                    tipSize.height += y;
                    p = op.x + tipSize.width > od.width ? new Point(od.width - tipSize.width, 0) : new Point(op.x, 0);
                }
            }
            SwingUtilities.convertPointToScreen(p, this.owner.getRootPane());
            return p;
        }
        this.position = 0;
        return null;
    }

    public Dimension caculateSize() {
        InfoTipModel model = (InfoTipModel)this.getModel();
        FontMetrics metrics = this.getFontMetrics(model.getFont());
        int length = metrics.stringWidth(model.getText());
        float max = model.getMaxRenderWidth();
        int rowCount = (int)((float)length / (max - 5.0f)) + 2;
        int height = (int)((double)(rowCount * metrics.getHeight()) * 1.5);
        return new Dimension((int)max, height);
    }

    public Component getOwner() {
        return this.owner;
    }

    public Dimension getTargetDimension() {
        return this.inTheOwner ? new Dimension(this.rec.width, this.rec.height) : this.getOwner().getSize();
    }

    @Override
    public void modelChanged(InfoTipModelChangeEvent e) {
        this.setShowing(false);
        this.setShowing(true);
    }

    public Point getPopupPosition() {
        return this.popupPosition;
    }

    private void setPopupPosition(Point popupPosition) {
        this.popupPosition = popupPosition;
    }

    private class OwnerMouseHandler
    implements MouseListener {
        private OwnerMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            KDInfoTip.this.setShowing(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class OwnerFocusHandler
    implements FocusListener {
        private OwnerFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            KDInfoTip.this.setShowing(false);
        }
    }
}

