/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeLabelUI;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class KDLabel
extends JLabel
implements IKDComponent {
    private static final long serialVersionUID = -1595222268824353900L;
    protected Object userObject = null;
    protected boolean underline = false;
    protected Color underlineColor = null;
    private Insets customInsets;
    private boolean autoToolTipText;

    public KDLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.setAutoToolTipText(true);
    }

    public KDLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.setAutoToolTipText(true);
    }

    public KDLabel(String text) {
        super(text);
        this.setAutoToolTipText(true);
    }

    public KDLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.setAutoToolTipText(true);
    }

    public KDLabel(Icon image) {
        super(image);
        this.setAutoToolTipText(true);
    }

    public KDLabel() {
        this.setAutoToolTipText(true);
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setUnderline(boolean value) {
        this.underline = value;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    @Override
    public void updateUI() {
        this.setUI(KingdeeLabelUI.createUI(this));
    }

    public void setUnderlineColor(Color color) {
        this.underlineColor = color;
    }

    public Color getUnderlineColor() {
        if (this.underlineColor == null) {
            return UIManager.getColor("Label.UnderlineColor");
        }
        return this.underlineColor;
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public String getToolTipText() {
        if (!this.autoToolTipText) {
            String str = super.getToolTipText();
            if (StringUtils.isEmpty(str)) {
                str = null;
            }
            return str;
        }
        String str = super.getToolTipText();
        if (StringUtils.isEmpty(str)) {
            str = this.getText();
        }
        return str;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    public void setAutoToolTipText(boolean auto) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (auto) {
            toolTipManager.registerComponent(this);
        } else {
            toolTipManager.unregisterComponent(this);
        }
        this.autoToolTipText = auto;
    }

    public boolean isAutoToolTipText() {
        return this.autoToolTipText;
    }
}

