/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.event.TabbedPaneCloseAllTabListener;
import com.kingdee.cosmic.ctrl.swing.event.TabbedPaneEvent;
import com.kingdee.cosmic.ctrl.swing.event.TabbedPaneListener;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeTabbedPaneUI;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.TabbedPaneUI;

public class KDTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -2143859940661053608L;
    public static final int VIEW_STYLE_DEFAULT = 1;
    public static final int VIEW_STYLE_MAINFRAME = 2;
    public static final String PROP_CLOSEBUTTONVISIBLE = "closeButtonVisible";
    public static final String PROP_MENUBUTTONVISIBLE = "menuButtonVisible";
    public static final String TAB_CLOSE_COMMAND = "TabClose";
    public static final String TAB_CLOSE_ACTION = "TabClose";
    private int viewStyle = 1;
    private ArrayList toggleStates = new ArrayList(1024);
    private Action closeAction = null;
    private Insets customInsets;
    private boolean isForcedHide;
    private HeadMouseWheelHandler mouseWheelHandler = null;
    private TabHistory history = new TabHistory();

    public KDTabbedPane() {
        this.setTabLayoutPolicy(1);
    }

    public KDTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.setTabLayoutPolicy(1);
    }

    public KDTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    public boolean isForcedHide() {
        return this.isForcedHide;
    }

    public void setForcedHide(boolean isForcedHide) {
        this.isForcedHide = isForcedHide;
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int index;
        String tooltip = super.getToolTipText(event);
        if ((tooltip == null || "".equals(tooltip)) && (index = ((TabbedPaneUI)this.ui).tabForCoordinate(this, event.getX(), event.getY())) != -1) {
            tooltip = this.getTitleAt(index);
        }
        return tooltip;
    }

    @Override
    public String getToolTipTextAt(int index) {
        String tooltip = super.getToolTipTextAt(index);
        if (tooltip == null || "".equals(tooltip)) {
            tooltip = this.getTitleAt(index);
        }
        return tooltip;
    }

    public void setVisibleAt(int index, boolean newValue) {
        Component comp = this.getComponentAt(index);
        if (comp == null) {
            return;
        }
        comp.setVisible(newValue);
    }

    public boolean isVisibleAt(int index) {
        Component comp = this.getComponentAt(index);
        if (comp == null) {
            return false;
        }
        return comp.isVisible();
    }

    public void addTabbedPaneListener(TabbedPaneListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.add(TabbedPaneListener.class, l);
    }

    public void addHeadMouseListener(MouseListener l) {
        KingdeeTabbedPaneUI.TabView tv;
        TabbedPaneUI ui = this.getUI();
        if (ui instanceof KingdeeTabbedPaneUI && (tv = ((KingdeeTabbedPaneUI)ui).getTabView()) != null) {
            tv.addMouseListener(l);
        }
    }

    public void addHeadMouseWheelListener() {
        KingdeeTabbedPaneUI.TabView tv;
        TabbedPaneUI ui;
        if (this.mouseWheelHandler == null) {
            this.mouseWheelHandler = new HeadMouseWheelHandler();
        }
        if ((ui = this.getUI()) instanceof KingdeeTabbedPaneUI && (tv = ((KingdeeTabbedPaneUI)ui).getTabView()) != null) {
            tv.addMouseWheelListener(this.mouseWheelHandler);
        }
    }

    public void removeHeadMouseWheelListener() {
        KingdeeTabbedPaneUI.TabView tv;
        TabbedPaneUI ui = this.getUI();
        if (ui instanceof KingdeeTabbedPaneUI && (tv = ((KingdeeTabbedPaneUI)ui).getTabView()) != null && this.mouseWheelHandler != null) {
            tv.removeMouseWheelListener(this.mouseWheelHandler);
        }
    }

    public void removeHeadMouseListener(MouseListener l) {
        KingdeeTabbedPaneUI.TabView tv;
        TabbedPaneUI ui = this.getUI();
        if (ui instanceof KingdeeTabbedPaneUI && (tv = ((KingdeeTabbedPaneUI)ui).getTabView()) != null) {
            tv.removeMouseListener(l);
        }
    }

    public void removeTabbedPaneListener(TabbedPaneListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(TabbedPaneListener.class, l);
    }

    protected void fireTabbedPaneEvent(TabbedPaneEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        block6: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TabbedPaneEvent.class) continue;
            int operType = event.getOperType();
            switch (operType) {
                case 2: {
                    ((TabbedPaneListener)listeners[i]).tabbedPaneActived(event);
                    continue block6;
                }
                case 1: {
                    ((TabbedPaneListener)listeners[i]).tabbedPaneClosed(event);
                    continue block6;
                }
                case 0: {
                    ((TabbedPaneListener)listeners[i]).tabbedPaneClosing(event);
                    continue block6;
                }
                case 3: {
                    ((TabbedPaneListener)listeners[i]).tabbedPaneDeactived(event);
                    continue block6;
                }
            }
        }
    }

    public int getVisibleTabCount() {
        int count = 0;
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.isVisibleAt(i)) continue;
            ++count;
        }
        return count;
    }

    public void addTab(String title, Icon icon, Component component, boolean toggle) {
        super.addTab(title, icon, component);
        this.setToggled(this.getTabCount() - 1, toggle);
    }

    public void setToggled(int index, boolean value) {
        this.ensureToggleStateArraySize();
        this.toggleStates.set(index, value);
    }

    public boolean isToggled(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("tab index outbounds");
        }
        this.ensureToggleStateArraySize();
        return (Boolean)this.toggleStates.get(index);
    }

    public void setViewStyle(int value) {
        if (value == this.viewStyle) {
            return;
        }
        this.addKeyboardAction(value);
        this.viewStyle = value;
        this.repaint();
    }

    public int getViewStyle() {
        return this.viewStyle;
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        this.setToggled(this.getTabCount() - 1, false);
    }

    @Override
    public void add(Component component, Object constraints, int index) {
        super.add(component, constraints, index);
    }

    public void ensureToggleStateArraySize() {
        while (this.toggleStates.size() < this.getTabCount()) {
            this.toggleStates.add(true);
        }
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        Component cur = this.getSelectedComponent();
        if (cur != null) {
            int idx = this.history.indexOf(cur);
            if (idx != -1) {
                this.history.removeFrom(idx + 1);
            } else {
                this.history.clear();
                this.history.add(cur);
            }
        } else {
            this.history.clear();
        }
        this.history.add(component);
        super.insertTab(title, icon, component, tip, index);
        if (component != null) {
            component.setVisible(false);
        }
        this.ensureToggleStateArraySize();
        this.toggleStates.add(index, Boolean.FALSE);
    }

    private void removeCloseActionListener(ActionListener l) {
        if (l != null && this.getCloseAction() == l) {
            this.setCloseAction(null);
        } else {
            this.listenerList.remove(ActionListener.class, l);
        }
    }

    private boolean isListener(Class c, ActionListener a) {
        boolean isListener = false;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != c || listeners[i + 1] != a) continue;
            isListener = true;
        }
        return isListener;
    }

    public void setCloseAction(Action a) {
        Action oldValue = this.getCloseAction();
        if (this.closeAction == null || !this.closeAction.equals(a)) {
            this.closeAction = a;
            if (oldValue != null) {
                this.removeCloseActionListener(oldValue);
            }
            if (this.closeAction != null && !this.isListener(ActionListener.class, this.closeAction)) {
                this.addCloseActionListener(this.closeAction);
            }
            this.firePropertyChange("TabClose", oldValue, this.closeAction);
        }
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    public void addCloseActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void addCloseAllTabListener(TabbedPaneCloseAllTabListener l) {
        this.listenerList.add(TabbedPaneCloseAllTabListener.class, l);
    }

    public TabbedPaneCloseAllTabListener[] getTabbedPaneCloseAllTabListeners() {
        return (TabbedPaneCloseAllTabListener[])this.listenerList.getListeners(TabbedPaneCloseAllTabListener.class);
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    @Override
    public void setComponentAt(int index, Component component) {
        super.setComponentAt(index, component);
        if (index < this.history.size() && this.history.get(index) != component) {
            this.history.remove(index);
            this.history.add(index, component);
        }
    }

    @Override
    public void removeTabAt(int index) {
        int idx;
        Component target = this.getComponentAt(index);
        this.ensureToggleStateArraySize();
        this.toggleStates.remove(index);
        super.removeTabAt(index);
        if (target != null && (idx = this.history.indexOf(target)) != -1) {
            this.history.removeFrom(idx);
            target = (Component)this.history.getLast();
            if (target != null) {
                this.setSelectedComponent(target);
            }
        }
    }

    @Override
    public void updateUI() {
        this.setUI(KingdeeTabbedPaneUI.createUI(this));
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        int size = this.getTabCount();
        boolean bUsed = true;
        for (int i = 0; i < size; ++i) {
            Icon icon = this.getIconAt(i);
            Icon dIcon = this.getDisabledIconAt(i);
            if (KDTabbedPane.doesIconReferenceImage(icon, img) || KDTabbedPane.doesIconReferenceImage(dIcon, img)) {
                bUsed = true;
                break;
            }
            bUsed = false;
        }
        if (!bUsed) {
            return false;
        }
        return super.imageUpdate(img, infoflags, x, y, w, h);
    }

    static boolean doesIconReferenceImage(Icon icon, Image image) {
        Image iconImage = icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
        return iconImage == image;
    }

    private void tryCloseTab(EventObject e) {
        int index;
        JTabbedPane tabPane = null;
        Object src = e.getSource();
        while (tabPane == null && src instanceof JComponent) {
            if (src instanceof JTabbedPane) {
                tabPane = (JTabbedPane)src;
            }
            src = ((JComponent)src).getParent();
        }
        if (tabPane != null && (index = tabPane.getSelectedIndex()) != -1 && index < tabPane.getTabCount()) {
            ActionListener[] actionListeners = ((KDTabbedPane)tabPane).getActionListeners();
            ActionEvent event = new ActionEvent(tabPane, 1001, "TabClose");
            for (int i = 0; i < actionListeners.length; ++i) {
                actionListeners[i].actionPerformed(event);
            }
        }
    }

    private void addKeyboardAction(int value) {
        if (value == 1) {
            this.getInputMap(1).remove(KeyStroke.getKeyStroke(87, 128));
            this.getActionMap().remove("Ctrl_W");
        } else if (value == 2) {
            this.getInputMap(1).put(KeyStroke.getKeyStroke(87, 128), "Ctrl_W");
            this.getActionMap().put("Ctrl_W", new AbstractAction(){
                private static final long serialVersionUID = 0L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDTabbedPane.this.tryCloseTab(e);
                }
            });
        }
    }

    private class HeadMouseWheelHandler
    implements MouseWheelListener {
        private HeadMouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int currentSelectedIndex = KDTabbedPane.this.getSelectedIndex();
            int lastIndex = KDTabbedPane.this.getTabCount() - 1;
            if (e.getWheelRotation() > 0) {
                if (currentSelectedIndex == lastIndex) {
                    KDTabbedPane.this.setSelectedIndex(0);
                } else {
                    KDTabbedPane.this.setSelectedIndex(currentSelectedIndex + 1);
                }
            } else if (e.getWheelRotation() < 0) {
                if (currentSelectedIndex == 0) {
                    KDTabbedPane.this.setSelectedIndex(lastIndex);
                } else {
                    KDTabbedPane.this.setSelectedIndex(currentSelectedIndex - 1);
                }
            }
        }
    }

    private static class TabHistory
    extends LinkedList {
        private static final long serialVersionUID = -6066449922716149783L;

        private TabHistory() {
        }

        public void removeFrom(int index) {
            while (this.size() > index) {
                this.removeLast();
            }
        }

        @Override
        public Object getLast() {
            if (this.size() == 0) {
                return null;
            }
            return super.getLast();
        }
    }

    public static class DefaultCloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -9051251400013536729L;

        @Override
        public void actionPerformed(ActionEvent e) {
            KDTabbedPane tabbedPane = (KDTabbedPane)e.getSource();
            if (tabbedPane != null && tabbedPane.getSelectedIndex() != -1) {
                tabbedPane.removeTabAt(tabbedPane.getSelectedIndex());
            }
        }
    }
}

