/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.ITextIconDisplayStyle;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.ToolTipManager;

public class KDToggleButton
extends JToggleButton
implements ITextIconDisplayStyle,
IKDComponent {
    private static final long serialVersionUID = 3834493978090640596L;
    private short textIconStyle = (short)-1;
    private boolean isControlByParent = true;
    private boolean forToolbar = false;
    private Object userObject = null;
    private Insets customInsets;
    public static final int BLUE_FACE = 0;
    public static final int GRAY_FACE = 1;
    private int faceType = 1;

    public KDToggleButton() {
        this.init();
    }

    public KDToggleButton(Icon icon) {
        super(icon);
        this.init();
    }

    public KDToggleButton(Icon icon, boolean selected) {
        super(icon, selected);
        this.init();
    }

    public KDToggleButton(String text) {
        super(text);
        this.init();
    }

    public KDToggleButton(String text, boolean selected) {
        super(text, selected);
        this.init();
    }

    public KDToggleButton(Action a) {
        super(a);
        this.init();
    }

    public KDToggleButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public KDToggleButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.init();
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setTextIconDisStyle(short newVal) {
        if (newVal == 1 || newVal == 2 || newVal == 3 || newVal == -1) {
            this.textIconStyle = newVal;
        }
    }

    @Override
    public short getTextIconDisStyle() {
        return this.textIconStyle;
    }

    @Override
    public void setIsControlByParent(boolean newVal) {
        this.isControlByParent = newVal;
    }

    @Override
    public boolean isControlByParent() {
        return this.isControlByParent;
    }

    public boolean isForToolbar() {
        return this.forToolbar;
    }

    public void setForToolbar(boolean forToolbar) {
        this.forToolbar = forToolbar;
    }

    @Override
    public Icon getIcon() {
        if (!this.isForToolbar()) {
            return super.getIcon();
        }
        short tiStyle = this.getTextIconDisStyle();
        if (this.isControlByParent() && this.getParent() instanceof KDToolBar) {
            tiStyle = ((KDToolBar)this.getParent()).isControlByParent() ? KDToolBar.getTextIconDisStyleByParent() : ((KDToolBar)this.getParent()).getTextIconDisStyle();
        }
        if (tiStyle == 2 || tiStyle == 3 || tiStyle == -1) {
            return super.getIcon();
        }
        return null;
    }

    @Override
    public String getText() {
        if (!this.isForToolbar()) {
            return super.getText();
        }
        short tiStyle = this.getTextIconDisStyle();
        if (this.isControlByParent() && this.getParent() instanceof KDToolBar) {
            tiStyle = ((KDToolBar)this.getParent()).isControlByParent() ? KDToolBar.getTextIconDisStyleByParent() : ((KDToolBar)this.getParent()).getTextIconDisStyle();
        }
        if (tiStyle == 1 || tiStyle == 3 || tiStyle == -1) {
            return super.getText();
        }
        return "";
    }

    public int getFaceType() {
        return this.faceType;
    }

    public void setFactType(int newValue) {
        int oldFace;
        int tempFace = 0;
        if (newValue != 0) {
            tempFace = 1;
        }
        if (tempFace != (oldFace = this.getFaceType())) {
            this.faceType = tempFace;
            this.firePropertyChange("selfFaceType", (Object)oldFace, (Object)tempFace);
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (!StringUtil.isEmptyString((String)text)) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setToolTipText(text);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    private void init() {
        this.faceType = 1;
        String text = this.getText();
        if (!StringUtil.isEmptyString((String)text)) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setToolTipText(text);
        }
    }
}

