/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.ITextIconDisplayStyle;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDToggleButton;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.LittleArrowButton;
import com.kingdee.cosmic.ctrl.swing.SimpleToolBarLayout;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeToolBarUI;
import com.kingdee.cosmic.ctrl.swing.util.SwingLogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class KDToolBar
extends JToolBar
implements ITextIconDisplayStyle {
    private static final long serialVersionUID = 2434924652073052417L;
    public static final int EAST = 3;
    public static final int SOUTH = 5;
    public static final int WEST = 7;
    public static final int NORTH = 1;
    public static final String ACTION_BUTTON = "ActionComponent";
    private boolean allowedInsets = true;
    private LittleArrowButton littleArrowButton = null;
    private static final boolean DEBUG = false;
    private boolean limitedSize = true;
    private int rowID = -1;
    private boolean popupMenuShowable = true;
    private static short textIconStyleFromParent = (short)-1;
    private short textIconStyle = (short)-1;
    private boolean isControlByParent = true;
    private short horizontalStyle = (short)-1;
    private short verticalStyle = (short)2;
    private boolean floatable;
    private static int tempCount = 0;

    public KDToolBar() {
        this.init();
    }

    public KDToolBar(int orientation) {
        super(orientation);
        this.init();
    }

    @Override
    public void setOrientation(int o) {
        super.setOrientation(o);
        this.setIsControlByParent(false);
        if (o == 1) {
            this.setTextIconDisStyle(this.verticalStyle);
        } else if (o == 0) {
            this.setTextIconDisStyle(this.horizontalStyle);
        }
        this.doLayout();
        this.repaint();
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JToolBar.Separator) {
            comp = new KDSeparator();
            this.installSelfSeparator((JSeparator)comp);
        } else if (comp instanceof JSeparator) {
            this.installSelfSeparator((JSeparator)comp);
        }
        this.addImpl(comp, null, -1);
        return comp;
    }

    @Override
    public Component add(Component comp, int index) {
        if (comp instanceof JToolBar.Separator) {
            comp = new KDSeparator();
            this.installSelfSeparator((JSeparator)comp);
        } else if (comp instanceof JSeparator) {
            this.installSelfSeparator((JSeparator)comp);
        }
        this.addImpl(comp, null, index);
        return comp;
    }

    public Component addComponentAtLast(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).putClientProperty("alwaysLast", Boolean.TRUE);
        }
        return this.add(comp);
    }

    public Component addComponentAfterComponent(Component comp, Component c) {
        int index = this.getComponentIndex(c);
        return this.add(comp, index + 1);
    }

    public Component addComponentBeforeComponent(Component comp, Component c) {
        int index = this.getComponentIndex(c);
        return this.add(comp, index);
    }

    public KDToolBar(String name) {
        super(name);
        this.init();
    }

    private void init() {
        LayoutManager tempLayout = this.getLayout();
        if (tempLayout instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)tempLayout));
            this.logs("layout is " + tempLayout.getClass().getName());
        }
        SimpleToolBarLayout layout = new SimpleToolBarLayout(this, this.getOrientation());
        this.setLayout(layout);
        this.addPropertyChangeListener(layout);
        this.littleArrowButton = new LittleArrowButton();
        this.littleArrowButton.putClientProperty("container", "true");
        this.add(this.littleArrowButton);
    }

    public KDToolBar(String name, int orientation) {
        super(name, orientation);
    }

    @Override
    public JButton add(Action an) {
        Object obj = an.getValue(ACTION_BUTTON);
        JButton bu = obj instanceof KDWorkButton ? this.addWorkButton((KDWorkButton)obj) : (obj instanceof JButton ? (JButton)this.add((JButton)obj) : super.add(an));
        if (bu != null) {
            bu.setFocusable(false);
            bu.setRolloverEnabled(true);
        }
        return bu;
    }

    public JButton add(Action an, int index) {
        JButton bu;
        Object obj = an.getValue(ACTION_BUTTON);
        if (obj instanceof KDWorkButton) {
            bu = this.addWorkButton((KDWorkButton)obj);
        } else if (obj instanceof JButton) {
            bu = (JButton)this.add((JButton)obj);
        } else {
            bu = this.createActionComponent(an);
            bu.setAction(an);
            this.addImpl(bu, null, index);
        }
        return bu;
    }

    public JButton addActionAfterComponent(Action an, Component comp) {
        int index = this.getComponentIndex(comp);
        return this.add(an, index + 1);
    }

    public JButton addActionBeforeComponent(Action an, Component comp) {
        int index = this.getComponentIndex(comp);
        return this.add(an, index);
    }

    @Override
    public void addSeparator() {
        KDSeparator s = new KDSeparator();
        this.installSelfSeparator(s);
        this.add(s);
    }

    public void addSeparator(String name) {
        KDSeparator s = new KDSeparator();
        s.setName(name);
        this.installSelfSeparator(s);
        this.add(s);
    }

    @Override
    public void addSeparator(Dimension size) {
        KDSeparator s = new KDSeparator();
        this.installSelfSeparator(s);
        this.add(s);
    }

    private void installSelfSeparator(JSeparator s) {
        if (s != null) {
            switch (this.getOrientation()) {
                case 1: {
                    s.setOrientation(0);
                    s.setPreferredSize(new Dimension(20, 8));
                    s.putClientProperty("orientation", s.getOrientation());
                    s.putClientProperty("preferedSize", s.getPreferredSize());
                    break;
                }
                default: {
                    s.setOrientation(1);
                    s.setPreferredSize(new Dimension(8, 20));
                    s.putClientProperty("orientation", s.getOrientation());
                    s.putClientProperty("preferedSize", s.getPreferredSize());
                }
            }
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (comp instanceof AbstractButton) {
            ((AbstractButton)comp).setRolloverEnabled(true);
            ((AbstractButton)comp).setFocusable(false);
            ((AbstractButton)comp).setOpaque(false);
        }
        if (comp instanceof KDWorkButton) {
            ((KDWorkButton)comp).setFactType(0);
        } else if (comp instanceof KDToggleButton) {
            ((KDToggleButton)comp).setFactType(0);
            ((KDToggleButton)comp).setForToolbar(true);
        }
        ((KingdeeToolBarUI)this.getUI()).add(comp);
    }

    public KDWorkButton addWorkButton(KDWorkButton workButton) {
        if (workButton != null) {
            workButton.setFocusable(false);
            workButton.setRolloverEnabled(true);
            super.add(workButton);
        }
        return workButton;
    }

    public KDWorkButton addWorkButton(KDWorkButton workButton, int index) {
        if (workButton != null) {
            workButton.setFocusable(false);
            workButton.setRolloverEnabled(true);
            super.addImpl(workButton, null, index);
        }
        return workButton;
    }

    public KDWorkButton addWorkButtonAfterComponent(KDWorkButton workButton, Component comp) {
        int index = this.getComponentIndex(comp);
        return this.addWorkButton(workButton, index + 1);
    }

    public KDWorkButton addWorkButtonBeforeComponent(KDWorkButton workButton, Component comp) {
        int index = this.getComponentIndex(comp);
        return this.addWorkButton(workButton, index);
    }

    public JComponent addRightComponent(JComponent comp, int rightInterval) {
        if (comp != null) {
            super.add(comp);
        }
        return comp;
    }

    public int getRowID() {
        return this.rowID;
    }

    public void setRowID(int rowID) {
        if (rowID < 0) {
            throw new IllegalArgumentException(CtrlSwingMessages.getMLS("toolbarRowMustBeNonNegativeInteger", "\u5de5\u5177\u6761\u884c\u53f7\u5fc5\u987b\u8bbe\u7f6e\u4e3a\u5927\u4e8e,\u7b49\u4e8e\u96f6\u7684\u6574\u6570!"));
        }
        this.rowID = rowID;
    }

    @Override
    protected JButton createActionComponent(Action a) {
        String text = a != null ? (String)a.getValue("Name") : null;
        Icon icon = a != null ? (Icon)a.getValue("SmallIcon") : null;
        boolean enabled = a != null ? a.isEnabled() : true;
        String tooltip = a != null ? (String)a.getValue("ShortDescription") : null;
        KDWorkButton b = new KDWorkButton(text, icon){
            private static final long serialVersionUID = 8154495647617569311L;

            @Override
            protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
                PropertyChangeListener pcl = KDToolBar.this.createActionChangeListener(this);
                if (pcl == null) {
                    pcl = super.createActionPropertyChangeListener(a);
                }
                return pcl;
            }
        };
        if (icon != null) {
            b.putClientProperty("hideActionText", Boolean.TRUE);
        }
        b.setEnabled(enabled);
        b.setToolTipText(tooltip);
        return b;
    }

    public void setLogo(Icon icon) {
        if (icon == null) {
            return;
        }
    }

    public void setLogo() {
    }

    public void removeLogo() {
    }

    public void setAllowedInsets(boolean b) {
        this.allowedInsets = b;
    }

    public boolean allowedInsets() {
        return this.allowedInsets;
    }

    @Override
    public void remove(Component comp) {
        if (comp != null) {
            if (comp.getParent() == this) {
                super.remove(comp);
                return;
            }
            if (this.littleArrowButton != null) {
                if (comp.getParent() != null) {
                    this.littleArrowButton.getSelfContainer().remove(comp.getParent());
                } else {
                    this.littleArrowButton.getSelfContainer().remove(comp);
                }
                return;
            }
        }
        SwingLogUtil.error((String)"[KDToolBar.remove(Component)] Waring");
    }

    @Override
    public void remove(int index) {
        Component comp = this.getComponent(index);
        if (comp.getParent() == this) {
            super.remove(index);
            return;
        }
        if (this.littleArrowButton != null) {
            this.littleArrowButton.getSelfContainer().remove(comp);
            return;
        }
        SwingLogUtil.error((String)"[KDToolBar.remove(int)] Waring");
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (this.littleArrowButton != null) {
            this.littleArrowButton.getSelfContainer().removeAll();
        }
    }

    @Override
    public void setFloatable(boolean b) {
        if (!b && !this.isOpenFloatable()) {
            return;
        }
        if (this.floatable != b) {
            boolean old = this.floatable;
            this.floatable = b;
            this.firePropertyChange("floatable", old, b);
            this.revalidate();
            this.repaint();
        }
        ((KingdeeToolBarUI)this.ui).configDragArea(b);
    }

    @Override
    public boolean isFloatable() {
        return this.floatable;
    }

    public boolean hasPoint() {
        return this.isFloatable();
    }

    public void setHasPoint(boolean b) {
    }

    public void setLimitedSize(boolean newB) {
        if (newB != this.limitedSize) {
            boolean old = this.limitedSize;
            this.limitedSize = newB;
            this.firePropertyChange("IsLimitedSize", (Object)old, (Object)this.limitedSize);
        }
    }

    public boolean isLimitedSize() {
        return this.limitedSize;
    }

    public void selfFrefresh() {
    }

    private void logs(String info) {
    }

    @Override
    public void setTextIconDisStyle(short newVal) {
        if ((newVal == 1 || newVal == 2 || newVal == 3 || newVal == -1) && newVal != this.getTextIconDisStyle()) {
            this.textIconStyle = newVal;
            if (this.getOrientation() == 0) {
                this.horizontalStyle = newVal;
            } else if (this.getOrientation() == 1) {
                this.verticalStyle = (short)2;
            }
        }
    }

    @Override
    public short getTextIconDisStyle() {
        return this.textIconStyle;
    }

    @Override
    public void setIsControlByParent(boolean newVal) {
        this.isControlByParent = newVal;
    }

    @Override
    public boolean isControlByParent() {
        return this.isControlByParent;
    }

    public boolean isPopupMenuShowable() {
        return this.popupMenuShowable;
    }

    public void setPopupMenuShowable(boolean popupMenuShowable) {
        this.popupMenuShowable = popupMenuShowable;
        ((KingdeeToolBarUI)this.getUI()).setPopupMenuShowable(popupMenuShowable);
    }

    public static void setTextIconDisStyleByParent(short newVal) {
        if (newVal == 1 || newVal == 2 || newVal == 3 || newVal == -1) {
            textIconStyleFromParent = newVal;
        }
    }

    public static short getTextIconDisStyleByParent() {
        return textIconStyleFromParent;
    }

    public Component getToolBarComponentAt(int index) {
        Component[] comps = this.getToolBarComponents();
        if (index >= 0 && index < comps.length) {
            return comps[index];
        }
        return null;
    }

    public int getToolBarComponentCount() {
        return this.getComponentCount() + this.littleArrowButton.getSelfComponentCount() - 1;
    }

    public Component[] getToolBarComponents() {
        Component[] tlComps = this.getComponents();
        Component[] lbComps = this.littleArrowButton.getSelfComponents();
        int tlCompsCount = this.getComponentCount();
        int lbCompsCount = this.littleArrowButton.getSelfComponentCount();
        Component[] allComps = new Component[tlCompsCount + lbCompsCount - 1];
        if (tlCompsCount > 1) {
            System.arraycopy(tlComps, 1, allComps, 0, tlCompsCount - 1);
        }
        System.arraycopy(lbComps, 0, allComps, tlCompsCount - 1, lbCompsCount);
        return allComps;
    }

    public void removeAllToolBarComponents() {
        if (this.isFloatable()) {
            while (this.getToolBarComponentCount() > 1) {
                this.remove(this.getToolBarComponentAt(1));
            }
        } else {
            while (this.getToolBarComponentCount() > 0) {
                this.remove(this.getToolBarComponentAt(0));
            }
        }
        this.updateUI();
    }

    protected boolean isOpenFloatable() {
        return false;
    }
}

