/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDComponentDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeToolBarUI;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.cosmic.ctrl.swing.util.JVM;
import com.kingdee.cosmic.ctrl.swing.util.SwingLogUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class KDTreeView
extends JPanel
implements IKDComponent,
ActionListener,
LayoutManager {
    private static final long serialVersionUID = -578626898655312799L;
    protected Object userObject = null;
    private KDTree tree;
    private KDScrollPane treePane;
    private ControlPanel controlPane;
    private KDWorkButton allExpandBnt;
    private KDWorkButton expandlevelBnt;
    private KDWorkButton allCollapseBnt;
    private KDWorkButton expandBnt;
    private KDWorkButton collapseBnt;
    private KDWorkButton findBtn;
    private KDWorkButton levelExpandBtn;
    private int maxExpandLevel;
    private Insets customInsets;
    private KDComponentDialog findDialog;
    private KDButton findNextBtn;
    private KDButton closeBtn;
    private KDLabelContainer findNextLabel;
    private KDTextField findNextTxt;
    private List nodeList;
    private String textToFound = "";
    private int foundIndex = -1;
    private int currentIndex = 0;
    private KDComponentDialog notFoundDialog;
    private KDComponentDialog finishSearchDialog;
    private boolean finishSearch = false;
    private boolean ControlPaneToolTipTextVisible = true;

    public KDTreeView() {
        this((KDTree)null);
    }

    public KDTreeView(KDTree tree) {
        this.tree = tree;
        this.init();
    }

    public KDTreeView(KDTree tree, String title, boolean showButton) {
        this(tree);
        this.setTitle(title);
        this.setShowButton(showButton);
    }

    public KDTreeView(KDTree tree, String title) {
        this(tree);
        this.setTitle(title);
    }

    public KDTreeView(KDTree tree, boolean showButton) {
        this(tree);
        this.setShowButton(showButton);
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    void init() {
        this.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Tree.treeCtrlPaneBorder")));
        this.treePane = new KDScrollPane(this.tree);
        this.treePane.setBorder(null);
        this.setLayout(this);
        this.controlPane = new ControlPanel("");
        this.controlPane.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Tree.treeCtrlPaneBorder")));
        this.controlPane.setLayout(this.controlPane);
        this.allExpandBnt = new KDWorkButton(new ImageIcon(KDResourceManager.getImageOfRapid(this.getMLS("picOpenAll", "tbtn_allopen_menu.gif"))));
        this.allExpandBnt.setActionCommand(CtrlSwingMessages.getMLS("menuToolTipOpenAll", "\u5168\u5c55"));
        this.allExpandBnt.setToolTipText(this.getMLS("menuToolTipOpenAll", "\u5168\u5c55"));
        this.allCollapseBnt = new KDWorkButton(new ImageIcon(KDResourceManager.getImageOfRapid(this.getMLS("picCloseAll", "tbtn_allclose_menu.gif"))));
        this.allCollapseBnt.setActionCommand(CtrlSwingMessages.getMLS("menuToolTipCloseAll", "\u5168\u6536"));
        this.allCollapseBnt.setToolTipText(this.getMLS("menuToolTipCloseAll", "\u5168\u6536"));
        this.expandlevelBnt = new KDWorkButton(new ImageIcon(KDResourceManager.getImageOfRapid(this.getMLS("picOpenLL", "tbtn_openlowerlever_menu.gif"))));
        this.expandlevelBnt.setActionCommand(CtrlSwingMessages.getMLS("menuToolTipOpenLL", "\u5c55\u7ea7"));
        this.expandlevelBnt.setToolTipText(this.getMLS("menuToolTipOpenLL", "\u5c55\u7ea7"));
        this.expandBnt = new KDWorkButton(new ImageIcon(KDResourceManager.getImageOfRapid(this.getMLS("picOpen", "tbtn_open_menu.gif"))));
        this.expandBnt.setActionCommand(CtrlSwingMessages.getMLS("menuToolTipOpen", "\u5c55\u5f00"));
        this.expandBnt.setToolTipText(this.getMLS("menuToolTipOpen", "\u5c55\u5f00"));
        this.collapseBnt = new KDWorkButton(new ImageIcon(KDResourceManager.getImageOfRapid(this.getMLS("picClose", "tbtn_close_menu.gif"))));
        this.collapseBnt.setActionCommand(CtrlSwingMessages.getMLS("menuToolTipClose", "\u6536\u7f29"));
        this.collapseBnt.setToolTipText(this.getMLS("menuToolTipClose", "\u6536\u7f29"));
        this.levelExpandBtn = new KDWorkButton("1");
        this.levelExpandBtn.setActionCommand(CtrlSwingMessages.getMLS("expandLevel1", "1\u7ea7\u5c55\u5f00"));
        this.levelExpandBtn.setToolTipText(this.getMLS("menuToolTipOpenLL", "\u5c55\u7ea7") + " n");
        this.levelExpandBtn.setVisible(false);
        this.setMaxExpandLevelForButton(3);
        this.findBtn = new KDWorkButton(new ImageIcon(KDResourceManager.getImageOfRapid(this.getMLS("picFind", "tree_demand.png"))));
        this.findBtn.setActionCommand("findNode");
        this.findBtn.setToolTipText(this.getMLS("menuToolTipFind", "\u67e5\u627e"));
        this.findBtn.addActionListener(new FindBtnActionListener());
        this.controlPane.add(this.expandBnt);
        this.controlPane.add(this.collapseBnt);
        this.controlPane.add(this.expandlevelBnt);
        this.controlPane.add(this.allExpandBnt);
        this.controlPane.add(this.allCollapseBnt);
        this.controlPane.add(this.levelExpandBtn);
        this.controlPane.add(this.findBtn);
        this.allExpandBnt.addActionListener(this);
        this.expandBnt.addActionListener(this);
        this.allCollapseBnt.addActionListener(this);
        this.collapseBnt.addActionListener(this);
        this.expandlevelBnt.addActionListener(this);
        this.levelExpandBtn.addActionListener(this);
        this.add((Component)this.controlPane, "North");
        this.add((Component)this.treePane, "South");
        InputMap inputmap = this.getInputMap(1);
        inputmap.put(KeyStroke.getKeyStroke(70, 128), "findNext");
        ActionMap actionmap = this.getActionMap();
        actionmap.put("findNext", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTreeView.this.showFindNextDialog();
            }
        });
        inputmap.put(KeyStroke.getKeyStroke(49, 128), "expandLevel2");
        inputmap.put(KeyStroke.getKeyStroke(50, 128), "expandLevel3");
        inputmap.put(KeyStroke.getKeyStroke(51, 128), "expandLevel4");
        actionmap.put("expandLevel2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTreeView.this.tree.expandOnLevel(2);
            }
        });
        actionmap.put("expandLevel3", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTreeView.this.tree.expandOnLevel(3);
            }
        });
        actionmap.put("expandLevel4", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTreeView.this.tree.expandOnLevel(4);
            }
        });
    }

    private void showFindNextDialog() {
        DefaultTreeModel newTreeModel;
        if (this.tree != null && (newTreeModel = (DefaultTreeModel)this.tree.getModel()) != null && newTreeModel.getRoot() != null) {
            Window w = SwingUtilities.windowForComponent(this);
            this.findDialog = w instanceof Dialog ? new KDComponentDialog((Dialog)w) : (w instanceof Frame ? new KDComponentDialog((Frame)w) : new KDComponentDialog());
            this.setFindDialogModal();
            this.findDialog.setLFStyle(2);
            this.findDialog.setTitle(this.getMLS("findNodeDialogTitle", "\u67e5\u627e\u8282\u70b9"));
            this.findNextBtn = new KDButton(this.getMLS("findNext", "\u67e5\u627e\u4e0b\u4e00\u4e2a"));
            this.findNextBtn.setLimitedSize(false);
            this.findNextBtn.setFocusable(false);
            this.closeBtn = new KDButton(this.getMLS("closeDialog", "\u5173\u95ed"));
            this.closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDTreeView.this.findDialog.dispose();
                }
            });
            this.findDialog.addButton(this.closeBtn);
            this.findDialog.addButton(this.findNextBtn);
            this.findNextLabel = new KDLabelContainer();
            this.findNextTxt = new KDTextField();
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this.findNextTxt, KeyStroke.getKeyStroke(10, 0));
            this.findNextLabel.setBoundLabelText(this.getMLS("findContentLabel", "\u67e5\u627e\u5185\u5bb9     "));
            this.findNextLabel.setBoundEditor(this.findNextTxt);
            this.findNextLabel.setPreferredSize(new Dimension(270, 21));
            this.findNextLabel.setBoundLabelUnderline(true);
            this.findDialog.setDialogComponent(this.findNextLabel);
            this.findDialog.setSize(290, 118);
            this.findDialog.setResizable(false);
            this.findNextBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDTreeView.this.findNode();
                }
            });
            this.nodeList = new ArrayList();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)newTreeModel.getRoot();
            Enumeration<TreeNode> e = root.preorderEnumeration();
            while (e.hasMoreElements()) {
                this.nodeList.add(e.nextElement());
            }
            this.findDialog.getRootPane().setDefaultButton(this.findNextBtn);
            this.findDialog.setLocation(this.getControlPane().getLocationOnScreen());
            this.findDialog.show();
        }
    }

    private void setFindDialogModal() {
        if (JVM.current().isOverOneDotFive() && this.findDialog != null) {
            this.findDialog.setModal(true);
        }
    }

    private void findNode() {
        String nodeText = "";
        int size = this.nodeList.size();
        String input = this.findNextTxt.getText().toLowerCase(Locale.ENGLISH).trim();
        if (input != null && input.trim().length() > 0) {
            DefaultKingdeeTreeNode currentNode;
            if (!this.textToFound.equalsIgnoreCase(input)) {
                this.finishSearch = false;
                this.textToFound = input;
                currentNode = null;
                this.foundIndex = -1;
                this.currentIndex = 0;
            }
            this.currentIndex = this.foundIndex + 1;
            if (this.currentIndex < size) {
                int i;
                for (i = this.currentIndex; i < size; ++i) {
                    Object node = this.nodeList.get(i);
                    if (!(node instanceof DefaultKingdeeTreeNode)) continue;
                    currentNode = (DefaultKingdeeTreeNode)this.nodeList.get(i);
                    nodeText = currentNode.getText();
                    String string = nodeText = StringUtil.isEmptyString((String)nodeText) ? "" : nodeText.toLowerCase(Locale.ENGLISH);
                    if (nodeText == null || nodeText.indexOf(this.textToFound) == -1) continue;
                    this.tree.setSelectionNode(currentNode);
                    this.tree.scrollPathToVisible(this.tree.getSelectionPath());
                    this.foundIndex = i;
                    if (i != this.nodeList.size() - 1) break;
                    ++i;
                    break;
                }
                if (i == size) {
                    this.finishSearch = true;
                }
            }
            if (this.foundIndex == -1) {
                if (this.notFoundDialog == null) {
                    this.notFoundDialog = new KDComponentDialog(this.findDialog);
                    this.notFoundDialog.setLFStyle(2);
                    this.notFoundDialog.setTitle(this.getMLS("notFindNodeDialogTitle", "\u4fe1\u606f\u63d0\u9192"));
                    KDButton ok = new KDButton(this.getMLS("OKBtn", "\u786e\u5b9a"));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            KDTreeView.this.notFoundDialog.dispose();
                        }
                    });
                    KDLabel notFoundLbl = new KDLabel(this.getMLS("searchFinish", "\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879"));
                    notFoundLbl.setHorizontalAlignment(0);
                    notFoundLbl.setPreferredSize(new Dimension(290, 21));
                    this.notFoundDialog.addButton(ok);
                    this.notFoundDialog.setDialogComponent(notFoundLbl);
                }
                this.notFoundDialog.setLocation(this.findDialog.getLocation());
                this.notFoundDialog.setSize(290, 118);
                this.notFoundDialog.setModal(true);
                this.notFoundDialog.show();
            } else if (this.finishSearch) {
                this.textToFound = "";
                if (this.finishSearchDialog == null) {
                    this.finishSearchDialog = new KDComponentDialog(this.findDialog);
                    this.finishSearchDialog.setLFStyle(2);
                    this.finishSearchDialog.setTitle(this.getMLS("notFindNodeDialogTitle", "\u4fe1\u606f\u63d0\u9192"));
                    KDButton ok = new KDButton(this.getMLS("OKBtn", "\u786e\u5b9a"));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            KDTreeView.this.finishSearchDialog.dispose();
                        }
                    });
                    KDLabel notFoundLbl = new KDLabel(this.getMLS("searchFinish2", "\u5df2\u7ecf\u5b8c\u6210\u641c\u7d22"));
                    notFoundLbl.setHorizontalAlignment(0);
                    notFoundLbl.setPreferredSize(new Dimension(290, 21));
                    this.finishSearchDialog.addButton(ok);
                    this.finishSearchDialog.setDialogComponent(notFoundLbl);
                }
                this.finishSearchDialog.setLocation(this.findDialog.getLocation());
                this.finishSearchDialog.setSize(290, 118);
                this.finishSearchDialog.setModal(true);
                this.finishSearchDialog.show();
            }
        }
    }

    public KDTree getTree() {
        return this.tree;
    }

    public void setTree(KDTree tree) {
        this.tree = tree;
        this.treePane.setViewportView(tree);
    }

    public void setControlPaneToolTipTextVisible(boolean visible) {
        this.ControlPaneToolTipTextVisible = visible;
        if (!visible) {
            ToolTipManager.sharedInstance().unregisterComponent(this.controlPane.label);
        } else {
            ToolTipManager.sharedInstance().registerComponent(this.controlPane.label);
        }
    }

    public boolean isControlPaneToolTipTextVisible() {
        return this.ControlPaneToolTipTextVisible;
    }

    public void setShowButton(boolean showButton) {
        this.allExpandBnt.setVisible(showButton);
        this.expandlevelBnt.setVisible(showButton);
        this.allCollapseBnt.setVisible(showButton);
        this.expandBnt.setVisible(showButton);
        this.collapseBnt.setVisible(showButton);
    }

    public boolean isShowButton() {
        return this.expandBnt.isVisible();
    }

    public boolean isShowLevelExpandButton() {
        return this.levelExpandBtn != null && this.levelExpandBtn.isVisible();
    }

    public void setShowLevelExpandButton(boolean showButton) {
        this.levelExpandBtn.setVisible(showButton);
    }

    public void setShowLevelExpandButton(int level) {
        if (level > this.maxExpandLevel) {
            level = this.maxExpandLevel;
        }
        String action = Integer.toString(level);
        this.levelExpandBtn.setActionCommand(action + CtrlSwingMessages.getMLS("menuToolTipOpenLLL", "\u7ea7\u5c55\u5f00"));
        this.levelExpandBtn.setText(action);
        this.levelExpandBtn.setToolTipText(action + this.getMLS("menuToolTipOpenLLL", "\u7ea7\u5c55\u5f00"));
        this.setShowLevelExpandButton(true);
    }

    public int getMaxExpandLevelForButton() {
        return this.maxExpandLevel;
    }

    public void setMaxExpandLevelForButton(int level) {
        this.maxExpandLevel = level;
    }

    public String getTitle() {
        return this.controlPane.title;
    }

    public void setTitle(String title) {
        this.controlPane.title = title == null ? "" : title;
        this.controlPane.label.setText(this.controlPane.title);
        if (!StringUtil.isEmptyString((String)this.controlPane.title)) {
            this.setControlPaneToolTipTextVisible(true);
            this.controlPane.label.setToolTipText(title);
        } else {
            this.setControlPaneToolTipTextVisible(false);
        }
        this.controlPane.repaint();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(500, 500);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        if (cmd.equals(CtrlSwingMessages.getMLS("menuToolTipOpenAll", "\u5168\u5c55"))) {
            if (root != null) {
                if (!this.tree.isRootVisible()) {
                    for (int ind = 0; ind < root.getChildCount(); ++ind) {
                        DefaultMutableTreeNode defnode = (DefaultMutableTreeNode)root.getChildAt(ind);
                        Object[] pathtoRoot = defnode.getPath();
                        TreePath path = new TreePath(pathtoRoot);
                        this.tree.expandPath(path);
                    }
                } else {
                    this.tree.expandAllNodes(true, root);
                }
            }
        } else if (cmd.equals(CtrlSwingMessages.getMLS("menuToolTipOpen", "\u5c55\u5f00"))) {
            TreePath path = this.tree.getSelectionPath();
            if (path != null) {
                this.tree.expandPath(path);
            }
        } else if (cmd.equals(CtrlSwingMessages.getMLS("menuToolTipClose", "\u6536\u7f29"))) {
            TreePath path = this.tree.getSelectionPath();
            if (path != null) {
                this.tree.collapsePath(path);
            }
        } else if (cmd.equals(CtrlSwingMessages.getMLS("menuToolTipOpenLL", "\u5c55\u7ea7"))) {
            TreePath path = this.tree.getSelectionPath();
            if (path != null) {
                TreeNode node = (TreeNode)path.getLastPathComponent();
                this.tree.expandAllNodes(true, node);
            }
        } else if (cmd.equals(CtrlSwingMessages.getMLS("menuToolTipCloseAll", "\u5168\u6536"))) {
            if (root != null) {
                if (!this.tree.isRootVisible()) {
                    for (int ind = 0; ind < root.getChildCount(); ++ind) {
                        DefaultMutableTreeNode defnode = (DefaultMutableTreeNode)root.getChildAt(ind);
                        Object[] pathtoRoot = defnode.getPath();
                        TreePath path = new TreePath(pathtoRoot);
                        this.tree.collapsePath(path);
                    }
                } else {
                    this.tree.expandAllNodes(false, root);
                }
            }
        } else if (cmd.endsWith(CtrlSwingMessages.getMLS("menuToolTipOpenLLL", "\u7ea7\u5c55\u5f00"))) {
            int level = Integer.parseInt(cmd.substring(0, cmd.indexOf(CtrlSwingMessages.getMLS("menuToolTipOpenLLL", "\u7ea7\u5c55\u5f00"))));
            this.tree.expandOnLevel(level);
            if (level < this.maxExpandLevel) {
                this.setShowLevelExpandButton(level + 1);
            }
        }
        this.tree.requestFocus();
    }

    @Override
    public void addLayoutComponent(String name, Component child) {
    }

    @Override
    public void removeLayoutComponent(Component child) {
    }

    @Override
    public Dimension preferredLayoutSize(Container Container2) {
        return new Dimension(240, 500);
    }

    @Override
    public Dimension minimumLayoutSize(Container Container2) {
        return new Dimension(32, 500);
    }

    @Override
    public void layoutContainer(Container container) {
        int h;
        Dimension sbSize = container.getSize();
        Insets insets = container.getInsets();
        int x = 0;
        int y = 0;
        int w = sbSize.width;
        if (this.isShowControlPanel()) {
            this.controlPane.setBounds(x, y, w, 23);
            y += 23;
            h = sbSize.height - insets.bottom - 23;
        } else {
            y = insets.top;
            h = sbSize.height - insets.top - insets.bottom;
        }
        w = sbSize.width - insets.left - insets.right;
        x = insets.left;
        this.treePane.setBounds(x, y, w, h);
    }

    public ControlPanel getControlPane() {
        return this.controlPane;
    }

    public void setShowControlPanel(boolean isShow) {
        this.controlPane.setVisible(isShow);
    }

    public boolean isShowControlPanel() {
        return this.controlPane.isVisible();
    }

    public void setShowFind(boolean showFind) {
        this.findBtn.setVisible(showFind);
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlSwingMessages.getMLS(key, defaultValue);
    }

    private class FindBtnActionListener
    implements ActionListener {
        private FindBtnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDTreeView.this.showFindNextDialog();
        }
    }

    public static class ControlPanel
    extends JPanel
    implements LayoutManager {
        private static final long serialVersionUID = -3343434420985156404L;
        private String title = "";
        private JLabel label = new JLabel();

        public ControlPanel(String title) {
            this.title = title;
            if (!StringUtil.isEmptyString((String)title)) {
                ToolTipManager.sharedInstance().registerComponent(this.label);
                this.label.setToolTipText(title);
                this.label.setText(title);
            }
            this.add(this.label);
        }

        @Override
        public Component add(Component comp) {
            if (comp instanceof KDWorkButton) {
                KDWorkButton kb = (KDWorkButton)comp;
                kb.setFactType(0);
                kb.setBorder(null);
                kb.setContentAreaFilled(false);
                kb.setOpaque(false);
                MouseListener[] listeners = kb.getMouseListeners();
                if (listeners != null) {
                    for (int i = 0; i < listeners.length; ++i) {
                        if (!(listeners[i] instanceof KingdeeToolBarUI.MouseHandler)) continue;
                        kb.removeMouseListener(listeners[i]);
                    }
                }
            }
            return super.add(comp);
        }

        @Override
        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            Dimension size = this.getSize();
            super.paint(g);
            g.drawImage(ControlPanel.getImage("Tree.treeTitlePic"), 1, 1, 10, size.height - 2, null, null);
            g.drawImage(ControlPanel.getImage("Tree.treeTitleBg"), 11, 1, size.width - 12, size.height - 2, null, null);
            g.setColor(UIManager.getColor("Tree.treeTitleColor"));
            g.setFont(KingdeeLookAndFeel.getSystemRenderFont());
            g.setColor(oldColor);
            this.paintChildren(g);
        }

        @Override
        public void addLayoutComponent(String name, Component child) {
        }

        @Override
        public void removeLayoutComponent(Component child) {
        }

        @Override
        public Dimension preferredLayoutSize(Container Container2) {
            return this.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container Container2) {
            return this.preferredLayoutSize(Container2);
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension sbSize = container.getSize();
            Component[] comps = container.getComponents();
            int x = sbSize.width;
            for (int i = comps.length; i > 0; --i) {
                if (comps[i - 1].isVisible()) {
                    comps[i - 1].setBounds(x -= 29, 2, 26, 20);
                }
                if (!(comps[i - 1] instanceof JLabel) || x <= 0) continue;
                comps[i - 1].setBounds(15, 2, x, 20);
            }
        }

        public static Image getImage(Object key) {
            ImageIcon icon = (ImageIcon)UIManager.getIcon(key);
            Image image = icon.getImage();
            if (image == null) {
                SwingLogUtil.info((String)key.toString());
            }
            return image;
        }
    }
}

