/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDComboFunctionChooser;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.cosmic.ctrl.swing.plaf.PaintUtil;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JSeparator;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;

public class LittleArrowButton
extends BasicArrowButton {
    private static final long serialVersionUID = 5688927518483189053L;
    private SelfPopup selfPopup = null;
    private MouseHandler mouseHandler = null;
    private Dimension newPreferredSize = null;

    public LittleArrowButton() {
        this(3);
    }

    public LittleArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
        super(direction, background, shadow, darkShadow, highlight);
        this.init();
    }

    public LittleArrowButton(int direction) {
        super(direction);
        this.init();
    }

    @Override
    public void setBorder(Border border) {
        if (border == null) {
            super.setBorder(null);
        } else if (!(this.getBorder() instanceof KingdeeBorders.WorkButtonBorder)) {
            super.setBorder(KingdeeBorders.getWorkButtonBorder());
        }
    }

    private void init() {
        this.setBorderPainted(true);
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
        this.setBackground(UIManager.getColor("ToolBar.darkShadow"));
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.newPreferredSize != null) {
            return this.newPreferredSize;
        }
        if (this.selfDirection(this.getDirection()) == 0) {
            return new Dimension(16, 31);
        }
        return new Dimension(31, 16);
    }

    @Override
    public void removeNotify() {
        if (this.selfPopup != null) {
            this.selfPopup.hideAssistPopup();
        }
        super.removeNotify();
    }

    @Override
    public void setPreferredSize(Dimension newDim) {
        this.newPreferredSize = newDim;
    }

    @Override
    public void setDirection(int dir) {
        this.direction = dir;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    private int selfDirection(int direct) {
        int tempD = 0;
        if (direct == 1 || direct == 5 || direct == 1) {
            tempD = 1;
        }
        return tempD;
    }

    @Override
    public void paint(Graphics g) {
        ButtonModel m = this.getModel();
        boolean isArmed = m.isArmed();
        boolean isRollver = m.isRollover();
        boolean isPressed = m.isPressed();
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color origColor = g.getColor();
        boolean isEnabled = this.isEnabled();
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        Rectangle rect = this.getBounds();
        Container parent = this.getParent();
        if (parent instanceof KDToolBar) {
            KDToolBar toolbar = (KDToolBar)parent;
            if (toolbar.getOrientation() == 0) {
                if (UIManager.getInt("ToolBar.shadowOrientation") == 1) {
                    if (isRollver && !isArmed && !isPressed) {
                        g2d.setColor(UIManager.getColor("WorkButton.rolloverBackground"));
                    } else if (isPressed) {
                        g2d.setColor(UIManager.getColor("WorkButton.activeBackground"));
                    } else {
                        g2d.setColor(UIManager.getColor("ToolBar.fifthsShadowColor"));
                    }
                    g.drawLine(2, h / 2 - 10, w - 3, h / 2 - 10);
                    g.drawLine(2, h / 2 + 9, w - 3, h / 2 + 9);
                    g.drawLine(1, h / 2 - 9, 1, h / 2 + 8);
                    g.drawLine(w - 2, h / 2 - 9, w - 2, h / 2 + 8);
                    g.fillRect(2, h / 2 - 9, w - 4, 18);
                } else if (UIManager.getInt("ToolBar.shadowOrientation") == 2) {
                    int perHeight = h / 4;
                    float x0 = 0.0f;
                    float y0 = 1.0f;
                    float x1 = 0.0f;
                    float y1 = y0 + (float)perHeight;
                    float x2 = 0.0f;
                    float y2 = y1 + (float)perHeight;
                    float x3 = 0.0f;
                    float y3 = y2 + (float)perHeight;
                    float x4 = 0.0f;
                    float y4 = y3 + (float)perHeight;
                    g2d.setColor(UIManager.getColor("ToolBar.topColor"));
                    g2d.fillRect(0, 0, this.getWidth(), 1);
                    GradientPaint gradient = new GradientPaint(x0, y0, UIManager.getColor("ToolBar.firstShadowColor"), x1, y1, UIManager.getColor("ToolBar.secondShadowColor"));
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x0, (int)y0, rect.width, perHeight);
                    gradient = new GradientPaint(x1, y1, UIManager.getColor("ToolBar.secondShadowColor"), x2, y2, UIManager.getColor("ToolBar.thirdShadowColor"));
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x1, (int)y1, rect.width, perHeight);
                    gradient = new GradientPaint(x2, y2, UIManager.getColor("ToolBar.thirdShadowColor"), x3, y3, UIManager.getColor("ToolBar.fourthShadowColor"));
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x2, (int)y2, rect.width, perHeight);
                    gradient = new GradientPaint(x3, y3, UIManager.getColor("ToolBar.fourthShadowColor"), x4, y4, UIManager.getColor("ToolBar.fifthsShadowColor"));
                    g2d.setPaint(gradient);
                    g2d.fillRect((int)x3, (int)y3, rect.width, h - (int)y3);
                }
            } else if (toolbar.getOrientation() == 1) {
                // empty if block
            }
        }
        g2d.setPaint(oldPaint);
        if (h < 5 || w < 5) {
            g.setColor(origColor);
            return;
        }
        if (isPressed) {
            g.translate(1, 1);
        }
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2);
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
        if (isPressed) {
            g.translate(-1, -1);
        }
        g.setColor(origColor);
        this.paintBorder(g);
    }

    @Override
    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        g.drawImage(((ImageIcon)UIManager.getIcon("ToolBar.littleArrowButtonHoriIcon")).getImage(), 0, 5, this);
    }

    public void addSelfComponent(JComponent comp) {
        this.getSelfPopup().addSelfComponent(comp);
    }

    public JComponent getSelfComponent(int index) {
        return this.getSelfPopup().getSelfComponent(index);
    }

    public int getSelfComponentCount() {
        return this.getSelfPopup().getSelfPopup().getComponentCount();
    }

    public Component[] getSelfComponents() {
        return this.getSelfPopup().getSelfComponents();
    }

    public Container getSelfContainer() {
        return this.getSelfPopup().getSelfPopup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelfPopup getSelfPopup() {
        if (this.selfPopup == null) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.selfPopup = new DefaultSelfPopup();
            }
        }
        return this.selfPopup;
    }

    private void pressedButton(MouseEvent me) {
        if (this.isEnabled() && this.getSelfComponentCount() > 0) {
            Point p = this.getLocationOnScreen();
            if (p == null) {
                p = new Point(me.getX(), me.getY());
            } else {
                p.y += this.getHeight();
            }
            this.getSelfPopup().showAssistPopup(this, p.x, p.y);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            LittleArrowButton.this.pressedButton(e);
        }
    }

    private static class DefaultSelfPopup
    implements SelfPopup {
        JDialog selfDialog = null;
        KDPanel selfPane = null;

        @Override
        public void showAssistPopup(int x, int y) {
            if (this.getSelfDialog(null) == null) {
                return;
            }
            this.getSelfDialog(null).setLocation(x, y);
            this.getSelfDialog(null).show();
        }

        @Override
        public void showAssistPopup(Component comp, int x, int y) {
            JDialog dialog = this.getSelfDialog(comp);
            if (dialog == null) {
                return;
            }
            dialog.pack();
            CtrlSwingUtilities.locateWindowToComponent(this.getSelfDialog(comp), null, comp, 3);
            dialog.show();
        }

        @Override
        public void hideAssistPopup() {
            if (this.selfDialog == null) {
                return;
            }
            this.selfDialog.hide();
            this.selfDialog.dispose();
        }

        @Override
        public void addSelfComponent(JComponent newVal) {
            if (newVal != null) {
                Component[] comps = this.getSelfPopup().getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    LittleArrowButtonItem labi = (LittleArrowButtonItem)comps[i];
                    if (newVal != labi.getWrappedComponent()) continue;
                    this.getSelfPane().remove(labi);
                }
                this.getSelfPane().add(new LittleArrowButtonItem(newVal));
            }
        }

        @Override
        public JComponent getSelfComponent(int index) {
            int count = this.getSelfPopup().getComponentCount();
            if (count <= 0) {
                return null;
            }
            index = index >= count ? 0 : index;
            index = index < 0 ? 0 : index;
            Component comp = this.getSelfPopup().getComponent(index);
            if (comp instanceof LittleArrowButtonItem) {
                return ((LittleArrowButtonItem)comp).getWrappedComponent();
            }
            return null;
        }

        @Override
        public Component[] getSelfComponents() {
            Component[] comps = this.getSelfPopup().getComponents();
            Component[] retComps = new Component[comps.length];
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] == null) continue;
                retComps[i] = ((LittleArrowButtonItem)comps[i]).getWrappedComponent();
            }
            return retComps;
        }

        @Override
        public Container getSelfPopup() {
            return this.getSelfPane();
        }

        private KDPanel getSelfPane() {
            if (this.selfPane == null) {
                this.selfPane = new KDPanel();
                this.selfPane.setBorder(BorderFactory.createLineBorder(UIManager.getColor("PopupMenu.borderLineColor")));
                this.selfPane.setLayout(new BoxLayout(this.selfPane, 3));
            }
            return this.selfPane;
        }

        private JDialog getSelfDialog(Component c) {
            if (c == null) {
                return null;
            }
            if (this.selfDialog == null) {
                Window w = SwingUtilities.getWindowAncestor(c);
                if (w instanceof Dialog) {
                    this.selfDialog = new JDialog((Dialog)w);
                } else if (w instanceof Frame) {
                    this.selfDialog = new JDialog((Frame)w);
                }
                if (this.selfDialog != null) {
                    this.selfDialog.setName("TOOLBAR_LAB_POPUP");
                    this.selfDialog.setUndecorated(true);
                    this.selfDialog.setContentPane(this.getSelfPane());
                    this.selfDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowDeactivated(WindowEvent we) {
                            if (selfDialog != null) {
                                Component[] comps = this.getSelfPopup().getComponents();
                                for (int i = 0; i < comps.length; ++i) {
                                    if (comps[i] instanceof KDComboFunctionChooser) {
                                        ((KDComboFunctionChooser)comps[i]).setPopupVisible(false);
                                        continue;
                                    }
                                    if (!(comps[i] instanceof KDComboColor)) continue;
                                    ((KDComboColor)comps[i]).setPopupVisible(false);
                                }
                                selfDialog.hide();
                                selfDialog.dispose();
                                selfDialog = null;
                            }
                        }
                    });
                }
            }
            return this.selfDialog;
        }

        private static class LittleArrowButtonItem
        extends KDPanel {
            private static final int BG_INIT = 0;
            private static final int BG_ROLLVER = 1;
            private static final int BG_DISABLE = 2;
            private static int leftAreaWidth = 22;
            private static int menuWidth = 200;
            private static int menuHeight = 20;
            protected static Icon initArrowIcon;
            protected static Icon selectedArrowIcon;
            protected static Icon disabledArrowIcon;
            private JComponent wrappedComp;
            private boolean isMouseOver;
            private boolean selfRender = true;
            private MouseListener littleArrowButtonItemMouseListener;

            public LittleArrowButtonItem(JComponent wrappedComp) {
                this.wrappedComp = wrappedComp;
                this.littleArrowButtonItemMouseListener = new LittleArrowButtonItemMouseListener();
                this.addMouseListener(this.littleArrowButtonItemMouseListener);
                this.layoutComponents();
            }

            private void layoutComponents() {
                this.setLayout(null);
                this.add(this.wrappedComp);
                this.wrappedComp.setBounds(300, 0, 0, 0);
                if (!(this.wrappedComp instanceof JButton) && !(this.wrappedComp instanceof JSeparator)) {
                    this.selfRender = false;
                    Dimension preferredSize = this.wrappedComp.getPreferredSize();
                    this.wrappedComp.setBounds(28, 0, preferredSize.width, preferredSize.height);
                }
            }

            @Override
            public boolean isVisible() {
                return this.wrappedComp.isVisible();
            }

            @Override
            public Dimension getPreferredSize() {
                if (this.wrappedComp instanceof JSeparator) {
                    return new Dimension(menuWidth, 4);
                }
                return new Dimension(menuWidth, menuHeight);
            }

            public JComponent getWrappedComponent() {
                return this.wrappedComp;
            }

            @Override
            protected void paintComponent(Graphics g) {
                this.paintBackground(g);
                this.paintSelfComponent(g);
            }

            protected void paintSelfComponent(Graphics g) {
                if (this.wrappedComp instanceof JSeparator) {
                    g.setColor(UIManager.getColor("MenuItem.separatorShadow"));
                    g.drawLine(leftAreaWidth + 2, 2, menuWidth, 2);
                    g.setColor(UIManager.getColor("MenuItem.separatorDarkShadow"));
                    g.drawLine(leftAreaWidth + 2, 3, menuWidth, 3);
                    return;
                }
                if (this.selfRender) {
                    KDWorkButton btn = (KDWorkButton)this.wrappedComp;
                    if (this.wrappedComp.isEnabled()) {
                        Icon icon = btn.getIconAnyWay();
                        String text = btn.getTextAnyWay();
                        if (this.isMouseOver) {
                            g.setColor(UIManager.getColor("MenuItem.selectionForeground"));
                            if (icon != null) {
                                icon.paintIcon(this, g, 2, 2);
                            }
                            if (text != null) {
                                g.drawString(text, 30, 14);
                            }
                        } else {
                            g.setColor(UIManager.getColor("MenuItem.foreground"));
                            if (icon != null) {
                                icon.paintIcon(this, g, 2, 2);
                            }
                            if (text != null) {
                                g.drawString(text, 30, 14);
                            }
                        }
                    } else {
                        g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                        Icon icon = btn.getDisabledIconAnyWay();
                        String text = btn.getTextAnyWay();
                        if (icon != null) {
                            icon.paintIcon(this, g, 2, 2);
                        }
                        if (text != null) {
                            g.drawString(text, 30, 14);
                        }
                    }
                }
            }

            protected void paintBackground(Graphics g) {
                Color oldColor = g.getColor();
                if (this.wrappedComp.isEnabled()) {
                    if (this.isMouseOver) {
                        g.setColor(UIManager.getColor("MenuItem.selectionBackground"));
                        g.fillRect(leftAreaWidth, 0, menuWidth, menuHeight);
                        this.paintLeftBackground(g, 1);
                        this.paintMiddleSeparator(g, 1);
                        if (this.wrappedComp instanceof KDWorkButton && ((KDWorkButton)this.wrappedComp).isAssitButton()) {
                            selectedArrowIcon.paintIcon(this, g, 184, 2);
                        }
                    } else {
                        g.setColor(UIManager.getColor("MenuItem.background"));
                        g.fillRect(leftAreaWidth, 0, menuWidth, menuHeight);
                        this.paintLeftBackground(g, 0);
                        this.paintMiddleSeparator(g, 0);
                        if (this.wrappedComp instanceof KDWorkButton && ((KDWorkButton)this.wrappedComp).isAssitButton()) {
                            initArrowIcon.paintIcon(this, g, 184, 2);
                        }
                    }
                } else {
                    g.setColor(UIManager.getColor("MenuItem.disabledBackground"));
                    g.fillRect(leftAreaWidth, 0, menuWidth, menuHeight);
                    this.paintLeftBackground(g, 2);
                    this.paintMiddleSeparator(g, 2);
                    if (this.wrappedComp instanceof KDWorkButton && ((KDWorkButton)this.wrappedComp).isAssitButton()) {
                        disabledArrowIcon.paintIcon(this, g, 184, 2);
                    }
                }
                g.setColor(oldColor);
            }

            protected void paintLeftBackground(Graphics g, int state) {
                Rectangle rect = new Rectangle(0, 0, leftAreaWidth, menuHeight);
                switch (state) {
                    case 1: {
                        PaintUtil.drawShadow(g, 1.0f, 1.0f, UIManager.getColor("MenuItem.leftRollBgShadow"), leftAreaWidth, 1.0f, UIManager.getColor("MenuItem.leftRollBgDarkShadow"), rect, 0);
                        break;
                    }
                    case 2: {
                        PaintUtil.drawShadow(g, 1.0f, 1.0f, UIManager.getColor("MenuItem.leftDisableShadow"), leftAreaWidth, 1.0f, UIManager.getColor("MenuItem.leftDisableDarkShadow"), rect, 0);
                        break;
                    }
                    default: {
                        PaintUtil.drawShadow(g, 1.0f, 1.0f, UIManager.getColor("MenuItem.leftBgShadow"), leftAreaWidth, 1.0f, UIManager.getColor("MenuItem.leftBgDarkShadow"), rect, 0);
                    }
                }
            }

            protected void paintMiddleSeparator(Graphics g, int state) {
                int h = menuHeight;
                switch (state) {
                    case 1: {
                        g.setColor(UIManager.getColor("MenuItem.separatorRollShadow"));
                        g.drawLine(leftAreaWidth, 0, leftAreaWidth, h);
                        g.setColor(UIManager.getColor("MenuItem.separatorRollDarkShadow"));
                        g.drawLine(leftAreaWidth + 1, 0, leftAreaWidth + 1, h);
                        break;
                    }
                    case 2: {
                        g.setColor(UIManager.getColor("MenuItem.separatorDisableShadow"));
                        g.drawLine(leftAreaWidth, 0, leftAreaWidth, h);
                        g.setColor(UIManager.getColor("MenuItem.separatorDisableDarkShadow"));
                        g.drawLine(leftAreaWidth + 1, 0, leftAreaWidth + 1, h);
                        break;
                    }
                    default: {
                        g.setColor(UIManager.getColor("MenuItem.separatorShadow"));
                        g.drawLine(leftAreaWidth, 0, leftAreaWidth, h);
                        g.setColor(UIManager.getColor("MenuItem.separatorDarkShadow"));
                        g.drawLine(leftAreaWidth + 1, 0, leftAreaWidth + 1, h);
                    }
                }
            }

            static {
                leftAreaWidth = (Integer)UIManager.get("MenuItem.leftAreaWidth") + 3;
                initArrowIcon = new ImageIcon(KDResourceManager.getImage("toolbar_group_arrowhead3.gif"));
                selectedArrowIcon = new ImageIcon(KDResourceManager.getImage("toolbar_group_arrowhead1.gif"));
                disabledArrowIcon = new ImageIcon(KDResourceManager.getImage("toolbar_group_arrowhead2.gif"));
            }

            private class LittleArrowButtonItemMouseListener
            extends MouseAdapter {
                private LittleArrowButtonItemMouseListener() {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!(LittleArrowButtonItem.this.wrappedComp instanceof JSeparator)) {
                        LittleArrowButtonItem.this.isMouseOver = true;
                        LittleArrowButtonItem.this.repaint();
                    }
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    if (LittleArrowButtonItem.this.wrappedComp instanceof KDWorkButton && ((KDWorkButton)LittleArrowButtonItem.this.wrappedComp).isAssitButton()) {
                        if (!((KDWorkButton)LittleArrowButtonItem.this.wrappedComp).isEnabled()) {
                            return;
                        }
                        KDPopupMenu pm = ((KDWorkButton)LittleArrowButtonItem.this.wrappedComp).getAssistPopup();
                        pm.setInvoker(LittleArrowButtonItem.this.wrappedComp);
                        Point p = LittleArrowButtonItem.this.getLocationOnScreen();
                        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                        if ((double)(p.x + LittleArrowButtonItem.this.getWidth()) + pm.getPreferredSize().getWidth() <= (double)d.width) {
                            pm.setLocation(p.x + LittleArrowButtonItem.this.getWidth(), p.y);
                        } else {
                            pm.setLocation(p.x - (int)pm.getPreferredSize().getWidth(), p.y);
                        }
                        pm.setVisible(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!(LittleArrowButtonItem.this.wrappedComp instanceof JSeparator)) {
                        LittleArrowButtonItem.this.isMouseOver = false;
                        LittleArrowButtonItem.this.repaint();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (LittleArrowButtonItem.this.wrappedComp instanceof JButton) {
                        SwingUtilities.getWindowAncestor(LittleArrowButtonItem.this).hide();
                        ((JButton)LittleArrowButtonItem.this.wrappedComp).doClick();
                    }
                }
            }
        }
    }

    static interface SelfPopup {
        public void showAssistPopup(int var1, int var2);

        public void showAssistPopup(Component var1, int var2, int var3);

        public void hideAssistPopup();

        public void addSelfComponent(JComponent var1);

        public JComponent getSelfComponent(int var1);

        public Component[] getSelfComponents();

        public Container getSelfPopup();
    }
}

