/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.CtrlPlainDocument;
import com.kingdee.cosmic.ctrl.swing.KDBusiMaskField;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.Document;
import javax.swing.text.MaskFormatter;

public class MaskFormatterEx
extends MaskFormatter {
    private static final long serialVersionUID = -8922844726384493148L;

    public MaskFormatterEx() {
    }

    public MaskFormatterEx(String mask) throws ParseException {
        super(mask);
    }

    @Override
    public Object stringToValue(String value) throws ParseException {
        String pMask = this.getBusiMask();
        if (pMask != null) {
            if (this.getBusiMaskPosition() == 4) {
                return value + pMask;
            }
            return pMask + value;
        }
        return value;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        String pStr = null;
        if (value == null) {
            return "";
        }
        pStr = value.toString();
        if (this.getFormattedTextField().isFocusOwner()) {
            String pMask = this.getBusiMask();
            String string = pMask = pMask != null ? pMask : "";
            if (pMask.length() > 0) {
                if (this.getBusiMaskPosition() == 2) {
                    pStr = pStr.substring(pMask.length());
                } else {
                    int pStrLen = pStr.length();
                    pStr = pStr.substring(0, pStrLen - pMask.length());
                }
            }
        }
        return pStr;
    }

    private String getBusiMask() {
        JFormattedTextField tf = this.getFormattedTextField();
        if (tf instanceof KDBusiMaskField) {
            return ((KDBusiMaskField)tf).getMask();
        }
        return null;
    }

    private int getBusiMaskPosition() {
        JFormattedTextField tf = this.getFormattedTextField();
        if (tf instanceof KDBusiMaskField) {
            return ((KDBusiMaskField)tf).getMaskPosition();
        }
        return 4;
    }

    @Override
    public void install(JFormattedTextField ftf) {
        Document document;
        if (ftf.hasFocus() && (document = ftf.getDocument()) instanceof CtrlPlainDocument) {
            ((CtrlPlainDocument)document).setFocusing(true);
        }
        super.install(ftf);
    }
}

