/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.dial;

import com.kingdee.cosmic.ctrl.swing.dial.BasicDial;
import com.kingdee.cosmic.ctrl.swing.dial.DialLegend;
import com.kingdee.cosmic.ctrl.swing.dial.DialScale;
import com.kingdee.cosmic.ctrl.swing.dial.DialTitle;
import com.kingdee.cosmic.ctrl.swing.dial.KpiNeedle;
import com.kingdee.cosmic.ctrl.swing.dial.KpiPan;
import com.kingdee.cosmic.ctrl.swing.dial.KpiScale;
import com.kingdee.cosmic.ctrl.swing.dial.KpiTitle;
import com.kingdee.cosmic.ctrl.swing.dial.Legend;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.text.Format;

public class KpiDial
extends BasicDial {
    private static final long serialVersionUID = 7546422832436502969L;
    protected static final double TOTAL_HEIGHT = 0.5707964601769911;
    protected static final double TOPTTL_HEIGHT = 0.14728682170542637;
    protected static final double PAN_HEIGHT = 0.6589147286821705;
    protected static final double BOTTOMTTL_HEIGHT = 0.1937984496124031;

    public Legend createKpiLegend(String normal, String warning, String critical, int orient) {
        Legend legend = null;
        DialScale scl = this.getScale(0);
        if (scl instanceof KpiScale) {
            KpiScale kpiscl = (KpiScale)scl;
            legend = DialLegend.createInstance(kpiscl.getNormalPaint(), normal, kpiscl.getWarningPaint(), warning, kpiscl.getCriticalPaint(), critical, orient);
        }
        return legend;
    }

    @Override
    protected void drawTitle(Graphics2D g2) {
        super.drawTitle(g2);
        KpiTitle ttl = this.getKpiTitle();
        Rectangle ttlR = ttl.getRect();
        g2.setPaint(ttl.getOutlinePaint());
        g2.drawLine(ttlR.x, ttlR.y + ttlR.height - 1, ttlR.x + ttlR.width - 1, ttlR.y + ttlR.height - 1);
        g2.drawLine(ttlR.x, ttlR.y + ttlR.height * 2 / 3, ttlR.x, ttlR.y + ttlR.height - 1);
        g2.drawLine(ttlR.x + ttlR.width - 1, ttlR.y + ttlR.height * 2 / 3, ttlR.x + ttlR.width - 1, ttlR.y + ttlR.height - 1);
    }

    @Override
    protected String generateToolTip() {
        DialScale scl = this.getScale(0);
        Format ft = null;
        Object val = null;
        String tip = "";
        if (scl != null) {
            ft = scl.getTickLabelFormat();
        }
        if (ft != null) {
            val = this.getValue();
        }
        if (val != null) {
            tip = ft.format(val);
        }
        return tip;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, width, height);
        }
        Insets ins = this.getInsets();
        Rectangle area = new Rectangle(ins.top, ins.left, width -= ins.left + ins.right, height -= ins.top + ins.bottom);
        Rectangle topTtlR = new Rectangle();
        Rectangle panR = new Rectangle();
        Rectangle bottomTtlR = new Rectangle();
        this.calcElementRect(area, topTtlR, panR, bottomTtlR);
        DialTitle unitTitle = this.getUnitTitle();
        unitTitle.setRect(topTtlR);
        if (this.pan != null) {
            this.pan.draw(g, panR, this);
        }
        if (this.scales != null) {
            for (i = 0; i < this.scales.size(); ++i) {
                BasicDial.ScaleItem si = (BasicDial.ScaleItem)this.scales.get(i);
                si.scale.draw(g, panR, this);
            }
        }
        if (this.indicators != null) {
            for (i = 0; i < this.indicators.size(); ++i) {
                BasicDial.IndicatorItem ii = (BasicDial.IndicatorItem)this.indicators.get(i);
                ii.indicator.draw(g, area, this);
            }
        }
        if (this.needles != null) {
            for (i = 0; i < this.needles.size(); ++i) {
                BasicDial.NeedleItem ni = (BasicDial.NeedleItem)this.needles.get(i);
                ni.needle.draw(g, panR, this);
            }
        }
        DialTitle ttl = this.getTitle();
        ttl.setRect(bottomTtlR);
        this.setToolTipText(this.generateToolTip());
    }

    private void calcElementRect(Rectangle area, Rectangle topTtlR, Rectangle panR, Rectangle bottomTtlR) {
        int width = area.width;
        int height = (int)((double)width * 0.5707964601769911);
        if (height > area.height) {
            height = area.height;
            width = (int)((double)height / 0.5707964601769911);
        }
        int x = area.x + (area.width - width) / 2;
        int y = area.y + (area.height - height) / 2;
        topTtlR.x = x;
        topTtlR.y = y + 8;
        topTtlR.width = width - 8;
        topTtlR.height = 12;
        panR.x = x;
        panR.y = topTtlR.y + topTtlR.height;
        panR.height = (int)((double)height * 0.6589147286821705);
        panR.width = width;
        bottomTtlR.x = x;
        bottomTtlR.y = panR.y + panR.height + 4;
        bottomTtlR.width = width;
        bottomTtlR.height = 12;
        area.x = x;
        area.y = y;
        area.height = topTtlR.height + panR.height + 4 + bottomTtlR.height + 16;
        area.width = width;
    }

    public KpiScale getScale() {
        return (KpiScale)this.getScale(0);
    }

    public KpiNeedle getNeedle() {
        return (KpiNeedle)super.getNeedle(0);
    }

    public void clear() {
        this.setValue(null);
        this.getScale().setTotalRange(null);
        this.getScale().setNormalRange(null);
        this.getScale().setWarningRange(null);
        this.getScale().setCriticalRange(null);
        this.repaint();
    }

    public KpiTitle getKpiTitle() {
        return (KpiTitle)super.getTitle();
    }

    public KpiPan getKpiPan() {
        return (KpiPan)super.getPan();
    }
}

