/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.palette;

import com.kingdee.cosmic.ctrl.swing.palette.PaletteFrame;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class PaletteThread
extends Thread {
    private static final int NOOP = 0;
    private static final int HUE = 1;
    private static final int SATURATION = 2;
    private static final int BRIGHTNESS = 3;
    private PaletteFrame.ImageCanvas canvas;
    private BufferedImage image;
    private int deltaHue;
    private int deltaSaturation;
    private int deltaBrightness;
    private int changingBand = 0;
    private boolean isIdle = true;
    private boolean isHalted;
    private boolean hereComesAnotherChallenger;
    private static float[][] originalHsbDataCache;
    private static float[][] lookupHsbDataCache;
    private int[] passingPhaseCache;
    private Rectangle skipArea1 = new Rectangle(6, 29, 50, 17);
    private Rectangle skipArea2 = new Rectangle(116, 55, 247, 12);
    private Rectangle skipArea3 = new Rectangle(385, 55, 177, 12);

    public PaletteThread(PaletteFrame.ImageCanvas canvas) {
        this.canvas = canvas;
        this.setName("PaletteThread");
    }

    public void stopGentlly() {
        this.isHalted = true;
        this.isIdle = false;
        this.changingBand = 0;
    }

    @Override
    public void run() {
        block7: while (!this.isHalted) {
            while (this.isIdle) {
                try {
                    PaletteThread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.image == null) {
                this.isIdle = true;
                continue;
            }
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            int brokenStreets = width % 20;
            int blockCount = brokenStreets == 0 ? width / 20 : width / 20 + 1;
            float blockCountFloat = (float)(width / 20) + (float)brokenStreets / 20.0f;
            this.canvas.setBlockCount(blockCountFloat);
            int blockNo = 0;
            if (this.passingPhaseCache == null || this.passingPhaseCache.length != 20 * height) {
                this.passingPhaseCache = null;
                this.passingPhaseCache = new int[20 * height];
            }
            float hueUnitSpeedUp = 0.0027777778f;
            block9: for (int i = 0; i < width; ++i) {
                block10: for (int j = 0; j < height; ++j) {
                    if (this.hereComesAnotherChallenger) {
                        i = -1;
                        j = 0;
                        blockNo = 0;
                        this.hereComesAnotherChallenger = false;
                        continue block9;
                    }
                    switch (this.changingBand) {
                        case 1: {
                            float newHue;
                            int addressSpeedUp = i * 3;
                            float temp = originalHsbDataCache[j][addressSpeedUp];
                            PaletteThread.lookupHsbDataCache[j][i * 3] = newHue = temp + hueUnitSpeedUp * (float)this.deltaHue;
                            int rgb = this.image.getRGB(i, j);
                            if (!this.isSkippable(i, j)) {
                                rgb = Color.HSBtoRGB(newHue, lookupHsbDataCache[j][addressSpeedUp + 1], lookupHsbDataCache[j][addressSpeedUp + 2]);
                            }
                            if (blockNo != blockCount - 1 || brokenStreets == 0) {
                                this.passingPhaseCache[j * 20 + i % 20] = rgb;
                                continue block10;
                            }
                            this.passingPhaseCache[j * brokenStreets + i % 20] = rgb;
                            continue block10;
                        }
                        case 2: {
                            int addressSpeedUp = i * 3;
                            float temp = originalHsbDataCache[j][addressSpeedUp + 1];
                            float newSaturation = temp + (this.deltaSaturation < 0 ? temp / 100.0f * (float)this.deltaSaturation : (1.0f - temp) / 100.0f * (float)this.deltaSaturation);
                            if (newSaturation > 1.0f) {
                                newSaturation = 1.0f;
                            }
                            if (newSaturation < 0.0f) {
                                newSaturation = 0.0f;
                            }
                            PaletteThread.lookupHsbDataCache[j][addressSpeedUp + 1] = newSaturation;
                            int rgb = this.image.getRGB(i, j);
                            if (!this.isSkippable(i, j)) {
                                rgb = Color.HSBtoRGB(lookupHsbDataCache[j][addressSpeedUp], newSaturation, lookupHsbDataCache[j][addressSpeedUp + 2]);
                            }
                            if (blockNo != blockCount - 1 || brokenStreets == 0) {
                                this.passingPhaseCache[j * 20 + i % 20] = rgb;
                                continue block10;
                            }
                            this.passingPhaseCache[j * brokenStreets + i % 20] = rgb;
                            continue block10;
                        }
                        case 3: {
                            int addressSpeedUp = i * 3;
                            float temp = originalHsbDataCache[j][addressSpeedUp + 2];
                            float newBrightness = temp + (this.deltaBrightness < 0 ? temp / 100.0f * (float)this.deltaBrightness : (1.0f - temp) / 100.0f * (float)this.deltaBrightness);
                            if (newBrightness > 1.0f) {
                                newBrightness = 1.0f;
                            }
                            if (newBrightness < 0.0f) {
                                newBrightness = 0.0f;
                            }
                            PaletteThread.lookupHsbDataCache[j][addressSpeedUp + 2] = newBrightness;
                            int rgb = this.image.getRGB(i, j);
                            if (!this.isSkippable(i, j)) {
                                rgb = Color.HSBtoRGB(lookupHsbDataCache[j][addressSpeedUp], lookupHsbDataCache[j][addressSpeedUp + 1], newBrightness);
                            }
                            if (blockNo != blockCount - 1 || brokenStreets == 0) {
                                this.passingPhaseCache[j * 20 + i % 20] = rgb;
                                continue block10;
                            }
                            this.passingPhaseCache[j * brokenStreets + i % 20] = rgb;
                            continue block10;
                        }
                        default: {
                            this.isIdle = true;
                            continue block7;
                        }
                    }
                }
                if (i % 20 == 19) {
                    this.image.setRGB(i - 19, 0, 20, height, this.passingPhaseCache, 0, 20);
                    this.canvas.paintBlockNo(blockNo);
                    ++blockNo;
                    continue;
                }
                if (i != width - 1) continue;
                this.image.setRGB(i - brokenStreets + 1, 0, brokenStreets, height, this.passingPhaseCache, 0, brokenStreets);
                this.canvas.paintBlockNo(blockNo);
            }
            this.canvas.repaint();
            this.isIdle = true;
        }
    }

    public void setImage(BufferedImage image, boolean clearData) {
        this.changingBand = 0;
        this.image = image;
        if (clearData) {
            this.refreshHsbImageDataCache(image);
        }
    }

    private boolean isSkippable(int x, int y) {
        return this.skipArea1.contains(x, y) || this.skipArea2.contains(x, y) || this.skipArea3.contains(x, y) || this.image.getRGB(x, y) >>> 24 == 0;
    }

    private void refreshHsbImageDataCache(BufferedImage image) {
        int i;
        int width = image.getWidth();
        int height = image.getHeight();
        float[] hsbBands = new float[3];
        if (originalHsbDataCache == null || originalHsbDataCache.length != height || originalHsbDataCache[1].length != width * 3) {
            originalHsbDataCache = null;
            lookupHsbDataCache = null;
            originalHsbDataCache = new float[height][width * 3];
            lookupHsbDataCache = new float[height][width * 3];
        }
        for (i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int argb = image.getRGB(j, i);
                int red = (argb & 0xFF0000) >>> 16;
                int green = (argb & 0xFF00) >>> 8;
                int blue = argb & 0xFF;
                Color.RGBtoHSB(red, green, blue, hsbBands);
                int addressSpeedUp = j * 3;
                PaletteThread.originalHsbDataCache[i][addressSpeedUp] = hsbBands[0];
                PaletteThread.originalHsbDataCache[i][addressSpeedUp + 1] = hsbBands[1];
                PaletteThread.originalHsbDataCache[i][addressSpeedUp + 2] = hsbBands[2];
            }
        }
        for (i = 0; i < height; ++i) {
            System.arraycopy(originalHsbDataCache[i], 0, lookupHsbDataCache[i], 0, width * 3);
        }
    }

    public void setDeltaHue(int deltaHue) {
        if (this.changingBand == 1) {
            this.deltaHue = deltaHue;
            this.hereComesAnotherChallenger = true;
            if (this.isIdle) {
                this.isIdle = false;
            }
        } else {
            if (this.isIdle) {
                this.changingBand = 1;
            } else {
                while (!this.isIdle) {
                    try {
                        PaletteThread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.changingBand = 1;
            }
            this.deltaHue = deltaHue;
            this.isIdle = false;
        }
    }

    public void setDeltaSaturation(int deltaSaturation) {
        if (this.changingBand == 2) {
            this.deltaSaturation = deltaSaturation;
            this.hereComesAnotherChallenger = true;
            if (this.isIdle) {
                this.isIdle = false;
            }
        } else {
            if (this.isIdle) {
                this.changingBand = 2;
            } else {
                while (!this.isIdle) {
                    try {
                        PaletteThread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.changingBand = 2;
            }
            this.deltaSaturation = deltaSaturation;
            this.isIdle = false;
        }
    }

    public void setDeltaBrightness(int deltaBrightness) {
        if (this.changingBand == 3) {
            this.deltaBrightness = deltaBrightness;
            this.hereComesAnotherChallenger = true;
            if (this.isIdle) {
                this.isIdle = false;
            }
        } else {
            if (this.isIdle) {
                this.changingBand = 3;
            } else {
                while (!this.isIdle) {
                    try {
                        PaletteThread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.changingBand = 3;
            }
            this.deltaBrightness = deltaBrightness;
            this.isIdle = false;
        }
        this.deltaBrightness = deltaBrightness;
    }
}

