/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.KDDatePicker;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeButtonStates;
import com.kingdee.cosmic.ctrl.swing.plaf.PlafUtilies;
import com.kingdee.cosmic.ctrl.swing.plaf.Tile;
import com.kingdee.cosmic.ctrl.swing.plaf.lfm.BasicLFM;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenu;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class KingdeeBorders {
    private static final Logger logger = LogUtil.getPackageLogger(KingdeeBorders.class);
    private static EditorBorder editorBorder = null;
    private static RomanticButtonBorder romanticBorder = null;
    private static F7ButtonBorder f7ButtonBorder = null;
    private static WorkButtonBorder toolBarWorkBuBorder = null;
    private static WorkButtonBorder contentWorkBuBorder = null;
    private static CommonEditorBorder comEditorBorder = null;
    private static KDMenuBorder menuBorder = null;
    private static WideEditorBorder wideEditorBorder = null;
    private static LabelContainerButtonBorder labelContainerButtonBorder = null;
    private static ToggleButtonBorder toolbarToggleButtonBorder = null;
    private static ToggleButtonBorder contentToggleButtonBorder = null;
    private static ShadowBorder shadowBorder = null;

    public static Border createBevelBorder(boolean isRaised, Color darkShadow, Color lightShadow) {
        return new BevelBorder(isRaised, darkShadow, lightShadow);
    }

    public static Border createEditorBorder() {
        if (editorBorder == null) {
            editorBorder = new EditorBorder();
        }
        return editorBorder;
    }

    public static Border createWideEditorBorder() {
        if (wideEditorBorder == null) {
            wideEditorBorder = new WideEditorBorder();
        }
        return wideEditorBorder;
    }

    public static Border createRomanticButtonBorder() {
        if (romanticBorder == null) {
            romanticBorder = new RomanticButtonBorder();
        }
        return romanticBorder;
    }

    public static Border createF7ButtonBorder() {
        if (f7ButtonBorder == null) {
            f7ButtonBorder = new F7ButtonBorder();
        }
        return f7ButtonBorder;
    }

    public static Border createLabelContainerButtonBorder() {
        if (labelContainerButtonBorder == null) {
            labelContainerButtonBorder = new LabelContainerButtonBorder();
        }
        return labelContainerButtonBorder;
    }

    public static Border getToolBarBorder() {
        Color botB;
        Color botA;
        Color topB;
        Color topA = UIManager.getColor("ToolBar.BorderTopColorA");
        if (topA == null) {
            topA = Color.decode("#B668DB");
        }
        if ((topB = UIManager.getColor("ToolBar.BorderTopColorB")) == null) {
            topB = Color.decode("#E9F0F6");
        }
        if ((botA = UIManager.getColor("ToolBar.BorderBotColorA")) == null) {
            botA = Color.decode("#82A7CC");
        }
        if ((botB = UIManager.getColor("ToolBar.BorderBotColorB")) == null) {
            botB = Color.decode("#516D8B");
        }
        return new ShadowRectangleBorder(topA, topB, botA, botB);
    }

    public static Border getWorkButtonBorder() {
        if (toolBarWorkBuBorder == null) {
            Color disableC;
            Color pressC;
            Color rollverC;
            Color initC = UIManager.getColor("WorkButton.toolbarInitBorderColor");
            if (initC == null) {
                initC = Color.decode("#ADC7DE");
            }
            if ((rollverC = UIManager.getColor("WorkButton.toolbarMouseoverBorderColor")) == null) {
                rollverC = Color.decode("#739EC6");
            }
            if ((pressC = UIManager.getColor("WorkButton.toolbarMousedownBorderColor")) == null) {
                pressC = Color.decode("#115285");
            }
            if ((disableC = UIManager.getColor("WorkButton.toolbarDisableBorderColor")) == null) {
                disableC = Color.decode("#115285");
            }
            toolBarWorkBuBorder = new WorkButtonBorder(initC, rollverC, pressC, initC, disableC);
            toolBarWorkBuBorder.setFactType(0);
        }
        return toolBarWorkBuBorder;
    }

    public static Border getCommonWorkButtonBorder() {
        if (contentWorkBuBorder == null) {
            Color disableC;
            Color pressC;
            Color rolloverC;
            Color initC = UIManager.getColor("WorkButton.initBorderColor");
            if (initC == null) {
                initC = Color.decode("#B3B3B3");
            }
            if ((rolloverC = UIManager.getColor("WorkButton.mouseoverBorderColor")) == null) {
                rolloverC = Color.decode("#E89600");
            }
            if ((pressC = UIManager.getColor("WorkButton.mousedownBorderColor")) == null) {
                pressC = Color.decode("#B3B3B3");
            }
            if ((disableC = UIManager.getColor("WorkButton.disableBorderColor")) == null) {
                disableC = Color.decode("#B3B3B3");
            }
            contentWorkBuBorder = new WorkButtonBorder(initC, rolloverC, pressC, initC, disableC);
            contentWorkBuBorder.setFactType(1);
        }
        return contentWorkBuBorder;
    }

    public static Border getToolbarToggleButtonBorder() {
        if (toolbarToggleButtonBorder == null) {
            Color initLightColor = null;
            Color initDarkColor = null;
            Color rollverLightColor = Color.decode("#0C477B");
            Color rollverDarkColor = Color.decode("#0C477B");
            Color pressLightColor = Color.decode("#183854");
            Color pressDarkColor = Color.decode("#DEE9F1");
            Color selectedLightColor = Color.decode("#183854");
            Color selectedDarkColor = Color.decode("#DEE9F1");
            Color selectedRollverLightColor = Color.decode("#183854");
            Color selectedRollverDarkColor = Color.decode("#DEE9F1");
            toolbarToggleButtonBorder = new ToggleButtonBorder(initLightColor, initDarkColor, rollverLightColor, rollverDarkColor, pressLightColor, pressDarkColor, selectedLightColor, selectedDarkColor, selectedRollverLightColor, selectedRollverDarkColor);
            toolbarToggleButtonBorder.setFactType(0);
        }
        return toolbarToggleButtonBorder;
    }

    public static Border getContentToggleButtonBorder() {
        if (contentToggleButtonBorder == null) {
            Color initLightColor = null;
            Color initDarkColor = null;
            Color rollverLightColor = Color.decode("#0C477B");
            Color rollverDarkColor = Color.decode("#0C477B");
            Color pressLightColor = Color.decode("#183854");
            Color pressDarkColor = Color.decode("#DEE9F1");
            Color selectedLightColor = Color.decode("#183854");
            Color selectedDarkColor = Color.decode("#DEE9F1");
            Color selectedRollverLightColor = Color.decode("#183854");
            Color selectedRollverDarkColor = Color.decode("#DEE9F1");
            contentToggleButtonBorder = new ToggleButtonBorder(initLightColor, initDarkColor, rollverLightColor, rollverDarkColor, pressLightColor, pressDarkColor, selectedLightColor, selectedDarkColor, selectedRollverLightColor, selectedRollverDarkColor);
            contentToggleButtonBorder.setFactType(1);
        }
        return contentToggleButtonBorder;
    }

    private static void paintSelftBorder(Graphics g, Color color1, Color color2, int w, int h) {
        Color old = g.getColor();
        g.setColor(color1);
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(color2);
        g.drawLine(w - 1, 1, w - 1, h - 1);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.setColor(old);
    }

    public static Border getCommonEditorBorder() {
        if (comEditorBorder == null) {
            comEditorBorder = new CommonEditorBorder();
        }
        return comEditorBorder;
    }

    public static Border getMenuBorder() {
        if (menuBorder == null) {
            Color initCol = Color.decode("#E6EDF3");
            Color rollverCol = UIManager.getColor("Menu.borderShadowColor");
            menuBorder = new KDMenuBorder(initCol, rollverCol, rollverCol, rollverCol);
        }
        return menuBorder;
    }

    public static Border getPopupBorder() {
        return new PopupMenuBorder(UIManager.getColor("PopupMenu.borderLineColor"));
    }

    public static Border getShadowBorder() {
        if (shadowBorder == null) {
            shadowBorder = new ShadowBorder();
        }
        return shadowBorder;
    }

    public static Border getEtchedBorder() {
        return new EtchedBorder(1, UIManager.getColor("GroupBorder.highlight"), UIManager.getColor("GroupBorder.shadow"));
    }

    public static class ShadowBorder
    extends AbstractBorder
    implements UIResource {
        int xoff = 5;
        int yoff = 5;
        Insets insets = new Insets(0, 0, this.yoff, this.xoff);

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            g.setColor(new Color(0, 0, 0, 89));
            g.drawLine(width - this.xoff, this.yoff, width - this.xoff, height - this.yoff - 1);
            g.drawLine(this.xoff, height - this.yoff, width - this.xoff - 1, height - this.yoff);
            g.setColor(new Color(0, 0, 0, 66));
            g.drawLine(width - this.xoff + 1, this.yoff, width - this.xoff + 1, height - this.yoff - 1);
            g.drawLine(this.xoff, height - this.yoff + 1, width - this.xoff - 1, height - this.yoff + 1);
            g.setColor(new Color(0, 0, 0, 38));
            g.drawLine(width - this.xoff + 2, this.yoff, width - this.xoff + 2, height - this.yoff - 1);
            g.drawLine(this.xoff, height - this.yoff + 2, width - this.xoff - 1, height - this.yoff + 2);
            g.setColor(new Color(0, 0, 0, 20));
            g.drawLine(width - this.xoff + 3, this.yoff, width - this.xoff + 3, height - this.yoff - 1);
            g.drawLine(this.xoff, height - this.yoff + 3, width - this.xoff - 1, height - this.yoff + 3);
            g.setColor(new Color(0, 0, 0, 8));
            g.drawLine(width - this.xoff + 4, this.yoff, width - this.xoff + 4, height - this.yoff - 1);
            g.drawLine(this.xoff, height - this.yoff + 4, width - this.xoff - 1, height - this.yoff + 4);
            g.setColor(new Color(0, 0, 0, 77));
            g.drawLine(this.xoff - 1, height - this.yoff, this.xoff - 1, height - this.yoff);
            g.setColor(new Color(0, 0, 0, 54));
            g.drawLine(this.xoff - 2, height - this.yoff, this.xoff - 2, height - this.yoff);
            g.drawLine(this.xoff - 1, height - this.yoff + 1, this.xoff - 1, height - this.yoff + 1);
            g.setColor(new Color(0, 0, 0, 33));
            g.drawLine(this.xoff - 2, height - this.yoff + 1, this.xoff - 2, height - this.yoff + 1);
            g.setColor(new Color(0, 0, 0, 30));
            g.drawLine(this.xoff - 3, height - this.yoff, this.xoff - 3, height - this.yoff);
            g.drawLine(this.xoff - 1, height - this.yoff + 2, this.xoff - 1, height - this.yoff + 2);
            g.setColor(new Color(0, 0, 0, 20));
            g.drawLine(this.xoff - 3, height - this.yoff + 1, this.xoff - 3, height - this.yoff + 1);
            g.drawLine(this.xoff - 2, height - this.yoff + 2, this.xoff - 2, height - this.yoff + 2);
            g.setColor(new Color(0, 0, 0, 15));
            g.drawLine(this.xoff - 4, height - this.yoff, this.xoff - 4, height - this.yoff);
            g.drawLine(this.xoff - 1, height - this.yoff + 3, this.xoff - 1, height - this.yoff + 3);
            g.setColor(new Color(0, 0, 0, 10));
            g.drawLine(this.xoff - 3, height - this.yoff + 2, this.xoff - 3, height - this.yoff + 2);
            g.drawLine(this.xoff - 2, height - this.yoff + 3, this.xoff - 2, height - this.yoff + 3);
            g.drawLine(this.xoff - 4, height - this.yoff + 1, this.xoff - 4, height - this.yoff + 1);
            g.setColor(new Color(0, 0, 0, 5));
            g.drawLine(this.xoff - 4, height - this.yoff + 2, this.xoff - 4, height - this.yoff + 2);
            g.drawLine(this.xoff - 3, height - this.yoff + 3, this.xoff - 3, height - this.yoff + 3);
            g.setColor(new Color(0, 0, 0, 77));
            g.drawLine(width - this.xoff, this.yoff - 1, width - this.xoff, this.yoff - 1);
            g.setColor(new Color(0, 0, 0, 54));
            g.drawLine(width - this.xoff + 1, this.yoff - 1, width - this.xoff + 1, this.yoff - 1);
            g.drawLine(width - this.xoff, this.yoff - 2, width - this.xoff, this.yoff - 2);
            g.setColor(new Color(0, 0, 0, 33));
            g.drawLine(width - this.xoff + 1, this.yoff - 2, width - this.xoff + 1, this.yoff - 2);
            g.setColor(new Color(0, 0, 0, 30));
            g.drawLine(width - this.xoff + 2, this.yoff - 1, width - this.xoff + 2, this.yoff - 1);
            g.drawLine(width - this.xoff, this.yoff - 3, width - this.xoff, this.yoff - 3);
            g.setColor(new Color(0, 0, 0, 20));
            g.drawLine(width - this.xoff + 1, this.yoff - 3, width - this.xoff + 1, this.yoff - 3);
            g.drawLine(width - this.xoff + 2, this.yoff - 2, width - this.xoff + 2, this.yoff - 2);
            g.setColor(new Color(0, 0, 0, 15));
            g.drawLine(width - this.xoff + 3, this.yoff - 1, width - this.xoff + 3, this.yoff - 1);
            g.drawLine(width - this.xoff, this.yoff - 4, width - this.xoff, this.yoff - 4);
            g.setColor(new Color(0, 0, 0, 10));
            g.drawLine(width - this.xoff + 1, this.yoff - 4, width - this.xoff + 1, this.yoff - 4);
            g.drawLine(width - this.xoff + 2, this.yoff - 3, width - this.xoff + 2, this.yoff - 3);
            g.drawLine(width - this.xoff + 3, this.yoff - 2, width - this.xoff + 3, this.yoff - 2);
            g.setColor(new Color(0, 0, 0, 5));
            g.drawLine(width - this.xoff + 2, this.yoff - 4, width - this.xoff + 2, this.yoff - 4);
            g.drawLine(width - this.xoff + 3, this.yoff - 3, width - this.xoff + 3, this.yoff - 3);
            g.setColor(new Color(0, 0, 0, 77));
            g.drawLine(width - this.xoff, height - this.yoff, width - this.xoff, height - this.yoff);
            g.setColor(new Color(0, 0, 0, 54));
            g.drawLine(width - this.xoff + 1, height - this.yoff, width - this.xoff + 1, height - this.yoff);
            g.drawLine(width - this.xoff, height - this.yoff + 1, width - this.xoff, height - this.yoff + 1);
            g.setColor(new Color(0, 0, 0, 33));
            g.drawLine(width - this.xoff + 1, height - this.yoff + 1, width - this.xoff + 1, height - this.yoff + 1);
            g.setColor(new Color(0, 0, 0, 30));
            g.drawLine(width - this.xoff + 2, height - this.yoff, width - this.xoff + 2, height - this.yoff);
            g.drawLine(width - this.xoff, height - this.yoff + 2, width - this.xoff, height - this.yoff + 2);
            g.setColor(new Color(0, 0, 0, 20));
            g.drawLine(width - this.xoff + 2, height - this.yoff + 1, width - this.xoff + 2, height - this.yoff + 1);
            g.drawLine(width - this.xoff + 1, height - this.yoff + 2, width - this.xoff + 1, height - this.yoff + 2);
            g.setColor(new Color(0, 0, 0, 15));
            g.drawLine(width - this.xoff + 3, height - this.yoff, width - this.xoff + 3, height - this.yoff);
            g.drawLine(width - this.xoff, height - this.yoff + 3, width - this.xoff, height - this.yoff + 3);
            g.setColor(new Color(0, 0, 0, 10));
            g.drawLine(width - this.xoff + 3, height - this.yoff + 1, width - this.xoff + 3, height - this.yoff + 1);
            g.drawLine(width - this.xoff + 2, height - this.yoff + 2, width - this.xoff + 2, height - this.yoff + 2);
            g.drawLine(width - this.xoff + 1, height - this.yoff + 3, width - this.xoff + 1, height - this.yoff + 3);
            g.setColor(new Color(0, 0, 0, 5));
            g.drawLine(width - this.xoff + 3, height - this.yoff + 2, width - this.xoff + 3, height - this.yoff + 2);
            g.drawLine(width - this.xoff + 2, height - this.yoff + 3, width - this.xoff + 2, height - this.yoff + 3);
            g.translate(-x, -y);
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -2158626578575318374L;
        private Color lineColor = null;

        public PopupMenuBorder() {
            this(Color.decode("#3E75A9"));
        }

        public PopupMenuBorder(Color newLineColor) {
            this.setLineColor(newLineColor);
        }

        public void setLineColor(Color newVal) {
            this.lineColor = newVal != null ? newVal : Color.decode("#3E75A9");
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color old = g.getColor();
            g.setColor(UIManager.getColor("PopupMenu.borderLineColor"));
            int topX = 0;
            MenuElement[] mes = MenuSelectionManager.defaultManager().getSelectedPath();
            int popupMenuIndex = this.popupMenuIndex(mes, c);
            if (popupMenuIndex != -1 && popupMenuIndex != 0 && mes[popupMenuIndex - 1] != null && mes[popupMenuIndex - 1] instanceof JMenu && ((JMenu)mes[popupMenuIndex - 1]).isTopLevelMenu()) {
                topX = ((JMenu)mes[1]).getSize().width;
            }
            g.drawLine(topX, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.setColor(old);
        }

        private int popupMenuIndex(MenuElement[] mes, Component c) {
            if (mes != null && c != null) {
                int len = mes.length;
                for (int i = 0; i < len; ++i) {
                    if (mes[i] != c) continue;
                    return i;
                }
            }
            return -1;
        }
    }

    public static class KDMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -2476166716162337846L;
        Color initCol = null;
        Color rollverCol = null;
        Color pressCol = null;
        Color armedCol = null;
        Color parentBack = null;
        boolean isOpaque = true;

        public KDMenuBorder(Color initC, Color rollverC, Color pressC, Color armedC) {
            this.initCol = initC;
            this.rollverCol = rollverC;
            this.pressCol = pressC;
            this.armedCol = armedC;
            this.parentBack = this.initCol;
        }

        public void setInitColor(Color iniC) {
            if (iniC != null) {
                this.initCol = iniC;
            }
        }

        public void setRollverColor(Color rollverC) {
            if (rollverC != null) {
                this.rollverCol = rollverC;
            }
        }

        public void setPressColor(Color pressC) {
            if (pressC != null) {
                this.pressCol = pressC;
            }
        }

        public void setArmedColor(Color armedC) {
            if (armedC != null) {
                this.armedCol = armedC;
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                margin = b.getMargin();
            } else if (c instanceof JToolBar) {
                JToolBar t = (JToolBar)c;
                margin = t.getMargin();
            } else if (c instanceof JTextComponent) {
                JTextComponent t = (JTextComponent)c;
                margin = t.getMargin();
            }
            insets.top = margin != null ? margin.top : 0;
            insets.left = margin != null ? margin.left : 0;
            insets.bottom = margin != null ? margin.bottom : 0;
            insets.right = margin != null ? margin.right : 0;
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public boolean isBorderOpaque() {
            return this.isOpaque;
        }

        private MenuElement[] getMenuElements(Component c) {
            if (c instanceof JMenu) {
                MenuSelectionManager mag = MenuSelectionManager.defaultManager();
                MenuElement[] me = mag.getSelectedPath();
                if (me != null && me.length > 0) {
                    return me;
                }
                return null;
            }
            return null;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            MenuElement[] mel;
            if (c instanceof JMenu && !((JMenu)c).isTopLevelMenu()) {
                return;
            }
            boolean isArm = false;
            boolean isPre = false;
            boolean isRol = false;
            this.isOpaque = c.isOpaque();
            Color old = g.getColor();
            int type = 0;
            if (c instanceof AbstractButton) {
                ButtonModel m = ((AbstractButton)c).getModel();
                isArm = m.isArmed();
                isPre = m.isPressed();
                isRol = m.isRollover();
            }
            if (isRol && !isArm && !isPre) {
                g.setColor(UIManager.getColor("Menu.borderShadowColor"));
            } else if (isArm && isPre) {
                g.setColor(UIManager.getColor("Menu.borderShadowColor"));
            } else if (!isArm && isPre) {
                g.setColor(UIManager.getColor("Menu.borderShadowColor"));
            } else if (this.isOpaque) {
                g.setColor(UIManager.getColor("Menu.borderShadowColor"));
            }
            if (isRol || isPre || isArm) {
                if (c instanceof JMenu) {
                    mel = this.getMenuElements(c);
                    if (isRol && !isArm && !isPre) {
                        type = mel != null && mel.length > 1 && mel[1] == c ? 2 : 1;
                    } else if (isArm && isPre) {
                        type = 2;
                    } else if (!isArm && isPre && mel != null && mel.length > 1) {
                        type = mel[1] == c ? 2 : 0;
                    }
                }
            } else if (c instanceof JMenu) {
                mel = this.getMenuElements(c);
                if (mel != null && mel.length > 1 && mel[1] == c) {
                    type = 2;
                    g.setColor(UIManager.getColor("Menu.borderShadowColor"));
                } else {
                    type = 0;
                }
            }
            if (type != 1) {
                if (type == 2) {
                    g.drawLine(0, 2, 0, h - 1);
                    g.fillOval(1, 1, 1, 1);
                    g.drawLine(2, 0, w - 3, 0);
                    g.fillOval(w - 2, 1, 1, 1);
                    g.drawLine(w - 1, 2, w - 1, h - 1);
                    return;
                }
                if (this.isOpaque) {
                    g.setColor(UIManager.getColor("Menu.borderShadowColor"));
                } else {
                    g.setColor(old);
                    return;
                }
            }
            g.drawLine(0, 2, 0, h - 3);
            g.fillOval(1, 1, 1, 1);
            g.drawLine(2, 0, w - 3, 0);
            g.fillOval(w - 2, 1, 1, 1);
            g.drawLine(w - 1, 2, w - 1, h - 3);
            g.fillOval(w - 2, h - 2, 1, 1);
            g.drawLine(2, h - 1, w - 3, h - 1);
            g.fillOval(1, h - 2, 1, 1);
            g.setColor(old);
        }
    }

    public static class CommonEditorBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -3586992724830707702L;
        Color initCol = null;
        Color activeCol = null;
        Color inActiveCol = null;
        private boolean isOpaque = true;

        public CommonEditorBorder() {
            this(UIManager.getColor("editorInitBorderColor"), UIManager.getColor("editorActiveBorderColor"), UIManager.getColor("editorDisableBorderColor"));
        }

        public CommonEditorBorder(Color initC, Color activeC, Color inActiveC) {
            this.initCol = initC != null ? initC : Color.decode("#B4B4B4");
            this.activeCol = activeC != null ? activeC : Color.decode("#5C85B3");
            this.inActiveCol = inActiveC != null ? inActiveC : Color.decode("#B4B4B4");
        }

        public void setInitColor(Color c) {
            if (c != null) {
                this.initCol = c;
            }
        }

        public void setActiveColor(Color c) {
            if (c != null) {
                this.activeCol = c;
            }
        }

        public void setInActiveColor(Color c) {
            if (c != null) {
                this.inActiveCol = c;
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.isOpaque;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void paintBorder(Component comp, Graphics g, int x, int y, int w, int h) {
            Component c = null;
            c = comp instanceof KDDatePicker ? ((KDDatePicker)comp).getEditor().getEditorComponent() : comp;
            this.isOpaque = c.isOpaque();
            Color old = g.getColor();
            if (c.isEnabled()) {
                if (c.isFocusOwner()) {
                    g.setColor(this.activeCol);
                } else {
                    if (!this.isOpaque) return;
                    g.setColor(this.initCol);
                }
            } else {
                if (!this.isOpaque) {
                    return;
                }
                g.setColor(this.inActiveCol);
            }
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.setColor(old);
        }
    }

    public static class ToggleButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 3558800102607006116L;
        private Color rollverLightColor = null;
        private Color rollverDarkColor = null;
        private Color pressLightColor = null;
        private Color pressDarkColor = null;
        private Color selectedLightColor = null;
        private Color selectedDarkColor = null;
        private Color selectedRollverLightColor = null;
        private Color selectedRollverDarkColor = null;
        private boolean isOpaque = true;
        private int faceType = 1;

        public ToggleButtonBorder(Color initLightColor, Color initDarkColor, Color rollverLightColor, Color rollverDarkColor, Color pressLightColor, Color pressDarkColor, Color selectedLightColor, Color selectedDarkColor, Color selectedRollverLightColor, Color selectedRollverDarkColor) {
            this.rollverLightColor = rollverLightColor;
            this.rollverDarkColor = rollverDarkColor;
            this.pressLightColor = pressLightColor;
            this.pressDarkColor = pressDarkColor;
            this.selectedLightColor = selectedLightColor;
            this.selectedDarkColor = selectedDarkColor;
            this.selectedRollverLightColor = selectedRollverLightColor;
            this.selectedRollverDarkColor = selectedRollverDarkColor;
        }

        public void setFactType(int newVal) {
            switch (newVal) {
                case 0: {
                    this.faceType = 0;
                    break;
                }
                default: {
                    this.faceType = 1;
                }
            }
        }

        public int getFaceType() {
            return this.faceType;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                margin = b.getMargin();
            } else if (c instanceof JToolBar) {
                JToolBar t = (JToolBar)c;
                margin = t.getMargin();
            } else if (c instanceof JTextComponent) {
                JTextComponent t = (JTextComponent)c;
                margin = t.getMargin();
            }
            insets.top = margin != null ? margin.top : 2;
            insets.left = margin != null ? margin.left : 4;
            insets.bottom = margin != null ? margin.bottom : 2;
            insets.right = margin != null ? margin.right : 4;
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public boolean isBorderOpaque() {
            return this.isOpaque;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            switch (this.faceType) {
                case 0: {
                    this.paintBlueType(c, g, x, y, w, h);
                    break;
                }
                default: {
                    this.paintGrayType(c, g, x, y, w, h);
                }
            }
        }

        private void paintBlueType(Component c, Graphics g, int x, int y, int w, int h) {
            boolean isArm = false;
            boolean isPre = false;
            boolean isRol = false;
            boolean isSelected = false;
            this.isOpaque = c.isOpaque();
            if (c instanceof AbstractButton) {
                ButtonModel m = ((AbstractButton)c).getModel();
                isArm = m.isArmed();
                isPre = m.isPressed();
                isRol = m.isRollover();
                isSelected = m.isSelected();
            }
            if (isSelected) {
                KingdeeBorders.paintSelftBorder(g, this.selectedLightColor, this.selectedDarkColor, w, h);
                if (isRol && !isArm && !isPre) {
                    KingdeeBorders.paintSelftBorder(g, this.selectedRollverLightColor, this.selectedRollverDarkColor, w, h);
                } else if (isArm && isPre) {
                    KingdeeBorders.paintSelftBorder(g, this.pressLightColor, this.pressDarkColor, w, h);
                } else if (!isArm && isPre) {
                    KingdeeBorders.paintSelftBorder(g, this.pressLightColor, this.pressDarkColor, w, h);
                }
            } else if (isRol && !isArm && !isPre) {
                KingdeeBorders.paintSelftBorder(g, this.rollverLightColor, this.rollverDarkColor, w, h);
            } else if (isArm && isPre) {
                KingdeeBorders.paintSelftBorder(g, this.pressLightColor, this.pressDarkColor, w, h);
            } else if (!isArm && isPre) {
                KingdeeBorders.paintSelftBorder(g, this.pressLightColor, this.pressDarkColor, w, h);
            }
        }

        private void paintGrayType(Component c, Graphics g, int x, int y, int w, int h) {
        }
    }

    public static class WorkButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 5247837287394868375L;
        private Color initCol = null;
        private Color rollverCol = null;
        private Color pressCol = null;
        private Color armedCol = null;
        private Color disableCol = null;
        private boolean isOpaque = true;
        private int faceType = 1;

        public WorkButtonBorder(Color initC, Color rollverC, Color pressC, Color armedC) {
            this.initCol = initC;
            this.rollverCol = rollverC;
            this.pressCol = pressC;
            this.armedCol = armedC;
        }

        public WorkButtonBorder(Color initC, Color rollverC, Color pressC, Color armedC, Color disableC) {
            this.initCol = initC;
            this.rollverCol = rollverC;
            this.pressCol = pressC;
            this.armedCol = armedC;
            this.disableCol = disableC;
        }

        public void setFactType(int newVal) {
            switch (newVal) {
                case 0: {
                    this.faceType = 0;
                    break;
                }
                default: {
                    this.faceType = 1;
                }
            }
        }

        public int getFaceType() {
            return this.faceType;
        }

        public void setInitColor(Color iniC) {
            if (iniC != null) {
                this.initCol = iniC;
            }
        }

        public void setRollverColor(Color rollverC) {
            if (rollverC != null) {
                this.rollverCol = rollverC;
            }
        }

        public void setPressColor(Color pressC) {
            if (pressC != null) {
                this.pressCol = pressC;
            }
        }

        public void setArmedColor(Color armedC) {
            if (armedC != null) {
                this.armedCol = armedC;
            }
        }

        public void setDisableColor(Color disableC) {
            if (disableC != null) {
                this.disableCol = disableC;
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                margin = b.getMargin();
            } else if (c instanceof JToolBar) {
                JToolBar t = (JToolBar)c;
                margin = t.getMargin();
            } else if (c instanceof JTextComponent) {
                JTextComponent t = (JTextComponent)c;
                margin = t.getMargin();
            }
            insets.top = margin != null ? margin.top : 2;
            insets.left = margin != null ? margin.left : 4;
            insets.bottom = margin != null ? margin.bottom : 2;
            insets.right = margin != null ? margin.right : 4;
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public boolean isBorderOpaque() {
            return this.isOpaque;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean isPaint = true;
            if (c instanceof AbstractButton) {
                isPaint = ((AbstractButton)c).isBorderPainted();
            }
            if (isPaint) {
                if (this.faceType == 0) {
                    this.paintBlueType(c, g, x, y, w, h);
                } else {
                    this.paintGrayType(c, g, x, y, w, h);
                }
            }
        }

        private void paintBlueType(Component c, Graphics g, int x, int y, int w, int h) {
            boolean isArm = false;
            boolean isPre = false;
            boolean isRol = false;
            this.isOpaque = c.isOpaque();
            if (c instanceof AbstractButton) {
                ButtonModel m = ((AbstractButton)c).getModel();
                isArm = m.isArmed();
                isPre = m.isPressed();
                isRol = m.isRollover();
            }
            Color old = g.getColor();
            if (isRol && !isArm && !isPre) {
                g.setColor(UIManager.getColor("WorkButton.toolbarMouseoverBorderColor"));
            } else if (isArm && isPre) {
                g.setColor(UIManager.getColor("WorkButton.toolbarInitBorderColor"));
            } else if (!isArm && isPre) {
                g.setColor(UIManager.getColor("WorkButton.toolbarMousedownBorderColor"));
            } else if (c.isFocusOwner()) {
                g.setColor(UIManager.getColor("WorkButton.toolbarMousedownBorderColor"));
            } else if (this.isOpaque) {
                g.setColor(UIManager.getColor("WorkButton.toolbarInitBorderColor"));
            } else {
                return;
            }
            g.drawLine(0, h / 2 - 8, 0, h / 2 + 8);
            g.fillOval(1, h / 2 - 9, 1, 1);
            g.drawLine(2, h / 2 - 10, w - 3, h / 2 - 10);
            g.fillOval(w - 2, h / 2 - 9, 1, 1);
            g.drawLine(w - 1, h / 2 - 8, w - 1, h / 2 + 8);
            g.fillOval(w - 2, h / 2 + 9, 1, 1);
            g.drawLine(2, h / 2 + 10, w - 3, h / 2 + 10);
            g.fillOval(1, h / 2 + 9, 1, 1);
            g.setColor(old);
        }

        private void paintGrayType(Component c, Graphics g, int x, int y, int w, int h) {
            this.isOpaque = c.isOpaque();
            Color old = g.getColor();
            if (!this.isOpaque) {
                return;
            }
            boolean isEnable = false;
            boolean isArm = false;
            boolean isPre = false;
            boolean isRol = false;
            isEnable = c.isEnabled();
            if (c instanceof AbstractButton) {
                ButtonModel m = ((AbstractButton)c).getModel();
                isArm = m.isArmed();
                isPre = m.isPressed();
                isRol = m.isRollover();
            }
            if (isEnable) {
                if (isRol && !isArm && !isPre) {
                    g.setColor(this.rollverCol);
                } else if (isArm && isPre) {
                    g.setColor(this.armedCol);
                } else if (!isArm && isPre) {
                    g.setColor(this.pressCol);
                } else if (c.isFocusOwner()) {
                    g.setColor(this.pressCol);
                } else {
                    g.setColor(this.initCol);
                }
            } else {
                g.setColor(this.disableCol);
            }
            g.drawRect(0, 0, w - 1, h);
            g.setColor(old);
        }
    }

    public static class ShadowRectangleBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -1902383955148331576L;
        private Color topA = null;
        private Color topB = null;
        private Color botA = null;
        private Color botB = null;

        public ShadowRectangleBorder() {
            this(Color.decode("#B6C8D8"), Color.decode("#E9F0F6"), Color.decode("#82A7CC"), Color.decode("#516D8B"));
        }

        public ShadowRectangleBorder(Color topC1, Color topC2, Color botC1, Color botC2) {
            this.topA = topC1 != null ? topC1 : Color.decode("#B6C8D8");
            this.topB = topC2 != null ? topC2 : Color.decode("#E9F0F6");
            this.botA = botC1 != null ? botC1 : Color.decode("#82A7CC");
            this.botB = botC2 != null ? botC2 : Color.decode("#516D8B");
        }

        public void setTopColorA(Color cA) {
            if (cA != null) {
                this.topA = cA;
            }
        }

        public void setTopColorB(Color cB) {
            if (cB != null) {
                this.topB = cB;
            }
        }

        public void setBotColorA(Color cA) {
            if (cA != null) {
                this.botA = cA;
            }
        }

        public void setBotColorB(Color cB) {
            if (cB != null) {
                this.botB = cB;
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return new Insets(2, 0, 2, 0);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 0, 2, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color old = g.getColor();
            int hv = 0;
            if (c instanceof JToolBar) {
                hv = ((JToolBar)c).getOrientation();
            }
            if (hv == 0) {
                g.setColor(this.topA);
                g.drawLine(0, 0, width - 1, 0);
                g.setColor(this.topB);
                g.drawLine(0, 1, width - 1, 1);
                g.setColor(this.botA);
                g.drawLine(0, height - 2, width - 1, height - 2);
                g.setColor(this.botB);
                g.drawLine(0, height - 1, width - 1, height - 1);
            } else {
                g.setColor(this.topA);
                g.drawLine(0, 0, 0, height - 1);
                g.setColor(this.topB);
                g.drawLine(1, 0, 1, height - 1);
                g.setColor(this.botA);
                g.drawLine(width - 2, 0, width - 2, height - 1);
                g.setColor(this.botB);
                g.drawLine(width - 1, 0, width - 1, height - 1);
            }
            g.setColor(old);
        }
    }

    public static class TextEditorBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -1460774706383013036L;
        private static Color defaultColor = new Color(0xB4B4B4);
        private static Color focusColor = new Color(6063539);
        private static Color disableColor = defaultColor;

        public TextEditorBorder() {
        }

        public TextEditorBorder(Color defaultC, Color focusC, Color disableC) {
            defaultColor = defaultC;
            focusColor = focusC;
            disableColor = disableC;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color borderColor = defaultColor;
            if (!c.isEnabled()) {
                borderColor = disableColor;
            }
            if (c.hasFocus()) {
                borderColor = focusColor;
            }
            g.setColor(borderColor);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y + h - 1, x, y + 1);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x + w - 1, y + 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(1, 1, 1, 1));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }

    public static class ToolBarButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 8253537858933004335L;
        Color initC = null;
        Color rolloverC = null;
        Color bc = Color.decode("#E6EDF3");
        Color sc = Color.decode("#BBD2E7");
        Color armc = Color.decode("#2661A8");
        protected static Insets borderInsets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            g.translate(x, y);
            if (c.getParent() instanceof JToolBar) {
                if (model.isArmed() || model.isSelected()) {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawLine(0, 0, w - 2, 0);
                    g.drawLine(0, 0, 0, h - 1);
                    g.drawLine(w - 2, 2, w - 2, h - 1);
                    g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                    g.drawLine(w - 1, 1, w - 1, h - 1);
                    g.setColor(MetalLookAndFeel.getMenuBackground());
                    g.drawLine(w - 1, 0, w - 1, 0);
                }
            } else {
                if (model.isRollover() && !model.isArmed() && !model.isPressed()) {
                    g.setColor(this.sc);
                } else if (model.isPressed()) {
                    g.setColor(this.armc);
                } else {
                    g.setColor(this.bc);
                }
                g.drawRect(0, 0, b.getWidth() - 1, b.getHeight() - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = ToolBarButtonBorder.borderInsets.top;
            newInsets.left = ToolBarButtonBorder.borderInsets.left;
            newInsets.bottom = ToolBarButtonBorder.borderInsets.bottom;
            newInsets.right = ToolBarButtonBorder.borderInsets.right;
            return newInsets;
        }
    }

    public static class LabelContainerButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 2195490912630433999L;
        private static Color underLineColor = null;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            KDLabelContainer container = null;
            if (c.getParent() instanceof KDLabelContainer) {
                container = (KDLabelContainer)c.getParent();
                underLineColor = container.getUnderlineColor();
            }
            if (container == null) {
                return;
            }
            int height = c.getHeight();
            int width = c.getWidth();
            Color oldColor = g.getColor();
            if (container.isBoundLabelUnderline()) {
                g.setColor(underLineColor);
                g.drawLine(0, height - 1, width, height - 1);
            }
            g.setColor(oldColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(1, 1, 1, 1));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 2;
            insets.bottom = 2;
            insets.left = 2;
            insets.top = 2;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }

    public static class F7ButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 853579934065808986L;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            boolean isRollover = model.isRollover();
            boolean isPress = model.isPressed();
            boolean isArmed = model.isArmed();
            if (c.isEnabled()) {
                if (isRollover) {
                    g.setColor(UIManager.getColor("PromptBox.mouseoverDarkBorderColor"));
                    g.drawLine(x + 2, h - 2, w - 2, h - 2);
                    g.drawLine(w - 2, y + 1, w - 2, h - 2);
                    g.setColor(UIManager.getColor("PromptBox.mouseoverLightBorderColor"));
                    g.drawLine(x + 1, y + 1, w - 3, y + 1);
                    g.drawLine(x + 1, y + 1, x + 1, h - 2);
                    g.setColor(UIManager.getColor("PromptBox.mouseoverBorderColor"));
                    g.drawRect(x, y, w - 1, h - 1);
                } else if (isArmed && isPress) {
                    g.setColor(UIManager.getColor("PromptBox.mousedownDarkBorderColor"));
                    g.drawLine(x + 2, h - 2, w - 2, h - 2);
                    g.drawLine(w - 2, y + 1, w - 2, h - 2);
                    g.setColor(UIManager.getColor("PromptBox.mousedownLightBorderColor"));
                    g.drawLine(x + 1, y + 1, w - 3, y + 1);
                    g.drawLine(x + 1, y + 1, x + 1, h - 2);
                    g.setColor(UIManager.getColor("PromptBox.mousedownBorderColor"));
                    g.drawRect(x, y, w - 1, h - 1);
                } else {
                    g.setColor(UIManager.getColor("PromptBox.initDarkBorderColor"));
                    g.drawLine(x + 2, h - 2, w - 2, h - 2);
                    g.drawLine(w - 2, y + 1, w - 2, h - 2);
                    g.setColor(UIManager.getColor("PromptBox.initLightBorderColor"));
                    g.drawLine(x + 1, y + 1, w - 3, y + 1);
                    g.drawLine(x + 1, y + 1, x + 1, h - 2);
                    g.setColor(UIManager.getColor("PromptBox.initBorderColor"));
                    g.drawRect(x, y, w - 1, h - 1);
                }
            } else {
                g.setColor(UIManager.getColor("PromptBox.disableDarkBorderColor"));
                g.drawLine(x + 2, h - 2, w - 2, h - 2);
                g.drawLine(w - 2, y + 1, w - 2, h - 2);
                g.setColor(UIManager.getColor("PromptBox.disableLightBorderColor"));
                g.drawLine(x + 1, y + 1, w - 3, y + 1);
                g.drawLine(x + 1, y + 1, x + 1, h - 2);
                g.setColor(UIManager.getColor("PromptBox.disableBorderColor"));
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(1, 1, 1, 1));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 2;
            insets.bottom = 2;
            insets.left = 2;
            insets.top = 2;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }

    public static class RomanticButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -9042330374277458963L;
        protected static final Insets INSETS = new Insets(4, 2, 4, 2);
        protected static final int INNERBORDER = 1;
        protected static final int OFF = 0;
        protected static final int ON = 1;
        protected static final int DOWN = 2;
        protected static final int DISABLE = 3;
        protected static final int FOCUS = 4;
        static Color[][] colors = null;

        private Color getColor(String colorValue) {
            Color col = PlafUtilies.getCacheColor((String)colorValue);
            if (col == null) {
                try {
                    col = new ColorUIResource(BasicLFM.parseColor((String)colorValue));
                    PlafUtilies.putCacheColor((String)colorValue, (Color)col);
                }
                catch (Exception ex) {
                    col = null;
                    logger.error((Object)"err", (Throwable)ex);
                }
            }
            return col;
        }

        protected void initColors() {
            String initBorderColor = UIManager.getString("Button.initBorderColor");
            String focusBorderColor = UIManager.getString("Button.focusBorderColor");
            String mouseoverBorderColor = UIManager.getString("Button.mouseoverBorderColor");
            String mousedownBorderColor = UIManager.getString("Button.mousedownBorderColor");
            String disableBorderColor = UIManager.getString("Button.disableBorderColor");
            String[] init = initBorderColor.split(",");
            String[] focus = focusBorderColor.split(",");
            String[] mouseover = mouseoverBorderColor.split(",");
            String[] mousedown = mousedownBorderColor.split(",");
            String[] disable = disableBorderColor.split(",");
            int STATES = 5;
            int COLORS = 12;
            colors = new Color[5][12];
            for (int i = 0; i < 12; ++i) {
                RomanticButtonBorder.colors[0][i] = this.getColor(init[i]);
                RomanticButtonBorder.colors[4][i] = this.getColor(focus[i]);
                RomanticButtonBorder.colors[1][i] = this.getColor(mouseover[i]);
                RomanticButtonBorder.colors[2][i] = this.getColor(mousedown[i]);
                RomanticButtonBorder.colors[3][i] = this.getColor(disable[i]);
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            this.initColors();
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            Color[] clrs = null;
            clrs = model.isArmed() && model.isPressed() ? colors[2] : (b.isRolloverEnabled() && model.isRollover() ? colors[1] : (b.isFocusPainted() && b.hasFocus() ? colors[4] : (b.isEnabled() ? colors[0] : colors[3])));
            this.paintRomanticBorder(c, (Graphics2D)g, x, y, w, h, clrs);
        }

        protected void paintRomanticBorder(Component c, Graphics2D g2, int x, int y, int w, int h, Color[] clrs) {
            int i;
            int xi = x;
            int yi = y;
            int color_bp = 0;
            for (i = 0; i < RomanticButtonBorder.INSETS.top; ++i) {
                g2.setColor(clrs[color_bp + i]);
                g2.drawLine(xi + RomanticButtonBorder.INSETS.left, yi, w - RomanticButtonBorder.INSETS.right - 1, yi);
                if (i == RomanticButtonBorder.INSETS.top - 1) {
                    g2.drawLine(xi + RomanticButtonBorder.INSETS.left, yi, xi + RomanticButtonBorder.INSETS.left, h - RomanticButtonBorder.INSETS.bottom);
                    g2.drawLine(w - RomanticButtonBorder.INSETS.right - 1, yi, w - RomanticButtonBorder.INSETS.right - 1, h - RomanticButtonBorder.INSETS.bottom);
                }
                ++yi;
            }
            color_bp += RomanticButtonBorder.INSETS.top;
            yi = h - RomanticButtonBorder.INSETS.bottom;
            for (i = 0; i < RomanticButtonBorder.INSETS.bottom; ++i) {
                g2.setColor(clrs[color_bp + i]);
                g2.drawLine(xi + RomanticButtonBorder.INSETS.left, yi, w - RomanticButtonBorder.INSETS.right - 1, yi);
                ++yi;
            }
            int LIGHTCOLOR = 8;
            int DARKCOLOR = 9;
            GradientPaint p = new GradientPaint(x, y + RomanticButtonBorder.INSETS.left, clrs[8], x, h - RomanticButtonBorder.INSETS.left, clrs[9]);
            g2.setPaint(p);
            g2.drawLine(x, y + RomanticButtonBorder.INSETS.left, x, h - RomanticButtonBorder.INSETS.left - 1);
            g2.drawLine(x + 1, y + RomanticButtonBorder.INSETS.left, x + 1, h - RomanticButtonBorder.INSETS.left - 1);
            g2.drawLine(w - 1, y + RomanticButtonBorder.INSETS.left, w - 1, h - RomanticButtonBorder.INSETS.left - 1);
            g2.drawLine(w - 2, y + RomanticButtonBorder.INSETS.left, w - 2, h - RomanticButtonBorder.INSETS.left - 1);
            int CORNERTOPCOLOR = 10;
            int CORNERBOTTOMCOLOR = 11;
            Color trans = new Color(255, 255, 255, 0);
            p = new GradientPaint(x + 1, y + RomanticButtonBorder.INSETS.left - 1, clrs[10], x, y, trans);
            g2.setPaint(p);
            g2.drawLine(x, y + RomanticButtonBorder.INSETS.left, x, y);
            g2.drawLine(x + 1, y + RomanticButtonBorder.INSETS.left, x + 1, y);
            yi = xi = RomanticButtonBorder.INSETS.left;
            p = new GradientPaint(xi - 1, yi - 1, clrs[10], xi + 1, yi + 1, c.getBackground());
            g2.setPaint(p);
            g2.drawLine(xi, yi, xi, yi);
            p = new GradientPaint(w - 2, y + RomanticButtonBorder.INSETS.left - 1, clrs[10], w - 1, y, trans);
            g2.setPaint(p);
            g2.drawLine(w - 1, y + RomanticButtonBorder.INSETS.left, w - 1, y);
            g2.drawLine(w - 2, y + RomanticButtonBorder.INSETS.left, w - 2, y);
            xi = w - RomanticButtonBorder.INSETS.right - 1;
            yi = RomanticButtonBorder.INSETS.right;
            p = new GradientPaint(xi + 1, yi - 1, clrs[10], xi - 1, yi + 1, c.getBackground());
            g2.setPaint(p);
            g2.drawLine(xi, yi, xi, yi);
            p = new GradientPaint(x + 1, h - RomanticButtonBorder.INSETS.left, clrs[11], x, h - 1, trans);
            g2.setPaint(p);
            g2.drawLine(x, h - RomanticButtonBorder.INSETS.left, x, h - 1);
            g2.drawLine(x + 1, h - RomanticButtonBorder.INSETS.left, x + 1, h - 1);
            xi = RomanticButtonBorder.INSETS.left;
            yi = h - RomanticButtonBorder.INSETS.left - 1;
            p = new GradientPaint(xi - 1, yi + 1, clrs[11], xi + 1, yi - 1, c.getBackground());
            g2.setPaint(p);
            g2.drawLine(xi, yi, xi, yi);
            p = new GradientPaint(w - 2, h - RomanticButtonBorder.INSETS.left, clrs[11], w - 1, h - 1, trans);
            g2.setPaint(p);
            g2.drawLine(w - 1, h - RomanticButtonBorder.INSETS.left, w - 1, h - 1);
            g2.drawLine(w - 2, h - RomanticButtonBorder.INSETS.left, w - 2, h - 1);
            xi = w - RomanticButtonBorder.INSETS.right - 1;
            yi = h - RomanticButtonBorder.INSETS.right - 1;
            p = new GradientPaint(xi + 1, yi + 1, clrs[11], xi - 1, yi - 1, c.getBackground());
            g2.setPaint(p);
            g2.drawLine(xi, yi, xi, yi);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(1, 1, 1, 1));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                margin = b.getMargin();
            } else if (c instanceof JToolBar) {
                JToolBar t = (JToolBar)c;
                margin = t.getMargin();
            } else if (c instanceof JTextComponent) {
                JTextComponent t = (JTextComponent)c;
                margin = t.getMargin();
            }
            insets.top = margin != null ? margin.top + 2 : RomanticButtonBorder.INSETS.top;
            insets.left = margin != null ? margin.left + 3 : RomanticButtonBorder.INSETS.left;
            insets.bottom = margin != null ? margin.bottom + 2 : RomanticButtonBorder.INSETS.bottom;
            insets.right = margin != null ? margin.right + 3 : RomanticButtonBorder.INSETS.right;
            return insets;
        }
    }

    public static class WideEditorBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1323376181108694169L;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JComponent editor;
            JFormattedTextField tf;
            boolean isEnabled = c.isEnabled();
            boolean isEditable = false;
            boolean isRequired = false;
            boolean isFocus = false;
            if (c instanceof IKDTextComponent) {
                IKDTextComponent textComponent = (IKDTextComponent)((Object)c);
                isEditable = textComponent.isEditable();
                isRequired = textComponent.isRequired();
            }
            if (!c.isEnabled()) {
                isFocus = false;
            }
            if (c.hasFocus()) {
                isFocus = true;
            }
            if (c instanceof JComboBox) {
                if (((JComboBox)c).getEditor().getEditorComponent().hasFocus()) {
                    isFocus = true;
                }
            } else if (c instanceof JSpinner && (tf = ((JSpinner.DefaultEditor)(editor = ((JSpinner)c).getEditor())).getTextField()).hasFocus()) {
                isFocus = true;
            }
            if (c instanceof KDScrollPane) {
                isFocus = true;
            }
            if (isFocus) {
                g.setColor(UIManager.getColor("TextField.focusBorderColor"));
                g.fillRect(0, 0, w, 2);
                g.fillRect(0, 0, 2, h);
                g.fillRect(0, h - 2, w, 2);
                g.fillRect(w - 2, 0, 2, h);
            } else {
                if (isEnabled) {
                    if (isEditable) {
                        if (isRequired) {
                            g.setColor(UIManager.getColor("TextField.requiredBorderColor"));
                        } else {
                            g.setColor(UIManager.getColor("TextField.initBorderColor"));
                        }
                    } else {
                        g.setColor(UIManager.getColor("TextField.readonlyBorderColor"));
                    }
                } else {
                    g.setColor(UIManager.getColor("TextField.disableBorderColor"));
                }
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, 1, 0, h - 1);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.drawLine(w - 1, 1, w - 1, h - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (c instanceof KDTextField && c.getParent() != null && c.getParent() instanceof KDLabelContainer) {
                return this.getBorderInsets(c, new Insets(1, 3, 1, 3));
            }
            if (c instanceof KDSpinner) {
                return this.getBorderInsets(c, new Insets(1, 1, 1, 1));
            }
            return this.getBorderInsets(c, new Insets(1, 2, 1, 2));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }

    public static class EditorBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -7290471533842324393L;
        private static Color defaultColor = new Color(0xB4B4B4);
        private static Color focusColor = new Color(6063539);
        private static Color disableColor = defaultColor;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color borderColor = defaultColor;
            if (!c.isEnabled()) {
                borderColor = disableColor;
            }
            if (c.hasFocus()) {
                borderColor = focusColor;
            }
            g.setColor(borderColor);
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(1, 1, 1, 1));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }

    public static class BoxTileBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -2665500393096633026L;
        private Tile.BoxTile boxTile = new Tile.BoxTile();

        public BoxTileBorder(Tile[] tiles, Insets tileInsets) {
            if (tiles.length < 8) {
                throw new IllegalArgumentException("tiles count should equals 8");
            }
            this.boxTile.leftTop = tiles[0];
            this.boxTile.top = tiles[1];
            this.boxTile.rightTop = tiles[2];
            this.boxTile.left = tiles[3];
            this.boxTile.centre = Tile.NullTile.getInstance();
            this.boxTile.right = tiles[4];
            this.boxTile.leftBottom = tiles[5];
            this.boxTile.bottom = tiles[6];
            this.boxTile.rightBottom = tiles[7];
            this.boxTile.sizingMargin = (Insets)tileInsets.clone();
        }

        public void setBorderInsets(Insets insets) {
            this.boxTile.sizingMargin = (Insets)insets.clone();
        }

        public BoxTileBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            this.boxTile.paintTile(g, c, x, y, w, h);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets result = (Insets)this.boxTile.getMargin().clone();
            return result;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets = (Insets)this.boxTile.getMargin().clone();
            return insets;
        }

        public Tile getLeftTop() {
            return this.boxTile.leftTop;
        }

        public Tile getTop() {
            return this.boxTile.top;
        }

        public Tile getRightTop() {
            return this.boxTile.rightTop;
        }

        public Tile getLeft() {
            return this.boxTile.left;
        }

        public Tile getRight() {
            return this.boxTile.right;
        }

        public Tile getLeftBottom() {
            return this.boxTile.leftBottom;
        }

        public Tile getBottom() {
            return this.boxTile.bottom;
        }

        public Tile getRightBottom() {
            return this.boxTile.rightBottom;
        }

        public void setLeftTop(Tile value) {
            this.boxTile.leftTop = value;
        }

        public void setTop(Tile value) {
            this.boxTile.top = value;
        }

        public void setRightTop(Tile value) {
            this.boxTile.rightTop = value;
        }

        public void setLeft(Tile value) {
            this.boxTile.left = value;
        }

        public void setRight(Tile value) {
            this.boxTile.right = value;
        }

        public void setLeftBottom(Tile value) {
            this.boxTile.leftBottom = value;
        }

        public void setBottom(Tile value) {
            this.boxTile.bottom = value;
        }

        public void setRightBottom(Tile value) {
            this.boxTile.rightBottom = value;
        }
    }

    public static class WorkButtonTileBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -8605891554013277000L;
        public BoxTileBorder[] borders = new BoxTileBorder[8];

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            int state = KingdeeButtonStates.getButtonState((KDWorkButton)c);
            Insets result = this.borders[state].getBorderInsets(c, insets);
            ++result.left;
            ++result.right;
            insets.left = result.left;
            insets.right = result.right;
            insets.top = result.top;
            insets.bottom = result.bottom;
            return result;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets result = new Insets(0, 0, 0, 0);
            this.getBorderInsets(c, result);
            return result;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            KDWorkButton b = (KDWorkButton)c;
            int state = KingdeeButtonStates.getWorkButtonState(b);
            this.borders[state].paintBorder(c, g, x, y, w, h);
        }
    }

    public static class BevelBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -1142211666684046710L;
        private Color darkShadow;
        private Color lightShadow;
        private boolean isRaised;

        public BevelBorder(boolean isRaised, Color darkShadow, Color lightShadow) {
            this.isRaised = isRaised;
            this.darkShadow = darkShadow;
            this.lightShadow = lightShadow;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(this.isRaised ? this.lightShadow : this.darkShadow);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y + h - 1, x, y + 1);
            g.setColor(this.isRaised ? this.darkShadow : this.lightShadow);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x + w - 1, y + 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(1, 1, 1, 1));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }
}

