/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class KingdeeDBntScrollBarExUI
extends BasicScrollBarUI {
    boolean isRolloverThumb = false;
    JButton incrButton2;
    JButton decrButton2;
    protected ArrowButtonListenerEx buttonListener2;
    protected RolloverListener rolloverListener;
    private static ImageIcon fillErectback = null;
    private static ImageIcon fillErectback2 = null;
    private static ImageIcon fillAcrossback = null;
    private static ImageIcon fillAcrossback2 = null;
    private static ImageIcon top3 = null;
    private static ImageIcon fillErect3 = null;
    private static ImageIcon down3 = null;
    private static ImageIcon top2 = null;
    private static ImageIcon fillErect2 = null;
    private static ImageIcon down2 = null;
    private static ImageIcon topA = null;
    private static ImageIcon fillErect = null;
    private static ImageIcon downA = null;
    private static ImageIcon left3 = null;
    private static ImageIcon fillAcross3 = null;
    private static ImageIcon right3 = null;
    private static ImageIcon left2 = null;
    private static ImageIcon fillAcross2 = null;
    private static ImageIcon right2 = null;
    private static ImageIcon left1 = null;
    private static ImageIcon fillAcross = null;
    private static ImageIcon right1 = null;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeDBntScrollBarExUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decrButton = new KingdeeArrowButton(orientation);
        return this.decrButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.incrButton = new KingdeeArrowButton(orientation);
        return this.incrButton;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (this.scrollbar.getOrientation() == 1) {
            if (this.scrollbar.isEnabled()) {
                g.drawImage(fillErectback.getImage(), trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, null, null);
            } else {
                g.drawImage(fillErectback2.getImage(), trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, null, null);
            }
        } else if (this.scrollbar.isEnabled()) {
            g.drawImage(fillAcrossback.getImage(), trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, null, null);
        } else {
            g.drawImage(fillAcrossback2.getImage(), trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, null, null);
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds, boolean isRollover) {
        if (thumbBounds.isEmpty()) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.scrollbar.isEnabled()) {
                this.drawVerticalThumb(g, thumbBounds, top3.getImage(), fillErect3.getImage(), down3.getImage());
            } else if (this.isRolloverThumb) {
                this.drawVerticalThumb(g, thumbBounds, top2.getImage(), fillErect2.getImage(), down2.getImage());
            } else {
                this.drawVerticalThumb(g, thumbBounds, topA.getImage(), fillErect.getImage(), downA.getImage());
            }
        } else if (!this.scrollbar.isEnabled()) {
            this.drawHorizonThumb(g, thumbBounds, left3.getImage(), fillAcross3.getImage(), right3.getImage());
        } else if (this.isRolloverThumb) {
            this.drawHorizonThumb(g, thumbBounds, left2.getImage(), fillAcross2.getImage(), right2.getImage());
        } else {
            this.drawHorizonThumb(g, thumbBounds, left1.getImage(), fillAcross.getImage(), right1.getImage());
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.rolloverListener = this.createRolloverListener();
        this.buttonListener2 = this.createArrowButtonListenerEx();
        this.scrollbar.addMouseListener(this.rolloverListener);
        this.scrollbar.addMouseMotionListener(this.rolloverListener);
        if (this.incrButton2 != null) {
            this.incrButton2.addMouseListener(this.buttonListener2);
        }
        if (this.decrButton2 != null) {
            this.decrButton2.addMouseListener(this.buttonListener2);
        }
        this.scrollbar.addPropertyChangeListener(new PropertyChangeHandler2());
    }

    protected ArrowButtonListenerEx createArrowButtonListenerEx() {
        return new ArrowButtonListenerEx();
    }

    protected RolloverListener createRolloverListener() {
        return new RolloverListener();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removeMouseListener(this.rolloverListener);
        this.scrollbar.removeMouseMotionListener(this.rolloverListener);
    }

    private void drawHorizonThumb(Graphics g, Rectangle thumbBounds, Image image1, Image image2, Image image3) {
        int temp = image1.getWidth(null);
        g.drawImage(image1, thumbBounds.x, thumbBounds.y, temp, thumbBounds.height, null, null);
        g.drawImage(image2, thumbBounds.x + temp, thumbBounds.y, thumbBounds.width - 2 * temp, thumbBounds.height, null, null);
        g.drawImage(image3, thumbBounds.x + thumbBounds.width - temp, thumbBounds.y, temp, thumbBounds.height, null, null);
    }

    private void drawVerticalThumb(Graphics g, Rectangle thumbBounds, Image image1, Image image2, Image image3) {
        int temp = image1.getHeight(null);
        g.drawImage(image1, thumbBounds.x, thumbBounds.y, thumbBounds.width, temp, null, null);
        g.drawImage(image2, thumbBounds.x, thumbBounds.y + temp, thumbBounds.width, thumbBounds.height - 2 * temp, null, null);
        g.drawImage(image3, thumbBounds.x, thumbBounds.y + thumbBounds.height - temp, thumbBounds.width, temp, null, null);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintTrack(g, c, this.getTrackBounds());
        this.paintThumb(g, c, this.getThumbBounds(), this.isRolloverThumb);
    }

    private void setRollover(boolean rollover) {
        if (this.isRolloverThumb == rollover) {
            return;
        }
        this.isRolloverThumb = rollover;
        this.scrollbar.repaint();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                this.incrButton2 = new KingdeeArrowButton(5);
                this.decrButton2 = new KingdeeArrowButton(1);
                break;
            }
            case 0: {
                if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    this.incrButton2 = new KingdeeArrowButton(3);
                    this.decrButton2 = new KingdeeArrowButton(7);
                    break;
                }
                this.incrButton2 = new KingdeeArrowButton(7);
                this.decrButton2 = new KingdeeArrowButton(3);
            }
        }
        this.scrollbar.add(this.incrButton2);
        this.scrollbar.add(this.decrButton2);
        if (fillErectback == null) {
            fillErectback = (ImageIcon)UIManager.get("ScrollBar.fillErectback");
        }
        if (fillErectback2 == null) {
            fillErectback2 = (ImageIcon)UIManager.get("ScrollBar.fillErectback2");
        }
        if (fillAcrossback == null) {
            fillAcrossback = (ImageIcon)UIManager.get("ScrollBar.fillAcrossback");
        }
        if (fillAcrossback2 == null) {
            fillAcrossback2 = (ImageIcon)UIManager.get("ScrollBar.fillAcrossback2");
        }
        if (topA == null) {
            topA = (ImageIcon)UIManager.get("ScrollBar.topA");
        }
        if (fillErect == null) {
            fillErect = (ImageIcon)UIManager.get("ScrollBar.fillErect");
        }
        if (downA == null) {
            downA = (ImageIcon)UIManager.get("ScrollBar.downA");
        }
        if (left3 == null) {
            left3 = (ImageIcon)UIManager.get("ScrollBar.left3");
        }
        if (fillAcross3 == null) {
            fillAcross3 = (ImageIcon)UIManager.get("ScrollBar.fillAcross3");
        }
        if (right3 == null) {
            right3 = (ImageIcon)UIManager.get("ScrollBar.right3");
        }
        if (left2 == null) {
            left2 = (ImageIcon)UIManager.get("ScrollBar.left2");
        }
        if (fillAcross2 == null) {
            fillAcross2 = (ImageIcon)UIManager.get("ScrollBar.fillAcross2");
        }
        if (right2 == null) {
            right2 = (ImageIcon)UIManager.get("ScrollBar.right2");
        }
        if (left1 == null) {
            left1 = (ImageIcon)UIManager.get("ScrollBar.left1");
        }
        if (fillAcross == null) {
            fillAcross = (ImageIcon)UIManager.get("ScrollBar.fillAcross");
        }
        if (right1 == null) {
            right1 = (ImageIcon)UIManager.get("ScrollBar.right1");
        }
        if (top3 == null) {
            top3 = (ImageIcon)UIManager.get("ScrollBar.top3");
        }
        if (fillErect3 == null) {
            fillErect3 = (ImageIcon)UIManager.get("ScrollBar.fillErect3");
        }
        if (down3 == null) {
            down3 = (ImageIcon)UIManager.get("ScrollBar.down3");
        }
        if (top2 == null) {
            top2 = (ImageIcon)UIManager.get("ScrollBar.top2");
        }
        if (fillErect2 == null) {
            fillErect2 = (ImageIcon)UIManager.get("ScrollBar.fillErect2");
        }
        if (down2 == null) {
            down2 = (ImageIcon)UIManager.get("ScrollBar.down2");
        }
    }

    @Override
    public void uninstallDefaults() {
        super.uninstallDefaults();
        fillErectback = null;
        fillErectback2 = null;
        fillAcrossback = null;
        fillAcrossback2 = null;
        topA = null;
        fillErect = null;
        downA = null;
        left3 = null;
        fillAcross3 = null;
        right3 = null;
        left2 = null;
        fillAcross2 = null;
        right2 = null;
        left1 = null;
        fillAcross = null;
        right1 = null;
        top3 = null;
        fillErect3 = null;
        down3 = null;
        top2 = null;
        fillErect2 = null;
        down2 = null;
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int decrButtonH = this.decrButton.getPreferredSize().height;
        int decrButtonY = sbInsets.top;
        int incrButtonH = this.incrButton.getPreferredSize().height;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButtonH2 = this.decrButton2.getPreferredSize().height;
        int decrButtonY2 = incrButtonY - decrButtonH2;
        int incrButtonH2 = this.incrButton2.getPreferredSize().height;
        int incrButtonY2 = decrButtonH + decrButtonY;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH + decrButtonH2 + incrButtonH2;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = incrButtonY - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += incrButtonY2 + incrButtonH2;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 4;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
            decrButtonY2 = incrButtonY - incrButtonH;
            incrButtonY2 = decrButtonY + decrButtonH;
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        this.decrButton2.setBounds(itemX, decrButtonY2, itemW, incrButtonH);
        this.incrButton2.setBounds(itemX, incrButtonY2, itemW, incrButtonH);
        int itrackY = decrButtonY + decrButtonH + incrButtonY2;
        int itrackH = decrButtonY2 - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButtonY2) {
                thumbY = decrButtonY2 - thumbH;
            }
            if (thumbY < incrButtonY2) {
                thumbY = incrButtonY2 + incrButtonH2 + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new TrackListenerEx();
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        boolean ltr;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        int leftButtonW = ((ltr = sb.getComponentOrientation().isLeftToRight()) ? this.decrButton : this.incrButton).getPreferredSize().width;
        int rightButtonW = (ltr ? this.incrButton : this.decrButton).getPreferredSize().width;
        int leftButtonW2 = (ltr ? this.decrButton2 : this.incrButton2).getPreferredSize().width;
        int rightButtonW2 = (ltr ? this.incrButton2 : this.decrButton2).getPreferredSize().width;
        int leftButtonX = sbInsets.left;
        int rightButtonX = sbSize.width - (sbInsets.right + rightButtonW);
        int leftButtonX2 = leftButtonX + leftButtonW;
        int rightButtonX2 = rightButtonX - rightButtonW;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = leftButtonW + rightButtonW + leftButtonW2 + rightButtonW2;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? rightButtonX - thumbW : leftButtonX + leftButtonW;
        if ((float)sb.getValue() < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            thumbX = ltr ? (int)(0.5f + thumbRange * ((value - min) / (range - extent))) : (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
            thumbX += leftButtonX2 + leftButtonW2;
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            rightButtonW = leftButtonW = sbAvailButtonW / 2;
            rightButtonX = sbSize.width - (sbInsets.right + rightButtonW);
        }
        (ltr ? this.decrButton : this.incrButton).setBounds(leftButtonX, itemY, leftButtonW, itemH);
        (ltr ? this.incrButton : this.decrButton).setBounds(rightButtonX, itemY, rightButtonW, itemH);
        (ltr ? this.decrButton2 : this.incrButton2).setBounds(rightButtonX2, itemY, rightButtonW2, itemH);
        (ltr ? this.incrButton2 : this.decrButton2).setBounds(leftButtonX2, itemY, leftButtonW2, itemH);
        int itrackX = leftButtonX2 + leftButtonW2;
        int itrackW = rightButtonX2 - itrackX;
        this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbX + thumbW > rightButtonX2) {
                thumbX = rightButtonX2 - thumbW;
            }
            if (thumbX < leftButtonX2 + leftButtonW2) {
                thumbX = leftButtonX2 + leftButtonW2 + 1;
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    public class PropertyChangeHandler2
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("orientation".equals(propertyName)) {
                Integer orient = (Integer)e.getNewValue();
                if (KingdeeDBntScrollBarExUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    if (KingdeeDBntScrollBarExUI.this.incrButton instanceof BasicArrowButton) {
                        ((KingdeeArrowButton)KingdeeDBntScrollBarExUI.this.incrButton2).setDirection(orient == 0 ? 3 : 5);
                    }
                    if (KingdeeDBntScrollBarExUI.this.decrButton instanceof BasicArrowButton) {
                        ((KingdeeArrowButton)KingdeeDBntScrollBarExUI.this.decrButton2).setDirection(orient == 0 ? 7 : 1);
                    }
                } else {
                    if (KingdeeDBntScrollBarExUI.this.incrButton instanceof BasicArrowButton) {
                        ((KingdeeArrowButton)KingdeeDBntScrollBarExUI.this.incrButton2).setDirection(orient == 0 ? 7 : 5);
                    }
                    if (KingdeeDBntScrollBarExUI.this.decrButton instanceof BasicArrowButton) {
                        ((KingdeeArrowButton)KingdeeDBntScrollBarExUI.this.decrButton2).setDirection(orient == 0 ? 3 : 1);
                    }
                }
            }
        }
    }

    protected class TrackListenerEx
    extends BasicScrollBarUI.TrackListener {
        protected TrackListenerEx() {
            super(KingdeeDBntScrollBarExUI.this);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.setExValueFrom(e);
        }

        private void setExValueFrom(MouseEvent e) {
            int thumbPos;
            int thumbMax;
            int thumbMin;
            if (!KingdeeDBntScrollBarExUI.this.scrollbar.isEnabled() || !KingdeeDBntScrollBarExUI.this.isDragging) {
                return;
            }
            BoundedRangeModel model = KingdeeDBntScrollBarExUI.this.scrollbar.getModel();
            Rectangle thumbR = KingdeeDBntScrollBarExUI.this.getThumbBounds();
            if (KingdeeDBntScrollBarExUI.this.scrollbar.getOrientation() == 1) {
                thumbMin = KingdeeDBntScrollBarExUI.this.incrButton2.getY() + KingdeeDBntScrollBarExUI.this.incrButton2.getHeight();
                thumbMax = KingdeeDBntScrollBarExUI.this.decrButton2.getY() - ((KingdeeDBntScrollBarExUI)KingdeeDBntScrollBarExUI.this).getThumbBounds().height;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                KingdeeDBntScrollBarExUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
                KingdeeDBntScrollBarExUI.this.scrollbar.setValueIsAdjusting(false);
            } else {
                if (KingdeeDBntScrollBarExUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    thumbMin = KingdeeDBntScrollBarExUI.this.incrButton2.getX() + KingdeeDBntScrollBarExUI.this.incrButton2.getWidth();
                    thumbMax = KingdeeDBntScrollBarExUI.this.decrButton2.getX() - ((KingdeeDBntScrollBarExUI)KingdeeDBntScrollBarExUI.this).getThumbBounds().width;
                } else {
                    thumbMin = KingdeeDBntScrollBarExUI.this.decrButton2.getX() + KingdeeDBntScrollBarExUI.this.decrButton2.getWidth();
                    thumbMax = KingdeeDBntScrollBarExUI.this.incrButton2.getX() - ((KingdeeDBntScrollBarExUI)KingdeeDBntScrollBarExUI.this).getThumbBounds().width;
                }
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getX() - this.offset));
                KingdeeDBntScrollBarExUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
            }
            if (thumbPos == thumbMax) {
                if (KingdeeDBntScrollBarExUI.this.scrollbar.getOrientation() == 1 || KingdeeDBntScrollBarExUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    KingdeeDBntScrollBarExUI.this.scrollbar.setValue(model.getMaximum() - model.getExtent());
                } else {
                    KingdeeDBntScrollBarExUI.this.scrollbar.setValue(model.getMinimum());
                }
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = KingdeeDBntScrollBarExUI.this.scrollbar.getOrientation() == 1 || KingdeeDBntScrollBarExUI.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(thumbValue / thumbRange * valueRange)) : (int)(0.5 + (double)((float)(thumbMax - thumbPos) / thumbRange * valueRange));
                KingdeeDBntScrollBarExUI.this.scrollbar.setValue(value + model.getMinimum());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    protected class ArrowButtonListenerEx
    extends MouseAdapter {
        protected ArrowButtonListenerEx() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!KingdeeDBntScrollBarExUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int direction = e.getSource() == KingdeeDBntScrollBarExUI.this.incrButton2 ? 1 : -1;
            KingdeeDBntScrollBarExUI.this.scrollByUnit(direction);
            KingdeeDBntScrollBarExUI.this.scrollTimer.stop();
            KingdeeDBntScrollBarExUI.this.scrollListener.setDirection(direction);
            KingdeeDBntScrollBarExUI.this.scrollListener.setScrollByBlock(false);
            KingdeeDBntScrollBarExUI.this.scrollTimer.start();
            if (!KingdeeDBntScrollBarExUI.this.scrollbar.hasFocus() && KingdeeDBntScrollBarExUI.this.scrollbar.isRequestFocusEnabled()) {
                KingdeeDBntScrollBarExUI.this.scrollbar.requestFocus();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            KingdeeDBntScrollBarExUI.this.scrollTimer.stop();
            KingdeeDBntScrollBarExUI.this.scrollbar.setValueIsAdjusting(false);
        }
    }

    protected class RolloverListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected RolloverListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Rectangle thumbR = KingdeeDBntScrollBarExUI.this.getThumbBounds();
            if (thumbR.contains(e.getX(), e.getY())) {
                KingdeeDBntScrollBarExUI.this.setRollover(true);
            } else {
                KingdeeDBntScrollBarExUI.this.setRollover(false);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            KingdeeDBntScrollBarExUI.this.setRollover(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Rectangle thumbR = KingdeeDBntScrollBarExUI.this.getThumbBounds();
            if (thumbR.contains(e.getX(), e.getY())) {
                KingdeeDBntScrollBarExUI.this.setRollover(true);
            } else {
                KingdeeDBntScrollBarExUI.this.setRollover(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    private class KingdeeArrowButton
    extends BasicArrowButton {
        private static final long serialVersionUID = -8527664297165922367L;
        protected int direction;
        private Image[] images;

        public KingdeeArrowButton(int direction) {
            this(direction, UIManager.getColor("control"), UIManager.getColor("controlShadow"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"));
        }

        private void initImages(int direction) {
            if (this.images == null) {
                this.images = new Image[4];
            }
            ImageIcon tempIcon = null;
            switch (direction) {
                case 1: {
                    tempIcon = (ImageIcon)UIManager.get("ScrollBar.btntop1");
                    if (tempIcon != null) {
                        this.images[0] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btntop2")) != null) {
                        this.images[1] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btntop3")) != null) {
                        this.images[2] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btntop4")) == null) break;
                    this.images[3] = tempIcon.getImage();
                    break;
                }
                case 5: {
                    tempIcon = (ImageIcon)UIManager.get("ScrollBar.btndown1");
                    if (tempIcon != null) {
                        this.images[0] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btndown2")) != null) {
                        this.images[1] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btndown3")) != null) {
                        this.images[2] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btndown4")) == null) break;
                    this.images[3] = tempIcon.getImage();
                    break;
                }
                case 7: {
                    tempIcon = (ImageIcon)UIManager.get("ScrollBar.btnleft1");
                    if (tempIcon != null) {
                        this.images[0] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btnleft2")) != null) {
                        this.images[1] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btnleft3")) != null) {
                        this.images[2] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btnleft4")) == null) break;
                    this.images[3] = tempIcon.getImage();
                    break;
                }
                case 3: {
                    tempIcon = (ImageIcon)UIManager.get("ScrollBar.btnright1");
                    if (tempIcon != null) {
                        this.images[0] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btnright2")) != null) {
                        this.images[1] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btnright3")) != null) {
                        this.images[2] = tempIcon.getImage();
                    }
                    if ((tempIcon = (ImageIcon)UIManager.get("ScrollBar.btnright4")) == null) break;
                    this.images[3] = tempIcon.getImage();
                    break;
                }
            }
        }

        @Override
        public void setDirection(int dir) {
            this.direction = dir;
            this.initImages(this.direction);
        }

        public KingdeeArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
            super(direction, background, shadow, darkShadow, highlight);
            this.direction = direction;
            this.initImages(direction);
        }

        public void paintTriangle(Graphics g, Dimension size) {
            boolean isPressed = this.getModel().isPressed();
            boolean isEnabled = this.isEnabled();
            if (isEnabled) {
                if (!isPressed) {
                    g.drawImage(this.images[0], 0, 0, size.width, size.height, null);
                } else if (this.getModel().isRollover()) {
                    g.drawImage(this.images[1], 0, 0, size.width, size.height, null);
                } else {
                    g.drawImage(this.images[2], 0, 0, size.width, size.height, null);
                }
            } else {
                g.drawImage(this.images[3], 0, 0, size.width, size.height, null);
            }
        }

        @Override
        public void paint(Graphics g) {
            this.paintTriangle(g, this.getSize());
        }

        @Override
        public Dimension getPreferredSize() {
            int size = 16;
            if (KingdeeDBntScrollBarExUI.this.scrollbar != null) {
                switch (KingdeeDBntScrollBarExUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        size = KingdeeDBntScrollBarExUI.this.scrollbar.getWidth();
                        break;
                    }
                    case 0: {
                        size = KingdeeDBntScrollBarExUI.this.scrollbar.getHeight();
                    }
                }
                size = Math.max(size, 5);
            }
            return new Dimension(size, size);
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.images[0] == null) {
                return new Dimension(16, 16);
            }
            return new Dimension(this.images[0].getWidth(null), this.images[0].getHeight(null));
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }
}

