/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.KDInfoTip;
import com.kingdee.cosmic.ctrl.swing.model.IInfoTipModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class KingdeeInfoTipUI
extends ComponentUI {
    private KDInfoTip c;
    private IInfoTipModel model;
    private int arrowHeight = 20;
    private int insetBottom = 1;
    private int insetLeft = 5;
    private int insetRight = 5;
    private int radian = 10;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.c = (KDInfoTip)c;
        this.model = this.c.getModel();
        this.installListeners(this.c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.unInstallListeners(this.c);
    }

    private void unInstallListeners(KDInfoTip tip) {
        this.c.removeMouseListener(null);
    }

    private void installListeners(KDInfoTip tip) {
        this.c.addMouseListener(null);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ((JComponent)c.getParent().getParent().getParent()).validate();
        Color oldColor = g.getColor();
        g.setColor(this.model.getBackgroundColor());
        Point op = this.c.getPopupPosition();
        op = SwingUtilities.convertPoint(this.c.getOwner(), op, this.c);
        Dimension od = this.c.getTargetDimension();
        Dimension size = c.getSize();
        int arrowWidth = Math.round((float)size.width * 0.1f);
        Dimension d = new Dimension(size.width, size.height - this.arrowHeight - this.insetBottom);
        switch (this.c.getPosition()) {
            case 1: {
                g.fillRoundRect(0, this.arrowHeight, d.width - 1, d.height, this.radian, this.radian);
                g.setColor(oldColor);
                Shape oldClip = g.getClip();
                Area target = new Area(oldClip);
                if (this.arrowHeight != 0) {
                    Area cover = new Area(new Rectangle(arrowWidth, this.arrowHeight, arrowWidth, 1));
                    target.subtract(cover);
                }
                g.setClip(target);
                g.drawRoundRect(0, this.arrowHeight, d.width - 1, d.height, this.radian, this.radian);
                g.setClip(oldClip);
                g.setColor(this.model.getBackgroundColor());
                Point arrowP = new Point(op.x, op.y + od.height + 2);
                g.fillPolygon(new Polygon(new int[]{arrowWidth, arrowP.x, arrowWidth * 2, arrowWidth}, new int[]{this.arrowHeight, arrowP.y, this.arrowHeight, this.arrowHeight}, 4));
                g.setColor(oldColor);
                if (this.arrowHeight != 0) {
                    g.drawLine(arrowWidth, this.arrowHeight, arrowP.x, arrowP.y);
                    g.drawLine(arrowP.x, arrowP.y, arrowWidth * 2, this.arrowHeight);
                }
                if (this.c.getType() == 1) {
                    Rectangle r = this.getRenderArea(1);
                    this.drawStringByRow(r, g);
                    break;
                }
                ((View)c.getClientProperty("view")).paint(g, this.getRenderArea(1));
                break;
            }
            case 2: {
                g.fillRoundRect(0, 0, d.width - 1, d.height, this.radian, this.radian);
                g.setColor(oldColor);
                Shape oldClip = g.getClip();
                Area target = new Area(oldClip);
                if (this.arrowHeight != 0) {
                    Area cover = new Area(new Rectangle(arrowWidth, op.y - 3 - this.arrowHeight, arrowWidth, 1));
                    target.subtract(cover);
                }
                g.setClip(target);
                g.drawRoundRect(0, 0, d.width - 1, d.height, this.radian, this.radian);
                g.setClip(oldClip);
                g.setColor(this.model.getBackgroundColor());
                Point arrowP = new Point(op.x, op.y - 2);
                g.fillPolygon(new Polygon(new int[]{arrowWidth, arrowP.x, arrowWidth * 2, arrowWidth}, new int[]{d.height, arrowP.y, d.height, d.height}, 4));
                g.setColor(oldColor);
                if (this.arrowHeight != 0) {
                    g.drawLine(arrowWidth, d.height, arrowP.x, arrowP.y);
                    g.drawLine(arrowP.x, arrowP.y, arrowWidth * 2, d.height);
                }
                if (this.c.getType() == 1) {
                    Rectangle r = this.getRenderArea(2);
                    this.drawStringByRow(r, g);
                    break;
                }
                ((View)c.getClientProperty("view")).paint(g, this.getRenderArea(2));
                break;
            }
        }
    }

    private void drawStringByRow(Rectangle rect, Graphics g) {
        Font oldFont = g.getFont();
        g.setFont(this.model.getFont());
        String modeltext = this.model.getText();
        char[] ch = modeltext.toCharArray();
        FontMetrics fm = g.getFontMetrics();
        int rowIndex = 0;
        int height = (int)((double)fm.getHeight() * 1.5);
        int length = 5;
        for (int i = 0; i < ch.length; ++i) {
            int y;
            String temp = String.valueOf(ch[i]);
            int wordWidth = fm.stringWidth(temp);
            if (rect.width - length - wordWidth < 0) {
                length = 5;
                ++rowIndex;
            }
            if ((y = rect.y + 16 + height * rowIndex) > rect.height - 5) break;
            if (y > rect.height - 5 - height && rect.width - length < 100 && rowIndex > 1) {
                g.drawString(".", length, y);
            } else {
                g.drawString(temp, length, y);
            }
            length += wordWidth;
        }
        g.setFont(oldFont);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.c.getType() == 1) {
            FontMetrics fm = c.getFontMetrics(this.model.getFont());
            return new Dimension(SwingUtilities.computeStringWidth(fm, this.model.getText()) + this.insetLeft + this.insetRight, (int)((double)fm.getHeight() * 1.5) + this.arrowHeight + this.insetBottom);
        }
        View v = (View)c.getClientProperty("view");
        return new Dimension((int)v.getPreferredSpan(0) + this.insetLeft + this.insetRight, (int)v.getPreferredSpan(1) + this.arrowHeight + this.insetBottom);
    }

    public Rectangle getRenderArea(int type) {
        Dimension d = this.c.getPreferredSize();
        switch (type) {
            case 1: {
                if (this.c.getType() == 1) {
                    return new Rectangle(this.insetLeft, this.arrowHeight, d.width, d.height + 5);
                }
                return new Rectangle(this.insetLeft, this.arrowHeight, d.width, d.height);
            }
            case 2: {
                if (this.c.getType() == 1) {
                    return new Rectangle(this.insetLeft, 0, d.width, d.height - 5);
                }
                return new Rectangle(this.insetLeft, 0, d.width, d.height);
            }
        }
        return null;
    }

    public void setArrowHeight(int height) {
        this.arrowHeight = height;
    }

    public void setRadian(int radian) {
        this.radian = radian;
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            KingdeeInfoTipUI.this.c.setShowing(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            KingdeeInfoTipUI.this.c.setShowing(false);
        }
    }
}

