/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.MultiLangItem;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import com.kingdee.cosmic.ctrl.swing.plaf.DefaultMultiLangBoxUI;
import com.kingdee.cosmic.ctrl.swing.plaf.MultiLangBoxEditor;
import com.kingdee.cosmic.ctrl.swing.plaf.MultiLangBoxPopup;
import com.kingdee.cosmic.ctrl.swing.plaf.MultiLangIcon;
import com.kingdee.cosmic.ctrl.swing.plaf.MultiLangListCellRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.ComboPopup;

public class KingdeeMultiLangBoxUI
extends DefaultMultiLangBoxUI {
    protected FocusListener focusHandler;
    protected DataChangeHandler dataChangeHandler;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeMultiLangBoxUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Font fn = UIManager.getFont("TextField.font");
        this.comboBox.setFont(fn);
        this.comboBox.setBackground(UIManager.getColor("TextField.background"));
    }

    @Override
    protected void uninstallDefaults() {
        this.comboBox.setBorder(null);
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusHandler = this.createFocusHandler();
        this.dataChangeHandler = this.createChangeHandler();
        ComboBoxEditor edt = this.comboBox.getEditor();
        if (edt instanceof MultiLangBoxEditor) {
            MultiLangBoxEditor mledt = (MultiLangBoxEditor)edt;
            mledt.addFocusListener(this.focusHandler);
            mledt.addDataChangeListener(this.dataChangeHandler);
        }
    }

    @Override
    protected void uninstallListeners() {
        ComboBoxEditor edt = this.comboBox.getEditor();
        if (edt instanceof MultiLangBoxEditor) {
            MultiLangBoxEditor mledt = (MultiLangBoxEditor)edt;
            mledt.removeFocusListener(this.focusHandler);
            mledt.removeDataChangeListener(this.dataChangeHandler);
        }
        super.uninstallListeners();
    }

    protected FocusListener createFocusHandler() {
        return new MultiLangBoxFocusHandler(this.comboBox);
    }

    protected DataChangeHandler createChangeHandler() {
        return new DataChangeHandler();
    }

    @Override
    protected JButton createArrowButton() {
        MultiLangBoxButton button = new MultiLangBoxButton();
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setBorder(null);
        button.setBackground(UIManager.getColor("TextField.background"));
        button.setIcon(MultiLangIcon.NULLICON);
        button.setFocusable(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KingdeeMultiLangBoxUI.this.comboBox.syncNullItemData();
            }
        });
        return button;
    }

    @Override
    protected ComboPopup createPopup() {
        MultiLangBoxPopup popup = new MultiLangBoxPopup((JComboBox)this.comboBox);
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        popup.setBorder(BorderFactory.createLineBorder(UIManager.getColor("ComboBox.popupBorderLineColor")));
        return popup;
    }

    @Override
    protected ListCellRenderer createRenderer() {
        return new MultiLangListCellRenderer(this.comboBox, this.arrowButton);
    }

    @Override
    protected ItemListener createItemListener() {
        return new MulitLangItemHandler();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new MultiLangBoxEditor.UIResource();
    }

    protected void setArrowButtonIcon(Icon newIcon) {
        if (newIcon != this.arrowButton.getIcon()) {
            this.arrowButton.setIcon(newIcon);
        }
    }

    protected static class MultiLangBoxButton
    extends JButton {
        private static final long serialVersionUID = -7609856864816944145L;
        private static Image initBackgroundPic = ((ImageIcon)UIManager.getIcon("MultiLangBox.initBackgroundPic")).getImage();
        private static Image mousedownBackgroundPic = ((ImageIcon)UIManager.getIcon("MultiLangBox.mousedownBackgroundPic")).getImage();
        private static Image mouseoverBackgroundPic = ((ImageIcon)UIManager.getIcon("MultiLangBox.mouseoverBackgroundPic")).getImage();
        private static Image disableBackgroundPic = ((ImageIcon)UIManager.getIcon("MultiLangBox.disableBackgroundPic")).getImage();

        public MultiLangBoxButton(Icon icon) {
            super(icon);
            this.setRolloverEnabled(true);
        }

        public MultiLangBoxButton() {
            this.setRolloverEnabled(true);
        }

        @Override
        public void paint(Graphics g) {
            Color origColor = g.getColor();
            int w = this.getSize().width;
            int h = this.getSize().height;
            boolean isPressed = this.model.isPressed() && this.model.isArmed();
            boolean isRollover = this.isRolloverEnabled() && this.model.isRollover();
            boolean isEnabled = this.model.isEnabled();
            if (isEnabled) {
                if (isRollover) {
                    if (isPressed) {
                        this.draw2(g, UIManager.getColor("MultiLangBox.mousedownBorderColor"), UIManager.getColor("MultiLangBox.mousedownLightBorderColor"), UIManager.getColor("MultiLangBox.mousedownDarkBorderColor"), mousedownBackgroundPic, w, h);
                        g.translate(1, 1);
                    } else {
                        this.draw2(g, UIManager.getColor("MultiLangBox.mouseoverBorderColor"), UIManager.getColor("MultiLangBox.mouseoverLightBorderColor"), UIManager.getColor("MultiLangBox.mouseoverDarkBorderColor"), mouseoverBackgroundPic, w, h);
                    }
                } else {
                    this.draw2(g, UIManager.getColor("MultiLangBox.mousedownBorderColor"), UIManager.getColor("MultiLangBox.mousedownLightBorderColor"), UIManager.getColor("MultiLangBox.mousedownDarkBorderColor"), initBackgroundPic, w, h);
                }
            } else {
                this.draw2(g, UIManager.getColor("MultiLangBox.disableBorderColor"), UIManager.getColor("MultiLangBox.disableLightBorderColor"), UIManager.getColor("MultiLangBox.disableDarkBorderColor"), disableBackgroundPic, w, h);
            }
            g.setColor(origColor);
            Icon icon = this.getIcon();
            icon.paintIcon(this, g, (w - icon.getIconWidth()) / 2 + 1, (h - icon.getIconHeight()) / 2);
            if (isPressed) {
                g.translate(1, 1);
            }
        }

        private void draw2(Graphics g, Color borderColor, Color lightBorderColor, Color darkBorderColor, Image backgroundImage, int w, int h) {
            g.drawImage(backgroundImage, 0, 0, this);
            g.setColor(borderColor);
            g.drawLine(0, 0, 0, h);
        }
    }

    protected class DataChangeHandler
    implements DataChangeListener {
        protected DataChangeHandler() {
        }

        @Override
        public void dataChanged(DataChangeEvent eventObj) {
            JPopupMenu pop;
            Object data = eventObj.getNewValue();
            KingdeeMultiLangBoxUI.this.comboBox.setSelectedItemData(data, false);
            if (KingdeeMultiLangBoxUI.this.popup != null && (pop = (JPopupMenu)((Object)KingdeeMultiLangBoxUI.this.popup)).isShowing()) {
                pop.repaint();
            }
        }
    }

    public static class MultiLangBoxFocusHandler
    implements FocusListener {
        protected JComponent comboBox;

        public MultiLangBoxFocusHandler(JComponent comp) {
            this.comboBox = comp;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.comboBox.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.comboBox.repaint();
        }
    }

    public class MulitLangItemHandler
    extends DefaultMultiLangBoxUI.ItemHandler {
        public MulitLangItemHandler() {
            super(KingdeeMultiLangBoxUI.this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object item;
            super.itemStateChanged(e);
            if (e.getStateChange() == 1 && (item = e.getItem()) instanceof MultiLangItem) {
                KingdeeMultiLangBoxUI.this.setArrowButtonIcon(((MultiLangItem)item).getIcon());
            }
        }
    }
}

