/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDPasswordField;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeBorders;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import org.apache.log4j.Logger;

public class KingdeePasswordFieldUI
extends BasicPasswordFieldUI {
    private static final Logger logger = LogUtil.getPackageLogger(KingdeePasswordFieldUI.class);
    private JTextField tf;

    public KingdeePasswordFieldUI(JComponent comp) {
        this.tf = (JTextField)comp;
    }

    public static ComponentUI createUI(JComponent c) {
        return new KingdeePasswordFieldUI(c);
    }

    @Override
    protected String getPropertyPrefix() {
        return "PasswordField";
    }

    @Override
    public void installUI(JComponent comp) {
        super.installUI(comp);
        this.tf.setBackground(UIManager.getColor("TextField.background"));
        this.tf.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
        this.tf.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
        this.tf.setBorder(KingdeeBorders.createEditorBorder());
        this.tf.setDisabledTextColor(UIManager.getColor("TextField.disableForeground"));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        InputMap inputMap = this.tf.getInputMap();
        ActionMap actionMap = this.tf.getActionMap();
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, "undo-KDPasswordField");
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, "redo-KDPasswordField");
        actionMap.put("undo-KDPasswordField", new UndoAction());
        actionMap.put("redo-KDPasswordField", new RedoAction());
    }

    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners();
        InputMap inputMap = this.tf.getInputMap();
        ActionMap actionMap = this.tf.getActionMap();
        inputMap.remove(KeyStroke.getKeyStroke(90, 2, false));
        inputMap.remove(KeyStroke.getKeyStroke(89, 2, false));
        actionMap.remove("undo-KDPasswordField");
        actionMap.remove("redo-KDPasswordField");
    }

    @Override
    protected void paintBackground(Graphics g) {
        if (this.tf.isEnabled()) {
            super.paintBackground(g);
        } else {
            g.setColor(UIManager.getColor("TextField.disableBackground"));
            g.fillRect(0, 0, this.tf.getWidth(), this.tf.getHeight());
        }
    }

    private int getHorAlignValue() {
        return this.tf.getHorizontalAlignment();
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        int tempHori = this.getHorAlignValue();
        if (rect != null) {
            if (tempHori == 4) {
                rect.x = -1;
            } else if (tempHori == 10) {
                rect.x = 3;
            }
        }
        return rect;
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -1553374361061207782L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (((KDPasswordField)((KingdeePasswordFieldUI)KingdeePasswordFieldUI.this).tf).manager.canRedo()) {
                    ((KDPasswordField)((KingdeePasswordFieldUI)KingdeePasswordFieldUI.this).tf).manager.redo();
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -4095070234429868262L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (((KDPasswordField)((KingdeePasswordFieldUI)KingdeePasswordFieldUI.this).tf).manager.canUndo()) {
                    ((KDPasswordField)((KingdeePasswordFieldUI)KingdeePasswordFieldUI.this).tf).manager.undo();
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }
}

