/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.DefaultTextField;
import com.kingdee.cosmic.ctrl.swing.KDPromptBox;
import com.kingdee.cosmic.ctrl.swing.KDPromptPopup;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import com.kingdee.cosmic.ctrl.swing.util.CtrlImageUtilities;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.JTextComponent;

public class KingdeePromptBoxUI
extends ComponentUI {
    protected Image icon_off = KDResourceManager.getImageOfRapid("prompt_off.gif");
    protected Image icon_disable = KDResourceManager.getImageOfRapid("prompt_disable.gif");
    protected Image icon_clear = KDResourceManager.getImageOfRapid("prompt_clear.gif");
    protected static final Color BGCOLOR = new Color(7645403);
    protected static final Color BGCOLORDISABLE = new Color(0xA7A7A7);
    protected static final int BUTTONSIZE = 19;
    protected static final Dimension MINSIZE = new Dimension(30, 19);
    protected static final Dimension MAXSIZE = new Dimension(Integer.MAX_VALUE, 19);
    protected static final Dimension PREFERREDSIZE = new Dimension(79, 19);
    protected KDPromptBox pb;
    protected JButton btn;
    protected JLabel label;
    protected boolean required = false;
    protected boolean readOnly = false;
    protected boolean editable = false;
    protected PromptBoxListener listener;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    protected PromptBoxLayout pl;
    private transient Popup popup = null;
    private KDPromptPopup downPanel = null;
    boolean isCtrlDown = false;

    public Icon getIconOff() {
        return this.btn.getIcon();
    }

    public Icon getDisabledIcon() {
        return this.btn.getDisabledIcon();
    }

    public void setIconOff(Image icon) {
        this.btn.setIcon(new ImageIcon(icon));
        this.icon_off = icon;
    }

    public void setDisabledIcon(Image icon) {
        this.btn.setDisabledIcon(new ImageIcon(icon));
        this.icon_disable = icon;
    }

    public void setIconClear(Image icon) {
        this.icon_clear = icon;
    }

    public static ComponentUI createUI(JComponent c) {
        return new KingdeePromptBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.pb = (KDPromptBox)c;
        this.listener = this.createPromptBoxListener(c);
        JTextComponent edt = (JTextComponent)this.pb.getEditor();
        edt.setBorder(KingdeeBorders.createWideEditorBorder());
        this.btn = this.createButton();
        this.label = this.pb.getLabel();
        this.label.setForeground(UIManager.getColor("PromptBox.labelForeground"));
        this.installListeners();
        this.pl = new PromptBoxLayout();
        this.pb.setLayout(this.pl);
        if (edt instanceof KDTextArea) {
            c.add("Editor", new KDScrollPane(edt));
        } else {
            c.add("Editor", edt);
        }
        c.add("Button", this.btn);
        c.add("Label", this.label);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.pb.setLayout(null);
        c.removeAll();
    }

    public JButton getButton() {
        return this.btn;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.readOnly) {
            ((JTextComponent)this.pb.getEditor()).setEditable(false);
            this.pb.getEditor().setForeground(UIManager.getColor("TextField.readonlyForeground"));
            this.pb.getEditor().setBackground(UIManager.getColor("TextField.readonlyBackground"));
        } else if (this.pb.isEnabled()) {
            String text = ((JTextComponent)this.pb.getEditor()).getText();
            FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
            double tw = ((Graphics2D)g).getFont().getStringBounds(text, frc).getWidth();
            double ew = this.pb.getEditor().getVisibleRect().width;
            if (this.pb.isLabelVisible() && StringUtils.isEmpty(this.pb.getLabel().getToolTipText()) && !StringUtils.isEmpty(text = this.pb.getLabelText()) && (tw = ((Graphics2D)g).getFont().getStringBounds(text, frc).getWidth()) > (ew = (double)this.pb.getLabel().getVisibleRect().width)) {
                this.pb.getLabel().setToolTipText(null);
                this.pb.getLabel().setToolTipText(text);
            }
            if (this.pb.isRequired()) {
                if (this.pb.isEditable()) {
                    ((JTextComponent)this.pb.getEditor()).setEditable(true);
                    this.pb.getEditor().setForeground(UIManager.getColor("TextField.foreground"));
                } else {
                    ((JTextComponent)this.pb.getEditor()).setEditable(false);
                    this.pb.getEditor().setForeground(UIManager.getColor("TextField.unEditabledFg"));
                }
                this.pb.getEditor().setBackground(UIManager.getColor("TextField.requiredBackground"));
            } else {
                if (this.pb.isEditable()) {
                    ((JTextComponent)this.pb.getEditor()).setEditable(true);
                    this.pb.getEditor().setForeground(UIManager.getColor("TextField.foreground"));
                } else {
                    ((JTextComponent)this.pb.getEditor()).setEditable(false);
                    this.pb.getEditor().setForeground(UIManager.getColor("TextField.unEditabledFg"));
                }
                this.pb.getEditor().setBackground(UIManager.getColor("TextField.background"));
            }
        }
    }

    protected JTextComponent createEditor() {
        DefaultTextField tf = new DefaultTextField();
        ((JTextComponent)tf).setEditable(false);
        return tf;
    }

    protected JButton createButton() {
        JButton b = new JButton();
        b.setUI(new BtnUI(this.pb, b));
        b.setIcon(new ImageIcon(this.icon_off));
        b.setBorder(KingdeeBorders.createF7ButtonBorder());
        b.setBackground(BGCOLOR);
        b.setDisabledIcon(new ImageIcon(this.icon_disable));
        b.setFocusable(false);
        return b;
    }

    protected void configureDownPanel() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        if (this.popup == null) {
            this.createDownPanel();
            if (!this.pb.hasDownPanel() || !this.pb.isVisible()) {
                return;
            }
            Point parentLocationOnScreen = null;
            try {
                parentLocationOnScreen = this.pb.getLocationOnScreen();
            }
            catch (Exception e) {
                this.pb.setHasDownPanel(false);
                return;
            }
            Point p = new Point(parentLocationOnScreen.x, parentLocationOnScreen.y + this.pb.getHeight());
            int screenWidth = GraphicsEnvironment.isHeadless() ? 1920 : Toolkit.getDefaultToolkit().getScreenSize().width;
            int width = (int)this.downPanel.getPreferredSize().getWidth();
            if (p.x + width > screenWidth) {
                p.x -= width;
            }
            this.popup = PopupFactory.getSharedInstance().getPopup(this.pb, this.downPanel, p.x, p.y);
        }
    }

    protected void createDownPanel() {
        this.downPanel = this.pb.getDownPanel();
    }

    protected void installListeners() {
        JTextComponent edt = (JTextComponent)this.pb.getEditor();
        edt.addKeyListener(this.listener);
        edt.addFocusListener(this.listener);
        edt.getDocument().addDocumentListener(this.listener);
        this.btn.addActionListener(this.listener);
        this.pb.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        JTextComponent edt = (JTextComponent)this.pb.getEditor();
        edt.removeKeyListener(this.listener);
        edt.removeFocusListener(this.listener);
        edt.getDocument().removeDocumentListener(this.listener);
        this.btn.removeActionListener(this.listener);
        this.pb.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected PromptBoxListener createPromptBoxListener(JComponent pb) {
        return new PromptBoxListener();
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(MAXSIZE);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(MINSIZE);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(PREFERREDSIZE);
    }

    public synchronized void setCtrlDown(boolean isDown) {
        if (this.isCtrlDown == isDown) {
            return;
        }
        this.isCtrlDown = isDown;
        if (!this.pb.isReadOnly()) {
            if (this.isCtrlDown) {
                this.btn.setIcon(new ImageIcon(this.icon_clear));
            } else {
                this.btn.setIcon(new ImageIcon(this.icon_off));
            }
        } else {
            this.btn.setIcon(CtrlImageUtilities.createDisableIcon(new ImageIcon(this.icon_off)));
        }
    }

    public void popDownPanel() {
        if (!this.pb.hasDownPanel() && this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        this.configureDownPanel();
        if (this.pb.hasDownPanel()) {
            this.popup.show();
        }
    }

    public void closeDownPanel() {
        if (this.popup != null) {
            this.pb.setHasDownPanel(false);
            this.popup.hide();
            this.popup = null;
        }
    }

    private void updateEnabledState(Container c, boolean enabled) {
        for (int counter = c.getComponentCount() - 1; counter >= 0; --counter) {
            Component child = c.getComponent(counter);
            child.setEnabled(enabled);
            if (!(child instanceof Container)) continue;
            this.updateEnabledState((Container)child, enabled);
        }
        if (enabled) {
            this.btn.setBackground(BGCOLOR);
        } else {
            this.btn.setBackground(BGCOLORDISABLE);
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledState(this.pb, this.pb.isEnabled());
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JComponent c = (JComponent)e.getSource();
            String propertyName = e.getPropertyName();
            KDPromptBox pb = (KDPromptBox)e.getSource();
            KingdeePromptBoxUI ui = pb.getUI();
            if ("enabled".equals(propertyName)) {
                ui.updateEnabledState();
            } else if (propertyName.equals("editable")) {
                KingdeePromptBoxUI.this.editable = (Boolean)e.getNewValue();
                c.repaint();
            } else if (propertyName.equals("required")) {
                KingdeePromptBoxUI.this.required = (Boolean)e.getNewValue();
                c.repaint();
            } else if (propertyName.equals("readOnly")) {
                KingdeePromptBoxUI.this.readOnly = (Boolean)e.getNewValue();
                c.repaint();
            }
        }
    }

    public class PromptBoxListener
    implements KeyListener,
    ActionListener,
    FocusListener,
    DocumentListener {
        protected boolean isCtrlDown() {
            return KingdeePromptBoxUI.this.isCtrlDown;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 118 || keyCode == 34) {
                if (KingdeePromptBoxUI.this.btn.isEnabled() && KingdeePromptBoxUI.this.pb.isEdittedStop()) {
                    KingdeePromptBoxUI.this.pb.setDataBySelector();
                }
            } else if (keyCode == 119) {
                if (KingdeePromptBoxUI.this.btn.isEnabled() && KingdeePromptBoxUI.this.pb.isEdittedStop()) {
                    KingdeePromptBoxUI.this.pb.popupDownPanel(KingdeePromptBoxUI.this.pb.getText());
                }
            } else if (e.isControlDown()) {
                KingdeePromptBoxUI.this.setCtrlDown(true);
            } else if (e.getKeyCode() == 38 ? KingdeePromptBoxUI.this.pb.hasDownPanel() : e.getKeyCode() != 40 || KingdeePromptBoxUI.this.pb.hasDownPanel()) {
                // empty if block
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 17) {
                KingdeePromptBoxUI.this.setCtrlDown(false);
            } else if ((keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90 || keyCode >= 96 && keyCode <= 105 || keyCode == 8 || keyCode == 127 || keyCode == 32) && KingdeePromptBoxUI.this.btn.isEnabled() && KingdeePromptBoxUI.this.pb.isEdittedStop()) {
                if (KingdeePromptBoxUI.this.pb.getText() == null || KingdeePromptBoxUI.this.pb.getText().equals("")) {
                    if (KingdeePromptBoxUI.this.popup != null) {
                        KingdeePromptBoxUI.this.popup.hide();
                        KingdeePromptBoxUI.this.popup = null;
                    }
                } else {
                    KingdeePromptBoxUI.this.pb.popupDownPanel(KingdeePromptBoxUI.this.pb.getText());
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (!KingdeePromptBoxUI.this.pb.hasFocus()) {
                    CtrlSwingUtilities.checkFocusAndCommit();
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Object comp = e.getSource();
            if (comp == KingdeePromptBoxUI.this.btn) {
                if (!KingdeePromptBoxUI.this.pb.hasFocus()) {
                    KingdeePromptBoxUI.this.pb.requestFocus();
                }
                if (!KingdeePromptBoxUI.this.pb.isReadOnly()) {
                    if (this.isCtrlDown()) {
                        KingdeePromptBoxUI.this.pb.setDataForCtrlDown(null);
                    } else {
                        KingdeePromptBoxUI.this.pb.setDataBySelector();
                    }
                } else {
                    KingdeePromptBoxUI.this.pb.setDataBySelector();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (KingdeePromptBoxUI.this.pb.getClientProperty("EditorForKDTable") != null) {
                return;
            }
            if (!KingdeePromptBoxUI.this.pb.isDirty()) {
                KingdeePromptBoxUI.this.pb.updateData();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            KingdeePromptBoxUI.this.setCtrlDown(false);
            if (!e.isTemporary()) {
                if (KingdeePromptBoxUI.this.pb.isDirty() && !KingdeePromptBoxUI.this.pb.isHasCommitEdit()) {
                    try {
                        KingdeePromptBoxUI.this.pb.commitEdit();
                    }
                    catch (ParseException e1) {
                        if (KingdeePromptBoxUI.this.pb.isDirty()) {
                            KingdeePromptBoxUI.this.pb.updateData();
                        }
                        KingdeePromptBoxUI.this.pb.requestFocus();
                        KingdeePromptBoxUI.this.pb.setTextSelected();
                    }
                } else {
                    KingdeePromptBoxUI.this.pb.updateData();
                    if (KingdeePromptBoxUI.this.popup != null) {
                        KingdeePromptBoxUI.this.closeDownPanel();
                    }
                }
                KingdeePromptBoxUI.this.pb.setHasCommitEdit(false);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            KingdeePromptBoxUI.this.pb.setDirty(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            KingdeePromptBoxUI.this.pb.setDirty(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            KingdeePromptBoxUI.this.pb.setDirty(true);
        }
    }

    private class PopupWindowHandler
    extends WindowAdapter {
        private PopupWindowHandler() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            KingdeePromptBoxUI.this.pb.getEditor().requestFocusInWindow();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (KingdeePromptBoxUI.this.popup != null) {
                KingdeePromptBoxUI.this.closeDownPanel();
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            KingdeePromptBoxUI.this.pb.getDownPanel().requestFocusForComponent();
        }
    }

    private static class PromptBoxLayout
    implements LayoutManager {
        private static final Dimension ZEROSIZE = new Dimension(0, 0);
        private Component button = null;
        private Component editor = null;
        private Component label = null;

        private PromptBoxLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if ("Button".equals(name)) {
                this.button = comp;
            } else if ("Editor".equals(name)) {
                this.editor = comp;
            } else if ("Label".equals(name)) {
                this.label = comp;
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int labelX;
            int buttonsX;
            int editorX;
            KDPromptBox pb = (KDPromptBox)parent;
            int align = pb.getAlignment();
            int labelLength = pb.getLabelLength();
            int editorLength = pb.getEditorLength();
            boolean labelVisible = pb.isLabelVisible();
            Insets insets = parent.getInsets();
            int availWidth = parent.getWidth() - (insets.left + insets.right);
            int availHeight = parent.getHeight() - (insets.top + insets.bottom);
            Dimension buttonD = new Dimension(19, 19);
            labelLength = availWidth - buttonD.width - editorLength - 4;
            labelLength = labelLength < 0 ? 0 : labelLength;
            Dimension labelD = null;
            labelD = labelLength == 0 || !labelVisible ? new Dimension(0, 0) : new Dimension(labelLength, 19);
            int buttonWidth = buttonD.width;
            int labelWidth = labelD.width;
            int editorWidth = 0;
            editorWidth = labelWidth == 0 ? availWidth - buttonWidth - 2 : availWidth - buttonWidth - labelWidth - 4;
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                buttonsX = editorX + editorWidth + 2;
                labelX = labelWidth != 0 ? buttonsX + buttonWidth + 2 : buttonsX + buttonWidth;
            } else {
                labelX = insets.left;
                if (labelWidth == 0) {
                    buttonsX = insets.left;
                    editorX = buttonsX + buttonWidth + 2;
                } else {
                    buttonsX = labelX + labelWidth + 2;
                    editorX = buttonsX + buttonWidth + 2;
                }
            }
            int y = 0;
            if (align == 2) {
                y = (availHeight - buttonD.height) / 2;
            } else if (align == 3) {
                y = availHeight - buttonD.height;
            }
            this.setBounds(this.editor, editorX, y += insets.top, editorWidth, availHeight);
            this.setBounds(this.button, buttonsX, y, buttonWidth, buttonD.height);
            this.setBounds(this.label, labelX, y, labelWidth, buttonD.height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension buttonD = new Dimension(19, 19);
            Dimension editorD = new Dimension(this.preferredSize((Component)this.editor).width, 19);
            Dimension size = new Dimension(buttonD.width, buttonD.height);
            size.width += editorD.width;
            if (parent != null) {
                Insets insets = parent.getInsets();
                size.width += insets.left + insets.right;
                size.height += insets.top + insets.bottom;
            }
            return size;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        private void setBounds(Component comp, int x, int y, int width, int height) {
            if (comp != null) {
                comp.setBounds(x, y, width, height);
            }
        }

        private Dimension preferredSize(Component comp) {
            return comp == null ? ZEROSIZE : comp.getPreferredSize();
        }
    }

    protected static class BtnUI
    extends BasicButtonUI {
        protected KDPromptBox pb;
        protected JButton btn;

        public BtnUI(KDPromptBox pb, JButton btn) {
            this.pb = pb;
            this.btn = btn;
        }

        @Override
        protected int getTextShiftOffset() {
            return 1;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            if (this.btn.isEnabled()) {
                this.fillContentArea(g, (AbstractButton)c, c.getBackground());
                this.btn.setToolTipText(this.pb.getButtonTooltipsText());
            } else {
                this.btn.setToolTipText(this.pb.getButtonTooltipsText());
                this.fillContentArea(g, (AbstractButton)c, UIManager.getColor("PromptBox.disableBackground"));
            }
            super.paint(g, c);
        }

        @Override
        protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
            super.paintIcon(g, c, iconRect);
        }

        private void fillContentArea(Graphics g, AbstractButton b, Color fillColor) {
            Insets margin = b.getMargin();
            Insets insets = b.getInsets();
            Dimension size = b.getSize();
            if (b.isContentAreaFilled()) {
                g.setColor(fillColor);
                g.fillRect(insets.left - margin.left, insets.top - margin.top, size.width - (insets.left - margin.left) - (insets.right - margin.right), size.height - (insets.top - margin.top) - (insets.bottom - margin.bottom));
            }
        }
    }
}

