/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.KDStatusBar;
import com.kingdee.cosmic.ctrl.swing.SimpleStatusBarPart;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class KingdeeStatusBarUI
extends ComponentUI {
    public static final int SHADOW_HORIZONTAL = 1;
    public static final int SHADOW_VERTICAL = 2;
    private JComponent c;
    private Color firstShadowColor = null;
    private Color secondShadowColor = null;
    private Color thirdShadowColor = null;
    private Color fourthShadowColor = null;
    private Color fifthsShadowColor = null;
    private int shadowOrientation = 2;

    public KingdeeStatusBarUI(JComponent c) {
        this.c = c;
    }

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeStatusBarUI(c);
    }

    @Override
    public void installUI(JComponent c) {
        ((KDStatusBar)c).setLayout(this.createLayout());
        this.installDefaults((KDStatusBar)c);
        this.installComponents((KDStatusBar)c);
        this.installListeners((KDStatusBar)c);
    }

    protected void installDefaults(KDStatusBar c) {
        this.initSelfColors();
    }

    protected void initSelfColors() {
        this.firstShadowColor = UIManager.getColor("StatusBar.firstShadowColor");
        if (this.firstShadowColor == null) {
            this.firstShadowColor = Color.decode("#E6EDF3");
        }
        this.secondShadowColor = UIManager.getColor("StatusBar.secondShadowColor");
        if (this.secondShadowColor == null) {
            this.secondShadowColor = Color.decode("#E5EDF3");
        }
        this.thirdShadowColor = UIManager.getColor("StatusBar.thirdShadowColor");
        if (this.thirdShadowColor == null) {
            this.thirdShadowColor = Color.decode("#E4EBF2");
        }
        this.fourthShadowColor = UIManager.getColor("StatusBar.fourthShadowColor");
        if (this.fourthShadowColor == null) {
            this.fourthShadowColor = Color.decode("#E2E9F1");
        }
        this.fifthsShadowColor = UIManager.getColor("StatusBar.fifthsShadowColor");
        if (this.fifthsShadowColor == null) {
            this.fifthsShadowColor = Color.decode("#D3E0EB");
        }
        this.shadowOrientation = UIManager.getInt("StatusBar.shadowOrientation");
    }

    protected void installComponents(KDStatusBar c) {
    }

    protected void installListeners(KDStatusBar c) {
    }

    protected void unInstallComponents(KDStatusBar c) {
    }

    protected void unInstallListeners(KDStatusBar c) {
    }

    protected LayoutManager createLayout() {
        return new StatusBarLayout();
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return super.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return super.getAccessibleChildrenCount(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return c.getLayout().preferredLayoutSize(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.paintSelfBackground(g);
    }

    protected void paintSelfBackground(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        Rectangle rect = this.c.getBounds();
        if (this.shadowOrientation == 2) {
            int height = this.c.getHeight();
            float perHeight1 = 1.0f;
            float perHeight2 = 9.0f;
            float perHeight3 = 1.0f;
            float perHeight4 = 9.0f;
            float x0 = 0.0f;
            float y0 = 0.0f;
            float x1 = x0;
            float y1 = y0 + perHeight1;
            float x2 = x1;
            float y2 = y1 + perHeight2;
            float x3 = x2;
            float y3 = y2 + perHeight3;
            float x4 = x3;
            float y4 = y3 + perHeight4;
            GradientPaint gradient = new GradientPaint(x0, y0, this.firstShadowColor, x1, y1, this.secondShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x0, (int)y0, rect.width, (int)perHeight1);
            gradient = new GradientPaint(x1, y1, this.secondShadowColor, x2, y2, this.thirdShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x1, (int)y1, rect.width, (int)perHeight2);
            gradient = new GradientPaint(x2, y2, this.thirdShadowColor, x3, y3, this.fourthShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x2, (int)y2, rect.width, (int)perHeight3);
            gradient = new GradientPaint(x3, y3, this.fourthShadowColor, x4, y4, this.fifthsShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x3, (int)y3, rect.width, height - (int)y3);
        } else if (this.shadowOrientation == 1) {
            int width = this.c.getWidth();
            int perWidth = width / 4;
            float x0 = 0.0f;
            float y0 = 0.0f;
            float x1 = x0 + (float)perWidth;
            float y1 = y0;
            float x2 = x1 + (float)perWidth;
            float y2 = y1;
            float x3 = x2 + (float)perWidth;
            float y3 = y2;
            float x4 = x3 + (float)perWidth;
            float y4 = y3;
            GradientPaint gradient = new GradientPaint(x0, y0, this.firstShadowColor, x1, y1, this.secondShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x0, (int)y0, perWidth, rect.height);
            gradient = new GradientPaint(x1, y1, this.secondShadowColor, x2, y2, this.thirdShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x1, (int)y1, perWidth, rect.height);
            gradient = new GradientPaint(x2, y2, this.thirdShadowColor, x3, y3, this.fourthShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x2, (int)y2, perWidth, rect.height);
            gradient = new GradientPaint(x3, y3, this.fourthShadowColor, x4, y4, this.fifthsShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x3, (int)y3, width - (int)x3, rect.height);
        }
        g2d.setPaint(oldPaint);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.unInstallListeners((KDStatusBar)c);
        this.unInstallComponents((KDStatusBar)c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    private static class StatusBarLayout
    implements LayoutManager {
        private StatusBarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                this.leftToRight(parent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void leftToRight(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int height;
                Dimension retrDim = this.calculate(parent);
                int count = parent.getComponentCount();
                int x = 0;
                int y = 0;
                Rectangle parentRect = parent.getBounds();
                int compH = height = parentRect.height;
                for (int i = 0; i < count; ++i) {
                    Insets compIns;
                    Component comp = parent.getComponent(i);
                    if (!comp.isVisible() || !(comp instanceof SimpleStatusBarPart)) continue;
                    boolean isR = ((SimpleStatusBarPart)comp).isRetractable();
                    int hgrap = ((SimpleStatusBarPart)comp).getHgrap();
                    Dimension dim = comp.getPreferredSize();
                    if (isR) {
                        dim = retrDim;
                    }
                    compIns = (compIns = ((JComponent)comp).getInsets()) != null ? compIns : new Insets(0, 0, 0, 0);
                    x = x + hgrap + compIns.left;
                    y = compIns.top;
                    int compW = dim.width;
                    compH = height - compIns.top - compIns.bottom;
                    comp.setLocation(x, y);
                    comp.setSize(compW, compH);
                    x += compW;
                }
            }
        }

        private Dimension calculate(Container parent) {
            boolean isR;
            Component[] comps = parent.getComponents();
            Rectangle rect = parent.getBounds();
            Dimension tempDim = new Dimension(rect.width, rect.height);
            int count = comps.length;
            int retrCount = 0;
            for (int i = 0; i < count; ++i) {
                Component comp = comps[i];
                isR = ((SimpleStatusBarPart)comp).isRetractable();
                if (!isR) continue;
                ++retrCount;
            }
            if (retrCount == 0) {
                Component tempComp = comps[0];
                ((SimpleStatusBarPart)tempComp).setRetractable(true);
            }
            retrCount = 0;
            for (int j = 0; j < count; ++j) {
                Component compt = comps[j];
                isR = ((SimpleStatusBarPart)compt).isRetractable();
                if (!isR) {
                    tempDim.width -= compt.getPreferredSize().width;
                    continue;
                }
                ++retrCount;
            }
            if (retrCount > 0) {
                tempDim.width /= retrCount;
                tempDim.width = Math.max(tempDim.width, 5);
            }
            return tempDim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int count = parent.getComponentCount();
                int height = 0;
                int width = insets.right + insets.left;
                for (int i = 0; i < count; ++i) {
                    Component comp = parent.getComponent(i);
                    if (!comp.isVisible() || !(comp instanceof SimpleStatusBarPart)) continue;
                    Dimension dim = comp.getPreferredSize();
                    int hgrap = ((SimpleStatusBarPart)comp).getHgrap();
                    height = Math.max(height, dim.height + insets.top + insets.bottom);
                    width += hgrap + dim.width;
                }
                height = Math.max(height, parent.getBounds().height);
                width = Math.max(width, parent.getBounds().width);
                return new Dimension(width, height);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

