/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.DateTimeEditor;
import com.kingdee.cosmic.ctrl.swing.KDTimePicker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;

public class KingdeeTimePickerUI
extends ComponentUI {
    private KDTimePicker c = null;
    private int labelLength = -1;
    private int labelAlignment = 7;

    public static ComponentUI createUI(JComponent x) {
        return new KingdeeTimePickerUI();
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return super.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return super.getAccessibleChildrenCount(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = c.getLayout().preferredLayoutSize(c);
        if (dim != null) {
            dim.width += 4;
        }
        return dim;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.c = (KDTimePicker)c;
        this.installDefaults(this.c);
        this.c.setLayout(this.createDatePickerLayout());
        this.installComponents(this.c);
        this.installListeners(this.c);
        this.installKeyboardActions(this.c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    protected void installDefaults(KDTimePicker c) {
        this.labelAlignment = c.getLabelAlignment();
        this.labelLength = c.getLabelLength();
    }

    protected void installComponents(KDTimePicker c) {
        DateTimeEditor editor = c.getEditor();
        c.add((Component)editor, "editor");
        if (this.getCompositeLabel() != null) {
            c.add((Component)this.getCompositeLabel(), "label");
        }
    }

    protected void installListeners(KDTimePicker c) {
        c.addPropertyChangeListener(new TimePickerPropertyChangeListener());
    }

    protected void installKeyboardActions(KDTimePicker c) {
    }

    protected void unInstallDefaults() {
    }

    protected void unInstallComponents(KDTimePicker c) {
    }

    protected void unInstallDefaults(KDTimePicker c) {
    }

    protected void unInstallListeners(KDTimePicker c) {
    }

    protected void unInstallKeyboardActions(KDTimePicker c) {
    }

    protected LayoutManager createDatePickerLayout() {
        return new TimePickerLayout();
    }

    private JLabel getCompositeLabel() {
        return this.c.getCompositeLabel();
    }

    private boolean isCompositeLabelVisible() {
        if (this.getCompositeLabel() == null) {
            return false;
        }
        return this.getCompositeLabel().getText().length() > 0;
    }

    private void setLabelLength(Object newLabelLen) {
        if (newLabelLen instanceof Integer) {
            this.labelLength = (Integer)newLabelLen;
        }
    }

    private void setLabelAlignment(Object newLabelAlig) {
        if (newLabelAlig instanceof Integer) {
            this.labelAlignment = (Integer)newLabelAlig;
            if (this.getCompositeLabel() != null) {
                this.getCompositeLabel().setVerticalAlignment(1);
                switch (this.labelAlignment) {
                    case 2: 
                    case 3: {
                        this.getCompositeLabel().setHorizontalAlignment(4);
                        break;
                    }
                    case 1: {
                        this.getCompositeLabel().setHorizontalAlignment(0);
                        break;
                    }
                    default: {
                        this.getCompositeLabel().setHorizontalAlignment(2);
                    }
                }
            }
        }
    }

    private void setCompositeLable(Object old, Object newLabel) {
        if (newLabel instanceof JLabel) {
            if (old == null) {
                this.c.add((Component)this.getCompositeLabel(), "label");
            } else {
                this.c.remove((Component)old);
                this.c.add((Component)this.getCompositeLabel(), "label");
            }
            this.setLabelAlignment(this.labelAlignment);
        }
    }

    private void revalidateWithParent() {
        this.c.revalidate();
        Container ct = this.c.getParent();
        if (ct != null) {
            ct.validate();
        }
    }

    class TimePickerPropertyChangeListener
    implements PropertyChangeListener {
        TimePickerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("labelLength")) {
                KingdeeTimePickerUI.this.setLabelLength(evt.getNewValue());
                KingdeeTimePickerUI.this.revalidateWithParent();
            } else if (name.equals("labelAlignment")) {
                KingdeeTimePickerUI.this.setLabelAlignment(evt.getNewValue());
                KingdeeTimePickerUI.this.revalidateWithParent();
            } else if (name.equals("compositeLabel")) {
                KingdeeTimePickerUI.this.setCompositeLable(evt.getOldValue(), evt.getNewValue());
                KingdeeTimePickerUI.this.revalidateWithParent();
            } else if (name.equals("preferredSize")) {
                KingdeeTimePickerUI.this.revalidateWithParent();
            }
        }
    }

    private class TimePickerLayout
    implements LayoutManager {
        JComponent editor = null;
        JComponent label = null;

        private TimePickerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals("editor")) {
                this.editor = (JComponent)comp;
            } else if (name.equals("label")) {
                this.label = (JComponent)comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this.editor) {
                this.editor = null;
            }
            if (comp == this.label) {
                this.label = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                Dimension ediDim = this.editor.getPreferredSize();
                Dimension labDim = this.getLabDim();
                int w = ediDim.width + insets.left + insets.right;
                int h = ediDim.height + insets.top + insets.bottom;
                if (KingdeeTimePickerUI.this.isCompositeLabelVisible()) {
                    switch (KingdeeTimePickerUI.this.labelAlignment) {
                        case 1: 
                        case 2: 
                        case 8: {
                            h += labDim.height;
                            break;
                        }
                        default: {
                            w += labDim.width;
                        }
                    }
                }
                return new Dimension(w, h);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private Dimension getLabDim() {
            Dimension ediDim = this.editor.getPreferredSize();
            Dimension labDim = new Dimension(0, 0);
            if (this.label != null) {
                Dimension labPrfDim = this.label.getPreferredSize();
                if (KingdeeTimePickerUI.this.labelAlignment == 3 || KingdeeTimePickerUI.this.labelAlignment == 7) {
                    int labW = KingdeeTimePickerUI.this.labelLength == -1 ? labPrfDim.width : KingdeeTimePickerUI.this.labelLength;
                    labDim = new Dimension(labW, ediDim.height);
                } else {
                    int labH = KingdeeTimePickerUI.this.labelLength == -1 ? labPrfDim.height : KingdeeTimePickerUI.this.labelLength;
                    labDim = new Dimension(ediDim.width, labH);
                }
            }
            return labDim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                Dimension pDim = parent.getSize();
                Dimension ediDim = this.editor.getPreferredSize();
                Dimension labDim = this.getLabDim();
                int w = pDim.width - insets.left - insets.right;
                int h = pDim.height - insets.top - insets.bottom;
                int x = insets.left;
                int y = insets.top;
                if (!KingdeeTimePickerUI.this.isCompositeLabelVisible()) {
                    this.editor.setBounds(x, y, w, h);
                    return;
                }
                int tempW = 0;
                int tempH = 0;
                tempW = w >= ediDim.width + labDim.width ? w - labDim.width : (w > ediDim.width ? ediDim.width : w);
                tempH = h;
                switch (KingdeeTimePickerUI.this.labelAlignment) {
                    case 1: 
                    case 2: 
                    case 8: {
                        tempH = h >= ediDim.height + labDim.height ? h - labDim.height : (h > ediDim.height ? ediDim.height : h);
                        tempW = w;
                        y = h - tempH;
                        this.editor.setBounds(x, y, tempW, tempH);
                        tempH = h - tempH;
                        y = insets.top;
                        this.label.setBounds(x, y, tempW, tempH);
                        break;
                    }
                    case 3: {
                        this.editor.setBounds(x, y, tempW, tempH);
                        x += tempW;
                        tempW = w - tempW;
                        this.label.setBounds(x, y, tempW, tempH);
                        break;
                    }
                    default: {
                        x = w - tempW;
                        this.editor.setBounds(x, y, tempW, tempH);
                        x = insets.left;
                        tempW = w - tempW;
                        this.label.setBounds(x, y, tempW, tempH);
                    }
                }
            }
        }
    }
}

