/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf.basic;

import com.kingdee.cosmic.ctrl.swing.KDTaskPaneContainer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class BasicTaskPaneContainerUI
extends ComponentUI {
    protected KDTaskPaneContainer taskPane;
    protected boolean useGradient;
    protected Color gradientStart;
    protected Color gradientEnd;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTaskPaneContainerUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.taskPane = (KDTaskPaneContainer)c;
        this.taskPane.setLayout(KDTaskPaneContainer.TaskPaneVLayout);
        this.taskPane.setBorder(BorderFactory.createEmptyBorder(6, 8, 8, 6));
        this.taskPane.setOpaque(true);
        if (this.taskPane.getBackground() == null || this.taskPane.getBackground() instanceof ColorUIResource) {
            this.taskPane.setBackground(UIManager.getColor("TaskPaneContainer.background"));
        }
        this.useGradient = UIManager.getBoolean("TaskPaneContainer.useGradient");
        if (this.useGradient) {
            this.gradientStart = UIManager.getColor("TaskPaneContainer.backgroundGradientStart");
            this.gradientEnd = UIManager.getColor("TaskPaneContainer.backgroundGradientEnd");
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.useGradient) {
            Paint old = g2d.getPaint();
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.gradientStart, 0.0f, c.getHeight(), this.gradientEnd);
            g2d.setPaint(gradient);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g2d.setPaint(old);
        }
    }
}

