function adjustPosition(top, left, buttom, right) {
    //调整量表，雷达图，金字塔图，漏斗图等没有grid的图形的位置
    var dom = myChart.getDom();
    var width = ($(dom)).width();
    var height = ($(dom)).height();
    var centerX = width / 2;
    var centerY = height / 2;
    var sizeX = width;
    var sizeY = height;
    var sizePercent = 85;
    var p = option;
    if (p.radar != null) {
        sizePercent = p.radar.radius.replace('%', '');
    } else {
        for (var i = 0; i < p.series.length; i ++) {
            var s = p.series[i];
            if (s.radius) {
                //跳过甜甜圈图 饼图 等特殊图表
                if (s.radius instanceof Array)
                {
                    continue;
                }
                sizePercent = s.radius.replace('%', '');
            } else {
                sizePercent = s.maxSize.replace('%', '');
            }
        }
    }
    if (null != top) {
        centerY = centerY + top;
        sizeY = sizeY - top;
    }
    if (null != left) {
        centerX = centerX + left;
        sizeX = sizeX - left;
    }
    if (null != buttom) {
        centerY = centerY - buttom;
        sizeY = sizeY - buttom;
    }
    if (null != right) {
        centerX = centerX - right;
        sizeX = sizeX - right;
    }
    //取较小的百分比
    sizePercent = Math.min(sizeX / width, sizeY / height, Number(sizePercent) / 100);
    //转换成百分数
    sizePercent = Math.round(sizePercent * 100);
    var sizePercentText = sizePercent + '%';
    if (p.radar != null) {
        p.radar.center = [centerX, centerY];
        p.radar.radius = sizePercentText;
    } else {
        for (var i = 0; i < p.series.length; i ++) {
            var s = p.series[i];
            s.center = [centerX, centerY];
            if (s.radius) {
                if (s.radius instanceof Array)
                {
                    continue;
                }
                s.radius = sizePercentText;
            } else {
                s.maxSize = sizePercentText;
            }
        }
    }
}
