//see com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils.calOffset(int, int, double)
function calOffset(serialSize, index) {
    var gap = 20;
    var h = 5 * gap;
    return index * h + index * gap - 0.5 * serialSize * h + 0.5 * h - 0.5 * serialSize * gap + 0.5 * gap;
}
//see com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils.calSize(int, int, double)
function calSize(serialSize, gap) {
    return 100 / (serialSize + (serialSize - 1) * gap / 100);
}
//堆叠图形，由于抽象图是自己创建的需要手动重设data才能动态改变高度
function stackValue(sdata, series, selected, index) {
    var ret = new Array();
	//只改变原有data的value或者数值
    for (var a = 0; a < index; a++) {
        if (a % 2 == 0 && selected[a / 2]) {
            for (var j = 0; j < series[a].data.length; j++) {
                var d = series[a].data[j];
                if (d.value) {
                    d = d.value;
                }
                if (!sdata[j])
                {
                    sdata[j] = 0;
                }
                if (!d)
                {
                    d = 0;
                }
                //判断统计负值还是正值
                if (sdata[j].value) {
                    if (d < 0) {
                        if (ret[j]) {
                            ret[j] = ret[j] + d;
                        } else {
                            ret[j] = d;
                        }
                    }

                } else if (d > 0) {
                    if (ret[j]) {
                        ret[j] = ret[j] + d;
                    } else {
                        ret[j] = d;
                    }
                }
            }
        }
    }
    for (var n = 0; n < sdata.length; n++) {
        if (sdata[n] && sdata[n].value) {
            sdata[n].value = ret[n];
        } else {
            sdata[n] = ret[n];
        }
    }
    return sdata;
}

myChart.on('legendselectchanged', function(obj) {
    var op = myChart.getOption();
    var selected = obj.selected;
    //点击的图例名称
    var legend = obj.name;
    var i = 0;
    var diamondSize = 0;
    //使用这个数组记录一下那些图形的数据进行堆叠如果true则堆叠
    var selectArray = new Array();
    for (name in selected) {
        //bar序列都是排在前面的，首先判断是bar才修改抽象菱形图是否显示
        if (op.series[i * 2] && op.series[i * 2].type === 'bar') {
            if (selected[name] == true) {
                op.series[i * 2 + 1].symbol = "diamond";
                diamondSize++;
                selectArray[i] = true;
            } else {
                op.series[i * 2 + 1].symbol = "none";
                selectArray[i] = false;
            }
        }
        i++;
    }
    //重新设置菱形抽象图的位置和尺寸
    var n = 0;
    var s = op.series;
    for (var j = 0; j < s.length; j++) {
        var sj = s[j];
        if (sj.symbol === "diamond" && s[j - 1].type === 'bar') {
            if (s[j - 1].stack) {
                var k = s.length - 1;
                while (s[k].type !== "pictorialBar") {
                    k = k - 1;
                }
                var totalLines = s[k].data;
                var heightArr = s[j - 1].data;
                var b = false;
                for (var prop in totalLines) {
                    if (Number(prop) === 0)
                    {
                        b = true;
                        sj.data = stackValue(sj.data, s, selectArray, j);
                    }
                }
                if (b)
                {
                    continue;
                }
                var min = 0;
                for (h in heightArr) {
                    if (min == 0) {
                        min = Math.abs(heightArr[h]) / Math.abs(totalLines[h]);
                    } else {
                        min = Math.abs(heightArr[h]) / Math.abs(totalLines[h]) < min ? Math.abs(heightArr[h]) / Math.abs(totalLines[h]) : min;
                    }
                }
                if (sj.symbolOffset[0] === '50%') {
                    //堆积图的设置尺寸
                    sj.symbolSize = [min * 30 + '%', '100%'];
                } else {
                    //堆积图的设置尺寸
                    sj.symbolSize = ['100%', min * 30 + '%'];
                }
                sj.data = stackValue(sj.data, s, selectArray, j);
            } else if (op.xAxis[0].type === 'category') {
				//柱形图
                //设置尺寸
                sj.symbolSize = [calSize(diamondSize, 20) + '%', '15.0'];
                //设置偏移量
                sj.symbolOffset = [calOffset(diamondSize, n) + '%', '-50%'];
				//处理下负值的情况
                var d = sj.data;
                for(var m = 0; m < d.length; m++)
                {
                    if(d[m] && d[m].symbolOffset)
                    {
                        d[m].symbolOffset = [calOffset(diamondSize, n) + '%', '50%'];
                    }
                }
            } else {
				//条形图
                //设置尺寸
                sj.symbolSize = ['15.0', calSize(diamondSize, 20) + '%'];
                //设置偏移量
                sj.symbolOffset = ['50%', calOffset(diamondSize, n) + '%'];
				//处理下负值情况
                var d = sj.data;
                for(var m = 0; m < d.length; m++)
                {
                    if(d[m] && d[m].symbolOffset)
                    {
                        d[m].symbolOffset = ['-50%', calOffset(diamondSize, n) + '%'];
                    }
                }
            }
            n++;
        }
    }
    myChart.setOption(op, true);
});