/**
 * x轴的label格式化（x轴类别显示格式化）
 *  主要功能：
 *      将太长的类别名称分成多行显示
 *      例如：乌鲁木齐齐齐哈尔  ->  乌鲁木齐
 *                               齐齐哈尔
 * @param params 上例中的“乌鲁木齐齐齐哈尔”
 * @returns {string}
 */
function xAxisAxislabelFormatter(params) {
    var op = myChart.getOption();
    var newParamsName = '';
    var paramsNameNumber = params.length;
    var gridLeft = op.grid ? op.grid[0].left : 60;
    var gridRight = op.grid ? op.grid[0].right : 60;
    var fontSize = op.textStyle.fontSize;
    if(!fontSize)
        fontSize = 12;
    // 一个x轴的类别label能容纳多少个fontSize（以类别Label的宽度为准：一行的长度）
    var provideNumber = Math.floor((myChart.getWidth() - gridLeft - gridRight) / op.series[0].data.length / fontSize);
    // 此值可能计算为0，表示该行可以容纳0个字，不符合逻辑，故作以下调整
    provideNumber = provideNumber === 0 ? 1 : provideNumber;
    // params需要分成几行
    var rowNumber = Math.ceil(paramsNameNumber / provideNumber);
    if (paramsNameNumber > provideNumber) {
        for (var p = 0; p < rowNumber; p++) {
            var tempStr = '';
            var start = p * provideNumber;
            var end = start + provideNumber;
            if (p == rowNumber - 1)
                tempStr = params.substring(start, paramsNameNumber);
            else
                tempStr = params.substring(start, end) + '\n';
            newParamsName += tempStr;
        }
    } else {
        newParamsName = params;
    }
    return newParamsName;
}
