/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class GetConvertType
implements BOSUDFunction {
    private static final Log log = LogFactory.getLog(GetConvertType.class);
    private static final String FORMID_UNIT = "bd_measureunits";
    private static final String FORMID_MATERIAL = "bd_material";
    private static final String KEY_CONVERT_TYPE = "converttype";
    private ExpressionContext expContext;

    public GetConvertType() {
    }

    public GetConvertType(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public String getName() {
        return "GETCONVERTTYPE";
    }

    public Object call(Object ... params) {
        DynamicObject muConvObj;
        Objects.requireNonNull(params);
        assert (params.length == 3);
        Object materialParam = params[0];
        Object srcUnitParam = params[1];
        Object distUnitParam = params[2];
        Long materialId = this.getMaterialId(materialParam);
        Long unit1 = this.getUnitId(srcUnitParam);
        Long unit2 = this.getUnitId(distUnitParam);
        if (unit1 == null || unit2 == null) {
            log.info(String.format("GetConvertType(%s, %s, %s), unit1 or unit2 is null, return '0'", materialId, unit1, unit2));
            return "0";
        }
        if (materialId == null) {
            materialId = -1L;
        }
        if ((muConvObj = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)unit1, (Long)unit2)) == null) {
            log.info(String.format("GetConvertType(%s, %s, %s), not exist unit convert type, return '0'", materialId, unit1, unit2));
            return "0";
        }
        return muConvObj.getString(KEY_CONVERT_TYPE);
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetConvertType(expContext);
    }

    private Long getMaterialId(Object materialParam) {
        if (materialParam == null) {
            return null;
        }
        if (materialParam instanceof DynamicObject) {
            return (Long)((DynamicObject)materialParam).getPkValue();
        }
        if (materialParam instanceof Long) {
            return (Long)materialParam;
        }
        BasedataEntityType material_dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)FORMID_MATERIAL);
        QFilter filter = new QFilter(material_dt.getNumberProperty(), "=", materialParam);
        Map material_Objs = BusinessDataServiceHelper.loadFromCache((String)FORMID_MATERIAL, (String)"id", (QFilter[])new QFilter[]{filter});
        if (material_Objs == null || material_Objs.isEmpty()) {
            return null;
        }
        return (Long)material_Objs.keySet().iterator().next();
    }

    private Long getUnitId(Object unitParam) {
        if (unitParam == null) {
            return null;
        }
        if (unitParam instanceof DynamicObject) {
            return (Long)((DynamicObject)unitParam).getPkValue();
        }
        if (unitParam instanceof Long) {
            return (Long)unitParam;
        }
        BasedataEntityType unit_dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)FORMID_UNIT);
        QFilter filter = new QFilter(unit_dt.getNumberProperty(), "=", unitParam);
        Map unit_Objs = BusinessDataServiceHelper.loadFromCache((String)FORMID_UNIT, (String)"id", (QFilter[])new QFilter[]{filter});
        if (unit_Objs == null || unit_Objs.isEmpty()) {
            return null;
        }
        return (Long)unit_Objs.keySet().iterator().next();
    }
}

