/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.math.BigDecimal;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.untrans.KDDMUntrans;

public class NumberChineseFormatter {
    private static final char[] DIGITS = KDDMUntrans.R4;
    private static final String[] CHINESE_NAME_VALUE = KDDMUntrans.R5;

    public static String format(double amount, boolean isUseTraditional) {
        return NumberChineseFormatter.format(amount, isUseTraditional, false);
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        return NumberChineseFormatter.format(amount, isUseTraditional, isMoneyMode, false, "\u8d1f", "\u5143");
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode, boolean isOnlyInteger) {
        return NumberChineseFormatter.format(amount, isUseTraditional, isMoneyMode, isOnlyInteger, "\u8d1f", "\u5143");
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode, boolean isOnlyInteger, String negativeName, String unitName) {
        if (0.0 == amount) {
            return "\u96f6";
        }
        if (amount <= -9.999999999999998E13 || amount >= 9.999999999999998E13) {
            throw new IllegalArgumentException("Number support only: (-99999999999999.99 ~ 99999999999999.99)\uff01");
        }
        StringBuilder chineseStr = new StringBuilder();
        if (amount < 0.0) {
            chineseStr.append(StringUtils.isBlank((CharSequence)negativeName) ? "\u8d1f" : negativeName);
            amount = -amount;
        }
        if (isOnlyInteger) {
            amount = Math.round(amount);
        }
        BigDecimal decimal = new BigDecimal(Double.toString(amount));
        amount = decimal.multiply(new BigDecimal(100)).doubleValue();
        long yuan = Math.round(amount);
        int fen = (int)(yuan % 10L);
        int jiao = (int)((yuan /= 10L) % 10L);
        if (!isMoneyMode || 0L != (yuan /= 10L)) {
            chineseStr.append(NumberChineseFormatter.longToChinese(yuan, isUseTraditional));
            if (isMoneyMode) {
                chineseStr.append(StringUtils.isBlank((CharSequence)unitName) ? "\u5143" : unitName);
            }
        }
        if (0 == jiao && 0 == fen) {
            if (isMoneyMode) {
                chineseStr.append("\u6574");
            }
            return chineseStr.toString();
        }
        if (!isMoneyMode) {
            chineseStr.append("\u70b9");
        }
        if (0L == yuan && 0 == jiao) {
            if (!isMoneyMode) {
                chineseStr.append("\u96f6");
            }
        } else {
            chineseStr.append(NumberChineseFormatter.numberToChinese(jiao, isUseTraditional));
            if (isMoneyMode && 0 != jiao) {
                chineseStr.append("\u89d2");
            }
        }
        if (0 != fen) {
            chineseStr.append(NumberChineseFormatter.numberToChinese(fen, isUseTraditional));
            if (isMoneyMode) {
                chineseStr.append("\u5206");
            }
        }
        return chineseStr.toString();
    }

    private static String longToChinese(long amount, boolean isUseTraditional) {
        String partChinese;
        if (0L == amount) {
            return "\u96f6";
        }
        int[] parts = new int[4];
        int i = 0;
        while (amount != 0L) {
            parts[i] = (int)(amount % 10000L);
            amount /= 10000L;
            ++i;
        }
        StringBuilder chineseStr = new StringBuilder();
        int partValue = parts[0];
        if (partValue > 0) {
            partChinese = NumberChineseFormatter.thousandToChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese);
            if (partValue < 1000) {
                NumberChineseFormatter.addPreZero(chineseStr);
            }
        }
        if ((partValue = parts[1]) > 0) {
            if (partValue % 10 == 0 && parts[0] > 0) {
                NumberChineseFormatter.addPreZero(chineseStr);
            }
            partChinese = NumberChineseFormatter.thousandToChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4e07");
            if (partValue < 1000) {
                NumberChineseFormatter.addPreZero(chineseStr);
            }
        } else {
            NumberChineseFormatter.addPreZero(chineseStr);
        }
        if ((partValue = parts[2]) > 0) {
            if (partValue % 10 == 0 && parts[1] > 0) {
                NumberChineseFormatter.addPreZero(chineseStr);
            }
            partChinese = NumberChineseFormatter.thousandToChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4ebf");
            if (partValue < 1000) {
                NumberChineseFormatter.addPreZero(chineseStr);
            }
        } else {
            NumberChineseFormatter.addPreZero(chineseStr);
        }
        if ((partValue = parts[3]) > 0) {
            if (parts[2] == 0) {
                chineseStr.insert(0, "\u4ebf");
            }
            partChinese = NumberChineseFormatter.thousandToChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4e07");
        }
        if (StringUtils.isNotEmpty((CharSequence)chineseStr) && '\u96f6' == chineseStr.charAt(0)) {
            return chineseStr.substring(1);
        }
        return chineseStr.toString();
    }

    private static String thousandToChinese(int amountPart, boolean isUseTraditional) {
        if (amountPart == 0) {
            return String.valueOf(DIGITS[0]);
        }
        int temp = amountPart;
        StringBuilder chineseStr = new StringBuilder();
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr.insert(0, "\u96f6");
                }
                lastIsZero = true;
            } else {
                chineseStr.insert(0, NumberChineseFormatter.numberToChinese(digit, isUseTraditional) + NumberChineseFormatter.getUnitName(i, isUseTraditional));
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr.toString();
    }

    private static char numberToChinese(int number, boolean isUseTraditional) {
        if (0 == number) {
            return DIGITS[0];
        }
        return DIGITS[number * 2 - (isUseTraditional ? 0 : 1)];
    }

    private static String getUnitName(int index, boolean isUseTraditional) {
        if (0 == index) {
            return "";
        }
        return CHINESE_NAME_VALUE[index * 2 - (isUseTraditional ? 0 : 1)];
    }

    private static void addPreZero(StringBuilder chineseStr) {
        if (StringUtils.isEmpty((CharSequence)chineseStr)) {
            return;
        }
        char c = chineseStr.charAt(0);
        if ('\u96f6' != c) {
            chineseStr.insert(0, '\u96f6');
        }
    }
}

