/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.OpBatchExecuter;
import kd.bos.entity.operate.OpBatchMonitorTask;
import kd.bos.entity.operate.OpBatchTaskClick;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class OpBatchExecutePlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(OpBatchExecutePlugin.class);
    private static final String FORMID_OPBATCHEXECUTE = "bos_opbatchexecute";
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String OP_KEY = "opkey";
    private static final String PK_IDS = "pkids";
    private static final String LIST_SELECTED_ROWS = "listselectedrows";
    private static final String OPERATE_OPTION = "operateoption";
    private static final String BATCH_SIZE = "batchsize";
    private static final String PERMISSION_ENTITYID = "permissionentityid";
    private static final String OP_NAME = "opname";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_LBLPROGRESS = "lblprogress";
    private static final String CACHEKEY_TASKID = "taskid";
    private static final String BTN_CANCELOP = "cancelop";
    private static final String BTN_TOBACKGROUND = "tobackground";
    private static final String CACHEKEY_JOBFORMINFO = "cachekey_jobforminfo";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"OpBatchExecuter", (int)5);

    public static void showOpBatchForm(DefaultEntityOperate op) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_OPBATCHEXECUTE);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put(ENTITY_NUMBER, op.getEntityId());
        showParameter.getCustomParams().put(OP_KEY, op.getOperateKey());
        showParameter.getCustomParams().put(PK_IDS, op.getOperateIds().toArray());
        showParameter.getCustomParams().put(LIST_SELECTED_ROWS, SerializationUtils.toJsonString((Object)op.getListSelectedData()));
        showParameter.getCustomParams().put(OPERATE_OPTION, op.getOption().getVariables());
        showParameter.getCustomParams().put(BATCH_SIZE, op.getBatchSize());
        showParameter.getCustomParams().put(PERMISSION_ENTITYID, op.getPermissionEntityId());
        showParameter.getCustomParams().put(OP_NAME, String.valueOf(op.getOperateName()));
        String appId = op.getView().getFormShowParameter().getServiceAppId();
        if (StringUtils.isNotBlank((CharSequence)appId) && !StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId)) {
            showParameter.setAppId(appId);
        }
        op.getView().showForm(showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTN_CANCELOP, BTN_TOBACKGROUND});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.start();
    }

    public void onProgress(ProgressEvent arg0) {
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = DBServiceHelper.genStringId();
            OpBatchExecuter executer = new OpBatchExecuter(taskId, this.getEntityNumber(), this.getOpKey(), this.getPKIds(), this.getOption(), this.getBatchSize());
            executer.setListSelectedRows(this.getListSelectedRows());
            this.executeTask(executer);
            this.setTaskId(taskId);
            return;
        }
        boolean completed = OpBatchExecuter.isCompleted(taskId);
        boolean finished = OpBatchExecuter.isFinished(taskId);
        boolean isInteraction = OpBatchExecuter.isInteraction(taskId);
        boolean isError = OpBatchExecuter.isError(taskId);
        ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        if (Boolean.parseBoolean(this.getPageCache().get("startAsyncMonitorTask"))) {
            return;
        }
        if (completed) {
            this.complete();
            bar.stop();
        } else if (isError) {
            IFormView parentView = this.getParentView();
            parentView.showErrMessage(OpBatchExecuter.getErrorMessage(taskId), "");
            this.getView().sendFormAction(parentView);
            this.getView().close();
            bar.stop();
        } else if (isInteraction) {
            OpBatchExecuter.setFinished(taskId, false);
            OpBatchExecuter.setInteraction(taskId, false);
            this.interaction();
        } else if (finished) {
            this.getView().close();
            bar.stop();
        } else {
            int progress = OpBatchExecuter.getProgress(taskId);
            String tip = OpBatchExecuter.getProgressTip(taskId);
            if (progress >= 100) {
                progress = 99;
            }
            arg0.setProgress(progress);
            if (StringUtils.isNotBlank((CharSequence)tip)) {
                this.setProgressTip(tip);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        if (Boolean.parseBoolean(this.getPageCache().get("startAsyncMonitorTask"))) {
            log.info("\u5df2\u8f6c\u540e\u53f0\u6267\u884c");
            return;
        }
        boolean finished = OpBatchExecuter.isFinished(taskId);
        if (finished) {
            OpBatchExecuter.clearCache(taskId);
        } else {
            OpBatchExecuter.setCancel(taskId, true);
            e.setCancel(true);
        }
    }

    private void startMonitorTask() {
        String opExecutorTaskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)opExecutorTaskId) || !OpBatchExecuter.isTaskStarted(opExecutorTaskId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u542f\u52a8\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"OpBatchExecutePlugin_1", (String)"bos-entity-business", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        Map formshowParams = this.getView().getFormShowParameter().getCustomParams();
        params.put("opexecutortaskid", opExecutorTaskId);
        params.put("listpageid", this.getView().getFormShowParameter().getParentPageId());
        params.put(ENTITY_NUMBER, formshowParams.get(ENTITY_NUMBER));
        params.put(OP_KEY, formshowParams.get(OP_KEY));
        params.put(OPERATE_OPTION, formshowParams.get(OPERATE_OPTION));
        params.put(PERMISSION_ENTITYID, formshowParams.get(PERMISSION_ENTITYID));
        params.put(OP_NAME, formshowParams.get(OP_NAME));
        JobFormInfo jobFormInfo = this.buildMonitorJobFormInfo(params);
        String monitorTaskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        OpBatchExecuter.setMonitorJobFormInfo(opExecutorTaskId, jobFormInfo);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)monitorTaskId);
        if (!TaskClientProxy.isExistTask((String)monitorTaskId)) {
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, monitorTaskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
        IFormView parentView = this.getParentView();
        this.getPageCache().put("startAsyncMonitorTask", "true");
        parentView.showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u540e\u53f0\u8fd0\u884c\uff0c\u8bf7\u52ff\u5173\u95ed\u5217\u8868\u3002", (String)"OpBatchExecutePlugin_2", (String)"bos-entity-business", (Object[])new Object[0]));
        this.getView().sendFormAction(parentView);
        this.getView().close();
        ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            switch (btn.getKey()) {
                case "cancelop": {
                    this.getView().close();
                    break;
                }
                case "tobackground": {
                    this.startMonitorTask();
                }
            }
        }
    }

    private JobFormInfo buildMonitorJobFormInfo(Map<String, Object> customParams) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(String.format("%s-%s", this.getParentView().getFormShowParameter().getCaption(), this.getOperateName()));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setTaskClassname(OpBatchMonitorTask.class.getName());
        jobInfo.setParams(customParams);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(customParams);
        jobFormInfo.setClickClassName(OpBatchTaskClick.class.getName());
        return jobFormInfo;
    }

    private void start() {
        String entityNumber = this.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
        this.setProgressTip(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u7684\u6570\u636e\u6bd4\u8f83\u591a\uff0c\u6b63\u5728\u5206\u6279...", (String)"OpBatchExecutePlugin_0", (String)"bos-entity-business", (Object[])new Object[0]));
    }

    protected void executeTask(OpBatchExecuter executer) {
        threadPool.execute((Runnable)executer);
    }

    private void interaction() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        this.continueExecute("sponsor", MessageBoxResult.Yes.toString());
    }

    private void continueExecute(String sponsor, String interactionResult) {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        String taskId = this.getTaskId();
        OpBatchExecuter executer = new OpBatchExecuter(taskId, this.getEntityNumber(), this.getOpKey(), this.getPKIds(), this.getOption(), this.getBatchSize());
        executer.setListSelectedRows(this.getListSelectedRows());
        OperateOption option = this.getOption().copy();
        option.setVariableValue(sponsor, interactionResult);
        executer.setInteractionOption(option);
        this.executeTask(executer);
    }

    private void complete() {
        String taskId = this.getTaskId();
        String result = OpBatchExecuter.getOperationResult(taskId);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            OperateOption option = this.getOption();
            option.setVariableValue("batchop_result", result);
            option.setVariableValue("batchop_completed", String.valueOf(true));
            IFormView parentView = this.getParentView();
            parentView.invokeOperation(this.getOpKey(), option);
            this.getView().sendFormAction(parentView);
        }
        this.getView().close();
    }

    protected IFormView getParentView() {
        return this.getView().getParentView();
    }

    private String getTaskId() {
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private String getEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
    }

    private String getOpKey() {
        return (String)this.getView().getFormShowParameter().getCustomParam(OP_KEY);
    }

    private String getOperateName() {
        return (String)this.getView().getFormShowParameter().getCustomParam(OP_NAME);
    }

    private Set<Object> getPKIds() {
        List ids = (List)this.getView().getFormShowParameter().getCustomParam(PK_IDS);
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(16);
        for (Object id : ids) {
            if (id instanceof Integer) {
                set.add(((Integer)id).longValue());
                continue;
            }
            set.add(id);
        }
        return set;
    }

    private ListSelectedRowCollection getListSelectedRows() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam(LIST_SELECTED_ROWS);
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ListSelectedRowCollection();
        }
        return (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)str, ListSelectedRowCollection.class);
    }

    private OperateOption getOption() {
        OperateOption option = OperateOption.create();
        Map vars = (Map)this.getView().getFormShowParameter().getCustomParam(OPERATE_OPTION);
        if (vars != null) {
            for (Map.Entry entry : vars.entrySet()) {
                option.setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        option.setVariableValue(PERMISSION_ENTITYID, (String)this.getView().getFormShowParameter().getCustomParam(PERMISSION_ENTITYID));
        return option;
    }

    private int getBatchSize() {
        return (Integer)this.getView().getFormShowParameter().getCustomParam(BATCH_SIZE);
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl(KEY_LBLPROGRESS);
        lblTip.setText(tip);
    }
}

