/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OpBatchExecuter
implements Runnable {
    public static final int DEFAULT_BATCH_COUNT = 100;
    private static final Log log = LogFactory.getLog(OpBatchExecuter.class);
    private static final String SPAN_TYPE_OPERATE = "operate";
    private static final String CACHE_TYPE = "OpBatchExecuter";
    private static final String CACHEKEY_COMPLETE = "complete";
    private static final String CACHEKEY_FINISH = "finish";
    private static final String CACHEKEY_CANCEL = "cancel";
    private static final String CACHEKEY_ERROR = "error";
    private static final String CACHEKEY_ERRORMESSAGE = "errormessage";
    private static final String CACHEKEY_INTERACTION = "interaction";
    private static final String CACHEKEY_PROGRESS = "progress";
    private static final String CACHEKEY_TIP = "tip";
    private static final String CACHEKEY_RESULT = "result";
    private static final String CACHEKEY_BATCHSEQ = "batchseq";
    private static final String CACHEKEY_INTERACTIONRESULT = "interactionresult";
    private static final String CACHEKEY_MONITORJOBFORMINFO = "jobforminfo";
    private static final String BOS_ENTITY_BUSINESS = "bos-entity-business";
    private static final int ERR_INFO_MAX_COUNT = 999;
    private static final int ERR_INFO_LENGTH = 100;
    private static final int ERR_INFO_MAX_LENGTH = 1000;
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("OpBatchExecuter", new DistributeCacheHAPolicy(true, true));
    private RequestContext rc;
    private String taskId;
    private String entityNumber;
    private String opKey;
    private List<Object> pkIds;
    private ListSelectedRowCollection listSelectedRows;
    private OperateOption option;
    private OperateOption interactionOption;
    private int batchSize;
    private Map<Object, String> mapBillNo = new HashMap<Object, String>();

    public ListSelectedRowCollection getListSelectedRows() {
        return this.listSelectedRows;
    }

    public void setListSelectedRows(ListSelectedRowCollection listSelectedRows) {
        this.listSelectedRows = listSelectedRows;
    }

    public OperateOption getInteractionOption() {
        return this.interactionOption;
    }

    public void setInteractionOption(OperateOption interactionOption) {
        this.interactionOption = interactionOption;
    }

    public OpBatchExecuter(String taskId, String entityNumber, String opKey, Set<Object> pkIds, OperateOption option, int batchSize) {
        this.rc = RequestContext.get();
        this.taskId = taskId;
        this.entityNumber = entityNumber;
        this.opKey = opKey;
        this.pkIds = new ArrayList<Object>();
        this.pkIds.addAll(pkIds);
        this.option = option;
        this.batchSize = batchSize <= 0 ? 100 : batchSize;
    }

    public void setRequestContext(RequestContext rc) {
        this.rc = rc;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        log.info(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u6279\u6267\u884c\u64cd\u4f5c\u3002entitynumber: %1$s, opkey: %2$s, taskid: %3$s, bill count: %4$d, batch size: %5$d", (String)"OpBatchExecuter_6", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.entityNumber, this.opKey, this.taskId, this.pkIds.size(), this.batchSize));
        EntityTraceSpan span = null;
        try {
            span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"OpBatchExecuter.run");
            span.addTag("entityNumber", this.entityNumber);
            span.addTag("opKey", this.opKey);
            span.addTag("pkIds", String.valueOf(this.pkIds.size()));
            span.addTag("batchSize", String.valueOf(this.batchSize));
            for (ListSelectedRow row : this.listSelectedRows) {
                String billNo = StringUtils.isBlank((CharSequence)row.getBillNo()) ? row.getNumber() : row.getBillNo();
                this.mapBillNo.put(row.getPrimaryKeyValue(), billNo);
            }
            this.doExecute();
        }
        catch (RuntimeException exp) {
            Throwable cause = this.getCause(exp);
            OpBatchExecuter.setError(this.taskId, true);
            OpBatchExecuter.setErrorMessage(this.taskId, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u9047\u5230\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u9519\u8bef\u65e5\u5fd7: %s", (String)"OpBatchExecuter_0", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), cause.getMessage()));
            if (span != null) {
                span.error((Throwable)exp);
            }
            log.error((Throwable)exp);
            throw exp;
        }
        finally {
            OpBatchExecuter.setFinished(this.taskId, true);
            if (span != null) {
                span.close();
            }
        }
    }

    private void doExecute() {
        int seq;
        if (!OpBatchExecuter.isTaskStarted(this.taskId)) {
            OpBatchExecuter.setProgress(this.taskId, 0);
        }
        OperationResult opResult = null;
        String opResultStr = OpBatchExecuter.getOperationResult(this.taskId);
        opResult = StringUtils.isBlank((CharSequence)opResultStr) ? new OperationResult() : (OperationResult)DataEntitySerializer.deSerializerFromString((String)opResultStr, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
        OperateOption currOption = this.interactionOption == null ? this.option.copy() : this.interactionOption;
        currOption.setVariableValue("bos_is_auto_batch_exe_op", String.valueOf(true));
        int totalCount = this.pkIds.size();
        int times = totalCount / this.batchSize + 1;
        int finishCount = seq * this.batchSize;
        for (seq = OpBatchExecuter.getBatchSeq(this.taskId); seq < times; ++seq) {
            currOption.setVariableValue("ignorewarn", String.valueOf(true));
            currOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            List<Object> ids = this.getCurrIds(seq);
            if (ids.isEmpty()) {
                log.info(String.format("taskid: %s, batch seq: %s, ids.isEmpty, break", this.taskId, seq));
                break;
            }
            boolean cancel = OpBatchExecuter.isCancel(this.taskId);
            int size = ids.size();
            if (cancel) {
                this.buildCancelMessage(opResult, seq, ids);
            } else {
                currOption.setVariableValue("batchOpExecute", String.valueOf(true));
                OperationResult currResult = this.executeOperate(seq, ids, currOption);
                if (this.needInteraction(currResult, currOption)) {
                    log.info(String.format("taskid: %s, batch seq: %s,  ids.size: %s, need interaction, reutrn", this.taskId, seq, size));
                    this.doInteraction(opResult, seq, currResult, currOption);
                    return;
                }
                this.appendBatchOperateError(currResult, ids);
                this.mergeOperateResult(opResult, currResult);
            }
            int percent = (finishCount += ids.size()) * 100 / totalCount;
            String tip = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5206\u6279\u5904\u7406\u4e2d\uff0c\u6bcf\u6279%1$s\u5f20\uff0c\u5df2\u5b8c\u6210 %2$s/%3$s\u5f20", (String)"OpBatchExecuter_10", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.batchSize, finishCount, totalCount);
            OpBatchExecuter.setProgress(this.taskId, percent);
            OpBatchExecuter.setProgressTip(this.taskId, tip);
            log.info(String.format("taskid: %s, batch seq: %s, is cancel: %s, ids.size: %s, %s", this.taskId, seq, cancel, size, tip));
            currOption = this.option.copy();
        }
        opResult.setBillCount(totalCount);
        if (!opResult.getAllErrorInfo().isEmpty()) {
            opResult.setMessageType(1);
            opResult.setMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u91cf\u8d85 %d\u6761\u81ea\u52a8\u5206\u6279\u5904\u7406\uff0c\u540c\u6279\u6b21\u5185\u53d1\u751f\u9519\u8bef\u5219\u6574\u6279\u5931\u8d25", (String)"OpBatchExecuter_7", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.batchSize));
        }
        OpBatchExecuter.setOperationResult(this.taskId, opResult);
        OpBatchExecuter.setCompleted(this.taskId, true);
    }

    private void appendBatchOperateError(OperationResult operationResult, List<Object> ids) {
        try {
            String errorMessage = operationResult.getMessage();
            Map dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)this.entityNumber, (String)this.opKey);
            LocaleString opName = LocaleString.fromMap((Map)((Map)dataEntityOperate.get("name")));
            String name = opName.toString();
            List successPkIds = operationResult.getSuccessPkIds();
            List errorInfoList = operationResult.getAllErrorInfo().stream().map(OperateInfo::getPkValue).collect(Collectors.toList());
            List validateErrorPkList = operationResult.getValidateResult().getValidateErrors().stream().flatMap(validateErrorItem -> validateErrorItem.getAllErrorInfo().stream()).map(operateErrorInfo -> operateErrorInfo.getPkValue()).collect(Collectors.toList());
            HashSet attachList = new HashSet();
            attachList.addAll(successPkIds);
            attachList.addAll(errorInfoList);
            attachList.addAll(validateErrorPkList);
            ids.stream().filter(item -> !this.idsContains(attachList, item)).forEach(pkItem -> {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setErrorLevel(ErrorLevel.FatalError.name());
                errorInfo.setPkValue(pkItem);
                errorInfo.setTitle(name);
                String billNo = this.mapBillNo.get(pkItem);
                String message = StringUtils.isNotBlank((CharSequence)errorMessage) ? (billNo != null ? String.format(ResManager.loadKDString((String)"%1$s\uff0c\u540c\u6279\u6570\u636e\u9519\u8bef\u5bfc\u81f4\u5931\u8d25\uff1a%2$s", (String)"OpBatchExecuter_11", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), billNo, errorMessage) : String.format(ResManager.loadKDString((String)"\u540c\u6279\u6570\u636e\u9519\u8bef\u5bfc\u81f4\u5931\u8d25\uff1a%2$s", (String)"OpBatchExecuter_13", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), "", errorMessage)) : (billNo != null ? String.format(ResManager.loadKDString((String)"%s\uff0c\u540c\u6279\u6570\u636e\u9519\u8bef\u5bfc\u81f4\u5931\u8d25\u3002", (String)"OpBatchExecuter_9", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), billNo) : ResManager.loadKDString((String)"\u540c\u6279\u6570\u636e\u9519\u8bef\u5bfc\u81f4\u5931\u8d25\u3002", (String)"OpBatchExecuter_14", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
                errorInfo.setMessage(message);
                operationResult.addErrorInfo(errorInfo);
            });
        }
        catch (Exception e) {
            log.info(String.format("appendBatchOperateError: %s", e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OperationResult executeOperate(int seq, List<Object> ids, OperateOption currOption) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"OpBatchExecuter.executeOperate");){
            span.addTag("seq", String.valueOf(seq));
            if (currOption.containsVariable("bos_support_bigdata_aysn")) {
                currOption.removeVariable("bos_support_bigdata_aysn");
            }
            OperationResult throwable3 = OperationServiceHelper.executeOperate((String)this.opKey, (String)this.entityNumber, (Object[])ids.toArray(), (OperateOption)currOption);
            return throwable3;
        }
        catch (Throwable exp) {
            log.error(exp);
            OperationResult currResult = new OperationResult();
            Throwable cause = this.getCause(exp);
            String errMsg = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u9047\u5230\u672a\u77e5\u9519\u8bef: %s", (String)"OpBatchExecuter_2", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), cause.toString());
            this.buildErrorMessage(currResult, seq, ids, errMsg);
            return currResult;
        }
    }

    private boolean needInteraction(OperationResult currResult, OperateOption currOption) {
        return false;
    }

    private void doInteraction(OperationResult opResult, int seq, OperationResult currResult, OperateOption currOption) {
        OpBatchExecuter.setInteraction(this.taskId, true);
        OpBatchExecuter.setBatchSeq(this.taskId, seq);
        OpBatchExecuter.setInteractionResult(this.taskId, currResult);
        OpBatchExecuter.setOperationResult(this.taskId, opResult);
    }

    private void buildErrorMessage(OperationResult opResult, int seq, List<Object> ids, String errMsg) {
        int dataIndex = seq * this.batchSize;
        int rowIndex = 0;
        String msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u51fa\u9519", (String)"OpBatchExecuter_3", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]);
        for (Object id : ids) {
            ValidationErrorInfo errInfo = new ValidationErrorInfo("", id, dataIndex, rowIndex, "OpBatchExecute - executeOperate", msg, String.format("%s%s", this.mapBillNo.get(id), errMsg), ErrorLevel.FatalError);
            opResult.addErrorInfo((OperateErrorInfo)errInfo);
            ++dataIndex;
        }
    }

    private void buildCancelMessage(OperationResult opResult, int seq, List<Object> ids) {
        int dataIndex = seq * this.batchSize;
        int rowIndex = 0;
        for (Object id : ids) {
            ValidationErrorInfo errInfo = new ValidationErrorInfo("", id, dataIndex, rowIndex, "OpBatchExecute - cancelOperate", ResManager.loadKDString((String)"\u53d6\u6d88\u64cd\u4f5c", (String)"OpBatchExecuter_4", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%s\u88ab\u53d6\u6d88\u64cd\u4f5c", (String)"OpBatchExecuter_5", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), StringUtils.isNotBlank((CharSequence)this.mapBillNo.get(id)) ? this.mapBillNo.get(id) : ""), ErrorLevel.Error);
            opResult.addErrorInfo((OperateErrorInfo)errInfo);
            ++dataIndex;
        }
    }

    private Throwable getCause(Throwable exp) {
        Throwable cause = exp;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private List<Object> getCurrIds(int seq) {
        ArrayList<Object> ids = new ArrayList<Object>();
        int begin = seq * this.batchSize;
        int end = begin + this.batchSize;
        for (int i = begin; i < end && i < this.pkIds.size(); ++i) {
            ids.add(this.pkIds.get(i));
        }
        return ids;
    }

    public static boolean isFinished(String taskId) {
        String finish = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_FINISH);
        if (StringUtils.isBlank((CharSequence)finish)) {
            return false;
        }
        return Boolean.parseBoolean(finish);
    }

    public static void setFinished(String taskId, boolean finish) {
        log.info(String.format("operate batch execute finished,  taskid: %s", taskId));
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_FINISH, (Object)String.valueOf(finish));
    }

    public static boolean isCompleted(String taskId) {
        String finish = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_COMPLETE);
        if (StringUtils.isBlank((CharSequence)finish)) {
            return false;
        }
        return Boolean.parseBoolean(finish);
    }

    public static void setCompleted(String taskId, boolean complete) {
        log.info(String.format("operate batch execute completed,  taskid: %s", taskId));
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_COMPLETE, (Object)String.valueOf(complete));
    }

    public static boolean isInteraction(String taskId) {
        String finish = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_INTERACTION);
        if (StringUtils.isBlank((CharSequence)finish)) {
            return false;
        }
        return Boolean.parseBoolean(finish);
    }

    public static void setInteraction(String taskId, boolean interaction) {
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_INTERACTION, (Object)String.valueOf(interaction));
    }

    public static boolean isCancel(String taskId) {
        String cancel = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_CANCEL);
        if (StringUtils.isBlank((CharSequence)cancel)) {
            return false;
        }
        return Boolean.parseBoolean(cancel);
    }

    public static void setCancel(String taskId, boolean cancel) {
        log.info(String.format("operate batch execute cancel,  taskid: %s", taskId));
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_CANCEL, (Object)String.valueOf(cancel));
    }

    public static boolean isError(String taskId) {
        String error = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_ERROR);
        if (StringUtils.isBlank((CharSequence)error)) {
            return false;
        }
        return Boolean.parseBoolean(error);
    }

    public static void setError(String taskId, boolean error) {
        log.info(String.format("operate batch execute error,  taskid: %s", taskId));
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_ERROR, (Object)String.valueOf(error));
    }

    public static String getErrorMessage(String taskId) {
        return (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_ERRORMESSAGE);
    }

    public static void setErrorMessage(String taskId, String msg) {
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_ERRORMESSAGE, (Object)msg);
    }

    public static int getProgress(String taskId) {
        String progress = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_PROGRESS);
        if (StringUtils.isBlank((CharSequence)progress)) {
            return 0;
        }
        return Integer.parseInt(progress);
    }

    public static boolean isTaskStarted(String taskId) {
        String progress = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_PROGRESS);
        return StringUtils.isNotBlank((CharSequence)progress);
    }

    public static void setProgress(String taskId, int progress) {
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_PROGRESS, (Object)String.valueOf(progress));
    }

    public static String getProgressTip(String taskId) {
        return (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_TIP);
    }

    public static void setProgressTip(String taskId, String tip) {
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_TIP, (Object)tip);
    }

    public static String getOperationResult(String taskId) {
        String result = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_RESULT);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        return result;
    }

    public static void setOperationResult(String taskId, OperationResult opResult) {
        String result = "";
        if (opResult != null) {
            result = OpBatchExecuter.serializeOperationResult(opResult);
        }
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_RESULT, (Object)result);
    }

    public static String getInteractionResult(String taskId) {
        String result = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_INTERACTIONRESULT);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        return result;
    }

    public static void setInteractionResult(String taskId, OperationResult currResult) {
        String result = "";
        if (currResult != null) {
            result = OpBatchExecuter.serializeOperationResult(currResult);
        }
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_INTERACTIONRESULT, (Object)result);
    }

    public static int getBatchSeq(String taskId) {
        String seq = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_BATCHSEQ);
        if (StringUtils.isBlank((CharSequence)seq)) {
            return 0;
        }
        return Integer.parseInt(seq);
    }

    public static void setBatchSeq(String taskId, int seq) {
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_BATCHSEQ, (Object)String.valueOf(seq));
    }

    public static void clearCache(String taskId) {
        cache.removeType(OpBatchExecuter.buildCacheType(taskId));
    }

    private static String buildCacheType(String taskId) {
        return "OpBatchExecuter_" + taskId;
    }

    public static void setMonitorJobFormInfo(String taskId, JobFormInfo info) {
        cache.put(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_MONITORJOBFORMINFO, (Object)SerializationUtils.toJsonString((Object)info));
    }

    public static JobFormInfo getMonitorJobFormInfo(String taskId) {
        String str = (String)cache.get(OpBatchExecuter.buildCacheType(taskId), CACHEKEY_MONITORJOBFORMINFO);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void mergeOperateResult(OperationResult opResult1, OperationResult opResult2) {
        opResult1.mergeOperateResult(opResult2);
        int allErrCount = this.getErrInfoCount(opResult1);
        if (allErrCount <= this.batchSize) {
            return;
        }
        HashSet<Object> billIds = new HashSet<Object>(opResult1.getBillCount());
        int count = 0;
        List<OperateErrorInfo> list1 = this.delDupErrInfos(opResult1.getAllErrorInfo(), billIds, count);
        opResult1.getAllErrorInfo().clear();
        opResult1.getAllErrorInfo().addAll(list1);
        boolean addOrerTip = false;
        if ((count += list1.size()) >= 999 && allErrCount > count) {
            this.addDelMsgInfo(opResult1.getAllErrorInfo());
            addOrerTip = true;
        }
        if (opResult1.getValidateResult() != null && !opResult1.getValidateResult().getValidateErrors().isEmpty()) {
            for (ValidateResult vr : opResult1.getValidateResult().getValidateErrors()) {
                List<OperateErrorInfo> list2 = this.delDupErrInfos(vr.getAllErrorInfo(), billIds, count);
                vr.getAllErrorInfo().clear();
                vr.getAllErrorInfo().addAll(list2);
                if (addOrerTip || (count += list2.size()) < 999 || allErrCount <= count) continue;
                this.addDelMsgInfo(vr.getAllErrorInfo());
                addOrerTip = true;
            }
        }
    }

    private List<OperateErrorInfo> delDupErrInfos(List<OperateErrorInfo> errInfos, Set<Object> billIds, int count) {
        if (count >= 999) {
            return new ArrayList<OperateErrorInfo>(0);
        }
        ArrayList<OperateErrorInfo> list = new ArrayList<OperateErrorInfo>(errInfos.size());
        for (OperateErrorInfo errInfo : errInfos) {
            if (errInfo.getPkValue() == null || billIds.add(errInfo.getPkValue())) {
                String msg;
                list.add(errInfo);
                String string = msg = errInfo.getMessage() == null ? "" : errInfo.getMessage();
                if (count + list.size() > this.batchSize) {
                    if (msg.length() > 100) {
                        errInfo.setMessage(msg.substring(0, 97) + "...");
                    }
                } else if (msg.length() > 1000) {
                    errInfo.setMessage(msg.substring(0, 997) + "...");
                }
            }
            if (count + list.size() < 999) continue;
            break;
        }
        return list;
    }

    private void addDelMsgInfo(List<OperateErrorInfo> list) {
        OperateErrorInfo overTips = new OperateErrorInfo();
        overTips.setLevel(ErrorLevel.Info);
        overTips.setErrorCode("bos_opbatchexecuter_delDupErrInfos");
        overTips.setMessage(ResManager.loadKDString((String)"\u63d0\u793a\u4fe1\u606f\u8fc7\u591a\uff0c\u4ec5\u4fdd\u7559\u524d{0}\u6761\u3002", (String)"OpBatchExecuter_12", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[]{999}));
        list.add(overTips);
    }

    private int getErrInfoCount(OperationResult opResult) {
        int count = opResult.getAllErrorInfo().size();
        if (opResult.getValidateResult() != null && !opResult.getValidateResult().getValidateErrors().isEmpty()) {
            for (ValidateResult vr : opResult.getValidateResult().getValidateErrors()) {
                count += vr.getAllErrorInfo().size();
            }
        }
        return count;
    }

    private static String serializeOperationResult(OperationResult operationResult) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        return serialResult;
    }

    private boolean idsContains(Set<Object> attchSet, Object o) {
        if (o instanceof Long) {
            boolean containLong = attchSet.contains(o);
            if (containLong) {
                return true;
            }
            Long longObj = (Long)o;
            if (longObj < Integer.MAX_VALUE) {
                return attchSet.contains(longObj.intValue());
            }
        }
        return attchSet.contains(o);
    }
}

