/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.OpBatchExecuter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.schedule.form.TaskClientProxy;

public class OpBatchProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_LBLPROGRESS = "lblprogress";
    private static final String BTN_CANCELOP = "cancelop";
    private static final String BTN_TOBACKGROUND = "tobackground";
    private static final String CACHEKEY_LASTPROGRESS = "lastprogress";
    private static final String CACHEKEY_PROGRESS_LASTUPDATETIME = "lastupdatetime";
    private boolean canClose = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTN_CANCELOP, BTN_TOBACKGROUND});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String taskId = this.getOpBatchExecutorTaskId();
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
        this.setProgressTip(ResManager.loadKDString((String)"\u6b63\u5728\u8bfb\u53d6\u4efb\u52a1\u8fdb\u5ea6\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"OpBatchProgressPlugin_0", (String)"bos-entity-business", (Object[])new Object[0]));
    }

    public void onProgress(ProgressEvent evt) {
        String taskId = this.getOpBatchExecutorTaskId();
        if (!OpBatchExecuter.isTaskStarted(taskId)) {
            this.setProgressTip(ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u5df2\u88ab\u5176\u5b83\u9875\u9762\u91ca\u653e\uff0c\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\u3002", (String)"OpBatchProgressPlugin_2", (String)"bos-entity-business", (Object[])new Object[0]));
            TaskClientProxy.delTask((IFormView)this.getView(), (String)((String)this.getView().getFormShowParameter().getCustomParam("schtaskid")));
            return;
        }
        boolean timeout = false;
        boolean completed = OpBatchExecuter.isCompleted(taskId);
        boolean finished = OpBatchExecuter.isFinished(taskId);
        boolean isError = OpBatchExecuter.isError(taskId);
        ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        if (completed || isError || finished) {
            bar.stop();
            this.showResultPage();
            evt.setProgress(100);
        } else {
            int progress = OpBatchExecuter.getProgress(taskId);
            if (progress >= 100) {
                progress = 99;
            }
            evt.setProgress(progress);
            timeout = this.checkResponseTimeout(progress);
        }
        if (timeout) {
            this.setProgressTip(ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u957f\u65f6\u95f4\u6ca1\u6709\u8fdb\u5c55\uff0c\u8bf7\u524d\u5f80\u8c03\u5ea6\u8fd0\u884c\u65e5\u5fd7\u67e5\u770b\u3002", (String)"OpBatchProgressPlugin_1", (String)"bos-entity-business", (Object[])new Object[0]));
        } else {
            String tip = OpBatchExecuter.getProgressTip(taskId);
            if (StringUtils.isNotBlank((CharSequence)tip)) {
                this.setProgressTip(tip);
            }
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            switch (btn.getKey()) {
                case "tobackground": {
                    this.canClose = true;
                }
                case "cancelop": {
                    this.getView().close();
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.canClose) {
            return;
        }
        OpBatchExecuter.setCancel(this.getOpBatchExecutorTaskId(), true);
    }

    private void showResultPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_opbatchresult");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        this.canClose = true;
        IFormView parentView = this.getView().getParentView();
        parentView.showForm(showParameter);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl(KEY_LBLPROGRESS);
        lblTip.setText(tip);
    }

    private String getOpBatchExecutorTaskId() {
        return (String)this.getView().getFormShowParameter().getCustomParam("opexecutortaskid");
    }

    private boolean checkResponseTimeout(int currentProgress) {
        String oldProgress = this.getView().getPageCache().get(CACHEKEY_LASTPROGRESS);
        boolean timeout = false;
        if (String.valueOf(currentProgress).equals(oldProgress)) {
            String lastTimeStr = this.getView().getPageCache().get(CACHEKEY_PROGRESS_LASTUPDATETIME);
            long lastTime = 0L;
            lastTime = StringUtils.isBlank((CharSequence)lastTimeStr) ? System.currentTimeMillis() : Long.parseLong(lastTimeStr);
            timeout = System.currentTimeMillis() - lastTime > 1800000L;
        } else {
            this.getView().getPageCache().put(CACHEKEY_PROGRESS_LASTUPDATETIME, String.valueOf(System.currentTimeMillis()));
        }
        this.getView().getPageCache().put(CACHEKEY_LASTPROGRESS, String.valueOf(currentProgress));
        return timeout;
    }
}

