/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.list.IListView;
import kd.bos.servicehelper.basedata.SoftDeleteHandler;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class StatusConvert
extends DefaultEntityOperate {
    @Override
    protected boolean beforeInvokeOperation(OperationResult result) {
        if (this.isEnableOp() && this.existSoftDeleteRecord()) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5220\u9664\u4e2d\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u72b6\u6001\u3002", (String)"StatusConvert_0", (String)"bos-entity-business", (Object[])new Object[0]);
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError("softdelete", validateResult);
            this.getView().showOperationResult(result);
            return false;
        }
        return super.beforeInvokeOperation(result);
    }

    private boolean isEnableOp() {
        Map parameter = this.getParameter();
        if (parameter == null) {
            return false;
        }
        String statusFieldKey = (String)parameter.get("statusProp");
        return StringUtils.equalsIgnoreCase((CharSequence)"enable", (CharSequence)statusFieldKey);
    }

    private boolean existSoftDeleteRecord() {
        List records = SoftDeleteHandler.getSoftDeleteRecords((String)this.getEntityId());
        if (records.isEmpty()) {
            return false;
        }
        ArrayList<Object> pks = new ArrayList<Object>();
        if (this.getView() instanceof IListView) {
            ListSelectedRowCollection cols = this.getListSelectedData();
            for (ListSelectedRow row : cols) {
                pks.add(row.getPrimaryKeyValue());
            }
        } else if (this.getView() instanceof IBillView) {
            BillShowParameter param = (BillShowParameter)this.getView().getFormShowParameter();
            pks.add(param.getPkId());
        }
        if (pks.isEmpty()) {
            return false;
        }
        return records.containsAll(pks);
    }
}

