/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.SaveValidatorCloseCallBack;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.FormRoot;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.NavigationCache;
import kd.bos.form.operate.OperateUtils;
import kd.bos.list.IListView;
import kd.bos.mvc.bill.BillView;
import kd.bos.param.ParameterReader;
import kd.bos.service.operation.OperationServiceImpl;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Submit
extends DefaultEntityOperate
implements IConfirmCallBack {
    private Boolean submitAndAudit = null;
    private String auditOpKey = null;
    private boolean addNew = false;
    private static final String SUBMITOP = "submitop";
    private boolean preSave = false;
    private String initSaveOpKey = "";

    @Override
    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
        Map saveOpSetting = (Map)this.getParameter().get("saveOp");
        if (!CollectionUtils.isEmpty((Map)saveOpSetting)) {
            String opKey = saveOpSetting.getOrDefault("key", "").toString();
            Boolean enableSave = saveOpSetting.getOrDefault("isSave", true);
            if (StringUtils.isNotBlank((CharSequence)opKey) && enableSave.booleanValue()) {
                this.initSaveOpKey = opKey;
                this.preSave = true;
            }
        }
    }

    private String getPreSaveOpKey() {
        if (!this.preSave) {
            return "";
        }
        List operates = EntityMetadataCache.getDataEntityOperate((String)this.getEntityId());
        ArrayList<String> saveOps = new ArrayList<String>();
        for (Map operate : operates) {
            Object opType = operate.get("type");
            if (!"save".equals(opType)) continue;
            saveOps.add((String)operate.get("key"));
        }
        if (saveOps.isEmpty()) {
            return "";
        }
        if (saveOps.contains(this.initSaveOpKey)) {
            return this.initSaveOpKey;
        }
        return (String)saveOps.get(0);
    }

    public boolean isSubmitAndAudit() {
        if (this.submitAndAudit == null && this.getView() != null) {
            DynamicObject billParamObj = ParameterReader.getBillParameter((String)this.getEntityId());
            this.submitAndAudit = billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)"submitandaudit") ? Boolean.valueOf(billParamObj.getBoolean("submitandaudit")) : Boolean.FALSE;
        }
        if (this.submitAndAudit == null) {
            return Boolean.FALSE;
        }
        return this.submitAndAudit;
    }

    public void setSubmitAndAudit(Boolean submitAndAudit) {
        this.submitAndAudit = submitAndAudit;
    }

    private String getAuditOpKey() {
        if (StringUtils.isNotBlank((CharSequence)this.auditOpKey)) {
            return this.auditOpKey;
        }
        Operations ops = null;
        if (StringUtils.isNotBlank((CharSequence)this.getEntityId())) {
            ops = EntityMetadataCache.getDataEntityOperations((String)this.getEntityId());
        }
        this.auditOpKey = "audit";
        if (ops != null && StringUtils.isNotBlank((CharSequence)ops.getAudit())) {
            this.auditOpKey = ops.getAudit();
        }
        return this.auditOpKey;
    }

    @Override
    protected Set<String> getOperationFields() {
        Set<String> loadFieldKeys = super.getOperationFields();
        MainEntityType mainType = this.getView().getModel().getDataEntityType();
        if (mainType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)mainType).getBillNo())) {
            loadFieldKeys.add(((BillEntityType)mainType).getBillNo());
        }
        OperateOption ops = this.getOption();
        RefObject opValue = new RefObject();
        if (ops != null) {
            this.getOption().tryGetVariableValue("mulilangtext.emptyfill.enable", opValue);
            if (Boolean.parseBoolean((String)opValue.getValue())) {
                DataEntityPropertyCollection props = mainType.getProperties();
                List simpleProps = props.getSimpleProperties(true);
                for (ISimpleProperty simpleProperty : simpleProps) {
                    if (!(simpleProperty instanceof MuliLangTextProp)) continue;
                    loadFieldKeys.add(simpleProperty.getName());
                }
                List entryProps = props.getCollectionProperties(true);
                for (ICollectionProperty entryProp : entryProps) {
                    this.addMulilangTextFieldKey(entryProp.getItemType(), loadFieldKeys);
                }
            }
        }
        return loadFieldKeys;
    }

    private void addMulilangTextFieldKey(IDataEntityType dt, Set<String> loadFieldKeys) {
        List simpleProps = dt.getProperties().getSimpleProperties(true);
        for (ISimpleProperty prop : simpleProps) {
            if (!(prop instanceof MuliLangTextProp)) continue;
            loadFieldKeys.add(prop.getName());
        }
    }

    @Override
    protected boolean beforeInvokeOperation(OperationResult opResult) {
        if (this.isOpenIntentLocks() && !this.checkIntentExist(SUBMITOP)) {
            return false;
        }
        if (this.hasAttachmentUploading()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"Submit_1", (String)"bos-entity-business", (Object[])new Object[0]));
            return false;
        }
        if (this.hasImgUploading() || this.hasImgListUploading()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fe\u7247\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"Submit_2", (String)"bos-entity-business", (Object[])new Object[0]));
            return false;
        }
        boolean result = super.beforeInvokeOperation(opResult);
        if (result) {
            this.getView().getModel().clearNoDataRow();
        }
        return result;
    }

    @Override
    protected boolean needCheckDBDataVersion() {
        Boolean enable = this.getParameter().getOrDefault("checkFormDataVersion", false);
        return enable instanceof Boolean ? enable : Boolean.parseBoolean(((Object)enable).toString());
    }

    @Override
    protected OperationResult callBillOperationService() {
        this.setTempAttachmentOption();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        OperationResult opResult = new OperationResult();
        boolean bl = this.addNew = !dataEntity.getDataEntityState().getFromDatabase();
        if (this.addNew && !this.checkDuplicateSubmit()) {
            opResult.setSuccess(false);
            opResult.setMessage(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002", (String)"Submit_3", (String)"bos-entity-business", (Object[])new Object[0]));
            return opResult;
        }
        this.setModelTableOption();
        this.flexSave(dataEntity);
        OperationServiceImpl operationService = new OperationServiceImpl();
        boolean saveSuccess = false;
        try {
            boolean dosubmit = true;
            String realOpKey = this.getPreSaveOpKey();
            if (StringUtils.isNotBlank((CharSequence)realOpKey)) {
                opResult = this.callPreSaveOperation(realOpKey, new DynamicObject[]{dataEntity}, this.getOption());
                if (opResult != null && (!opResult.isSuccess() || opResult.getSuccessPkIds().isEmpty())) {
                    dosubmit = false;
                } else {
                    saveSuccess = true;
                    dosubmit = true;
                }
            }
            if (dosubmit) {
                opResult = operationService.localInvokeOperation(this.getOperateKey(), new DynamicObject[]{dataEntity}, this.getOption());
            }
        }
        catch (Exception e) {
            if (this.addNew) {
                this.clearDuplicateSubmit();
            }
            throw e;
        }
        if (this.addNew && opResult != null && !opResult.isSuccess()) {
            this.clearDuplicateSubmit();
        }
        if (opResult != null && !opResult.getSuccessPkIds().isEmpty()) {
            this.clearAttsCache();
            boolean removedItems = this.getView().getModel().getDataEntity().getDataEntityState().getRemovedItems();
            this.updateAttachment();
            this.getView().getModel().getDataEntity().getDataEntityState().setRemovedItems(Boolean.valueOf(removedItems));
            this.updateOperationFields(opResult);
            NavigationCache.addPKValue((IFormView)this.getView(), (Object)dataEntity.getPkValue());
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            if (showParameter instanceof BillShowParameter) {
                boolean bl2 = this.addNew = this.addNew || ((BillShowParameter)showParameter).getBillStatus() == BillOperationStatus.ADDNEW;
                if (showParameter.getStatus() == OperationStatus.ADDNEW) {
                    showParameter.setStatus(OperationStatus.EDIT);
                }
                if (((BillShowParameter)showParameter).getBillStatus() == BillOperationStatus.ADDNEW || ((BillShowParameter)showParameter).getBillStatus() == BillOperationStatus.EDIT) {
                    ((BillShowParameter)showParameter).setBillStatus(BillOperationStatus.SUBMIT);
                    this.getView().cacheFormShowParameter();
                }
            }
        } else if (saveSuccess) {
            this.clearAttsCache();
            this.updateAttachment();
            this.updateOperationFields(opResult);
            NavigationCache.addPKValue((IFormView)this.getView(), (Object)dataEntity.getPkValue());
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            if (this.addNew && showParameter instanceof BillShowParameter && ((BillShowParameter)showParameter).getBillStatus() == BillOperationStatus.ADDNEW) {
                showParameter.setStatus(OperationStatus.EDIT);
                ((BillShowParameter)showParameter).setBillStatus(BillOperationStatus.EDIT);
                this.getView().cacheFormShowParameter();
            }
            this.getView().getModel().setDataChanged(false);
        }
        this.notifyListViewChanged();
        return opResult;
    }

    private OperationResult callPreSaveOperation(String saveOpKey, DynamicObject[] dataEntities, OperateOption option) {
        OperationResult operationResult = null;
        try (EntityTraceSpan span = EntityTracer.create((String)"operate", (String)"submit.callPreSaveOperation");){
            boolean doSave = false;
            span.addLocaleTag("objs", (Object)dataEntities);
            span.addLocaleTag("ops", (Object)option);
            if (StringUtils.isNotBlank((CharSequence)saveOpKey)) {
                doSave = true;
                OperationServiceImpl operationService = new OperationServiceImpl();
                operationResult = operationService.localInvokeOperation(saveOpKey, dataEntities, option);
            }
            span.addTag("preSave", String.valueOf(doSave));
            span.addLocaleTag("opResult", (Object)(operationResult == null ? "null" : operationResult));
        }
        return operationResult;
    }

    @Override
    protected boolean isShowMessage(OperationResult operationResult) {
        if (operationResult != null && operationResult.isSuccess() && this.isSubmitAndAudit()) {
            return false;
        }
        return super.isShowMessage(operationResult);
    }

    @Override
    protected void invokeNextOperation(OperationResult opResult) {
        DynamicObject opDyObj;
        String nextOp = "";
        if (!(this.getView() instanceof IListView) && (opDyObj = ParameterHelper.getUserOption((long)RequestContext.get().getCurrUserId(), (String)this.getEntityId())) != null) {
            boolean submitAndAudit = (Boolean)opDyObj.get("submitandaudit");
            Map allOperates = OperateUtils.getAllOperate((String)this.getEntityId());
            List auditOperate = (List)allOperates.get("audit");
            if (submitAndAudit && auditOperate != null && auditOperate.size() == 1) {
                nextOp = (String)auditOperate.get(0);
            } else {
                List newOperate = (List)allOperates.get("new");
                boolean submitAndNew = (Boolean)opDyObj.get("submitandnew");
                if (newOperate != null && newOperate.size() == 1) {
                    if (submitAndNew) {
                        nextOp = (String)newOperate.get(0);
                    } else {
                        boolean saveAndSubmit = (Boolean)opDyObj.get("saveandsubmit");
                        if (saveAndSubmit) {
                            boolean saveAndNew = (Boolean)opDyObj.get("saveandnew");
                            Object sourceOperateType = this.getView().getFormShowParameter().getCustomParam("source_operate_type");
                            if (saveAndNew && "save".equals(sourceOperateType)) {
                                nextOp = (String)newOperate.get(0);
                            }
                        }
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)nextOp)) {
            Object sourceOperateType = this.getView().getFormShowParameter().getCustomParam("source_operate_type");
            if (sourceOperateType == null) {
                this.getView().getFormShowParameter().setCustomParam("source_operate_type", (Object)this.getType());
            }
            this.getView().invokeOperation(nextOp);
        } else {
            String nextOperationKey = (String)this.getParameter().get("afterOperation");
            if (opResult != null && opResult.isSuccess() && this.isSubmitAndAudit()) {
                this.getView().invokeOperation(this.getAuditOpKey());
            } else if (StringUtils.equals((CharSequence)nextOperationKey, (CharSequence)"view") && this.getView() instanceof BillView) {
                this.getOperateLog().info(String.format("invokeNextOperation: %s", "view"));
                this.getView().invokeOperation("view");
            } else {
                super.invokeNextOperation(opResult);
            }
        }
        this.getView().getFormShowParameter().setCustomParam("source_operate_type", null);
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        boolean openIntentLocks = MutexHelper.isOpenIntentLocks();
        if (!opResult.isSuccess() && openIntentLocks) {
            MutexHelper.releaseAndApplyIntent((IFormView)this.getView(), (StringBuilder)new StringBuilder());
        }
        if (opResult.isSuccess()) {
            if (MutexHelper.isOpenIntentLocks()) {
                this.applyILockAfterOperate();
            } else {
                if (this.addNew) {
                    FormRoot rootControl;
                    IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    if (!MutexHelper.allFieldWithRequiredLock((IClientViewProxy)service, (List)(rootControl = (FormRoot)this.getView().getRootControl()).getItems(), (BillOperationStatus)BillOperationStatus.SUBMIT, (MainEntityType)this.getView().getModel().getDataEntityType())) {
                        this.requestMutex("modify");
                    }
                } else if (this.getView() instanceof IBillView) {
                    this.releaseMutexByLock();
                }
                if (Boolean.parseBoolean(opResult.getCustomData().getOrDefault("dataChangValidator.completed", "false"))) {
                    MutexHelper.release((IFormView)this.getView());
                }
            }
        }
        super.afterInvokeOperation(opResult);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)SUBMITOP)) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getView().invokeOperation("refresh");
            }
        } else if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)"savevalidator_refreshactionid")) {
            SaveValidatorCloseCallBack cb = new SaveValidatorCloseCallBack();
            HashMap<String, String> data = new HashMap<String, String>(1);
            data.put("opType", "refresh");
            ClosedCallBackEvent event = new ClosedCallBackEvent((Object)this.getView(), "savevalidator_refreshactionid", data);
            event.setView(this.getView());
            cb.closedCallBack(event);
        }
    }

    private void releaseMutexByLock() {
        IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int status = this.getBillStatus(service);
        if (BillOperationStatus.VIEW.getValue() == status) {
            MutexHelper.release((IFormView)this.getView());
        } else {
            FormRoot rootControl = (FormRoot)this.getView().getRootControl();
            if (MutexHelper.allFieldWithRequiredLock((IClientViewProxy)service, (List)rootControl.getItems(), (BillOperationStatus)BillOperationStatus.SUBMIT, (MainEntityType)this.getView().getModel().getDataEntityType())) {
                MutexHelper.release((IFormView)this.getView());
            }
        }
    }

    private int getBillStatus(IClientViewProxy clientViewProxy) {
        int status = this.getView().getFormShowParameter().getStatusValue();
        BillStatusProp statusProp = null;
        Map metaStatusMap = clientViewProxy.getControlMetaState("status");
        if (metaStatusMap != null && metaStatusMap.containsKey("status")) {
            Object staObj = metaStatusMap.get("status");
            if (staObj instanceof Integer) {
                status = (Integer)staObj;
            }
        } else {
            String billStatusKey;
            MainEntityType mainEntityType = this.getView().getModel().getDataEntityType();
            if (mainEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billStatusKey = ((BillEntityType)mainEntityType).getBillStatus()))) {
                statusProp = (BillStatusProp)mainEntityType.getProperty(billStatusKey);
            }
            if (statusProp != null) {
                String dbStatus = (String)statusProp.getValue((Object)this.getView().getModel().getDataEntity());
                status = this.convertStatus(dbStatus);
            }
        }
        return status;
    }

    private int convertStatus(String status) {
        int result = 0;
        switch (status) {
            case "A": 
            case "new": {
                result = BillOperationStatus.ADDNEW.getValue();
                break;
            }
            case "edit": {
                result = BillOperationStatus.EDIT.getValue();
                break;
            }
            case "view": {
                result = BillOperationStatus.VIEW.getValue();
                break;
            }
            case "B": 
            case "submit": {
                result = BillOperationStatus.SUBMIT.getValue();
                break;
            }
            case "C": 
            case "audit": {
                result = BillOperationStatus.AUDIT.getValue();
                break;
            }
        }
        return result;
    }
}

