/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.DefaultValueCalculator;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.rule.BRAction;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FillDateTimeAction
extends BRAction {
    private static final Log log = LogFactory.getLog(FillDateTimeAction.class);
    private Map<String, String> expression;

    public void setParameter(Map<String, Object> param) {
        if (param.get("expression") != null) {
            this.expression = (Map)param.get("expression");
        }
    }

    public void execute(BRExecuteContext executeContext) {
        if (executeContext._raiseEventTypeFlag != RaiseEventType.FieldChanged) {
            return;
        }
        if (this.expression == null || this.expression.isEmpty()) {
            log.info("expression \u4e3a\u7a7a");
            return;
        }
        IDataModel model = executeContext.getModel();
        String dateField = this.expression.get("DateField");
        String orgField = this.expression.get("orgField");
        String funcName = this.expression.get("Expression");
        if (StringUtils.isBlank((CharSequence)funcName) || StringUtils.isBlank((CharSequence)orgField) || StringUtils.isBlank((CharSequence)dateField)) {
            log.info(String.format("expression\uff1a%s\u8868\u8fbe\u5f0f\u4e0d\u89c4\u8303", SerializationUtils.toJsonString(this.expression)));
            return;
        }
        Object orgValue = model.getValue(orgField);
        DynamicProperty dateProp = model.getDataEntityType().getProperty(dateField);
        Date value = null;
        switch (funcName) {
            case "#CurrentDateOrgTZ#": {
                value = DefaultValueCalculator.getCurrentDateOrgTZ((Object)orgValue, (boolean)false, (boolean)(dateProp instanceof DateTimeProp));
                break;
            }
            case "#CurrentDatetimeOrgTZ#": {
                value = DefaultValueCalculator.getCurrentDateOrgTZ((Object)orgValue, (boolean)true, (boolean)(dateProp instanceof DateTimeProp));
                break;
            }
        }
        model.setValue(dateField, value);
    }

    @SimplePropertyAttribute
    public Map<String, String> getExpression() {
        return this.expression;
    }

    public void setExpression(Map<String, String> expression) {
        this.expression = expression;
    }

    public String toString() {
        return this.expression == null ? "" : JSON.toJSONString(this.expression);
    }
}

