/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.UnitConvertDTO;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.rule.BRAction;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.UnitConvertHelper;

public class FillQtyAction
extends BRAction {
    private static final Log log = LogFactory.getLog(FillQtyAction.class);
    private String expression;

    public void setParameter(Map<String, Object> param) {
        this.expression = (String)param.get("expression");
    }

    public void execute(BRExecuteContext executeContext) {
        if (executeContext._raiseEventTypeFlag != RaiseEventType.FieldChanged) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.expression)) {
            return;
        }
        IDataModel model = executeContext.getModel();
        List unitConvertDTOs = SerializationUtils.fromJsonStringToList((String)this.expression, UnitConvertDTO.class);
        for (UnitConvertDTO unitConvertDTO : unitConvertDTOs) {
            String distQty = unitConvertDTO.getDistQtyField();
            String srcQty = unitConvertDTO.getSrcQtyField();
            if (!StringUtils.isNotBlank((CharSequence)srcQty) || !StringUtils.isNotBlank((CharSequence)distQty)) continue;
            MainEntityType dt = model.getDataEntityType();
            Map allFields = dt.getAllFields();
            QtyProp distQtyProp = (QtyProp)allFields.get(distQty);
            QtyProp srcQtyProp = (QtyProp)allFields.get(srcQty);
            StringBuilder errMsg = new StringBuilder();
            try {
                List dataEntities = executeContext.getDataEntities();
                boolean convertCurContextObj = true;
                for (RowDataEntity row : dataEntities) {
                    DataEntityPropertyCollection properties = row.getDataEntity().getDataEntityType().getProperties();
                    if (properties.get((Object)distQtyProp.getName()) != null && properties.get((Object)srcQtyProp.getName()) != null) {
                        UnitConvertHelper.convertQtyByNewUnit((IDataModel)model, (QtyProp)srcQtyProp, (QtyProp)distQtyProp, (int)row.getRowIndex(), (StringBuilder)errMsg);
                        continue;
                    }
                    convertCurContextObj = false;
                    break;
                }
                if (!convertCurContextObj) {
                    UnitConvertHelper.convertQtyByNewUnit((IDataModel)model, (QtyProp)srcQtyProp, (QtyProp)distQtyProp, (StringBuilder)errMsg);
                }
                if (errMsg.length() <= 0) continue;
                log.error(errMsg.toString());
            }
            catch (Exception e) {
                UnitConvertHelper.convertQtyByNewUnit((IDataModel)model, (QtyProp)srcQtyProp, (QtyProp)distQtyProp, (StringBuilder)errMsg);
                if (errMsg.length() <= 0) continue;
                log.error(errMsg.toString());
            }
        }
    }

    @SimplePropertyAttribute
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String toString() {
        return this.expression;
    }
}

