/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.rule.BRAction;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class SetEqutionAction
extends BRAction {
    private static Set<Class<?>> formatClz = new HashSet();
    private List<Map<String, Object>> expression;
    private boolean onlyEmptyRow;

    public void setParameter(Map<String, Object> param) {
        this.expression = (List)param.get("expression");
        this.onlyEmptyRow = (Boolean)param.get("onlyEmptyRow");
    }

    public void execute(BRExecuteContext executeContext) {
        if (executeContext.getDataEntities() == null || executeContext.getDataEntities().isEmpty()) {
            return;
        }
        for (Map<String, Object> parameter : this.expression) {
            this.setEqutionValue(parameter, executeContext);
        }
    }

    private void setEqutionValue(Map<String, Object> parameter, BRExecuteContext executeContext) {
        String targetFieldKey;
        IDataModel model = executeContext.getModel();
        String srcPropName = (String)parameter.get("srcField");
        if (StringUtils.equals((CharSequence)srcPropName, (CharSequence)(targetFieldKey = (String)parameter.get("targetField")))) {
            return;
        }
        DynamicObjectType entityType = ((RowDataEntity)executeContext.getDataEntities().get(0)).getDataEntity().getDynamicObjectType();
        IDataEntityProperty targetProp = model.getProperty(targetFieldKey);
        IDataEntityProperty srcProp = model.getProperty(srcPropName);
        if (srcProp == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b9e\u4f53\u4e0a\u6ca1\u627e\u5230\u89c4\u5219\u5f15\u7528\u5b57\u6bb5\uff1a\u201c%2$s\u201d", (String)"SetEqutionAction_1", (String)"bos-entity-business", (Object[])new Object[0]), entityType.getDisplayName().toString(), srcPropName));
        }
        if (targetProp == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b9e\u4f53\u4e0a\u6ca1\u627e\u5230\u89c4\u5219\u5f15\u7528\u5b57\u6bb5\uff1a\u201c%2$s\u201d", (String)"SetEqutionAction_1", (String)"bos-entity-business", (Object[])new Object[0]), entityType.getDisplayName().toString(), targetFieldKey));
        }
        if (!StringUtils.equals((CharSequence)targetProp.getParent().getName(), (CharSequence)entityType.getName())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b9e\u4f53\u670d\u52a1\u89c4\u5219\u51fa\u9519\uff1a\u201c%2$s\u201d\u4e0d\u662f\u672c\u5b9e\u4f53\u4e0a\u7684\u5b57\u6bb5\uff0c\u4e0d\u80fd\u643a\u5e26\u5b57\u6bb5\u503c\u8fc7\u53bb\u3002", (String)"SetEqutionAction_0", (String)"bos-entity-business", (Object[])new Object[0]), entityType.getDisplayName().toString(), ((DynamicProperty)targetProp).getDisplayName().toString()));
        }
        RowDataModel rowDataModel = new RowDataModel(entityType.getName(), model);
        for (RowDataEntity row : executeContext.getDataEntities()) {
            rowDataModel.setRowContext(row.getDataEntity());
            if (!this.canTakeValue(rowDataModel, targetProp, this.getOnlyEmptyRow())) continue;
            Object value = rowDataModel.getValue(srcPropName);
            model.setValue(targetFieldKey, this.convertValueType(srcProp, targetProp, value), row.getRowIndex(), row.getParentRowIndex());
        }
    }

    private boolean canTakeValue(RowDataModel rowDataModel, IDataEntityProperty targetProp, boolean onlyEmptyRow) {
        if (!onlyEmptyRow) {
            return true;
        }
        if (!(targetProp instanceof IValidatorHanlder)) {
            return true;
        }
        Object oldValue = rowDataModel.getValue(targetProp.getName());
        if (oldValue instanceof DynamicObject) {
            oldValue = ((DynamicObject)oldValue).getPkValue();
        }
        return ((IValidatorHanlder)targetProp).getValueComparator().compareValue(oldValue);
    }

    @SimplePropertyAttribute
    public boolean getOnlyEmptyRow() {
        return this.onlyEmptyRow;
    }

    public void setOnlyEmptyRow(boolean onlyEmptyRow) {
        this.onlyEmptyRow = onlyEmptyRow;
    }

    @SimplePropertyAttribute
    public List<Map<String, Object>> getExpression() {
        return this.expression;
    }

    public void setExpression(List<Map<String, Object>> expression) {
        this.expression = expression;
    }

    private Object convertValueType(IDataEntityProperty srcProp, IDataEntityProperty targetProp, Object value) {
        if (targetProp.getPropertyType() == String.class) {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toPlainString();
            }
            if (value != null && this.isNeedFormat(srcProp)) {
                FormatObject formatObject = InteServiceHelper.getUserFormat((Long)Long.parseLong(RequestContext.get().getUserId()));
                if (srcProp instanceof DateProp) {
                    return FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(formatObject).format(value);
                }
                if (srcProp instanceof DateTimeProp) {
                    return FormatFactory.get((FormatTypes)FormatTypes.Time).getFormat(formatObject).format(value);
                }
            }
        }
        return value;
    }

    private boolean isNeedFormat(IDataEntityProperty prop) {
        return formatClz.contains(prop.getClass());
    }

    public String toString() {
        return "" + this.expression;
    }

    static {
        formatClz.add(DateTimeProp.class);
        formatClz.add(DateProp.class);
        formatClz.add(DecimalProp.class);
    }
}

