/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgRelationItem;
import kd.bos.entity.property.org.OrgRelationItemOrg;
import kd.bos.entity.rule.BRAction;
import kd.bos.entity.rule.BRExecuteContext;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class UpdateOrgDelegateAction
extends BRAction {
    private static final Log log = LogFactory.getLog(UpdateOrgDelegateAction.class);
    private static final String BOS_ENTITY_BUSINESS = "bos-entity-business";
    private String orgField;
    private boolean overrideVal = false;

    public void setParameter(Map<String, Object> param) {
        if (param.get("orgField") != null) {
            this.orgField = (String)param.get("orgField");
        }
    }

    public void execute(BRExecuteContext executeContext) {
        if (executeContext._raiseEventTypeFlag == RaiseEventType.FieldChanged) {
            this.overrideVal = true;
        }
        if (StringUtils.isEmpty((CharSequence)this.orgField)) {
            log.info("orgField is null");
            return;
        }
        if (executeContext.getDataEntities() == null || executeContext.getDataEntities().isEmpty()) {
            return;
        }
        List<OrgProp> delegateOrgs = this.getDelegateOrgsWithSpan(executeContext.getModel().getDataEntityType(), this.orgField);
        if (delegateOrgs == null || delegateOrgs.isEmpty()) {
            return;
        }
        this.updateDelegateWithSpan(executeContext, delegateOrgs);
    }

    private void updateDelegateWithSpan(BRExecuteContext executeContext, List<OrgProp> delegateOrgs) {
        if (!EntityTracer.isRealtime()) {
            this.updateDelegate(executeContext, delegateOrgs);
        } else {
            try (EntityTraceSpan span = EntityTracer.create((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"updateDelegate", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                this.updateDelegate(executeContext, delegateOrgs);
            }
        }
    }

    private void updateDelegate(BRExecuteContext executeContext, List<OrgProp> delegateOrgs) {
        IDataModel model = executeContext.getModel();
        IDataEntityProperty srcProp = (IDataEntityProperty)model.getDataEntityType().getAllFields().get(this.orgField);
        if (srcProp == null) {
            return;
        }
        int currentParentRowIndex = -1;
        if (srcProp.getParent() instanceof SubEntryType) {
            currentParentRowIndex = model.getEntryCurrentRowIndex(srcProp.getParent().getParent().getName());
        }
        List dataEntities = executeContext.getDataEntities();
        ChangeData[] changeDatas = new ChangeData[dataEntities.size()];
        for (int i = 0; i < dataEntities.size(); ++i) {
            ChangeData[] rowDataEntity = (ChangeData[])dataEntities.get(i);
            changeDatas[i] = new ChangeData(rowDataEntity.getRowIndex(), rowDataEntity.getDataEntity(), null, null);
        }
        ArrayList<FourTuple> valueList = new ArrayList<FourTuple>(32);
        for (ChangeData o : changeDatas) {
            List<FourTuple> tempList;
            if (currentParentRowIndex >= 0 && currentParentRowIndex != o.getParentRowIndex() || CollectionUtils.isEmpty(tempList = this.setDelegateOrgValue(delegateOrgs, model, srcProp, o))) continue;
            valueList.addAll(tempList);
        }
        if (!CollectionUtils.isEmpty(valueList)) {
            RuleContainer ruleContainer = (RuleContainer)model.getService(RuleContainer.class);
            ruleContainer.setMaxTaskCount((long)valueList.size());
            for (FourTuple obj : valueList) {
                model.setValue((String)obj.item1, obj.item2, ((Integer)obj.item3).intValue(), ((Integer)obj.item4).intValue());
            }
        }
    }

    private List<FourTuple> setDelegateOrgValue(List<OrgProp> delegateOrgs, IDataModel model, IDataEntityProperty srcProp, ChangeData o) {
        IDefValueProvider defValueProvider = (IDefValueProvider)model.getService(IDefValueProvider.class);
        if (defValueProvider == null) {
            return null;
        }
        ArrayList<FourTuple> valueList = new ArrayList<FourTuple>(32);
        block0: for (int i = 0; i < delegateOrgs.size(); ++i) {
            int index;
            Object defOrgValue;
            OrgProp delegateOrg = delegateOrgs.get(i);
            if (delegateOrg.getParent() instanceof SubEntryType && srcProp.getParent() instanceof SubEntryType) {
                if (!this.isOverrideVal(model, delegateOrg.getName(), o.getRowIndex(), o.getParentRowIndex()) || (defOrgValue = defValueProvider.getOrgDefValue(model, delegateOrg, o)) == null) continue;
                valueList.add(new FourTuple((Object)delegateOrg.getName(), defOrgValue, (Object)o.getRowIndex(), (Object)o.getParentRowIndex()));
                continue;
            }
            if (delegateOrg.getParent() instanceof SubEntryType && srcProp.getParent() instanceof EntryType) {
                int count = model.getEntryRowCount(delegateOrg.getParent().getName());
                Object defOrgValue2 = null;
                for (index = 0; index < count; ++index) {
                    if (!this.isOverrideVal(model, delegateOrg.getName(), index, o.getParentRowIndex())) continue;
                    if (defOrgValue2 == null && (defOrgValue2 = defValueProvider.getOrgDefValue(model, delegateOrg, o)) == null) continue block0;
                    valueList.add(new FourTuple((Object)delegateOrg.getName(), defOrgValue2, (Object)index, (Object)o.getParentRowIndex()));
                }
                continue;
            }
            if (delegateOrg.getParent() instanceof EntryType && srcProp.getParent() instanceof EntryType) {
                if (!this.isOverrideVal(model, delegateOrg.getName(), o.getRowIndex(), o.getParentRowIndex()) || (defOrgValue = defValueProvider.getOrgDefValue(model, delegateOrg, o)) == null) continue;
                valueList.add(new FourTuple((Object)delegateOrg.getName(), defOrgValue, (Object)o.getRowIndex(), (Object)o.getParentRowIndex()));
                continue;
            }
            if (delegateOrg.getParent() instanceof EntryType && srcProp.getParent() instanceof EntityType) {
                defOrgValue = null;
                int count = model.getEntryRowCount(delegateOrg.getParent().getName());
                for (index = 0; index < count; ++index) {
                    if (!this.isOverrideVal(model, delegateOrg.getName(), index, o.getParentRowIndex())) continue;
                    if (defOrgValue == null && (defOrgValue = defValueProvider.getOrgDefValue(model, delegateOrg, o)) == null) continue block0;
                    valueList.add(new FourTuple((Object)delegateOrg.getName(), defOrgValue, (Object)index, (Object)o.getParentRowIndex()));
                }
                continue;
            }
            if (!(delegateOrg.getParent() instanceof EntityType) || !(srcProp.getParent() instanceof EntityType) || !this.isOverrideVal(model, delegateOrg.getName(), -1, -1) || (defOrgValue = defValueProvider.getOrgDefValue(model, delegateOrg, o)) == null) continue;
            valueList.add(new FourTuple((Object)delegateOrg.getName(), defOrgValue, (Object)-1, (Object)-1));
        }
        return valueList;
    }

    private List<OrgProp> getDelegateOrgsWithSpan(MainEntityType dataEntityType, String orgName) {
        if (!EntityTracer.isRealtime()) {
            return this.getDelegateOrgs(dataEntityType, orgName);
        }
        try (EntityTraceSpan span = EntityTracer.create((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getDelegateOrgs", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            List<OrgProp> list = this.getDelegateOrgs(dataEntityType, orgName);
            return list;
        }
    }

    private List<OrgProp> getDelegateOrgs(MainEntityType dataEntityType, String orgName) {
        ArrayList<OrgProp> delegateOrgs = new ArrayList<OrgProp>(4);
        Map allFields = dataEntityType.getAllFields();
        for (Map.Entry propMap : allFields.entrySet()) {
            OrgRelationItemOrg org;
            List orgRelation;
            IDataEntityProperty prop = (IDataEntityProperty)propMap.getValue();
            if (!(prop instanceof OrgProp) || (orgRelation = ((OrgProp)prop).getOrgRelation()) == null || orgRelation.isEmpty() || !orgName.equals((org = ((OrgRelationItem)orgRelation.get(0)).getOrg()).getNumber())) continue;
            delegateOrgs.add((OrgProp)prop);
        }
        return delegateOrgs;
    }

    private boolean isOverrideVal(IDataModel model, String propName, int index, int parentRowIndex) {
        Object value = model.getValue(propName, index, parentRowIndex);
        return this.overrideVal || value == null;
    }
}

