/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.business.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.fulltext.MatchProperty;
import kd.bos.lang.Lang;

public class AbstractFullTextIndexOp
extends AbstractOperationServicePlugIn {
    protected Map<String, BillEntityType> entityTypeMap = new HashMap<String, BillEntityType>();
    protected List<MatchProperty> matchProperties = new ArrayList<MatchProperty>();

    protected void prepareData(String entityNumber, String fieldName) {
        if ("all_billno".equalsIgnoreCase(entityNumber)) {
            this.entityTypeMap.put("all_billno", null);
        } else {
            String[] split = fieldName.split(",");
            ArrayList<String> properties = new ArrayList<String>(split.length);
            for (String propertyName : split) {
                properties.add(propertyName);
            }
            MainEntityType mainEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)entityNumber, properties);
            for (String propertyName : split) {
                FilterField filterField = FilterField.create((MainEntityType)mainEntityType, (String)propertyName);
                String entityId = entityNumber;
                if (StringUtils.isNotBlank((CharSequence)filterField.getRefEntityId())) {
                    entityId = filterField.getRefEntityId();
                }
                if (!this.entityTypeMap.containsKey(entityId)) {
                    BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
                    this.entityTypeMap.put(entityId, billEntityType);
                }
                if (filterField.getSrcFieldProp() instanceof MuliLangTextProp) {
                    boolean isNameField = false;
                    if (mainEntityType instanceof BasedataEntityType) {
                        isNameField = filterField.getRefPropKey().equalsIgnoreCase(((BasedataEntityType)mainEntityType).getNameProperty());
                    }
                    for (Lang lang : Lang.values()) {
                        MatchProperty matchProperty = lang == Lang.zh_CN ? new MatchProperty(filterField.getRefPropKey(), lang, isNameField) : new MatchProperty(filterField.getRefPropKey(), lang, false);
                        this.matchProperties.add(matchProperty);
                    }
                    continue;
                }
                this.matchProperties.add(new MatchProperty(filterField.getRefPropKey(), null, false));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs afteroperationargs) {
        String entityNumber = (String)((ExtendedDataEntity)afteroperationargs.getSelectedRows().get(0)).getValue("fentitynumber_id");
        String fieldName = (String)((ExtendedDataEntity)afteroperationargs.getSelectedRows().get(0)).getValue("ffieldname");
        this.prepareData(entityNumber, fieldName);
    }
}

