/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.business.plugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BaseTreeLongNumberOp
extends AbstractOperationServicePlugIn {
    private static final String LEVEL = "level";
    private static final String LONG_NUMBER = "longnumber";
    private static final String FULL_NAME = "fullname";
    private static final String NUMBER = "number";
    private static final String PARENT = "parent";
    private static final String NAME = "name";
    private static final String SELECT_FIELD = "id,longnumber,fullname,level,number,name,parent";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(LEVEL);
        e.getFieldKeys().add("parent_id");
        e.getFieldKeys().add(LONG_NUMBER);
        e.getFieldKeys().add(FULL_NAME);
        e.getFieldKeys().add(NUMBER);
        e.getFieldKeys().add(NAME);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map operMeta = this.operateMeta;
        if (null == operMeta) {
            return;
        }
        String operateType = (String)operMeta.get("type");
        if (StringUtils.isNotEmpty((CharSequence)"operateType") && (operateType.equals("save") || operateType.equals("submit"))) {
            DynamicObject[] list = e.getDataEntities();
            String longNumberDLM = ".";
            IDataEntityType dataEntityType = list[0].getDataEntityType();
            if (list.length > 0) {
                for (IDataEntityProperty dymProperty : dataEntityType.getProperties()) {
                    if (!(dymProperty instanceof ParentBasedataProp)) continue;
                    longNumberDLM = ((ParentBasedataProp)dymProperty).getLongNumberDLM();
                    break;
                }
            }
            if ("submit".equals(e.getOperationKey()) || "save".equals(e.getOperationKey()) || "saveandnew".equals(e.getOperationKey())) {
                List<Object> pkList = Arrays.stream(list).map(item -> item.getPkValue()).collect(Collectors.toList());
                this.processLeafNode(list, pkList, dataEntityType, longNumberDLM);
            }
            this.processCurrentNode(list, longNumberDLM);
        }
    }

    private void processLeafNode(DynamicObject[] list, List<Object> pkList, IDataEntityType dataEntityType, String longNumberDLM) {
        Map oldObjectList = BusinessDataServiceHelper.loadFromCache((String)dataEntityType.getName(), (String)SELECT_FIELD, (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
        for (DynamicObject dynamicObject : list) {
            DynamicObject oldObject = (DynamicObject)oldObjectList.get(dynamicObject.getPkValue());
            if (oldObject == null) continue;
            DynamicObject oldParent = oldObject.getDynamicObject(PARENT);
            DynamicObject currentParent = dynamicObject.getDynamicObject(PARENT);
            if (currentParent == null && oldParent == null || oldParent != null && currentParent != null && currentParent.getPkValue().equals(oldParent.getPkValue())) {
                this.processChange(oldObject, dynamicObject, longNumberDLM, dataEntityType);
                continue;
            }
            this.processParentChanges(oldObject, dynamicObject, longNumberDLM);
        }
    }

    private void processCurrentNode(DynamicObject[] list, String longNumberDLM) {
        for (DynamicObject doj : list) {
            if (doj.getDataEntityType().getProperties().get((Object)PARENT) == null) continue;
            String number = doj.getString(NUMBER);
            Object name = doj.get(NAME);
            int level = doj.getInt(LEVEL);
            Object parentId = doj.get("parent_id");
            Object parentFullName = doj.get("parent.fullname");
            int parentLevel = doj.getInt("parent.level");
            if (StringUtils.isNotBlank((CharSequence)number)) {
                String parentLongNumber = doj.getString("parent.longnumber");
                if (StringUtils.isNotBlank((CharSequence)parentLongNumber)) {
                    doj.set(LONG_NUMBER, (Object)(parentLongNumber + longNumberDLM + number));
                } else {
                    for (DynamicObject dynamicObject : list) {
                        if (!dynamicObject.get("id").equals(parentId)) continue;
                        parentLongNumber = dynamicObject.getString(LONG_NUMBER);
                        parentFullName = dynamicObject.get(FULL_NAME);
                        parentLevel = dynamicObject.getInt(LEVEL);
                        break;
                    }
                    if (StringUtils.isNotBlank((CharSequence)parentLongNumber)) {
                        doj.set(LONG_NUMBER, (Object)(parentLongNumber + longNumberDLM + number));
                    } else if (parentId != null) {
                        QFilter filter = new QFilter("id", "=", parentId);
                        DynamicObject tempDoj = ORM.create().queryOne(doj.getDataEntityType().getName(), SELECT_FIELD, new QFilter[]{filter});
                        if (tempDoj != null) {
                            parentLongNumber = tempDoj.getString(LONG_NUMBER);
                            parentFullName = tempDoj.get(FULL_NAME);
                            parentLevel = tempDoj.getInt(LEVEL);
                            if (StringUtils.isNotBlank((CharSequence)parentLongNumber)) {
                                doj.set(LONG_NUMBER, (Object)(parentLongNumber + longNumberDLM + number));
                            } else {
                                doj.set(LONG_NUMBER, (Object)number);
                            }
                        } else {
                            doj.set(LONG_NUMBER, (Object)number);
                        }
                    } else {
                        doj.set(LONG_NUMBER, (Object)number);
                    }
                }
            }
            if (name != null && StringUtils.isNotBlank((CharSequence)name.toString())) {
                doj.set(FULL_NAME, this.updateFullName(name, doj.get(FULL_NAME), longNumberDLM, parentFullName));
            }
            if (parentLevel != 0) {
                doj.set(LEVEL, (Object)(parentLevel + 1));
                continue;
            }
            doj.set(LEVEL, (Object)level);
        }
    }

    private void processChange(DynamicObject oldObject, DynamicObject data, String longNumberDLM, IDataEntityType dataEntityType) {
        String number = data.getString(NUMBER);
        boolean numberChange = this.isDataChange((IDataEntityProperty)dataEntityType.getProperties().get((Object)NUMBER), number, oldObject);
        Object name = data.get(NAME);
        boolean nameChange = this.isDataChange((IDataEntityProperty)dataEntityType.getProperties().get((Object)NAME), name, oldObject);
        if (!numberChange && !nameChange) {
            return;
        }
        Object id = data.getPkValue();
        HashMap<String, String> mapLongNumber = new HashMap<String, String>(16);
        HashMap<String, Object> mapFullName = new HashMap<String, Object>(16);
        DynamicObject parent = data.getDynamicObject(PARENT);
        if (numberChange) {
            if (parent != null) {
                mapLongNumber.put(id.toString(), String.format("%s%s%s", parent.getString(LONG_NUMBER), longNumberDLM, number));
            } else {
                mapLongNumber.put(id.toString(), number);
            }
        }
        if (nameChange) {
            Object parentFullName = null;
            if (parent != null) {
                parentFullName = parent.get(FULL_NAME);
            }
            Object fullName = this.updateFullName(name, data.get(FULL_NAME), longNumberDLM, parentFullName);
            mapFullName.put(id.toString(), fullName);
        }
        String oldLongNumber = oldObject.getString(LONG_NUMBER);
        QFilter longFilter = new QFilter(LONG_NUMBER, "like", (Object)(oldLongNumber + longNumberDLM + "%")).and(new QFilter("id", "!=", id));
        Object[] dys = BusinessDataServiceHelper.load((String)data.getDataEntityType().getName(), (String)SELECT_FIELD, (QFilter[])new QFilter[]{longFilter}, (String)"level asc");
        if (dys == null || dys.length <= 0) {
            return;
        }
        for (DynamicObject dynamicObject : dys) {
            String currentLongNumber = dynamicObject.getString(LONG_NUMBER);
            if (currentLongNumber == null || currentLongNumber.indexOf(longNumberDLM) == -1) {
                return;
            }
            DynamicObject oldParent = dynamicObject.getDynamicObject(PARENT);
            if (oldParent == null) continue;
            if (numberChange && mapLongNumber.get(oldParent.getString("id")) != null) {
                String longNumber = (String)mapLongNumber.get(oldParent.getString("id")) + longNumberDLM + dynamicObject.getString(NUMBER);
                dynamicObject.set(LONG_NUMBER, (Object)longNumber);
                mapLongNumber.put(dynamicObject.getString("id"), longNumber);
            }
            if (!nameChange || dynamicObject.getString(FULL_NAME) == null || dynamicObject.getString(FULL_NAME).indexOf(longNumberDLM) == -1 || mapFullName.get(oldParent.getString("id")) == null) continue;
            Object fullName = this.updateFullName(dynamicObject.get(NAME), dynamicObject.get(FULL_NAME), longNumberDLM, mapFullName.get(oldParent.getString("id")));
            dynamicObject.set(FULL_NAME, fullName);
            mapFullName.put(dynamicObject.getString("id"), fullName);
        }
        SaveServiceHelper.save((IDataEntityType)dys[0].getDataEntityType(), (Object[])dys);
    }

    private void processParentChanges(DynamicObject oldObject, DynamicObject currentObject, String longNumberDLM) {
        DynamicObject currentParent = currentObject.getDynamicObject(PARENT);
        String pLongNumber = oldObject.getString(LONG_NUMBER);
        QFilter longFilter = new QFilter(LONG_NUMBER, "like", (Object)(pLongNumber + longNumberDLM + "%")).and(new QFilter("id", "!=", currentObject.getPkValue()));
        Object[] dys = BusinessDataServiceHelper.load((String)currentObject.getDataEntityType().getName(), (String)SELECT_FIELD, (QFilter[])new QFilter[]{longFilter}, (String)"level asc");
        if (dys == null || dys.length == 0) {
            return;
        }
        if (dys[0].getDynamicObject(PARENT) == null || !currentObject.getString("id").equals(dys[0].getDynamicObject(PARENT).getString("id"))) {
            return;
        }
        HashMap<String, String> mapLongNumber = new HashMap<String, String>(dys.length);
        HashMap<String, Object> mapFulName = new HashMap<String, Object>(dys.length);
        HashMap<String, Integer> mapLevel = new HashMap<String, Integer>(dys.length);
        for (DynamicObject dynamicObject : dys) {
            if (currentParent != null && currentParent.getPkValue().toString().equals(dynamicObject.getPkValue().toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u4e0b\u7ea7\u8282\u70b9\u4f5c\u4e3a\u4e0a\u7ea7\uff01", (String)"BaseTreeLongNumberOp_1", (String)"bos-business-opplugin", (Object[])new Object[0]));
            }
            mapLongNumber.put(dynamicObject.getString("id"), dynamicObject.getString(LONG_NUMBER));
            mapFulName.put(dynamicObject.getString("id"), dynamicObject.get(FULL_NAME));
            mapLevel.put(dynamicObject.getString("id"), dynamicObject.getInt(LEVEL));
        }
        for (DynamicObject dynamicObject : dys) {
            int level;
            String longNumber;
            Object fullName = dynamicObject.get(FULL_NAME);
            DynamicObject oldParent = (DynamicObject)dynamicObject.get(PARENT);
            if (oldParent != null && mapLongNumber.get(oldParent.getString("id")) != null) {
                longNumber = (String)mapLongNumber.get(oldParent.getString("id")) + longNumberDLM + dynamicObject.getString(NUMBER);
                fullName = this.updateFullName(dynamicObject.get(NAME), fullName, longNumberDLM, mapFulName.get(oldParent.getString("id")));
                level = (Integer)mapLevel.get(oldParent.getString("id")) + 1;
            } else if (currentParent != null) {
                longNumber = currentParent.getString(LONG_NUMBER) + longNumberDLM + currentObject.getString(NUMBER) + longNumberDLM + dynamicObject.getString(NUMBER);
                fullName = this.updateFullName(currentObject.get(NAME), fullName, longNumberDLM, currentParent.get(FULL_NAME));
                fullName = this.updateFullName(dynamicObject.get(NAME), fullName, longNumberDLM, fullName);
                level = currentObject.getInt(LEVEL) + 1;
            } else {
                longNumber = currentObject.getString(NUMBER) + longNumberDLM + dynamicObject.getString(NUMBER);
                fullName = this.updateFullName(dynamicObject.get(NAME), fullName, longNumberDLM, currentObject.get(NAME));
                level = currentObject.getInt(LEVEL) + 1;
            }
            if (!longNumber.equals(dynamicObject.getString(LONG_NUMBER))) {
                dynamicObject.set(LONG_NUMBER, (Object)longNumber);
                dynamicObject.set(LEVEL, (Object)level);
                mapLongNumber.put(dynamicObject.getString("id"), longNumber);
                mapLevel.put(dynamicObject.getString("id"), level);
            }
            dynamicObject.set(FULL_NAME, fullName);
            mapFulName.put(dynamicObject.getString("id"), fullName);
        }
        SaveServiceHelper.save((IDataEntityType)dys[0].getDataEntityType(), (Object[])dys);
    }

    private boolean isDataChange(IDataEntityProperty property, Object value, DynamicObject oldObject) {
        try {
            if (property instanceof MuliLangTextProp && value instanceof ILocaleString) {
                ILocaleString oldValue = oldObject.getLocaleString(property);
                if (((ILocaleString)value).size() != oldValue.size()) {
                    return true;
                }
                for (Map.Entry localeValue : ((ILocaleString)value).entrySet()) {
                    if (StringUtils.equals((CharSequence)((CharSequence)localeValue.getValue()), (CharSequence)((CharSequence)oldValue.getItem((String)localeValue.getKey())))) continue;
                    return true;
                }
            } else {
                String oldValue = oldObject.getString(property);
                if (!StringUtils.equals((CharSequence)((String)value), (CharSequence)oldValue)) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private Object updateFullName(Object name, Object fullName, String longNumberDLM, Object parentFullName) {
        if (name instanceof ILocaleString && fullName instanceof ILocaleString) {
            LocaleString newFullName = new LocaleString();
            Set allLang = ((ILocaleString)fullName).keySet();
            for (Map.Entry value : ((ILocaleString)name).entrySet()) {
                String lcid = (String)value.getKey();
                String parFullName = null;
                if (StringUtils.equals((CharSequence)"GLang", (CharSequence)lcid) && !allLang.contains(lcid)) continue;
                if (parentFullName instanceof ILocaleString) {
                    parFullName = (String)((ILocaleString)parentFullName).getItem(lcid);
                }
                if (StringUtils.isNotEmpty(parFullName)) {
                    newFullName.setItem(lcid, (Object)String.format("%s%s%s", parFullName, longNumberDLM, value.getValue()));
                    continue;
                }
                newFullName.setItem((String)value.getKey(), value.getValue());
            }
            return newFullName;
        }
        if (parentFullName != null && StringUtils.isNotBlank((CharSequence)parentFullName.toString())) {
            return parentFullName + longNumberDLM + name;
        }
        return name.toString();
    }
}

