/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.business.plugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.business.plugin.BaseTreeParentValidate;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.datamanager.DataEntityCacheManager;

public class BaseTreeOp
extends AbstractOperationServicePlugIn {
    private static final String IS_LEAF = "isleaf";
    private static final String SELECT = "select ";
    private static final String WHERE = " where ";
    private static final String IN = " in (";
    private static final String FORM = " from ";
    private static final String ERROR_MSG = "error:%s;  sql:%s";
    private static final String PARENT = "parent";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(IS_LEAF);
        e.getFieldKeys().add(PARENT);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] doj = e.getDataEntities();
        HashSet<Object> clearCacheKey = new HashSet<Object>(10);
        for (DynamicObject d : doj) {
            clearCacheKey.add(d.getPkValue());
            if (d.getDynamicObject(PARENT) == null) continue;
            clearCacheKey.add(d.getDynamicObject(PARENT).getPkValue());
        }
        HashMap saveMap = new HashMap();
        HashMap<Object, Integer> deleteMap = new HashMap<Object, Integer>();
        if (doj.length > 0) {
            IDataEntityType type = doj[0].getDataEntityType();
            ISimpleProperty pkProp = type.getPrimaryKey();
            String routeKey = type.getDBRouteKey();
            String fisleaf = "";
            String parentName = "";
            String tableName = doj[0].getDataEntityType().getAlias();
            String numberName = "";
            String numberTabelName = "";
            String primaryKey = type.getPrimaryKey().getName();
            String fidTableName = type.getPrimaryKey() != null ? type.getPrimaryKey().getAlias() : "";
            String parentTableName = "";
            numberName = ((BasedataEntityType)type).getBillNo();
            if (StringUtils.isBlank((CharSequence)numberName) || StringUtils.isBlank((CharSequence)tableName) || StringUtils.isBlank((CharSequence)primaryKey)) {
                return;
            }
            for (DynamicObject[] prop : type.getProperties()) {
                if (prop instanceof ParentBasedataProp) {
                    parentName = prop.getName();
                    parentTableName = prop.getAlias();
                }
                if (prop.getName().equals(IS_LEAF)) {
                    fisleaf = prop.getAlias();
                }
                if (!prop.getName().equals(numberName)) continue;
                numberTabelName = prop.getAlias();
            }
            if (StringUtils.isBlank((CharSequence)numberTabelName) || StringUtils.isBlank((CharSequence)parentName) || StringUtils.isBlank((CharSequence)fidTableName) || StringUtils.isBlank((CharSequence)parentTableName)) {
                return;
            }
            String sql = "update " + tableName + " set " + fisleaf + " =? where " + fidTableName + " =?";
            block12: for (DynamicObject dynamicObject : doj) {
                DynamicObject parent = dynamicObject.getDynamicObject(parentName);
                if (!StringUtils.isNotBlank((CharSequence)fisleaf)) continue;
                Iterator fid = dynamicObject.get(primaryKey);
                switch (e.getOperationKey()) {
                    case "save": {
                        if (parent != null) {
                            saveMap.put(fid, parent.get(primaryKey));
                            continue block12;
                        }
                        saveMap.put(fid, null);
                        continue block12;
                    }
                    case "submit": {
                        if (parent != null) {
                            saveMap.put(fid, parent.get(primaryKey));
                            continue block12;
                        }
                        saveMap.put(fid, null);
                        continue block12;
                    }
                    case "delete": {
                        if (parent == null) continue block12;
                        if (deleteMap.containsKey(parent.get(primaryKey))) {
                            deleteMap.put(parent.get(primaryKey), (Integer)deleteMap.get(parent.get(primaryKey)) + 1);
                            continue block12;
                        }
                        deleteMap.put(parent.get(primaryKey), 1);
                        continue block12;
                    }
                    default: {
                        return;
                    }
                }
            }
            Set saveEntry = saveMap.entrySet();
            ArrayList<List<Object>> fids = new ArrayList<List<Object>>();
            ArrayList<Object> temp = new ArrayList<Object>();
            ArrayList saveParentId = new ArrayList();
            int index = 0;
            for (Map.Entry entry : saveEntry) {
                if (index < 1000) {
                    temp.add(entry.getKey());
                } else {
                    temp.add(entry.getKey());
                    fids.add(temp);
                    temp = new ArrayList();
                    index = 0;
                }
                ++index;
            }
            fids.add(temp);
            List<Object> modifyFid = this.isNewData(fids, tableName, routeKey, fidTableName, pkProp);
            if (modifyFid.isEmpty()) {
                doj[0].set(IS_LEAF, (Object)1);
            }
            for (Map.Entry entry : saveEntry) {
                if (modifyFid.contains(entry.getKey())) continue;
                saveParentId.add(entry.getValue());
            }
            ArrayList arrayList = new ArrayList(saveParentId.size() + saveEntry.size());
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList.addAll(saveParentId);
            ArrayList<List<Object>> modify = new ArrayList<List<Object>>();
            temp = new ArrayList();
            index = 0;
            for (Object object : modifyFid) {
                if (index < 1000) {
                    temp.add(object);
                } else {
                    temp.add(object);
                    modify.add(temp);
                    temp = new ArrayList();
                    index = 0;
                }
                ++index;
            }
            modify.add(temp);
            List<Object> oldParent = this.getOldParent(modify, tableName, routeKey, fidTableName, parentTableName, pkProp);
            ArrayList<List<Object>> queryParent = new ArrayList<List<Object>>();
            temp = new ArrayList();
            index = 0;
            for (Object object : oldParent) {
                if (object == null || "0".equals(object.toString()) || saveMap.containsValue(object)) continue;
                if (index < 1000) {
                    temp.add(object);
                } else {
                    temp.add(object);
                    queryParent.add(temp);
                    temp = new ArrayList();
                    index = 0;
                }
                ++index;
            }
            queryParent.add(temp);
            Map<Object, List<Object>> notModifys = this.hasChildren(queryParent, tableName, "modify", routeKey, fidTableName, parentTableName, pkProp);
            for (Object object : notModifys.keySet()) {
                int otherSunCount = 0;
                List<Object> suns = notModifys.get(object);
                for (Object object2 : suns) {
                    if (saveMap.containsKey(object2)) continue;
                    ++otherSunCount;
                }
                if (otherSunCount != 0) continue;
                arrayList2.add(object);
            }
            for (Map.Entry entry : saveEntry) {
                if (entry.getValue() == null) continue;
                arrayList.add(entry.getValue());
            }
            Set set = deleteMap.entrySet();
            ArrayList<List<Object>> arrayList3 = new ArrayList<List<Object>>();
            temp = new ArrayList();
            index = 0;
            for (Map.Entry entry : set) {
                if (index < 1000) {
                    temp.add(entry.getKey());
                } else {
                    temp.add(entry.getKey());
                    arrayList3.add(temp);
                    temp = new ArrayList();
                    index = 0;
                }
                ++index;
            }
            arrayList3.add(temp);
            Map<Object, List<Object>> deleteParentChildren = this.hasChildren(arrayList3, tableName, "delete", routeKey, fidTableName, parentTableName, pkProp);
            HashMap<Object, Integer> tempMap = new HashMap<Object, Integer>();
            for (Object object : deleteParentChildren.keySet()) {
                List<Object> list = deleteParentChildren.get(object);
                Integer tempVal = (Integer)tempMap.get(object);
                if (tempVal == null) {
                    tempMap.put(object, list.size());
                    continue;
                }
                tempMap.put(object, (Integer)tempMap.get(object) + list.size());
            }
            for (Map.Entry entry : set) {
                if (((Integer)entry.getValue()).intValue() != ((Integer)tempMap.get(entry.getKey())).intValue()) continue;
                arrayList2.add(entry.getKey());
            }
            ArrayList<SqlParameter[]> sqlParameters = new ArrayList<SqlParameter[]>(16);
            for (Object e2 : arrayList) {
                sqlParameters.add(new SqlParameter[]{new SqlParameter(fisleaf, 1, (Object)0), new SqlParameter(fidTableName, 12, e2)});
            }
            if (sqlParameters.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)routeKey), (String)sql, sqlParameters);
            }
            sqlParameters = new ArrayList();
            for (Object e3 : arrayList2) {
                sqlParameters.add(new SqlParameter[]{new SqlParameter(fisleaf, 1, (Object)1), new SqlParameter(fidTableName, 12, e3)});
            }
            if (sqlParameters.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)routeKey), (String)sql, sqlParameters);
            }
            DataEntityCacheManager dataEntityCacheManager = new DataEntityCacheManager(tableName);
            dataEntityCacheManager.removeByPrimaryKey(clearCacheKey.toArray());
        }
    }

    private List<Object> getOldParent(List<List<Object>> modify, String tableName, String routeKey, String fidTableName, String parentTableName, final ISimpleProperty fidType) {
        ArrayList<Object> oldParent = new ArrayList<Object>();
        for (List<Object> list : modify) {
            if (list.size() <= 0) continue;
            String queryFid = this.StringJoin(list, ",");
            String querySql = SELECT + parentTableName + FORM + tableName + WHERE + fidTableName + IN + queryFid + ")";
            List temp = new ArrayList();
            try {
                temp = (List)DB.query((DBRoute)DBRoute.of((String)routeKey), (String)querySql, null, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

                    public List<Object> handle(ResultSet rs) throws Exception {
                        ArrayList<Object> temp;
                        block3: {
                            block2: {
                                temp = new ArrayList<Object>();
                                if (!(fidType instanceof VarcharProp)) break block2;
                                while (rs.next()) {
                                    String tempValue = rs.getString(1);
                                    temp.add(tempValue);
                                }
                                break block3;
                            }
                            if (!(fidType instanceof LongProp)) break block3;
                            while (rs.next()) {
                                Long tempValue = rs.getLong(1);
                                temp.add(tempValue);
                            }
                        }
                        return temp;
                    }
                });
            }
            catch (Exception e) {
                String msg = String.format(ERROR_MSG, e.getMessage(), querySql);
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
            }
            oldParent.addAll(temp);
        }
        return oldParent;
    }

    private Map<Object, List<Object>> hasChildren(List<List<Object>> fids, String tableName, String operationType, String routeKey, String fidTableName, String parentTableName, final ISimpleProperty fidType) {
        HashMap<Object, List<Object>> hasChildrenFid = new HashMap<Object, List<Object>>(16);
        for (List<Object> list : fids) {
            if (list.isEmpty()) continue;
            String queryFid = this.StringJoin(list, ",");
            String querySql = SELECT + parentTableName + "," + fidTableName + FORM + tableName + WHERE + parentTableName + IN + queryFid + ") order by " + parentTableName;
            Map temp = new HashMap();
            try {
                temp = (Map)DB.query((DBRoute)DBRoute.of((String)routeKey), (String)querySql, null, (ResultSetHandler)new ResultSetHandler<Map<Object, List<Object>>>(){

                    public Map<Object, List<Object>> handle(ResultSet rs) throws Exception {
                        HashMap<Object, List<Object>> map;
                        block5: {
                            block4: {
                                map = new HashMap<Object, List<Object>>(16);
                                if (!(fidType instanceof VarcharProp)) break block4;
                                while (rs.next()) {
                                    String key = rs.getString(1);
                                    List objects = (List)map.get(key);
                                    if (!ObjectUtils.isEmpty((Object)objects)) {
                                        ((List)map.get(key)).add(rs.getString(2));
                                        continue;
                                    }
                                    ArrayList<String> list = new ArrayList<String>();
                                    list.add(rs.getString(2));
                                    map.put(key, list);
                                }
                                break block5;
                            }
                            if (!(fidType instanceof LongProp)) break block5;
                            while (rs.next()) {
                                Long key = rs.getLong(1);
                                List objects = (List)map.get(key);
                                if (!ObjectUtils.isEmpty((Object)objects)) {
                                    ((List)map.get(key)).add(rs.getLong(2));
                                    continue;
                                }
                                ArrayList<Long> list = new ArrayList<Long>();
                                list.add(rs.getLong(2));
                                map.put(key, list);
                            }
                        }
                        return map;
                    }
                });
            }
            catch (Exception e) {
                String msg = String.format(ERROR_MSG, e.getMessage(), querySql);
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
            }
            hasChildrenFid.putAll(temp);
        }
        return hasChildrenFid;
    }

    private List<Object> isNewData(List<List<Object>> fids, String tableName, String routeKey, String fidTableName, final ISimpleProperty fidType) {
        ArrayList<Object> modifyFids = new ArrayList<Object>();
        for (List<Object> list : fids) {
            if (list.size() <= 0) continue;
            String queryFid = this.StringJoin(list, ",");
            String querySql = SELECT + fidTableName + FORM + tableName + WHERE + fidTableName + IN + queryFid + ")";
            List temp = new ArrayList(16);
            try {
                temp = (List)DB.query((DBRoute)DBRoute.of((String)routeKey), (String)querySql, null, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

                    public List<Object> handle(ResultSet rs) throws Exception {
                        ArrayList<Object> temp;
                        block3: {
                            block2: {
                                temp = new ArrayList<Object>();
                                if (!(fidType instanceof VarcharProp)) break block2;
                                while (rs.next()) {
                                    String tempValue = rs.getString(1);
                                    temp.add(tempValue);
                                }
                                break block3;
                            }
                            if (!(fidType instanceof LongProp)) break block3;
                            while (rs.next()) {
                                Long tempValue = rs.getLong(1);
                                temp.add(tempValue);
                            }
                        }
                        return temp;
                    }
                });
            }
            catch (Exception e) {
                String msg = String.format(ERROR_MSG, e.getMessage(), querySql);
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
            }
            modifyFids.addAll(temp);
        }
        return modifyFids;
    }

    private String StringJoin(List<Object> list, String spliter) {
        int index = 0;
        StringBuilder sb = new StringBuilder();
        boolean isString = false;
        for (Object object : list) {
            if (index == 0) {
                if (object instanceof String) {
                    isString = true;
                }
                if (isString) {
                    sb.append('\'').append(object).append('\'');
                } else {
                    sb.append(object);
                }
            } else if (isString) {
                sb.append(',').append('\'').append(object).append('\'');
            } else {
                sb.append(',').append(object);
            }
            ++index;
        }
        return sb.toString();
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        BaseTreeParentValidate validator = new BaseTreeParentValidate();
        e.addValidator((AbstractValidator)validator);
    }
}

