/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.business.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.datamanager.DataEntityCacheManager;

public class FlexPropertyOp
extends AbstractOperationServicePlugIn {
    private static final String INDEX = "index";
    private static final String FLEX_FIELD = "flexfield";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(INDEX);
        e.getFieldKeys().add("flexid");
        e.getFieldKeys().add(FLEX_FIELD);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        switch (e.getOperationKey()) {
            case "save": 
            case "submit": 
            case "audit": {
                DynamicObject[] datas = e.getDataEntities();
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_flex_property");
                String dbRouteKey = dt.getDBRouteKey();
                long flexId = datas[0].getLong("flexid_id");
                String sql = "select max(findex) from t_bas_flex_property ";
                int maxIndex = (Integer)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Integer>(){

                    public Integer handle(ResultSet rs) throws SQLException {
                        if (rs.next()) {
                            return (int)rs.getLong(1);
                        }
                        return 0;
                    }
                });
                if (maxIndex + datas.length > 999999) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027Index\u6700\u5927\u503c\u5df2\u8d85\u8fc7999999\uff0c\u8d85\u51fa\u7cfb\u7edf\u652f\u6301\u8303\u56f4\u3002", (String)"FlexPropertyOp_0", (String)"bos-business-opplugin", (Object[])new Object[0])});
                }
                for (DynamicObject object : datas) {
                    String flexField;
                    int index = object.getInt(INDEX);
                    if (index == 0) {
                        index = ++maxIndex;
                        object.set(INDEX, (Object)index);
                    }
                    if (!StringUtils.isBlank((CharSequence)(flexField = object.getString(FLEX_FIELD)))) continue;
                    if (index < maxIndex) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u5b57\u6bb5\u540d\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FlexPropertyOp_1", (String)"bos-business-opplugin", (Object[])new Object[0]), object.get("number")));
                    }
                    String fieldKey = String.format("f%1$06d", index);
                    object.set(FLEX_FIELD, (Object)fieldKey);
                }
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        IDataEntityType dt = OrmUtils.getDataEntityType(FlexProperty.class);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(dt);
        cacheManager.removeByDt();
    }
}

