/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.billconvert.bizcase;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;

public class AfterBuildQueryParemeterSample
extends AbstractConvertPlugIn {
    private static final String KEY_BILLNO = "billno";
    private static final String KEY_DATE = "date";
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_CURRENCYNAME = "currency.name";
    private static final String KEY_CONTENT = "content";

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField(KEY_BILLNO);
        e.addSrcField(KEY_DATE);
        e.addSrcField(KEY_AMOUNT);
        e.addSrcField(KEY_CURRENCYNAME);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        SimpleDateFormat timesdf = new SimpleDateFormat("yyyy-MM-dd");
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(this.getSrcMainType().getDisplayName().toString());
            String billno = (String)((DynamicProperty)e.getFldProperties().get(KEY_BILLNO)).getValue((Object)srcRow);
            sBuilder.append(billno).append("; ");
            Object date = ((DynamicProperty)e.getFldProperties().get(KEY_DATE)).getValue((Object)srcRow);
            if (date != null) {
                sBuilder.append("\u65e5\u671f: ").append(timesdf.format((Date)date)).append("; ");
            }
            BigDecimal amount = (BigDecimal)((DynamicProperty)e.getFldProperties().get(KEY_AMOUNT)).getValue((Object)srcRow);
            sBuilder.append("\u91d1\u989d: ").append(amount.toString());
            String currency = (String)((DynamicProperty)e.getFldProperties().get(KEY_CURRENCYNAME)).getValue((Object)srcRow);
            sBuilder.append(currency);
            billDataEntity.setValue(KEY_CONTENT, (Object)sBuilder.toString());
        }
    }
}

